/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.model.AddNodeTemplateCopyCmd;
import kd.bos.workflow.engine.impl.cmd.model.AddNodeTemplateExtendCmd;
import kd.bos.workflow.engine.impl.cmd.model.ProcessCagetoryNameUpdateCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntity;

public class AddNodeTemplateByStrategyCmd
implements Command<String> {
    private Log logger = LogFactory.getLog(ProcessCagetoryNameUpdateCmd.class);
    private String developmentType;
    private Map<String, Object> nodeInformationMap;
    private NodeTemplateEntity nodeTemplateEntity;

    public AddNodeTemplateByStrategyCmd(String developmentType, Map<String, Object> nodeInformationMap) {
        this.developmentType = developmentType;
        this.nodeInformationMap = nodeInformationMap;
    }

    public AddNodeTemplateByStrategyCmd(String developmentType, NodeTemplateEntity nodeTemplateEntity) {
        this.developmentType = developmentType;
        this.nodeTemplateEntity = nodeTemplateEntity;
    }

    @Override
    public String execute(CommandContext commandContext) {
        try {
            switch (this.developmentType) {
                case "copy": {
                    this.logger.debug(String.format("developmentType is %s", "copy"));
                    new AddNodeTemplateCopyCmd(this.nodeInformationMap).execute(commandContext);
                    break;
                }
                case "addNew": {
                    break;
                }
                case "expend": {
                    this.logger.debug(String.format("developmentType is %s", "expend"));
                    new AddNodeTemplateExtendCmd(this.nodeTemplateEntity).execute(commandContext);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("AddNodeTemplateByStrategyCmd has error :" + WfUtils.getExceptionStacktrace(e));
            return e.getMessage();
        }
        return null;
    }
}

