/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.api.NodeTemplate;
import kd.bos.workflow.bpmn.converter.util.ModelConfigUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntityConstants;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntityManager;

public class AddNodeTemplateCmd
implements Command<Void>,
Serializable {
    private transient Log log = LogFactory.getLog(this.getClass());
    private static final long serialVersionUID = 6335050373399594576L;
    private NodeTemplate template;
    private Set<String> types = new HashSet<String>();

    public AddNodeTemplateCmd(NodeTemplate template) {
        this.template = template;
        this.types.addAll(ModelConfigUtil.getBuiltInStencilTypes());
        this.types.addAll(ModelConfigUtil.getAllExtendedStencilTypes());
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.template == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AddNodeTemplateCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        String tipTpl = ResManager.loadKDString((String)"\u53c2\u6570\u5c5e\u6027\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AddNodeTemplateCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]);
        if (WfUtils.isEmpty(this.template.getStencilType())) {
            throw new KDBizException(String.format(tipTpl, "stencilType"));
        }
        if (WfUtils.isEmpty(this.template.getName())) {
            throw new KDBizException(String.format(tipTpl, "name"));
        }
        if (WfUtils.isEmpty(this.template.getNumber())) {
            throw new KDBizException(String.format(tipTpl, "number"));
        }
        if (WfUtils.isEmpty(this.template.getAppId())) {
            throw new KDBizException(String.format(tipTpl, "appId"));
        }
        this.logInfo();
        if (!QueryServiceHelper.exists((String)"bos_devportal_bizapp", (Object)this.template.getAppId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e94\u7528\u627e\u4e0d\u5230\uff0c\u8bf7\u68c0\u67e5appID\u662f\u5426\u5b58\u5728\u3002", (String)"AddNodeTemplateCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        if (!this.template.getNumber().matches("^[A-Za-z][A-Za-z0-9_]+$")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u5e94\u4f7f\u7528\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u7684\u7ec4\u5408\uff0c\u4e14\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\u3002", (String)"AddNodeTemplateCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        if (this.types.contains(this.template.getNumber())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8282\u70b9\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e0e\u7cfb\u7edf\u5185\u7f6e\u7f16\u7801\u76f8\u540c\u3002", (String)"AddNodeTemplateCmd_5", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        if (String.valueOf(NodeTemplateEntityConstants.SYSTEMNODEID).equals(this.template.getGroupId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8282\u70b9\u6a21\u677f\u5206\u7ec4\u4e0d\u80fd\u9009\u62e9\u7cfb\u7edf\u8282\u70b9\u5206\u7ec4\u3002", (String)"AddNodeTemplateCmd_8", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        NodeTemplateEntityManager templateManager = commandContext.getNodeTemplateEntityManager();
        QFilter[] stencilTypeFilters = new QFilter[]{new QFilter("number", "=", (Object)this.template.getStencilType())};
        boolean stencilTypeExists = templateManager.exist(stencilTypeFilters);
        if (!stencilTypeExists) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u201cstencilType\u201d\u7684\u503c\u4e0d\u5b58\u5728\u3002", (String)"AddNodeTemplateCmd_7", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)this.template.getNumber())};
        boolean exists = templateManager.exist(filters);
        if (exists) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u5df2\u5b58\u5728\u3002", (String)"AddNodeTemplateCmd_6", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        templateManager.insert(this.getNodeTemplateEntity());
        return null;
    }

    private void logInfo() {
        String info = "addNodeTemplate: stencilType: %s, name: %s, number: %s, properties: %s, bizIdentification: %s, appId: %s, cloudId: %s, processType: %s, version: %s, status: %s, enable: %s";
        this.log.debug(String.format(info, this.template.getStencilType(), this.template.getName(), this.template.getNumber(), this.template.getProperties(), this.template.getBizIdentification(), this.template.getAppId(), this.template.getCloudId(), this.template.getProcessType(), this.template.getVersion(), this.template.getStatus(), this.template.getEnable()));
    }

    private NodeTemplateEntity getNodeTemplateEntity() {
        NodeTemplateEntityImpl entity = new NodeTemplateEntityImpl();
        entity.setStencilType(this.template.getStencilType());
        entity.setName(this.template.getName());
        entity.setNumber(this.template.getNumber());
        entity.setAppId(this.template.getAppId());
        entity.setProperties(this.template.getProperties());
        entity.setBizIdentification(this.template.getBizIdentification());
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)this.template.getAppId());
        if (appInfo == null) {
            this.log.debug(String.format("AppInfo is null. AppId: %s", this.template.getAppId()));
        } else {
            entity.setCloudId(appInfo.getCloudId());
        }
        if (WfUtils.isNotEmpty(this.template.getProcessType())) {
            entity.setProcessType(this.template.getProcessType());
        }
        if (WfUtils.isNotEmpty(this.template.getVersion())) {
            entity.setVersion(this.template.getVersion());
        }
        if (WfUtils.isNotEmpty(this.template.getStatus())) {
            entity.setStatus(this.template.getStatus());
        } else {
            entity.setStatus("C");
        }
        if (WfUtils.isNotEmpty(this.template.getEnable())) {
            entity.setEnable(this.template.getEnable());
        } else {
            entity.setEnable("1");
        }
        entity.setProcessType(ModelType.AuditFlow.toString());
        entity.setVersion("Premium");
        entity.setGroupId(this.template.getGroupId());
        entity.setEntityId(this.template.getEntityId());
        entity.setDevelopmentType("D");
        entity.setExtend(false);
        entity.setInitialization(false);
        entity.setSystemNode(false);
        return entity;
    }
}

