/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cmd.model.AddNodeTemplateLogCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class AddNodeTemplateCopyCmd
implements Command<Void> {
    private Log log = LogFactory.getLog(this.getClass());
    private Map<String, Object> nodeInformationMap;
    final List<String> nodePropertiesBlackListForNoEntity = Arrays.asList("entityNumber", "outMsg", "mobilePageAttrConfigModel", "entityName", "inMsg", "pageParameter", "operationWhenSubmit", "pageAttrConfigModel", "batchRejectCond", "batchApproveCond", "autoAuditCondition", "entityId", "pageAttrConfig", "mobilFormKey", "expireTime", "sensitiveFieldData", "radiogroup_participant", "extendBtnsWhenMatch", "personrangeformanual", "extendBtns", "skipCondition", "operationWhenSave", "formKey", "operationWhenReject", "fieldModified", "auditPoints", "displayInfo", "mobilePageAttrConfig", "participantBlackList", "subject", "sensitiveField", "participant", "serviceExecutor", "condition", "callProcessName", "callProcessId", "calledWay", "callProcessNumber", "addressKeyName", "circulate", "timeControls", "expireType", "timeUnit", "expirebtn", "expressionType", "customParams", "autoCoordinate", "inParameters", "auditPointWhenMatch", "advAppSchemeWhenMatch", "advAppSchemes", "autoAuditWhenMatch");

    public AddNodeTemplateCopyCmd(Map<String, Object> nodeInformationMap) {
        this.nodeInformationMap = nodeInformationMap;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.nodeInformationMap == null) {
            this.log.debug("nodeInformationMap is null.There are big problems here!!!!");
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u5f02\u5e38\u3002", (String)"AddNodeTemplateCopyCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        Object basicInformationObject = this.nodeInformationMap.get("basicInformation");
        if (!(basicInformationObject instanceof Map)) {
            this.log.debug("basicInformation is null.There are big problems here!!!!");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u201c%s\u201d\u5f02\u5e38\u3002", (String)"AddNodeTemplateCopyCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]), "basicInformationObject"));
        }
        NodeTemplateEntityManager nodeTemplateEntityManager = commandContext.getNodeTemplateEntityManager();
        Map basicInformation = (Map)basicInformationObject;
        boolean isNewAdd = (Boolean)basicInformation.get("isNewAdd");
        if (isNewAdd) {
            this.log.debug(String.format("isNewAdd value is %s", isNewAdd));
            NodeTemplateEntity nodeTemplate = this.getNodeTemplateEntity(basicInformation);
            nodeTemplateEntityManager.insert(nodeTemplate);
            new AddNodeTemplateLogCmd(null, nodeTemplate, "add").execute(commandContext);
        } else {
            String number = (String)basicInformation.get("nodenumber");
            this.log.debug(String.format("isNewAdd value is %s;number value is %s", isNewAdd, number));
            QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)number)};
            List nodeTemplates = nodeTemplateEntityManager.findByQueryFilters(filters);
            if (nodeTemplates == null || nodeTemplates.isEmpty()) {
                this.log.debug("number is  null");
                NodeTemplateEntity nodeTemplate = this.getNodeTemplateEntity(basicInformation);
                nodeTemplateEntityManager.insert(nodeTemplate);
                new AddNodeTemplateLogCmd(null, nodeTemplate, "add").execute(commandContext);
            } else {
                Object groupId;
                NodeTemplateEntity nodeTemplate = (NodeTemplateEntity)nodeTemplates.get(0);
                NodeTemplateEntityImpl oldNodeTemplate = ((NodeTemplateEntityImpl)nodeTemplate).clone();
                boolean isRetainBillInfo = (Boolean)basicInformation.get("isRetainBillInfo");
                String entityNumber = (String)this.nodeInformationMap.get("entityid");
                if (WfUtils.isNotEmpty(entityNumber) && isRetainBillInfo) {
                    QFilter[] bizAppFilters;
                    DynamicObject bizApp;
                    nodeTemplate.setEntityId(entityNumber);
                    QFilter[] entityFilters = new QFilter[]{new QFilter("number", "=", (Object)entityNumber)};
                    DynamicObject entity = QueryServiceHelper.queryOne((String)"bos_entityobject", (String)"bizappid", (QFilter[])entityFilters);
                    String appId = "";
                    if (entity != null) {
                        appId = entity.getString("bizappid");
                        nodeTemplate.setAppId(appId);
                    }
                    if ((bizApp = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"bizcloud", (QFilter[])(bizAppFilters = new QFilter[]{new QFilter("id", "=", (Object)appId)}))) != null) {
                        nodeTemplate.setCloudId(bizApp.getString("bizcloud"));
                    }
                } else {
                    basicInformation.put("isRetainBillInfo", Boolean.FALSE);
                    nodeTemplate.setEntityId(null);
                }
                nodeTemplate.setProperties(this.getProperties(basicInformation));
                nodeTemplate.setModifierId((Long)basicInformation.get("creator"));
                Object nodename = basicInformation.get("nodename");
                if (nodename != null) {
                    nodeTemplate.setName(nodename.toString());
                }
                if ((groupId = basicInformation.get("nodegroup")) != null) {
                    nodeTemplate.setGroupId(groupId.toString());
                }
                Date modifyDate = WfUtils.now();
                nodeTemplate.setModifyTime(modifyDate);
                WfCacheHelper.putStencilConfigTime(nodeTemplate.getNumber(), String.valueOf(modifyDate.getTime()));
                nodeTemplateEntityManager.update(nodeTemplate);
                String oldNumber = oldNodeTemplate.getNumber();
                String newNumber = nodeTemplate.getNumber();
                String oldName = oldNodeTemplate.getName();
                String newName = nodeTemplate.getName();
                Long oldGroupId = oldNodeTemplate.getGroupId();
                Long newGroupId = nodeTemplate.getGroupId();
                Long oldCreatorId = oldNodeTemplate.getCreatorId();
                Long newCreatorId = nodeTemplate.getCreatorId();
                if (!(oldNumber.equals(newNumber) && oldName.equals(newName) && oldGroupId.equals(newGroupId) && oldCreatorId.equals(newCreatorId))) {
                    new AddNodeTemplateLogCmd(oldNodeTemplate, nodeTemplate, "changebaseinfo").execute(commandContext);
                }
                new AddNodeTemplateLogCmd(oldNodeTemplate, nodeTemplate, "changeproperty").execute(commandContext);
            }
        }
        return null;
    }

    private NodeTemplateEntity getNodeTemplateEntity(Map<String, Object> basicInformation) {
        NodeTemplateEntityImpl nodeTemplateEntity = new NodeTemplateEntityImpl();
        nodeTemplateEntity.setStencilType((String)this.nodeInformationMap.get("stenciltype"));
        nodeTemplateEntity.setILocaleStringName((ILocaleString)LocaleString.fromMap((Map)((Map)basicInformation.get("nodename"))));
        nodeTemplateEntity.setNumber((String)basicInformation.get("nodenumber"));
        nodeTemplateEntity.setProcessType((String)this.nodeInformationMap.get("processType"));
        nodeTemplateEntity.setCreatorId((Long)basicInformation.get("creator"));
        nodeTemplateEntity.setCreateTime(new Date(System.currentTimeMillis()));
        nodeTemplateEntity.setModifierId((Long)basicInformation.get("creator"));
        nodeTemplateEntity.setModifyTime(new Date(System.currentTimeMillis()));
        nodeTemplateEntity.setGroupId((String)basicInformation.get("nodegroup"));
        nodeTemplateEntity.setStatus("C");
        nodeTemplateEntity.setEnable("1");
        nodeTemplateEntity.setDevelopmentType("D");
        nodeTemplateEntity.setExtend(false);
        nodeTemplateEntity.setInitialization(false);
        nodeTemplateEntity.setSystemNode(false);
        nodeTemplateEntity.setVersion("Standard");
        boolean isRetainBillInfo = (Boolean)basicInformation.get("isRetainBillInfo");
        String entityNumber = (String)this.nodeInformationMap.get("entityid");
        if (WfUtils.isNotEmpty(entityNumber) && isRetainBillInfo) {
            QFilter[] bizAppFilters;
            DynamicObject bizApp;
            nodeTemplateEntity.setEntityId(entityNumber);
            QFilter[] entityFilters = new QFilter[]{new QFilter("number", "=", (Object)entityNumber)};
            DynamicObject entity = QueryServiceHelper.queryOne((String)"bos_entityobject", (String)"bizappid", (QFilter[])entityFilters);
            String appId = "";
            if (entity != null) {
                appId = entity.getString("bizappid");
                nodeTemplateEntity.setAppId(appId);
            }
            if ((bizApp = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"bizcloud", (QFilter[])(bizAppFilters = new QFilter[]{new QFilter("id", "=", (Object)appId)}))) != null) {
                nodeTemplateEntity.setCloudId(bizApp.getString("bizcloud"));
            }
        }
        String properties = this.getProperties(basicInformation);
        nodeTemplateEntity.setProperties(properties);
        return nodeTemplateEntity;
    }

    private String getProperties(Map<String, Object> basicInformation) {
        boolean isRetainBillInfo = (Boolean)basicInformation.get("isRetainBillInfo");
        HashMap<String, Object> differenceDataMap = new HashMap<String, Object>();
        this.getDifferenceDataMap(differenceDataMap, isRetainBillInfo);
        return SerializationUtils.toJsonString(differenceDataMap);
    }

    private void getDifferenceDataMap(Map<String, Object> differenceDataMap, boolean isRetainBillInfo) {
        Object newestPropertiesObject = this.nodeInformationMap.get("newestProperties");
        if (!(newestPropertiesObject instanceof Map)) {
            this.log.debug("newestPropertiesObject is null.There are big problems here!!!!");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u201c%s\u201d\u5f02\u5e38\u3002", (String)"AddNodeTemplateCopyCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]), "newestPropertiesObject"));
        }
        Map newestProperties = (Map)newestPropertiesObject;
        String modelType = (String)this.nodeInformationMap.get("modelType");
        String stencilType = (String)this.nodeInformationMap.get("stenciltype");
        List<Property> nodeProperties = GraphCodecUtils.getNodeProperties(modelType, stencilType);
        for (Property property : nodeProperties) {
            JSONObject jsonObject;
            Object defaultValue;
            String propertyName = property.getPropertyName();
            String group = property.getGroupId();
            String fullPathPropertyName = propertyName;
            if (WfUtils.isNotEmpty(group) && !"base".equals(group)) {
                fullPathPropertyName = String.format("%s.%s", group, propertyName);
            }
            Object newValue = BpmnModelUtil.getProperty(newestProperties, fullPathPropertyName);
            if (this.nodePropertiesBlackListForNoEntity.contains(propertyName) && !isRetainBillInfo) continue;
            Map config = property.getEditor();
            Object v0 = defaultValue = config != null ? config.get("default") : null;
            if (newValue != null && newValue.equals(defaultValue)) continue;
            if (WfUtils.isNotEmpty(group)) {
                Map<String, Object> groupVlue;
                Object groupVlueObject = differenceDataMap.get(group);
                if (groupVlueObject == null) {
                    groupVlue = new HashMap();
                    if (!isRetainBillInfo && "extItf".equals(propertyName) && newValue instanceof JSONArray) {
                        Iterator newValueIterator = ((JSONArray)newValue).iterator();
                        while (newValueIterator.hasNext()) {
                            JSONObject newValueJSON = JSONObject.parseObject((String)((String)newValueIterator.next()));
                            if (!(newValueJSON instanceof JSONObject) || !"operation".equals(newValueJSON.getString("type")) && !"script".equals(newValueJSON.getString("type"))) continue;
                            newValueIterator.remove();
                        }
                    }
                    groupVlue.put(propertyName, newValue);
                    differenceDataMap.put(group, groupVlue);
                    continue;
                }
                groupVlue = (Map)differenceDataMap.get(group);
                if ("allowNextPersonSetting".equals(propertyName) && newValue != null) {
                    new JSONObject((Map)newValue).remove((Object)"sceneNextNodeAssignValue");
                }
                groupVlue.put(propertyName, newValue);
                differenceDataMap.put(group, groupVlue);
                continue;
            }
            if ("decisionOptions".equals(propertyName) && newValue instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)newValue;
                Iterator iterator = jsonArray.iterator();
                while (iterator.hasNext()) {
                    JSONObject value = (JSONObject)iterator.next();
                    String decisionScene = value.getString("decisionScene");
                    if ("rejectToParentProcPreNode".equals(decisionScene) || "rejectToParentProcEditNode".equals(decisionScene) || "terminateMainProcess".equals(decisionScene)) {
                        iterator.remove();
                        continue;
                    }
                    String auditType = value.getString("auditType");
                    if (!"reject".equals(auditType)) continue;
                    value.remove((Object)"rejectOptions");
                }
            }
            if (!isRetainBillInfo && ("executionListeners".equals(propertyName) || "taskListeners".equals(propertyName)) && newValue instanceof JSONArray) {
                Iterator newValueIterator = ((JSONArray)newValue).iterator();
                while (newValueIterator.hasNext()) {
                    Object newValueJSON = newValueIterator.next();
                    if (!(newValueJSON instanceof JSONObject) || !"operation".equals(((JSONObject)newValueJSON).getString("implementationtype")) && !"script".equals(((JSONObject)newValueJSON).getString("implementationtype"))) continue;
                    newValueIterator.remove();
                }
            } else if (!isRetainBillInfo && "flowRecordFormatter".equals(propertyName) && newValue instanceof String && "script".equals((jsonObject = JSONObject.parseObject((String)((String)newValue))).getString("type"))) {
                newValue = null;
            }
            differenceDataMap.put(propertyName, newValue);
        }
        this.log.debug(String.format("differenceDataMap is %s", differenceDataMap));
    }
}

