/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.workflow.bpmn.converter.util.ModelConfigUtil;
import kd.bos.workflow.bpmn.diff.patch.JsonPatch;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateGroupEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateLogEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ModelModifyLogUtils;

public class AddNodeTemplateLogCmd
implements Command<Void> {
    private Log log = LogFactory.getLog(this.getClass());
    private NodeTemplateEntity oldNodeTemplate;
    private NodeTemplateEntity newNodeTemplate;
    private String opertionType;

    public AddNodeTemplateLogCmd(NodeTemplateEntity oldNodeTemplate, NodeTemplateEntity newNodeTemplate, String opertionType) {
        this.oldNodeTemplate = oldNodeTemplate;
        this.newNodeTemplate = newNodeTemplate;
        this.opertionType = opertionType;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        NodeTemplateLogEntityManager nodeTemplateLogEntityManager = commandContext.getNodeTemplateLogEntityManager();
        NodeTemplateLogEntity nodeTemplateLogEntity = (NodeTemplateLogEntity)nodeTemplateLogEntityManager.create();
        nodeTemplateLogEntity.setNumber(this.newNodeTemplate.getNumber());
        nodeTemplateLogEntity.setName((ILocaleString)new LocaleString(this.newNodeTemplate.getName()));
        nodeTemplateLogEntity.setGroupId(this.newNodeTemplate.getGroupId());
        nodeTemplateLogEntity.setOperation(this.opertionType);
        Long modifierId = WfUtils.isEmpty(this.newNodeTemplate.getModifierId()) ? Long.valueOf(RequestContext.get().getUserId()) : this.newNodeTemplate.getModifierId();
        nodeTemplateLogEntity.setModifierId(modifierId);
        nodeTemplateLogEntity.setModifyTime(this.newNodeTemplate.getModifyTime());
        nodeTemplateLogEntity.setNodeTemplateId(this.newNodeTemplate.getId());
        this.log.debug(String.format("opertionType is:%s", this.opertionType));
        if ("changebaseinfo".equals(this.opertionType)) {
            this.changeNodeTemplateBaseInfo(nodeTemplateLogEntity, commandContext);
            nodeTemplateLogEntityManager.insert(nodeTemplateLogEntity);
        } else if ("changeproperty".equals(this.opertionType)) {
            this.changeNodetmplateProperty(nodeTemplateLogEntity);
            String newValue = nodeTemplateLogEntity.getNewValue();
            if (WfUtils.isNotEmpty(newValue)) {
                nodeTemplateLogEntityManager.insert(nodeTemplateLogEntity);
            }
        } else {
            nodeTemplateLogEntityManager.insert(nodeTemplateLogEntity);
        }
        return null;
    }

    private void changeNodetmplateProperty(NodeTemplateLogEntity nodeTemplateLogEntity) {
        HashMap<Object, String> resultMap = new HashMap<Object, String>();
        String oldProperties = this.oldNodeTemplate.getProperties();
        String newProperties = this.newNodeTemplate.getProperties();
        this.log.debug(String.format("changeNodetmplateProperty old is:%s", oldProperties));
        this.log.debug(String.format("changeNodetmplateProperty new is:%s", newProperties));
        JSONObject oldJSONObject = (JSONObject)JSONObject.parse((String)oldProperties);
        JSONObject newJSONObject = (JSONObject)JSONObject.parse((String)newProperties);
        String stencilType = WfUtils.isEmpty(this.newNodeTemplate.getStencilType()) ? this.newNodeTemplate.getNumber() : this.newNodeTemplate.getStencilType();
        String modelType = GraphCodecUtils.getModelTypeByProcessType(this.newNodeTemplate.getProcessType());
        DomainModelType domainModelType = GraphCodecUtils.getDomainType(modelType);
        ElementType elementType = this.getElementType(modelType, domainModelType, stencilType);
        List properties = null;
        if (elementType == null) {
            this.log.debug(String.format("ElementType is null! %s ", stencilType));
            return;
        }
        properties = elementType.getProperties();
        ArrayList<String> groups = new ArrayList<String>();
        for (Property property : properties) {
            String groupId = property.getGroupId();
            if (!WfUtils.isNotEmpty(groupId)) continue;
            groups.add(groupId);
        }
        JsonPatch patch = BpmnDiffUtil.getJsonDiffPatch(oldProperties, newProperties);
        JsonNode patchJson = BpmnDiffUtil.getBpmnPatch(patch);
        if (!(patchJson instanceof ObjectNode) || ((ObjectNode)patchJson).isNull() || ((ObjectNode)patchJson).size() < 1) {
            return;
        }
        ObjectNode objectNode = (ObjectNode)patchJson;
        Iterator objectNodeIt = objectNode.fieldNames();
        while (objectNodeIt.hasNext()) {
            String fieldName = (String)objectNodeIt.next();
            JsonNode objectNodeProperty = patchJson.get(fieldName);
            String path0 = fieldName;
            if (groups.contains(path0)) {
                Iterator it = objectNodeProperty.fieldNames();
                while (it.hasNext()) {
                    String path1 = (String)it.next();
                    StringBuilder path = new StringBuilder();
                    path.append("properties").append(".").append(path0).append(".").append(path1);
                    resultMap.put(path1, path.toString());
                }
                continue;
            }
            StringBuilder path = new StringBuilder();
            path.append("properties").append(".").append(path0);
            resultMap.put(path0, path.toString());
        }
        HashMap<String, LocaleString> propertyMap = new HashMap<String, LocaleString>(properties.size());
        HashMap<String, String> defultValueMap = new HashMap<String, String>();
        for (Property property : properties) {
            propertyMap.put(property.getPropertyName(), property.getName());
            if (property.getEditor() == null) continue;
            defultValueMap.put(property.getPropertyName(), String.valueOf(property.getEditor().get("default")));
        }
        Set resultEntrySet = resultMap.entrySet();
        StringBuilder sbOld = new StringBuilder();
        StringBuilder sbNew = new StringBuilder();
        for (Map.Entry result : resultEntrySet) {
            String newValue;
            String oldValue;
            ILocaleString propertyName = (ILocaleString)propertyMap.get(result.getKey());
            String defultValue = (String)defultValueMap.get(result.getKey());
            String propertyPatch = WfUtils.isEmpty((String)result.getValue()) ? null : ((String)result.getValue()).replace("properties.", "");
            String string = oldValue = BpmnModelUtil.getProperty((Map<String, Object>)oldJSONObject, propertyPatch) == null ? defultValue : String.valueOf(BpmnModelUtil.getProperty((Map<String, Object>)oldJSONObject, propertyPatch));
            if (WfUtils.isNotEmpty(oldValue) && !"null".equals(oldValue)) {
                sbOld.append(propertyName).append(":");
                sbOld.append(ModelModifyLogUtils.handleSpecial((String)result.getValue(), stencilType, oldValue)).append(";").append(" ");
            }
            if (!WfUtils.isNotEmpty(newValue = BpmnModelUtil.getProperty((Map<String, Object>)newJSONObject, propertyPatch) == null ? defultValue : String.valueOf(BpmnModelUtil.getProperty((Map<String, Object>)newJSONObject, propertyPatch))) || "null".equals(newValue)) continue;
            sbNew.append(propertyName).append(":");
            sbNew.append(ModelModifyLogUtils.handleSpecial((String)result.getValue(), stencilType, newValue)).append(";").append(" ");
        }
        nodeTemplateLogEntity.setOldValue(sbOld.toString());
        nodeTemplateLogEntity.setDetailOldValue(sbOld.toString());
        nodeTemplateLogEntity.setNewValue(sbNew.toString());
        nodeTemplateLogEntity.setDetailNewValue(sbNew.toString());
    }

    private ElementType getElementType(String modelType, DomainModelType domainModelType, String type) {
        if (WfUtils.isEmpty(modelType) || WfUtils.isEmpty(type)) {
            return null;
        }
        if (domainModelType == null) {
            this.log.debug(String.format("DomainType %s not exists ", modelType));
            return null;
        }
        ElementType elementType = domainModelType.getElementType(type);
        if (elementType != null) {
            return elementType;
        }
        String parentType = ModelConfigUtil.getExtendNodeInheritStencilType(type);
        return this.getElementType(modelType, domainModelType, parentType);
    }

    private void changeNodeTemplateBaseInfo(NodeTemplateLogEntity nodeTemplateLogEntity, CommandContext commandContext) {
        String oldValue = this.getNodeBaseInfo(this.oldNodeTemplate, commandContext);
        String newValue = this.getNodeBaseInfo(this.newNodeTemplate, commandContext);
        this.log.debug(String.format("baseInfo old is:%s", oldValue));
        this.log.debug(String.format("baseInfo newValue is:%s", newValue));
        nodeTemplateLogEntity.setOldValue(oldValue);
        nodeTemplateLogEntity.setDetailOldValue(oldValue);
        nodeTemplateLogEntity.setNewValue(newValue);
        nodeTemplateLogEntity.setDetailNewValue(newValue);
    }

    private String getNodeBaseInfo(NodeTemplateEntity nodeTemplate, CommandContext commandContext) {
        StringBuilder sbContext = new StringBuilder();
        sbContext.append(ResManager.loadKDString((String)"\u8282\u70b9\u6a21\u677f\u7f16\u7801\uff1a", (String)"AddNodeTemplateLogCmd_1", (String)"bos-wf-engine", (Object[])new Object[0])).append(nodeTemplate.getNumber()).append(";");
        sbContext.append(ResManager.loadKDString((String)"\u8282\u70b9\u6a21\u677f\u540d\u79f0\uff1a", (String)"AddNodeTemplateLogCmd_2", (String)"bos-wf-engine", (Object[])new Object[0])).append(nodeTemplate.getName()).append(";");
        if (WfUtils.isNotEmpty(nodeTemplate.getGroupId())) {
            Long groupId = nodeTemplate.getGroupId();
            NodeTemplateGroupEntity groupEntity = (NodeTemplateGroupEntity)commandContext.getNodeTemplateGroupEntityManager().findById(groupId);
            LocaleString groupName = groupEntity == null ? new LocaleString() : groupEntity.getName();
            sbContext.append(ResManager.loadKDString((String)"\u8282\u70b9\u6a21\u677f\u5206\u7ec4\uff1a", (String)"AddNodeTemplateLogCmd_3", (String)"bos-wf-engine", (Object[])new Object[0])).append(groupName);
        }
        return sbContext.toString();
    }
}

