/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import java.io.Serializable;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.workflow.engine.impl.cmd.entity.SaveEntityCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.DelegateSettingEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.DelegateSettingEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.HistoricDelegateSettingEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.HistoricDelegateSettingEntityImpl;

public class BatchDelegationSettingsCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 7465062278868533056L;
    private DynamicObject assignor;
    private DynamicObject trustee;
    private String scope;
    private Date startTime;
    private Date endTime;
    private Boolean sendMsgToassignor;
    private Boolean receiveTodotTask;
    private DynamicObjectCollection entryEntityData;

    public BatchDelegationSettingsCmd(DynamicObject assignor, DynamicObject trustee, String scope, Date startTime, Date endTime, Boolean sendMsgToassignor, Boolean receiveTodotTask, DynamicObjectCollection entryEntityData) {
        this.assignor = assignor;
        this.trustee = trustee;
        this.scope = scope;
        this.startTime = startTime;
        this.endTime = endTime;
        this.sendMsgToassignor = sendMsgToassignor;
        this.receiveTodotTask = receiveTodotTask;
        this.entryEntityData = entryEntityData;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        DelegateSettingEntityManager delegateSettingEntityManager = commandContext.getDelegateSettingEntityManager();
        if (this.entryEntityData == null || this.entryEntityData.isEmpty()) {
            DelegateSettingEntity delegateSettingEntity = (DelegateSettingEntity)delegateSettingEntityManager.create();
            HistoricDelegateSettingEntityImpl hiDelegate = new HistoricDelegateSettingEntityImpl();
            this.setBasicInfo(delegateSettingEntity, hiDelegate);
            delegateSettingEntityManager.insert(delegateSettingEntity);
            hiDelegate.setDelegateId(delegateSettingEntity.getId());
            new SaveEntityCmd<HistoricDelegateSettingEntityImpl>(hiDelegate).execute(commandContext);
        } else {
            for (DynamicObject dynamicObject : this.entryEntityData) {
                DelegateSettingEntity delegateSettingEntity = (DelegateSettingEntity)delegateSettingEntityManager.create();
                HistoricDelegateSettingEntityImpl hiDelegate = new HistoricDelegateSettingEntityImpl();
                this.setBasicInfo(delegateSettingEntity, hiDelegate);
                this.setMajorInfo(delegateSettingEntity, dynamicObject, hiDelegate);
                delegateSettingEntityManager.insert(delegateSettingEntity);
                hiDelegate.setDelegateId(delegateSettingEntity.getId());
                new SaveEntityCmd<HistoricDelegateSettingEntityImpl>(hiDelegate).execute(commandContext);
            }
        }
        return null;
    }

    private void setMajorInfo(DelegateSettingEntity delegateSettingEntity, DynamicObject dynamicObject, HistoricDelegateSettingEntity hiDelegate) {
        if ("2".equals(this.scope)) {
            String delegateRule = dynamicObject.getString("bill_delegaterule");
            String delegateExpression = dynamicObject.getString("bill_delegateexpression");
            ILocaleString deleruleShowText = dynamicObject.getLocaleString("bill_deleruleshowtext");
            String entraBillId = dynamicObject.getString("entrabillid");
            delegateSettingEntity.setEntraBillId(entraBillId);
            hiDelegate.setEntraBillId(entraBillId);
            delegateSettingEntity.setDelegateRule(delegateRule);
            hiDelegate.setDelegateRule(delegateRule);
            delegateSettingEntity.setDelegateExpression(delegateExpression);
            hiDelegate.setDelegateExpression(delegateExpression);
            delegateSettingEntity.setDeleRuleShowText(deleruleShowText);
            hiDelegate.setDeleRuleShowText(deleruleShowText);
            delegateSettingEntity.setLatestVersion(false);
        } else if ("1".equals(this.scope)) {
            String delegateRule = dynamicObject.getString("process_delegaterule");
            Long processDefinitionId = dynamicObject.getLong("processdefinitionid");
            ILocaleString deleRuleShowText = dynamicObject.getLocaleString("process_deleruleshowtext");
            String expression = dynamicObject.getString("proces_delegateexpression");
            String delegateNodeName = dynamicObject.getString("delegatenodename");
            String delegateNodeId = dynamicObject.getString("delegatenodeid");
            Boolean islatestversion = dynamicObject.getBoolean("islatestversion");
            delegateSettingEntity.setLatestVersion(islatestversion);
            delegateSettingEntity.setDelegateRule(delegateRule);
            hiDelegate.setDelegateRule(delegateRule);
            delegateSettingEntity.setProcessDefinitionId(processDefinitionId);
            hiDelegate.setProcessDefinitionId(processDefinitionId);
            delegateSettingEntity.setDelegateExpression(expression);
            hiDelegate.setDelegateExpression(expression);
            delegateSettingEntity.setDelegateNodeId(delegateNodeId);
            hiDelegate.setDelegateNodeId(delegateNodeId);
            delegateSettingEntity.setDeleRuleShowText(deleRuleShowText);
            hiDelegate.setDeleRuleShowText(deleRuleShowText);
            delegateSettingEntity.setDelegateNodeName((ILocaleString)new LocaleString(delegateNodeName));
            hiDelegate.setDelegateNodeName((ILocaleString)new LocaleString(delegateNodeName));
        }
    }

    private void setBasicInfo(DelegateSettingEntity delegateSettingEntity, HistoricDelegateSettingEntity hiDelegate) {
        long assignorId = this.assignor.getLong("id");
        delegateSettingEntity.setAssignorId(assignorId);
        hiDelegate.setAssignorId(assignorId);
        long trusteeId = this.trustee.getLong("id");
        delegateSettingEntity.setTrusteeId(trusteeId);
        hiDelegate.setTrusteeId(trusteeId);
        delegateSettingEntity.setScope(this.scope);
        hiDelegate.setScope(this.scope);
        delegateSettingEntity.setStartTime(this.startTime);
        hiDelegate.setStartTime(this.startTime);
        delegateSettingEntity.setEndTime(this.endTime);
        hiDelegate.setEndTime(this.endTime);
        delegateSettingEntity.setSendMsgToAssignor(this.sendMsgToassignor);
        hiDelegate.setSendMsgToAssignor(this.sendMsgToassignor);
        delegateSettingEntity.setReceiveTodoTask(this.receiveTodotTask);
        hiDelegate.setReceiveTodoTask(this.receiveTodotTask);
        delegateSettingEntity.setEndTime(this.endTime);
        hiDelegate.setEndTime(this.endTime);
        delegateSettingEntity.setStatus("0");
        hiDelegate.setStatus("0");
        delegateSettingEntity.setCreatorId(RequestContext.get().getCurrUserId());
        hiDelegate.setCreatorId(RequestContext.get().getCurrUserId());
        delegateSettingEntity.setModifierId(RequestContext.get().getCurrUserId());
        hiDelegate.setModifierId(RequestContext.get().getCurrUserId());
        delegateSettingEntity.setCreateDate(new Date(System.currentTimeMillis()));
        hiDelegate.setCreateDate(new Date(System.currentTimeMillis()));
        delegateSettingEntity.setModifyDate(new Date(System.currentTimeMillis()));
        hiDelegate.setModifyDate(new Date(System.currentTimeMillis()));
    }
}

