/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.dynamicpartial.DynamicModelPartial;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.cmd.entity.SaveEntityCmd;
import kd.bos.workflow.engine.impl.cmd.model.AbstractProcessor;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.context.ModelProcessorContext;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;

public class ConditionalRuleProcessor
extends AbstractProcessor {
    @Override
    public void process(ModelProcessorContext context, Long modelId, DynamicModelPartial partial) {
    }

    @Override
    public void process(ModelProcessorContext context, DynamicModelPartial partial, Long procDefId) {
        ConditionalRuleEntity conditionalRule = (ConditionalRuleEntity)((Object)partial.getPartial());
        if (ConditionalRuleType.participant.toString().equals(conditionalRule.getType())) {
            return;
        }
        conditionalRule.setProcdefid(procDefId);
        CommandContext commandContext = Context.getCommandContext();
        new SaveEntityCmd<ConditionalRuleEntity>(conditionalRule).execute(commandContext);
    }

    @Override
    public void process(ModelProcessorContext context, DynamicModelPartial partial, Long procDefId, Long schemeId) {
        this.process(context, partial, procDefId);
    }

    @Override
    public void updateBpmnModel(BpmnModel bpmnModel, List<AbstractEntity> entities) {
        ConditionalRuleEntity condRuleEntity = null;
        for (AbstractEntity entity : entities) {
            condRuleEntity = (ConditionalRuleEntity)((Object)entity);
            if (ConditionalRuleType.participant.toString().equals(condRuleEntity.getType())) continue;
            condRuleEntity.setEntryentity(this.sortEntryEntity(condRuleEntity.getEntryentity()));
            this.updateBpmnModelProperty(bpmnModel.getFlowElement(condRuleEntity.getElementid()), condRuleEntity.getProperty(), condRuleEntity);
        }
    }

    private List<ConditionalEntity> sortEntryEntity(List<ConditionalEntity> entryentity) {
        if (entryentity == null || entryentity.isEmpty()) {
            return entryentity;
        }
        Collections.sort(entryentity, new Comparator<ConditionalEntity>(){

            @Override
            public int compare(ConditionalEntity entity, ConditionalEntity other) {
                if (entity.getId() == other.getId()) {
                    return 0;
                }
                if (entity.getId() == null) {
                    return -1;
                }
                if (other.getId() == null) {
                    return 1;
                }
                return entity.getId().compareTo(other.getId());
            }
        });
        return entryentity;
    }

    @Override
    public String getEntityNumber() {
        return "wf_conditionalrule";
    }
}

