/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;

public class CreateBlankProcessResourceCmd
implements Command<String> {
    private String procType;
    private Map<String, Object> config;
    private Log log = LogFactory.getLog(this.getClass());

    public CreateBlankProcessResourceCmd(String procType, Map<String, Object> config) {
        this.procType = procType;
        this.config = config;
    }

    @Override
    public String execute(CommandContext commandContext) {
        this.log.debug(String.valueOf(this.config));
        if (ModelType.NoCodeFlow.name().equals(this.procType)) {
            JSONObject resource = this.createNoCodeFlowBlankResource();
            return resource.toJSONString();
        }
        return null;
    }

    private JSONObject createNoCodeFlowBlankResource() {
        JSONObject resource = new JSONObject();
        resource.put("id", (Object)"node_1");
        resource.put("name", (Object)ResManager.loadKDString((String)"\u672a\u547d\u540d\u6d41\u7a0b", (String)"CreateBlankProcessResourceCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        long orgId = RequestContext.get().getOrgId();
        if (orgId == 0L) {
            orgId = OrgUnitServiceHelper.getRootOrgId();
        }
        resource.put("orgUnitId", (Object)orgId);
        resource.put("_Type_", (Object)"NoCodeWfMetaData");
        String procNumber = String.format("Proc_%s_%s", new SimpleDateFormat("yyyyMMdd").format(new Date()), System.currentTimeMillis());
        resource.put("key", (Object)procNumber);
        JSONArray nodes = new JSONArray();
        JSONObject startEvent = new JSONObject();
        String startNumber = String.format("%s0", "StartSignalEvent");
        startEvent.put("number", (Object)startNumber);
        startEvent.put("itemId", (Object)String.format("%s_%s", procNumber, startNumber));
        startEvent.put("_Type_", (Object)"StartSignalEvent");
        startEvent.put("fireType", (Object)"newSubmit");
        startEvent.put("parentId", (Object)"node_1");
        startEvent.put("name", (Object)ResManager.loadKDString((String)"\u6d41\u7a0b\u89e6\u53d1", (String)"CreateBlankProcessResourceCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        nodes.add((Object)startEvent);
        resource.put("nodes", (Object)nodes);
        return resource;
    }
}

