/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessEventEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessEventEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessEventEntryEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessEventEntryEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessEventManager;

public class CreateProcessEventCmd
implements Command<ProcessEventEntity> {
    private String eventNumber;
    private String eventName;
    private JSONArray eventParams;

    public CreateProcessEventCmd(String eventNumber, String eventName, JSONArray eventParams) {
        this.eventNumber = eventNumber;
        this.eventName = eventName;
        this.eventParams = eventParams;
    }

    @Override
    public ProcessEventEntity execute(CommandContext commandContext) {
        StringBuilder onlyNumberStr = new StringBuilder();
        onlyNumberStr.append(this.eventNumber);
        if (this.eventParams != null && this.eventParams.size() > 0) {
            for (int i = 0; i < this.eventParams.size(); ++i) {
                JSONObject jsonObject = this.eventParams.getJSONObject(i);
                onlyNumberStr.append(jsonObject.get((Object)"number"));
            }
        }
        String onlyNumber = onlyNumberStr.toString();
        int uniqueNumber = onlyNumber.hashCode();
        ProcessEventManager processEventManager = commandContext.getProcessEngineConfiguration().getProcessEventManager();
        List<ProcessEventEntity> processEventEntities = processEventManager.getProcessEventByNumber(uniqueNumber);
        if (processEventEntities != null && processEventEntities.size() > 0) {
            return processEventEntities.get(0);
        }
        ProcessEventEntityImpl processEventEntity = ProcessEventEntityImpl.create();
        processEventEntity.setEnable("1");
        processEventEntity.setEventNumber(this.eventNumber);
        processEventEntity.setEventName((ILocaleString)new LocaleString(this.eventName));
        processEventEntity.setUniqueNumber(uniqueNumber);
        ArrayList<ProcessEventEntryEntity> processEventEntryEntities = new ArrayList<ProcessEventEntryEntity>();
        if (this.eventParams != null && this.eventParams.size() > 0) {
            for (int i = 0; i < this.eventParams.size(); ++i) {
                JSONObject jsonObject = this.eventParams.getJSONObject(i);
                if (jsonObject == null) continue;
                ProcessEventEntryEntityImpl processEventEntryEntity = new ProcessEventEntryEntityImpl();
                processEventEntryEntity.setEntryNumber(jsonObject.getString("number"));
                processEventEntryEntity.setEntryName((ILocaleString)new LocaleString(jsonObject.get((Object)"name") == null ? "" : jsonObject.getString("name")));
                processEventEntryEntity.setSeq(i);
                processEventEntryEntities.add(processEventEntryEntity);
            }
            processEventEntity.setEntryentity(processEventEntryEntities);
        }
        processEventManager.insert(processEventEntity);
        return processEventEntity;
    }
}

