/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cmd.model.AddNodeTemplateLogCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeToolBoxEntityConstants;

public class DeleteNodeTemplateByNumberCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 4981718448634544228L;
    private List<String> nodeTemplateNumbers;

    public DeleteNodeTemplateByNumberCmd(List<String> nodeTemplateNumbers) {
        this.nodeTemplateNumbers = nodeTemplateNumbers;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        NodeTemplateEntityManager nodeTemplateEntityManager = commandContext.getNodeTemplateEntityManager();
        QFilter[] filters = new QFilter[]{new QFilter("number", "in", this.nodeTemplateNumbers)};
        List deleteNodeTemplates = nodeTemplateEntityManager.findByQueryFilters(filters);
        ArrayList<Long> nodeTemplateIds = new ArrayList<Long>(this.nodeTemplateNumbers.size());
        for (NodeTemplateEntity nodeTemplateEntity : deleteNodeTemplates) {
            nodeTemplateIds.add(nodeTemplateEntity.getId());
            nodeTemplateEntityManager.delete(nodeTemplateEntity);
            new AddNodeTemplateLogCmd(null, nodeTemplateEntity, "delete").execute(commandContext);
            WfCacheHelper.removeStencilConfigTime(nodeTemplateEntity.getNumber());
        }
        ArrayList<Long> toolConfigPks = new ArrayList<Long>(this.nodeTemplateNumbers.size());
        DynamicObject toolBox = BusinessDataServiceHelper.loadSingle((Object)NodeToolBoxEntityConstants.DEFAULTID, (String)"wf_nodetoolbox");
        DynamicObjectCollection nodeTemplateDynaCollection = toolBox.getDynamicObjectCollection("nodetemplateentryentity");
        for (DynamicObject dynamicObject : nodeTemplateDynaCollection) {
            if (!nodeTemplateIds.contains(dynamicObject.get("nodetemplate.id"))) continue;
            toolConfigPks.add(dynamicObject.getLong("id"));
        }
        DynamicObject roleperm = BusinessDataServiceHelper.newDynamicObject((String)"wf_nodetoolbox");
        DynamicObjectCollection toolConfigCollection = roleperm.getDynamicObjectCollection("nodetemplateentryentity");
        DeleteServiceHelper.delete((IDataEntityType)toolConfigCollection.getDynamicObjectType(), (Object[])toolConfigPks.toArray(new Long[toolConfigPks.size()]));
        return null;
    }
}

