/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.ModelDataChangeLogEntity;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class DeleteProcessByProcDefIdCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String PROCDEFID = "procdefid";
    private static final String NEWPROCDEFID = "newprocdefid";
    private static final String PERSONANALYSISENTITYMANAGER = "kd.bos.workflow.analysis.entity.PersonAnalysisEntityManager";
    private static final String PROCANALYSISENTITYMANAGER = "kd.bos.workflow.analysis.entity.ProcAnalysisEntityManager";
    private static final String PLUGINPROCINFOENTITYMANAGER = "kd.bos.workflow.devops.entity.PluginProcInfoEntityManager";
    private static final String NODEANALYSISENTITYMANAGER = "kd.bos.workflow.analysis.entity.NodeAnalysisEntityManager";
    private Long procDefId;

    public DeleteProcessByProcDefIdCmd(Long procDefId) {
        this.procDefId = procDefId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.procDefId == null) {
            throw new WFIllegalArgumentException("procDefId is null");
        }
        this.deleteProcessDefinitionInfo(commandContext);
        return null;
    }

    private void deleteProcessDefinitionInfo(CommandContext commandContext) {
        HashSet<Long> canDeleteResourceId = new HashSet<Long>(1);
        ProcessDefinitionEntity entity = (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(this.procDefId);
        canDeleteResourceId.add(entity.getResourceId());
        Long modelId = entity.getModelId();
        QFilter[] f1 = new QFilter[]{new QFilter("modelid", "=", (Object)modelId)};
        List list = commandContext.getProcessDefinitionEntityManager().findByQueryFilters(f1, "id", null);
        if (list.size() <= 1) {
            ModelEntity modelEntity = (ModelEntity)commandContext.getModelEntityManager().findById(modelId);
            canDeleteResourceId.add(modelEntity.getBPMNXMLID());
            commandContext.getModelEntityManager().delete(modelEntity);
        }
        QFilter[] f2 = new QFilter[]{new QFilter(PROCDEFID, "=", (Object)this.procDefId)};
        List changeLogList = commandContext.getModelDataChangeLogEntityManager().findByQueryFilters(f2);
        for (ModelDataChangeLogEntity changeLog : changeLogList) {
            canDeleteResourceId.add(changeLog.getResourceId());
        }
        commandContext.getModelDataChangeLogEntityManager().deleteChangeLogsByProcDefId(this.procDefId);
        QFilter[] f3 = new QFilter[]{new QFilter(NEWPROCDEFID, "=", (Object)this.procDefId)};
        List relationEntities = commandContext.getResourceRelationEntityManager().findByQueryFilters(f3);
        for (Object relationEntity : relationEntities) {
            canDeleteResourceId.add(relationEntity.getNewResourceId());
            canDeleteResourceId.add(relationEntity.getOriginalResourceId());
        }
        commandContext.getResourceRelationEntityManager().deleteByFilters(this.getFilters(NEWPROCDEFID));
        List<DynamicConfigSchemeEntity> dyList = commandContext.getDynamicConfigSchemeEntityManager().getSchemesByProcDefId(this.procDefId, true);
        for (DynamicConfigSchemeEntity dyEntity : dyList) {
            canDeleteResourceId.add(dyEntity.getJsonResourceId());
            canDeleteResourceId.add(dyEntity.getJsonPatchId());
        }
        commandContext.getDynamicConfigSchemeEntityManager().deleteByFilters(this.getFilters("processdefinitionid"));
        QFilter[] f4 = new QFilter[]{new QFilter("id", "in", canDeleteResourceId)};
        commandContext.getResourceEntityManager().deleteByFilters(f4);
        commandContext.getProcessDefinitionEntityManager().delete(this.procDefId);
        commandContext.getConditionRuleEntityManager().deleteByFilters(this.getFilters(PROCDEFID));
        commandContext.getHistoricConditionalRuleEntityManager().deleteByFilters(this.getFilters(PROCDEFID));
        commandContext.getProcessConfigEntityManager().deleteByFilters(this.getFilters(PROCDEFID));
        commandContext.getModifyLogEntityManager().deleteByFilters(this.getFilters(PROCDEFID));
        commandContext.getProcessInfoEntityManager().deleteProcessInfoByProcDefId(this.procDefId);
        commandContext.getConditionParseLogManager().deleteByFilters(this.getFilters("processdefinitionid"));
        commandContext.getWorksTransferLogEntityManager().deleteByFilters(this.getFilters("processdefinitionid"));
        commandContext.getDelegateSettingEntityManager().deleteByFilters(this.getFilters("processdefinitionid"));
        commandContext.getHistoricDelegateSettingEntityManager().deleteByFilters(this.getFilters("processdefinitionid"));
        commandContext.getEventSubscriptionEntityManager().deleteEventSubscriptionsByProcessDefinitionId(this.procDefId);
        commandContext.getBaseDataRefRecordManager().deleteByFilters(this.getFilters(PROCDEFID));
        commandContext.getParticipantModelEntityManager().deleteByprocdeId(this.procDefId);
        commandContext.getEntityManager(PERSONANALYSISENTITYMANAGER).deleteByFilters(this.getFilters(PROCDEFID));
        commandContext.getEntityManager(PROCANALYSISENTITYMANAGER).deleteByFilters(this.getFilters(PROCDEFID));
        commandContext.getEntityManager(PLUGINPROCINFOENTITYMANAGER).deleteByFilters(this.getFilters(PROCDEFID));
        commandContext.getEntityManager(NODEANALYSISENTITYMANAGER).deleteByFilters(this.getFilters(PROCDEFID));
        WfUtils.addOpLog("wf_processdefinition", "delete", new MultiLangEnumBridge("\u5220\u9664\u6d41\u7a0b", "DeleteProcessByProcDefIdCmd_1", "bos-wf-engine"), null, String.format("procDefId:[%s]", this.procDefId));
    }

    private QFilter[] getFilters(String property) {
        return new QFilter[]{new QFilter(property, "=", (Object)this.procDefId)};
    }
}

