/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.bpmn.model.deploy.DeployModel;
import kd.bos.workflow.domain.model.NodeLifecycleUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillSubjectModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ExtractMultiLanguageWordsUtil;
import kd.bos.workflow.engine.impl.util.ImportExportProcessUtil;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class DeployModelCmd
implements Command<Long>,
Serializable {
    private static final long serialVersionUID = -5120668326777509321L;
    protected static Log logger = LogFactory.getLog(DeployModelCmd.class);
    private static final String ENTRYENTITY = "entryentity";
    private transient DeployModel deployModel;
    protected boolean isCoverModel;
    private Boolean isCoverSummaryCfg;

    public DeployModelCmd(DeployModel deployModel, boolean isCover) {
        this.deployModel = deployModel;
        this.isCoverModel = isCover;
    }

    public DeployModelCmd(DeployModel deployModel, boolean isCover, Boolean isCoverSummaryCfg) {
        this(deployModel, isCover);
        this.isCoverSummaryCfg = isCoverSummaryCfg;
    }

    @Override
    public Long execute(CommandContext commandContext) {
        if (this.deployModel == null) {
            throw new WFIllegalArgumentException(ResManager.loadKDString((String)"\u5b9e\u4f8b\u5316\u90e8\u7f72\u5bf9\u8c61deployModel\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DeployModelCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        return this.importModel(commandContext);
    }

    private Long importModel(CommandContext commandContext) {
        Long modelId = null;
        if (this.deployModel == null) {
            logger.error("\u83b7\u53d6\u5bfc\u5165\u6a21\u578b\u4e3a\u7a7a");
            return modelId;
        }
        try {
            modelId = this.importCategoryModelAndResource(commandContext);
            this.insertBillSubject(commandContext);
            this.insertCommonBaseDatas(commandContext, this.deployModel);
            this.executeListener(commandContext);
        }
        catch (OrmException | KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s. sql:%s", e.getMessage(), "deployCard")});
        }
        return modelId;
    }

    protected Long importCategoryModelAndResource(CommandContext commandContext) {
        Long modelId = null;
        List<DynamicObject> categories = this.deployModel.getCategories();
        List<DynamicObject> models = this.deployModel.getModels();
        List<DynamicObject> resources = this.deployModel.getResources();
        ProcessCategoryEntity category = ImportExportProcessUtil.insertProcessCategoryIfNeed(commandContext, categories);
        if (this.isCoverModel) {
            modelId = this.updateModelAndResource(commandContext, models, resources);
        } else {
            ModelEntity model = this.insertModel(models, commandContext, category);
            this.insertResources(resources, model, commandContext);
            if (model != null) {
                modelId = model.getId();
            }
        }
        return modelId;
    }

    protected void executeListener(CommandContext commandContext) {
        final List<DynamicObject> models = this.deployModel.getModels();
        if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
            HashMap<String, String> params = new HashMap<String, String>(1);
            if (models != null && !models.isEmpty()) {
                String modelNumber = models.get(0).getString("key");
                params.put("processNumber", modelNumber);
            }
            new EventTriggerCmd("wf.AfterImportModelEvent", SerializationUtils.toJsonString(params)).execute(commandContext);
        }
        if (models != null && !models.isEmpty()) {
            commandContext.addCloseListener(new DefaultCommandContextCloseListener("lifecycleListener"){

                @Override
                public void closed(CommandContext commandContext) {
                    try {
                        NodeLifecycleUtil.executeLifecycleImportListener((DynamicObject)models.get(0));
                    }
                    catch (Exception e) {
                        this.log.error(WfUtils.getExceptionStacktrace(e));
                    }
                }
            });
        }
    }

    private Long updateModelAndResource(CommandContext commandContext, List<DynamicObject> models, List<DynamicObject> resources) {
        ProcessDefinitionEntity processDefinition;
        ModelEntityManager modelManager = commandContext.getModelEntityManager();
        DynamicObject modelObject = models.get(0);
        String modelKey = modelObject.getString("key");
        QFilter[] filters = new QFilter[]{new QFilter("key", "=", (Object)modelKey)};
        ModelEntity model = (ModelEntity)modelManager.findByQueryFilters(filters).get(0);
        model.setEntraBill(modelObject.getString("entrabill"));
        String entraBillId = modelObject.getString("entrabillid_id");
        model.setEntraBillId(entraBillId);
        String applicationId = modelObject.getString("applicationid");
        if (WfUtils.isEmpty(applicationId)) {
            applicationId = WfUtils.getApplicationIdByBillId(entraBillId);
        }
        model.setApplicationId(applicationId);
        model.setName(modelObject.getLocaleString("name"));
        String businessId = modelObject.getString("businessid");
        model.setDescription(modelObject.getString("description"));
        businessId = StringUtils.isEmpty((Object)businessId) ? modelKey : businessId;
        model.setBusinessId(businessId);
        if (modelObject.get("primarysubprocess") != null) {
            model.setPrimarySubprocess(modelObject.getString("primarysubprocess"));
        }
        modelManager.update(model);
        Long originalResourceId = 0L;
        Long newResourceId = model.getBPMNXMLID();
        ResourceEntity resourceEntity = (ResourceEntity)commandContext.getResourceEntityManager().findById(newResourceId);
        for (DynamicObject resource : resources) {
            String name = resource.getString("name");
            if (!name.endsWith("graph_json")) continue;
            this.setResourceData(resource, resourceEntity);
            originalResourceId = resource.getLong("id");
            break;
        }
        Long modelId = model.getId();
        ExtractMultiLanguageWordsUtil.repairMultiLangResWords(newResourceId, model.getName().toString(), modelId, model.getVersion());
        Long newProcdefId = 0L;
        Long deploymentId = model.getDeploymentId();
        if (!WfUtils.isEmpty(deploymentId) && (processDefinition = commandContext.getProcessDefinitionEntityManager().findProcessDefinitionByDeploymentAndKey(deploymentId, modelKey)) != null) {
            newProcdefId = processDefinition.getId();
        }
        this.recordResourceRelation(originalResourceId, model, newProcdefId, newResourceId);
        BpmnModelUtil.disposeDynamicPartial(resourceEntity.getData(), modelId);
        return modelId;
    }

    private void insertBillSubject(CommandContext commandContext) {
        List<DynamicObject> billSubject = this.deployModel.getBillSubject();
        if (billSubject == null || billSubject.isEmpty()) {
            return;
        }
        BillSubjectModelEntity billEntity = (BillSubjectModelEntity)commandContext.getBillSubjectModelEntityManager().create();
        DynamicObject resource = billSubject.get(0);
        String entityNumber = resource.getString("entityNumber");
        boolean exist = QueryServiceHelper.exists((String)"wf_billsubjectmodel", (QFilter[])new QFilter[]{new QFilter("entityNumber", "=", (Object)entityNumber)});
        if (!exist) {
            billEntity.setId(null);
            billEntity.setBillId(resource.getString("billId"));
            billEntity.setEntityNumber(resource.getString("entityNumber"));
            billEntity.setFormKey(resource.getString("formKey"));
            billEntity.setCreatorId(resource.getLong("creatorId"));
            billEntity.setCreateDate(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
            billEntity.setModifierId(resource.getLong("modifierId"));
            billEntity.setModifyDate(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
            billEntity.setBillName(resource.getLocaleString("billName"));
            ILocaleString billSubjectName = resource.getLocaleString("subjectShowname");
            if (WfUtils.isEmpty(billSubjectName)) {
                billSubjectName = resource.getLocaleString("billSubjectName");
            }
            if (WfUtils.isEmpty(billSubjectName)) {
                billSubjectName = resource.getLocaleString("billSubject");
            }
            billEntity.setBillSubjectName(billSubjectName);
            billEntity.setBillSubject(resource.getLocaleString("billSubject"));
            billEntity.setFormKeyName(resource.getLocaleString("formKeyName"));
            billEntity.setSample(resource.getString("sample"));
            billEntity.setBillSubjectMob(resource.getLocaleString("billSubjectMob"));
            billEntity.setBillSubjectMobName(resource.getLocaleString("billSubjectMobName"));
            billEntity.setBusinessFieldMappingInfo(resource.getString("businessFieldMappingInfo"));
            commandContext.getBillSubjectModelEntityManager().insert(billEntity);
        }
    }

    private void insertCommonBaseDatas(CommandContext commandContext, DeployModel deployModel) {
        ImportExportProcessUtil.insertRoles(commandContext, deployModel.getRoles());
        ImportExportProcessUtil.insertCommonBaseData(deployModel.getOrgType(), "wf_orgtype", true, true, false, ENTRYENTITY);
        ImportExportProcessUtil.insertKeyAuditors(commandContext, deployModel.getKeyAuditor());
        try (TXHandle tx = TX.requiresNew();){
            ImportExportProcessUtil.insertCommonBaseData(deployModel.getMobileFormConfig(), "bos_mobileformconfig", true, true, false, ENTRYENTITY);
        }
        ImportExportProcessUtil.insertMobileBillSummaryCfg(this.isCoverSummaryCfg, deployModel.getMobileBillSummaryCfg());
        ImportExportProcessUtil.insertCommonAuditComment(deployModel.getCommonAuditComment(), "wf_commonauditcommenttree", true, false, false, null);
        ImportExportProcessUtil.insertCommonBaseData(deployModel.getAuditCommentGroup(), "wf_auditcommentgroup", true, false, false, null);
        ImportExportProcessUtil.insertCommonBaseData(deployModel.getExpressionExtension(), "wf_expressionext", true, false, false, null);
    }

    private ModelEntity insertModel(List<DynamicObject> models, CommandContext commandContext, ProcessCategoryEntity category) {
        if (models == null || models.isEmpty()) {
            return null;
        }
        DynamicObject modelObject = models.get(0);
        ModelEntity model = (ModelEntity)commandContext.getModelEntityManager().create();
        model.setOrgUnitId(RequestContext.get().getOrgId());
        model.setCreatorId(Long.valueOf(RequestContext.get().getUserId()));
        model.setModifierId(Long.valueOf(RequestContext.get().getUserId()));
        model.setCreateDate(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
        model.setModifyDate(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
        String key = modelObject.getString("key");
        model.setKey(key);
        model.setName(modelObject.getString("name"));
        String businessId = modelObject.getString("businessid");
        businessId = StringUtils.isEmpty((Object)businessId) ? key : businessId;
        model.setBusinessId(businessId);
        model.setDescription(modelObject.getString("description"));
        model.setCategory(category.getId());
        model.setEntraBill(modelObject.getString("entrabill"));
        String entraBillId = modelObject.getString("entrabillid_id");
        model.setEntraBillId(entraBillId);
        String applicationId = modelObject.getString("applicationid");
        if (WfUtils.isEmpty(applicationId)) {
            applicationId = WfUtils.getApplicationIdByBillId(entraBillId);
        }
        model.setApplicationId(applicationId);
        model.setOperation(modelObject.getString("operation"));
        model.setType(modelObject.getString("type"));
        if (modelObject.get("primarysubprocess") != null) {
            model.setPrimarySubprocess(modelObject.getString("primarysubprocess"));
        }
        commandContext.getModelEntityManager().insert(model, true);
        return model;
    }

    private void insertResources(List<DynamicObject> resources, ModelEntity model, CommandContext commandContext) {
        if (resources == null || resources.isEmpty()) {
            return;
        }
        for (DynamicObject resource : resources) {
            ResourceEntity resourceEntity = (ResourceEntity)commandContext.getResourceEntityManager().create();
            String name = resource.getString("name");
            if (name == null || !name.endsWith("graph_json")) continue;
            resourceEntity.setId(null);
            resourceEntity.setName(name);
            resourceEntity.setDeploymentId(0L);
            resourceEntity.setGenerated(resource.getBoolean("generated"));
            resourceEntity.setCurrentLanguage(resource.getString("currentlanguage"));
            this.setResourceData(resource, resourceEntity);
            commandContext.getResourceEntityManager().insert(resourceEntity);
            Long modelId = model.getId();
            Long newResourceId = resourceEntity.getId();
            model.setBPMNXMLID(newResourceId);
            ExtractMultiLanguageWordsUtil.repairMultiLangResWords(newResourceId, model.getName().toString(), modelId, model.getVersion());
            this.recordResourceRelation(resource.getLong("id"), model, 0L, newResourceId);
            BpmnModelUtil.disposeDynamicPartial(resourceEntity.getData(), modelId);
        }
        commandContext.getModelEntityManager().updateModel(model);
    }

    protected String setResourceData(DynamicObject resource, ResourceEntity resourceEntity) {
        String data = resource.getString("data");
        String content = resource.getString("content");
        if (WfUtils.isNotEmpty(data)) {
            data = this.replaceResourceOrg(data);
            resourceEntity.setData(data);
            resourceEntity.setContent(resource.getLocaleString("content"));
        } else if (WfUtils.isNotEmpty(content)) {
            content = this.replaceResourceOrg(content);
            resourceEntity.setData(content);
        }
        return data;
    }

    private String replaceResourceOrg(String resource) {
        return resource.replaceFirst("(\"itemId\":\"node_1\".*?\"orgUnitId\":\")\\d+(\")", "$1" + RequestContext.get().getOrgId() + "$2");
    }

    private void recordResourceRelation(Long originalResourceId, ModelEntity newModel, Long newProcdefId, Long newResourceId) {
        List<DynamicObject> models = this.deployModel.getModels();
        DynamicObject model = models.get(0);
        ImportExportProcessUtil.insertOrUpdateResRelation(model, originalResourceId, newModel, newProcdefId, newResourceId, this.isCoverModel);
    }
}

