/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.impl.cmd.SuspendProcessDefinitionCmd;
import kd.bos.workflow.engine.impl.cmd.management.AbandonProcessCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntityManager;

public class DiscardProcessesCmd
implements Command<Void> {
    private List<Long> modelIds;
    private boolean disableProcDefinition;
    private boolean terminalProcInst;

    public DiscardProcessesCmd(List<Long> modelIds, boolean disableProcDefinition, boolean terminalProcInst) {
        this.modelIds = modelIds;
        this.disableProcDefinition = disableProcDefinition;
        this.terminalProcInst = terminalProcInst;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ModelEntityManager modelManager = commandContext.getModelEntityManager();
        List models = modelManager.findByQueryFilters(new QFilter[]{new QFilter("id", "in", this.modelIds)});
        if (models.isEmpty()) {
            return null;
        }
        for (ModelEntity model : models) {
            model.setDiscard(true);
            modelManager.update(model);
        }
        if (this.disableProcDefinition) {
            this.disableProcDefinitions(commandContext);
        }
        return null;
    }

    private void disableProcDefinitions(CommandContext commandContext) {
        ProcessDefinitionEntityManager procDefManager = commandContext.getProcessDefinitionEntityManager();
        QFilter[] filters = new QFilter[]{new QFilter("modelid", "in", this.modelIds), new QFilter("enable", "=", (Object)"enable")};
        List procDefs = procDefManager.findByQueryFilters(filters, "id", null);
        HashSet<Long> procDefIds = new HashSet<Long>(procDefs.size());
        for (ProcessDefinitionEntity procDef : procDefs) {
            procDefIds.add(procDef.getId());
            new SuspendProcessDefinitionCmd(procDef.getId(), null, null).execute(commandContext);
        }
        if (this.terminalProcInst && !procDefIds.isEmpty()) {
            this.terminateProcInstances(commandContext, procDefIds);
        }
    }

    private void terminateProcInstances(CommandContext commandContext, Set<Long> procDefIds) {
        QFilter[] filters = new QFilter[]{new QFilter("processDefinitionId", "in", procDefIds), new QFilter("endTime", "is null", null)};
        ILocaleString cause = WFMultiLangConstants.getDiscardProcessText();
        List procInsts = commandContext.getHistoricProcessInstanceEntityManager().findByQueryFilters(filters, "id", null);
        for (HistoricProcessInstanceEntity procInst : procInsts) {
            new AbandonProcessCmd(procInst.getId(), cause, "forceAbort").execute(commandContext);
        }
    }
}

