/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import java.io.Serializable;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.DuplicateModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityManager;
import kd.bos.workflow.engine.impl.util.ExtractMultiLanguageWordsUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class DuplicateAndSaveModelCmd
implements Command<Long>,
Serializable {
    private static final long serialVersionUID = 4988253582369413906L;
    private Long modelId;
    private transient Map<String, Object> duplicateProperties;

    public DuplicateAndSaveModelCmd(Long modelId, Map<String, Object> duplicateProperties) {
        this.modelId = modelId;
        this.duplicateProperties = duplicateProperties;
    }

    @Override
    public Long execute(CommandContext commandContext) {
        if (this.modelId == null || this.duplicateProperties == null) {
            throw new WFIllegalArgumentException("modelId is null");
        }
        ModelEntity modelEntity = (ModelEntity)commandContext.getModelEntityManager().findById(this.modelId);
        if (modelEntity instanceof ModelEntityImpl) {
            Long bpmnxmlId = ((ModelEntityImpl)modelEntity).getBPMNXMLID();
            if (bpmnxmlId == null) {
                throw new WFIllegalArgumentException("resources is not setting!");
            }
            Long newBpmnxmlId = this.insertBpmnxml(commandContext, modelEntity);
            ModelEntity newModelEntity = this.insertModel(commandContext, modelEntity, newBpmnxmlId);
            String appType = "wf";
            if ("BizFlow".equals(newModelEntity.getType())) {
                appType = "bpm";
            }
            WfUtils.addOpLogByAppType(appType, "wf_model", "duplicate", new MultiLangEnumBridge("\u590d\u5236\u6d41\u7a0b", "DuplicateAndSaveModelCmd_2", "bos-wf-engine"), new MultiLangEnumBridge("\u901a\u8fc7\u6d41\u7a0b\u201c%1$s\u201d\u6210\u529f\u590d\u5236\u6d41\u7a0b\u201c%2$s\u201d\u3002", "DuplicateAndSaveModelCmd_3", "bos-wf-engine"), modelEntity.getKey(), newModelEntity.getKey());
            return newModelEntity.getId();
        }
        return null;
    }

    private DuplicateModel getDuplicateModel(ModelEntity modelEntity) {
        String key = (String)this.duplicateProperties.get("key");
        ILocaleString name = (ILocaleString)this.duplicateProperties.get("name");
        ILocaleString description = (ILocaleString)this.duplicateProperties.get("description");
        Long orgunitid = (Long)this.duplicateProperties.get("orgunitid");
        Object businessIdObj = this.duplicateProperties.get("businessid");
        String businessId = businessIdObj == null ? "" : businessIdObj.toString();
        Object primarysubprocess = this.duplicateProperties.get("primarysubprocess");
        DuplicateModel duplicateModel = new DuplicateModel();
        duplicateModel.setModelKey(key);
        duplicateModel.setModelName(name);
        duplicateModel.setModelBusinessId(businessId);
        duplicateModel.setModelDescription(description);
        duplicateModel.setModelOrgunitid(orgunitid.equals(modelEntity.getOrgUnitId()) ? null : orgunitid);
        duplicateModel.setModelKeyOld(modelEntity.getKey());
        duplicateModel.setModelNameOld(modelEntity.getName());
        duplicateModel.setModelDescriptionOld(modelEntity.getDescription());
        duplicateModel.setModelBusinessIdOld(modelEntity.getBusinessId());
        duplicateModel.setSubprocess("sub".equals(primarysubprocess));
        return duplicateModel;
    }

    private String getOldModelBillName(String entraBillId) {
        String oldModelBillName = null;
        return oldModelBillName;
    }

    private Long insertBpmnxml(CommandContext commandContext, ModelEntity modelEntity) {
        ResourceEntityManager resourceEntityManager = commandContext.getResourceEntityManager();
        String newContent = this.getNewContent(resourceEntityManager, modelEntity);
        return this.insertBpmnxmlDo(resourceEntityManager, newContent);
    }

    private Long insertBpmnxmlDo(ResourceEntityManager resourceEntityManager, String newContent) {
        ResourceEntity newBPMNResourceEntity = (ResourceEntity)resourceEntityManager.create();
        newBPMNResourceEntity.setData(newContent);
        String name = this.duplicateProperties.get("key") + "." + "graph_json";
        newBPMNResourceEntity.setName(name);
        resourceEntityManager.insert(newBPMNResourceEntity);
        return newBPMNResourceEntity.getId();
    }

    private String getNewContent(ResourceEntityManager resourceEntityManager, ModelEntity modelEntity) {
        String newContent = null;
        Long bpmnxmlId = modelEntity.getBPMNXMLID();
        ResourceEntity BPMNResourceEntity = (ResourceEntity)resourceEntityManager.findById(bpmnxmlId);
        String content = BPMNResourceEntity.getData();
        BpmnModel model = ProcessDefinitionUtil.getBpmnModel(content);
        DuplicateModel duplicateModel = this.getDuplicateModel(modelEntity);
        BpmnModel modelNew = model.copy(duplicateModel);
        newContent = GraphCodecUtils.convertBpmnModelToJSON(modelNew);
        return newContent;
    }

    private ModelEntity insertModel(CommandContext commandContext, ModelEntity modelEntity, Long bpmnxmlId) {
        Long newModelId = null;
        ModelEntity newModelEntity = (ModelEntity)commandContext.getModelEntityManager().create();
        newModelEntity.setBPMNXMLID(bpmnxmlId);
        newModelEntity.setVersion("");
        newModelEntity.setDeploymentId(null);
        newModelEntity.setPublish(false);
        String key = (String)this.duplicateProperties.get("key");
        ILocaleString name = (ILocaleString)this.duplicateProperties.get("name");
        String businessId = (String)this.duplicateProperties.get("businessid");
        ILocaleString description = (ILocaleString)this.duplicateProperties.get("description");
        String entrabill = (String)this.duplicateProperties.get("entrabill");
        String entrabillid = (String)this.duplicateProperties.get("entrabillid");
        Long orgunitid = (Long)this.duplicateProperties.get("orgunitid");
        String applicationId = (String)this.duplicateProperties.get("applicationid");
        String primarySubprocessTag = (String)this.duplicateProperties.get("primarysubprocess");
        newModelEntity.setKey(key);
        newModelEntity.setName(name);
        newModelEntity.setBusinessId(businessId);
        newModelEntity.setDescription(description);
        newModelEntity.setEntraBill(entrabill);
        newModelEntity.setEntraBillId(entrabillid);
        newModelEntity.setApplicationId(applicationId);
        newModelEntity.setOrgUnitId(orgunitid);
        newModelEntity.setType(modelEntity.getType());
        newModelEntity.setOperation(modelEntity.getOperation());
        newModelEntity.setPrimarySubprocess(primarySubprocessTag);
        newModelEntity.setCategory(modelEntity.getCategory());
        commandContext.getModelEntityManager().insert(newModelEntity);
        newModelId = newModelEntity.getId();
        ExtractMultiLanguageWordsUtil.extractWordsAndSaveOrUpdate(bpmnxmlId, name.getLocaleValue(), newModelId, "", key);
        return newModelEntity;
    }
}

