/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.dynamicpartial.DynamicModelPartial;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.model.BillSettingProcessor;
import kd.bos.workflow.engine.impl.cmd.model.BillSubjectProcessor;
import kd.bos.workflow.engine.impl.cmd.model.ConditionalRuleProcessor;
import kd.bos.workflow.engine.impl.cmd.model.IModelProcessor;
import kd.bos.workflow.engine.impl.cmd.model.ParticipantProcessor;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.context.ModelProcessorContext;
import kd.bos.workflow.engine.impl.db.BatchSQLInfo;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntity;
import kd.bos.workflow.service.WorkflowService;

public class DynamicPartialHelper {
    private static Map<String, IModelProcessor> processorMap = new HashMap<String, IModelProcessor>();

    private DynamicPartialHelper() {
    }

    public static void disposeDynamicPartial(Process process, Long modelId, Long procDefId, Long schemeId) {
        Map<String, List<DynamicModelPartial>> dynamicPartial = process.getDynamicModelPartial();
        List<DynamicModelPartial> partials = null;
        IModelProcessor processor = null;
        ModelProcessorContext context = new ModelProcessorContext();
        for (Map.Entry<String, List<DynamicModelPartial>> entry : dynamicPartial.entrySet()) {
            partials = entry.getValue();
            for (DynamicModelPartial partial : partials) {
                String type = partial.getPartial().getPartialType();
                if ("condition".equals(type) || "subject".equals(type)) continue;
                processor = processorMap.get(type);
                if (!WfUtils.isEmpty(modelId)) {
                    processor.process(context, modelId, partial);
                    continue;
                }
                processor.process(context, partial, procDefId, schemeId);
            }
        }
        CommandContext commandContext = Context.getCommandContext();
        for (Map.Entry<String, List<Object[]>> entry : context.getSqlParamMap().entrySet()) {
            String sql = entry.getKey();
            List<Object[]> params = entry.getValue();
            BatchSQLInfo info = new BatchSQLInfo(sql, params, 500);
            commandContext.getDbSqlSession().addBatchSQLInfo(info);
        }
    }

    public static void updateBpmnModelDynamicPartial(BpmnModel bpmnModel, Long modelId, Long procDefId, Long schemeId) {
        WorkflowService wfService = WfUtils.getWfService();
        RepositoryService repositoryService = wfService.getRepositoryService();
        IModelProcessor processor = null;
        HashSet<String> entityNumberSet = new HashSet<String>(processorMap.size());
        for (Map.Entry<String, IModelProcessor> entry : processorMap.entrySet()) {
            QFilter filter1 = null;
            QFilter filter2 = null;
            QFilter filter3 = null;
            String key = entry.getKey();
            processor = entry.getValue();
            if (entityNumberSet.contains(processor.getEntityNumber())) continue;
            if (!WfUtils.isEmpty(modelId)) {
                if (DynamicPartialHelper.isCondSubBillSettingPartial(key)) continue;
                filter1 = new QFilter("modelid", "=", (Object)modelId);
                filter2 = new QFilter("type", "=", (Object)"person");
            } else {
                filter1 = new QFilter(processor.getProcessDefinitionField(), "=", (Object)procDefId);
                if (DynamicPartialHelper.isParticipantProcessor(key)) {
                    filter2 = new QFilter("type", "=", (Object)"person");
                    filter3 = WfUtils.isNotEmpty(schemeId) ? new QFilter("schemeId", "=", (Object)schemeId) : null;
                }
            }
            List<AbstractEntity> entities = repositoryService.findEntitiesByFilters(processor.getEntityNumber(), new QFilter[]{filter1, filter2, filter3});
            entityNumberSet.add(processor.getEntityNumber());
            if (entities == null || entities.isEmpty()) continue;
            processor.updateBpmnModel(bpmnModel, entities);
        }
    }

    private static boolean isCondSubBillSettingPartial(String key) {
        return "condition".equals(key) || "subject".equals(key) || "billSetting".equals(key);
    }

    private static boolean isParticipantProcessor(String key) {
        return "participant".equals(key) || "receiver".equals(key) || "circulator".equals(key) || "coordinator".equals(key) || "personRangeSetting".equals(key);
    }

    static {
        processorMap.put("participant", new ParticipantProcessor());
        processorMap.put("receiver", new ParticipantProcessor());
        processorMap.put("circulator", new ParticipantProcessor());
        processorMap.put("coordinator", new ParticipantProcessor());
        processorMap.put("personRangeSetting", new ParticipantProcessor());
        processorMap.put("condition", new ConditionalRuleProcessor());
        processorMap.put("subject", new BillSubjectProcessor());
        processorMap.put("billSetting", new BillSettingProcessor());
    }
}

