/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import java.io.Serializable;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.deploy.NodeTemplateModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.model.GetDeployModelFileCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateGroupEntity;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class ExportNodeTemplateCmd
implements Serializable,
Command<DeployFile> {
    private static final long serialVersionUID = 3818433633911856771L;
    protected static Log logger = LogFactory.getLog(GetDeployModelFileCmd.class);
    private String selectNodeTemplateNumber;
    private static final String FILE_SUFFIX = ".nodeTemplate";

    public ExportNodeTemplateCmd(String selectNodeTemplateNumber) {
        this.selectNodeTemplateNumber = selectNodeTemplateNumber;
    }

    @Override
    public DeployFile execute(CommandContext commandContext) {
        if (WfUtils.isEmpty(this.selectNodeTemplateNumber)) {
            throw new WFIllegalArgumentException(ResManager.loadKDString((String)"\u8282\u70b9\u6a21\u677f\u7684\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExportNodeTemplateCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        return this.getExportNodeTemplateModel(this.selectNodeTemplateNumber, commandContext);
    }

    private DeployFile getExportNodeTemplateModel(String selectNodeTemplateNumber, CommandContext commandContext) {
        NodeTemplateModel exportNodeTemplate = new NodeTemplateModel();
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)selectNodeTemplateNumber)};
        List nodeTemplates = commandContext.getNodeTemplateEntityManager().findByQueryFilters(filters);
        if (nodeTemplates != null && !nodeTemplates.isEmpty()) {
            NodeTemplateEntity nodeTemplate = (NodeTemplateEntity)nodeTemplates.get(0);
            exportNodeTemplate.getTemplates().add(nodeTemplate.getDynamicObject());
            NodeTemplateGroupEntity groupEntity = (NodeTemplateGroupEntity)commandContext.getNodeTemplateGroupEntityManager().findById(nodeTemplate.getGroupId());
            exportNodeTemplate.getGroups().add(groupEntity.getDynamicObject());
        }
        return exportNodeTemplate.toDeployFile(selectNodeTemplateNumber + FILE_SUFFIX);
    }
}

