/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.bpmn.model.deploy.DeployModel;
import kd.bos.workflow.domain.model.NodeLifecycleUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.util.ImportExportProcessUtil;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class GetDeployModelFileCmd
implements Serializable,
Command<DeployFile> {
    private static final long serialVersionUID = 3818433633911856771L;
    protected Log logger = LogFactory.getLog(this.getClass());
    private long modelId;
    private static final String FILE_SUFFIX = ".process";

    public GetDeployModelFileCmd(long modelId) {
        this.modelId = modelId;
    }

    @Override
    public DeployFile execute(CommandContext commandContext) {
        if (WfUtils.isEmpty(this.modelId)) {
            throw new WFIllegalArgumentException(ResManager.loadKDString((String)"\u6d41\u7a0b\u6a21\u578b\u7684modelID\u4e3a\u7a7a\u3002", (String)"GetDeployModelFileCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        return this.getDeployModel(commandContext, this.modelId);
    }

    protected DeployFile getDeployModel(CommandContext commandContext, Long id) {
        DeployModel deploy = this.getDeployModel();
        DynamicObject model = this.loadModel(id, deploy);
        this.loadCategory(deploy, model);
        Long bpmnxmlid = this.getResourceId(model);
        String data = this.loadResource(deploy, bpmnxmlid);
        this.loadBillSubject(deploy, model);
        this.loadBaseDatasForModel(deploy, data);
        this.executeListener(commandContext, model);
        return deploy.toDeployFile(this.getDeployFileName(model));
    }

    protected void executeListener(CommandContext commandContext, final DynamicObject model) {
        String key = model.getString("key");
        if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
            HashMap<String, String> params = new HashMap<String, String>(1);
            params.put("processNumber", key);
            new EventTriggerCmd("wf.AfterExportModelEvent", SerializationUtils.toJsonString(params)).execute(commandContext);
        }
        commandContext.addCloseListener(new DefaultCommandContextCloseListener("lifecycleListener"){

            @Override
            public void closed(CommandContext commandContext) {
                try {
                    NodeLifecycleUtil.executeLifecycleExportListener(model);
                }
                catch (Exception e) {
                    this.log.error(WfUtils.getExceptionStacktrace(e));
                }
            }
        });
    }

    protected DeployModel getDeployModel() {
        return new DeployModel();
    }

    protected long getResourceId(DynamicObject model) {
        return model.getLong("bpmnxmlid");
    }

    protected String getDeployFileName(DynamicObject model) {
        String key = model.getString("key");
        return key + FILE_SUFFIX;
    }

    protected String getEntityNumber(DynamicObject model) {
        return model.getString("entrabill");
    }

    protected DynamicObject loadModel(Long id, DeployModel deploy) {
        DynamicObject[] models = BusinessDataReader.load((Object[])new Long[]{id}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"wf_model"), (Boolean)Boolean.TRUE);
        if (models == null || models.length == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u6a21\u578b\u4fe1\u606f\u8bfb\u53d6\u5f02\u5e38\uff0cModelID\uff1a%s\u3002", (String)"GetDeployModelFileCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]), id));
        }
        DynamicObject model = models[0];
        deploy.getModels().add(model);
        return model;
    }

    protected void loadCategory(DeployModel deploy, DynamicObject model) {
        Long categoryid = 0L;
        DynamicObject category = (DynamicObject)model.get("categoryid");
        if (category != null) {
            categoryid = category.getLong("id");
        }
        Long parentCategoryid = 0L;
        DynamicObject[] categories = BusinessDataReader.load((Object[])new Long[]{categoryid}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"wf_processcagetory"), (Boolean)Boolean.FALSE);
        if (categories != null && categories.length == 1) {
            deploy.getCategories().add(categories[0]);
            if (categories[0].getBoolean("isleaf")) {
                parentCategoryid = categories[0].getLong("parentid");
            }
        } else {
            this.logger.warn("\u8bfb\u53d6\u6d41\u7a0b\u5b50\u7c7b\u522b\u4fe1\u606f\u5f02\u5e38");
        }
        if (WfUtils.isNotEmpty(parentCategoryid)) {
            categories = BusinessDataReader.load((Object[])new Long[]{parentCategoryid}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"wf_processcagetory"), (Boolean)Boolean.FALSE);
            if (categories != null && categories.length == 1) {
                deploy.getCategories().add(categories[0]);
            } else {
                this.logger.warn("\u8bfb\u53d6\u6d41\u7a0b\u7236\u7c7b\u522b\u4fe1\u606f\u5f02\u5e38");
            }
        }
    }

    private String loadResource(DeployModel deploy, Long bpmnxmlid) {
        String data = "";
        if (WfUtils.isNotEmpty(bpmnxmlid)) {
            DynamicObject resource = BusinessDataReader.loadSingle((Object)bpmnxmlid, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"wf_resource"), (Boolean)Boolean.FALSE);
            if (resource != null) {
                data = resource.getString("data");
                deploy.getResources().add(resource);
            } else {
                this.logger.warn("\u8bfb\u53d6\u6d41\u7a0b\u8d44\u6e90\u4fe1\u606f\u5f02\u5e38");
            }
        } else {
            this.logger.warn("\u6d41\u7a0b\u8d44\u6e90\u4fe1\u606f\u4e3a\u7a7a\u6216\u7f3a\u5c11");
        }
        return data;
    }

    private void loadBillSubject(DeployModel deploy, DynamicObject model) {
        String entityNumber = this.getEntityNumber(model);
        DynamicObject billSubject = BusinessDataServiceHelper.loadSingle((String)"wf_billsubjectmodel", (String)"id,billId,billName,billSubject,entityNumber,formKey,formKeyName,businessFieldMappingInfo", (QFilter[])new QFilter[]{new QFilter("entityNumber", "=", (Object)entityNumber)});
        if (billSubject != null) {
            deploy.getBillSubject().add(billSubject);
        }
    }

    private void loadBaseDatasForModel(DeployModel deploy, String data) {
        ImportExportProcessUtil.loadBaseDataForModel("wf_role", data, true, null, deploy.getRoles());
        ImportExportProcessUtil.loadBaseDataForModel("wf_orgtype", data, true, null, deploy.getOrgType());
        ImportExportProcessUtil.loadBaseDataForModel("wf_keyauditor", data, true, null, deploy.getKeyAuditor());
        ImportExportProcessUtil.loadMobileBillSummaryForModel("bos_mobileformconfig", data, deploy.getMobileFormConfig());
        ImportExportProcessUtil.loadMobileBillSummaryForModel("wf_mbillsummary_cfg", data, deploy.getMobileBillSummaryCfg());
        Set<Long> auditCommentIds = ImportExportProcessUtil.loadCommonAuditCommentForModel("wf_commonauditcommenttree", data, deploy.getCommonAuditComment());
        ImportExportProcessUtil.loadAuditCommentGroupForSchemeOrModel("wf_auditcommentgroup", auditCommentIds, deploy.getAuditCommentGroup());
        ImportExportProcessUtil.loadBaseDataForModel("wf_expressionext", data, false, "mc_", deploy.getExpressionExtension());
    }
}

