/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.SignalEventSubscriptionEntityImpl;

public class GetEventSubScrCmd
implements Command<EventSubscriptionEntity> {
    private Long procdefId;
    private String eventName;

    public GetEventSubScrCmd(Long procdefId, String eventName) {
        this.procdefId = procdefId;
        this.eventName = eventName;
    }

    @Override
    public EventSubscriptionEntity execute(CommandContext commandContext) {
        String sql = "SELECT A.FID id, A.FEVENTTYPE eventType, A.FEVENTNAME eventName, A.FEXECUTIONID executionId, A.FPROCINSTID processInstanceId, A.FACTIVITYID activityId, A.FCONFIGURATION configuration, A.FPROCDEFID processDefinitionId, A.fversion version FROM T_WF_EVENTSUBSCR A WHERE A.FEVENTNAME = ? AND A.FPROCDEFID = ?";
        Object[] params = new Object[]{this.eventName, this.procdefId};
        SignalEventSubscriptionEntityImpl entity = null;
        try (DataSet ds = DB.queryDataSet((String)"wf_eventsubscr.queryGridData", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            Row row;
            String eventType;
            Iterator iter = ds.iterator();
            if (iter.hasNext() && "signal".equals(eventType = (row = (Row)iter.next()).getString("eventType"))) {
                entity = new SignalEventSubscriptionEntityImpl();
                entity.setEventType(eventType);
                entity.setId(row.getLong("id"));
                entity.setEventName(row.getString("eventName"));
                entity.setExecutionId(row.getLong("executionId"));
                entity.setProcessInstanceId(row.getLong("processInstanceId"));
                entity.setActivityId(row.getString("activityId"));
                entity.setConfiguration(row.getString("configuration"));
                entity.setProcessDefinitionId(row.getLong("processDefinitionId"));
                entity.setVersion(row.getString("version"));
            }
        }
        return entity;
    }
}

