/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import java.util.ArrayList;
import java.util.List;
import kd.bos.workflow.bpmn.model.BillSetting;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillPageAttributeConfigEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class GetPageAttrCfgCmd
implements Command<Object> {
    private Long procdefId;
    private String actId;
    private String pageNumber;
    private String businessKey;
    private Boolean pcShow;
    private Long procInstanceId;

    public GetPageAttrCfgCmd(Long procdefId, String actId, String pageNumber) {
        this.procdefId = procdefId;
        this.actId = actId;
        this.pageNumber = pageNumber;
    }

    public GetPageAttrCfgCmd(String businessKey, Long procdefId, Long procInstanceId, String actId, String pageNumber, Boolean pcShow) {
        this(procdefId, actId, pageNumber);
        this.businessKey = businessKey;
        this.pcShow = pcShow;
        this.procInstanceId = procInstanceId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (WfUtils.isEmpty(this.businessKey)) {
            return this.getPageAttrConfigFromDB(commandContext);
        }
        return this.getPageAttrConfigFromBpmnModel(commandContext);
    }

    @Deprecated
    private List<BillPageAttributeConfigEntity> compatable(CommandContext commandContext) {
        return null;
    }

    private Object getPageAttrConfigFromDB(CommandContext commandContext) {
        return commandContext.getBillPageAttributeConfigEntityManager().findEntitysByProcdefidAndTaskdefid(this.procdefId, this.actId, this.pageNumber, true);
    }

    private Object getPageAttrConfigFromBpmnModel(CommandContext commandContext1) {
        if (this.procdefId == null && this.procInstanceId == null) {
            return new ArrayList();
        }
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(this.procdefId, this.procInstanceId);
        if (null == bpmnModel) {
            return new ArrayList();
        }
        UserTask currentNode = (UserTask)bpmnModel.getFlowElement(this.actId);
        if (null == currentNode) {
            return new ArrayList();
        }
        BillSetting billSetting = currentNode.getBillSetting();
        if (billSetting == null) {
            return new ArrayList();
        }
        Object configs = null;
        if (this.pcShow.booleanValue()) {
            configs = billSetting.getPageAttrConfigModel();
            if (null == configs) {
                configs = billSetting.getPageAttrConfig();
            }
        } else {
            configs = billSetting.getMobilePageAttrConfigModel();
            if (null == configs) {
                configs = billSetting.getMobilePageAttrConfig();
            }
        }
        return configs;
    }
}

