/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import com.alibaba.fastjson.JSONObject;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.converter.util.ModelConfigUtil;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.dynprocess.freeflow.WFAuditTask;
import kd.bos.workflow.engine.dynprocess.freeflow.WFAutoTask;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowElement;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowNode;
import kd.bos.workflow.engine.dynprocess.freeflow.WFJointAuditTask;
import kd.bos.workflow.engine.dynprocess.freeflow.WFSequenceFlow;
import kd.bos.workflow.engine.dynprocess.freeflow.WFUserTask;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.bpmn.helper.BPMNUtil;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.ReflectUtil;
import kd.bos.workflow.exception.WFException;
import kd.bos.workflow.exception.WFIllegalArgumentException;
import org.apache.commons.beanutils.PropertyUtils;

public class GetProcessElementsCmd
implements Command<List<WFFlowElement>>,
Serializable {
    private static final long serialVersionUID = -3159986007795118482L;
    private Log log = LogFactory.getLog(this.getClass());
    public static final String PARAM_BILL = "bill";
    public static final String PARAM_OPERATION = "operation";
    public static final String PARAM_PROCESSNUMBER = "number";
    public static final String PARAM_VERSION = "version";
    public static final String PARAM_PROCDEFID = "procDefId";
    private String VERSION_LATEST = "latest";
    private Map<String, Class<?>> classMap = new HashMap();
    private Map<Class<?>, List<PropertyDescriptor>> propertyMap = new HashMap();
    private Map<String, String> multiPropMap = new HashMap<String, String>();
    protected Map<String, Object> params;
    private JSONObject multiLangDatas;
    protected String propertyPath;

    private void init() {
        this.classMap.put("SequenceFlow", WFSequenceFlow.class);
        this.classMap.put("StartSignalEvent", WFFlowNode.class);
        this.classMap.put("EndNoneEvent", WFFlowNode.class);
        this.classMap.put("UserTask", WFUserTask.class);
        this.classMap.put("AuditTask", WFAuditTask.class);
        this.classMap.put("YunzhijiaTask", WFJointAuditTask.class);
        this.classMap.put("AutoTask", WFAutoTask.class);
        this.classMap.put("NotifyTask", WFFlowNode.class);
        this.classMap.put("BoundaryErrorEvent", WFFlowNode.class);
        this.classMap.put("WaitTask", WFFlowNode.class);
        this.classMap.put("InclusiveGateway", WFFlowNode.class);
        this.classMap.put("CallActivity", WFFlowNode.class);
        this.classMap.put("RPATask", WFFlowNode.class);
        this.classMap.put("AutoMicroServiceTask", WFFlowNode.class);
        this.initExtendedNodeClass();
        this.multiPropMap.put("name", "%s.name");
        this.multiPropMap.put("autoAudit.autoOpinionWhenMatch", "%s.autoAudit.autoOpinionWhenMatch");
        this.multiPropMap.put("autoAudit.processHandler", "%s.autoAudit.processHandler");
        this.multiPropMap.put("decisionOptions.[id].name", "%s.decisionOptions.[%s].name");
        this.multiPropMap.put("decisionOptions.[id].rejectOptions.[itemId].name", "%s.decisionOptions.[%s].rejectOptions.[%s].name");
        this.multiPropMap.put("entraBillName", "%s.entraBillName");
    }

    public GetProcessElementsCmd(Map<String, Object> params) {
        this.params = params;
        this.init();
    }

    private void initExtendedNodeClass() {
        Set<String> types = ModelConfigUtil.getAllExtendedStencilTypes();
        if (types == null || types.isEmpty()) {
            return;
        }
        for (String stencilType : types) {
            String parentType = ModelConfigUtil.getExtendNodeInheritStencilType(stencilType);
            if (parentType == null) continue;
            this.classMap.put(stencilType, this.classMap.get(parentType));
        }
    }

    @Override
    public List<WFFlowElement> execute(CommandContext commandContext) {
        if (this.params == null || this.params.isEmpty()) {
            throw new WFIllegalArgumentException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GetProcessElementsCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        Long procDefId = (Long)this.params.get(PARAM_PROCDEFID);
        String processNumber = (String)this.params.get(PARAM_PROCESSNUMBER);
        DynamicObject bill = (DynamicObject)this.params.get(PARAM_BILL);
        if (WfUtils.isEmpty(processNumber) && bill == null && WfUtils.isEmpty(procDefId)) {
            throw new WFIllegalArgumentException(ResManager.loadKDString((String)"\u53c2\u6570\u6d41\u7a0b\u7f16\u7801(number)\u6216\u5355\u636e\u4fe1\u606f(bill)\u6216\u6d41\u7a0b\u5b9a\u4e49ID(procDefId)\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"GetProcessElementsCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        ProcessDefinitionEntity processDefinition = null;
        if (WfUtils.isNotEmpty(procDefId)) {
            processDefinition = (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(procDefId);
        } else if (WfUtils.isNotEmpty(processNumber)) {
            String version = (String)this.params.get(PARAM_VERSION);
            processDefinition = this.getProcessDefinition(commandContext, processNumber, version);
        } else {
            String operation = (String)this.params.get(PARAM_OPERATION);
            processDefinition = this.getProcessDefinition(commandContext, bill, operation);
        }
        try {
            List<WFFlowElement> result = this.getProcessElements(commandContext, processDefinition);
            return result;
        }
        catch (Exception e) {
            throw new WFException(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u8282\u70b9\u83b7\u53d6\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"GetProcessElementsCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private ProcessDefinitionEntity getProcessDefinition(CommandContext commandContext, DynamicObject bill, String operation) {
        if (WfUtils.isEmpty(operation)) {
            operation = "submit";
        }
        return BPMNUtil.findProcessDefinition(commandContext, bill, operation);
    }

    private ProcessDefinitionEntity getProcessDefinition(CommandContext commandContext, String processNumber, String version) {
        if (WfUtils.isNotEmpty(version) && !this.VERSION_LATEST.equals(version)) {
            return BPMNUtil.findProcessDefinition(commandContext, processNumber, version);
        }
        return BPMNUtil.findProcessDefinition(commandContext, processNumber, null);
    }

    private List<WFFlowElement> getProcessElements(CommandContext commandContext, ProcessDefinitionEntity procDef) {
        if (procDef == null) {
            return null;
        }
        ResourceEntity resource = (ResourceEntity)commandContext.getResourceEntityManager().findById(procDef.getResourceId());
        try {
            return this.getProcessElements(procDef, resource);
        }
        catch (Exception e) {
            this.log.warn(WfUtils.getExceptionStacktrace(e));
            return null;
        }
    }

    protected List<WFFlowElement> getProcessElements(Entity entity, ResourceEntity resource) {
        ArrayList<WFFlowElement> elements = null;
        if (resource == null) {
            this.log.debug(String.format("Cann't found resource %s!", entity.getId()));
            return elements;
        }
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(resource.getData());
        this.multiLangDatas = BpmnModelUtil.getMultiLangDatasFromResource(resource);
        List<FlowElement> flowElements = bpmnModel.getMainProcess().getFlowElementList();
        int size = flowElements.size();
        elements = new ArrayList<WFFlowElement>(size);
        HashMap<String, WFFlowElement> elementMap = new HashMap<String, WFFlowElement>(size);
        for (FlowElement flowElement : flowElements) {
            String type = flowElement.getType();
            Class<?> clazz = this.classMap.get(type);
            if (clazz == null) {
                this.log.debug(String.format("Cann't found the class of type %s!", type));
                continue;
            }
            String nodeId = flowElement.getId();
            WFFlowElement element = null;
            try {
                element = (WFFlowElement)this.createElement(clazz, flowElement, new ConvertContext(nodeId));
                elements.add(element);
                elementMap.put(nodeId, element);
            }
            catch (Exception e) {
                this.log.error(WfUtils.getExceptionStacktrace(e));
            }
        }
        this.initElementRelation(elementMap, flowElements);
        return elements;
    }

    private void initElementRelation(Map<String, WFFlowElement> elementMap, List<FlowElement> flowElements) {
        FlowNode flowNode = null;
        for (FlowElement flowElement : flowElements) {
            if (flowElement instanceof FlowNode) {
                flowNode = (FlowNode)flowElement;
                WFFlowElement element = elementMap.get(flowNode.getId());
                List<SequenceFlow> flows = flowNode.getOutgoingFlows();
                for (SequenceFlow flow : flows) {
                    WFFlowNode node = (WFFlowNode)elementMap.get(flow.getTargetRef());
                    WFSequenceFlow wfFlow = (WFSequenceFlow)elementMap.get(flow.getId());
                    node.getIncomings().put(wfFlow.getId(), wfFlow);
                    element.getNextNodes().add(node);
                }
                continue;
            }
            if (!(flowElement instanceof SequenceFlow)) continue;
            SequenceFlow sequenceFlow = (SequenceFlow)flowElement;
            WFSequenceFlow wfSequenceFlow = (WFSequenceFlow)elementMap.get(sequenceFlow.getId());
            flowNode = (FlowNode)sequenceFlow.getTargetFlowElement();
            if (!sequenceFlow.getId().equals(flowNode.getDefaultFlow())) continue;
            wfSequenceFlow.setDefaultflow(true);
        }
    }

    private Object createElement(Class<?> clazz, Object oriElement, ConvertContext context) {
        Object element = TypesContainer.createInstance(clazz);
        List<PropertyDescriptor> props = this.getClassProperties(element);
        for (PropertyDescriptor prop : props) {
            String name = prop.getName();
            Class<?> propertyType = prop.getPropertyType();
            Collection<?> oriValue = null;
            try {
                Field field;
                oriValue = GraphCodecUtils.safeGetPropertyValue(oriElement, name);
                Method setMethod = prop.getWriteMethod();
                if (setMethod == null || oriValue == null) continue;
                Object value = oriValue;
                context.pathAppend(name);
                this.propertyPath = context.getPath();
                if (LocaleString.class.equals(propertyType) || ILocaleString.class.equals(propertyType)) {
                    value = this.getMultiPropValue(oriElement, oriValue, context);
                } else if (!ExternalInterfaceUtil.isSameClass(propertyType, oriValue.getClass())) {
                    value = String.class.equals(propertyType) ? String.valueOf(oriValue) : this.createElement(propertyType, oriValue, context);
                } else if (List.class.equals(propertyType) || Set.class.equals(propertyType)) {
                    field = ReflectUtil.getField(name, clazz);
                    if (field == null) {
                        this.log.debug(String.format("%s has no field %s!", clazz, name));
                        context.pathToBack();
                        continue;
                    }
                    value = this.createCollectionElement(field, oriValue, context);
                } else if (Map.class.equals(propertyType) && "extAttrGroup".equals(name)) {
                    field = ReflectUtil.getField(name, clazz);
                    if (field == null) {
                        this.log.debug(String.format("%s has no field %s!", clazz, name));
                        context.pathToBack();
                        continue;
                    }
                    value = this.createMapElement(field, (Map)((Object)oriValue), context);
                }
                setMethod.invoke(element, value);
                context.pathToBack();
            }
            catch (Exception e) {
                this.log.error(WfUtils.getExceptionStacktrace(e));
            }
        }
        return element;
    }

    private Map createMapElement(Field field, Map<String, ?> oriValueMap, ConvertContext context) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (oriValueMap == null || oriValueMap.isEmpty()) {
            return resultMap;
        }
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            ParameterizedType itemType = (ParameterizedType)genericType;
            Class itemClass = (Class)itemType.getActualTypeArguments()[1];
            Set<Map.Entry<String, ?>> entrySet = oriValueMap.entrySet();
            for (Map.Entry<String, ?> entry : entrySet) {
                resultMap.put(entry.getKey(), this.createElement(itemClass, entry.getValue(), context));
            }
            context.pathToBack();
        }
        return resultMap;
    }

    private Collection<?> createCollectionElement(Field field, Collection<?> collection, ConvertContext context) {
        Collection array = (Collection)TypesContainer.createInstance(collection.getClass());
        if (collection.isEmpty()) {
            return array;
        }
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            ParameterizedType itemType = (ParameterizedType)genericType;
            Class itemClass = (Class)itemType.getActualTypeArguments()[0];
            String path = context.getPath();
            String property = this.getProperty(path);
            String uniqueKey = BpmnDiffUtil.getListElementUniqueKey(property);
            context.pathAppend(String.format("[%s]", uniqueKey));
            for (Object item : collection) {
                String itemId = null;
                try {
                    itemId = this.getUniqueKeyValue(item, uniqueKey);
                }
                catch (Exception e) {
                    this.log.error(WfUtils.getExceptionStacktrace(e));
                }
                context.pushListItemId(itemId);
                array.add(this.createElement(itemClass, item, context));
                context.popListItemId();
            }
            context.pathToBack();
        }
        return array;
    }

    private ILocaleString getMultiPropValue(Object oriElement, Object oriValue, ConvertContext context) {
        ILocaleString result = null;
        String path = context.getPath();
        String keyTpl = this.multiPropMap.get(path);
        if (keyTpl != null) {
            String nodeId = context.getNodeId();
            String realPath = path.indexOf(91) > -1 ? String.format(keyTpl, context.getListParams()) : String.format(keyTpl, nodeId);
            result = BpmnModelUtil.getMultiLangFieldValue(this.multiLangDatas, realPath, (String)oriValue);
        } else {
            this.log.warn(String.format("MultilLang property %s's path undefined!", path));
        }
        return result;
    }

    private List<PropertyDescriptor> getClassProperties(Object element) {
        Class<?> clazz = element.getClass();
        List<PropertyDescriptor> props = this.propertyMap.get(clazz);
        if (props == null) {
            props = this.getProperties(clazz);
            this.propertyMap.put(clazz, props);
        }
        return props;
    }

    private List<PropertyDescriptor> getProperties(Class<?> clazz) {
        PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors(clazz);
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(descriptors.length);
        for (PropertyDescriptor descriptor : descriptors) {
            if (Class.class.equals(descriptor.getPropertyType())) continue;
            properties.add(descriptor);
        }
        return properties;
    }

    private String getProperty(String propertyPath) {
        int index = propertyPath.lastIndexOf(46);
        return propertyPath.substring(index + 1);
    }

    private String getUniqueKeyValue(Object object, String uniqueKey) {
        try {
            return String.valueOf(GraphCodecUtils.safeGetPropertyValue(object, uniqueKey));
        }
        catch (Exception e) {
            this.log.warn(WfUtils.getExceptionStacktrace(e));
            return null;
        }
    }

    private static class ConvertContext {
        private String nodeId;
        private StringBuilder path = new StringBuilder();
        private Stack<String> itemIds = new Stack();

        public ConvertContext(String nodeId) {
            this.nodeId = nodeId;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public void pathToBack() {
            int index = this.path.lastIndexOf(".");
            this.path.delete(Math.max(0, index), this.path.length());
        }

        public void pathAppend(String property) {
            if (this.path.length() > 0) {
                this.path.append('.');
            }
            this.path.append(property);
        }

        public String getPath() {
            return this.path.toString();
        }

        public String pushListItemId(String itemId) {
            return this.itemIds.push(itemId);
        }

        public String popListItemId() {
            return this.itemIds.pop();
        }

        public Object[] getListParams() {
            ArrayList<String> params = new ArrayList<String>(this.itemIds.size() + 1);
            params.add(this.nodeId);
            params.addAll(this.itemIds);
            return params.toArray();
        }
    }
}

