/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.dynprocess.freeflow.WFBillExceptionOp;
import kd.bos.workflow.engine.dynprocess.freeflow.WFListener;
import kd.bos.workflow.engine.dynprocess.freeflow.WFProcess;
import kd.bos.workflow.engine.dynprocess.freeflow.WFVariable;
import kd.bos.workflow.engine.impl.bpmn.helper.BPMNUtil;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class GetProcessInfoCmd
implements Command<WFProcess>,
Serializable {
    private static final long serialVersionUID = -6136573379663911690L;
    private static final String ID = "id";
    private transient Log log = LogFactory.getLog(this.getClass());
    private String number;
    private String version;
    private DynamicObject bill;
    private String operation;

    public GetProcessInfoCmd(String number, String version) {
        this.number = number;
        this.version = version;
    }

    public GetProcessInfoCmd(DynamicObject bill, String operation) {
        this.bill = bill;
        this.operation = operation;
    }

    @Override
    public WFProcess execute(CommandContext commandContext) {
        if (WfUtils.isEmpty(this.number) && this.bill == null) {
            throw new WFIllegalArgumentException(ResManager.loadKDString((String)"\u53c2\u6570\u6d41\u7a0b\u7f16\u7801(number)\u548c\u5355\u636e\u4fe1\u606f(bill)\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"GetProcessInfoCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        ProcessDefinitionEntity processDefinition = null;
        processDefinition = WfUtils.isNotEmpty(this.number) ? this.getProcessDefinition(commandContext, this.number, this.version) : this.getProcessDefinition(commandContext, this.bill, this.operation);
        if (processDefinition == null) {
            return null;
        }
        ResourceEntity resource = (ResourceEntity)commandContext.getResourceEntityManager().findById(processDefinition.getResourceId());
        try {
            return this.getProcessInfo(processDefinition, resource);
        }
        catch (Exception e) {
            this.log.warn(WfUtils.getExceptionStacktrace(e));
            return null;
        }
    }

    private ProcessDefinitionEntity getProcessDefinition(CommandContext commandContext, String number, String version) {
        if (WfUtils.isNotEmpty(version) && !"latest".equals(version)) {
            return BPMNUtil.findProcessDefinition(commandContext, number, version);
        }
        return BPMNUtil.findProcessDefinition(commandContext, number, null);
    }

    private ProcessDefinitionEntity getProcessDefinition(CommandContext commandContext, DynamicObject bill, String operation) {
        if (WfUtils.isEmpty(operation)) {
            operation = "submit";
        }
        return BPMNUtil.findProcessDefinition(commandContext, bill, operation);
    }

    private WFProcess getProcessInfo(ProcessDefinitionEntity procDef, ResourceEntity resource) {
        JSONObject datas = JSON.parseObject((String)resource.getData());
        JSONObject properties = datas.getJSONObject("properties");
        JSONObject multiLangDatas = BpmnModelUtil.getMultiLangDatasFromResource(resource);
        WFProcess process = new WFProcess();
        process.setNumber(procDef.getKey());
        process.setName(this.getProcessName(properties, multiLangDatas));
        process.setEntraBill(properties.getString("entraBill"));
        process.setEntraBillId(properties.getString("entraBillId"));
        process.setEntraBillName(this.getProcessEntraBillName(properties, multiLangDatas));
        process.setAutoAuditWhenSamePerson(properties.getBoolean("autoAuditWhenSamePerson"));
        process.setBillExceptionOp(this.getBillExceptionOp(properties));
        process.setExecutionListeners(this.getExecutionListeners(properties));
        process.setVariables(this.getVairables(properties));
        return process;
    }

    private LocaleString getProcessName(JSONObject properties, JSONObject multiLangDatas) {
        String namePath = "node_1.name";
        String defaultValue = properties.getString("name");
        return (LocaleString)BpmnModelUtil.getMultiLangFieldValue(multiLangDatas, namePath, defaultValue);
    }

    private LocaleString getProcessEntraBillName(JSONObject properties, JSONObject multiLangDatas) {
        String namePath = "node_1.entraBillName";
        String defaultValue = properties.getString("entraBillName");
        return (LocaleString)BpmnModelUtil.getMultiLangFieldValue(multiLangDatas, namePath, defaultValue);
    }

    private List<WFBillExceptionOp> getBillExceptionOp(JSONObject properties) {
        JSONArray billExceptions = properties.getJSONArray("billExceptionOp");
        if (billExceptions == null || billExceptions.isEmpty()) {
            return new ArrayList<WFBillExceptionOp>();
        }
        int size = billExceptions.size();
        JSONObject billException = null;
        WFBillExceptionOp exceptionOp = null;
        ArrayList<WFBillExceptionOp> exceptionOps = new ArrayList<WFBillExceptionOp>(size);
        for (int i = 0; i < size; ++i) {
            billException = billExceptions.getJSONObject(i);
            exceptionOp = new WFBillExceptionOp();
            exceptionOp.setId(billException.getString(ID));
            exceptionOp.setOper(billException.getString("oper"));
            exceptionOp.setProcaction(billException.getString("procaction"));
            exceptionOps.add(exceptionOp);
        }
        return exceptionOps;
    }

    private List<WFListener> getExecutionListeners(JSONObject properties) {
        JSONArray executionListeners = properties.getJSONArray("executionListeners");
        if (executionListeners == null || executionListeners.isEmpty()) {
            return new ArrayList<WFListener>();
        }
        int size = executionListeners.size();
        WFListener listener = null;
        JSONObject executionListener = null;
        ArrayList<WFListener> listeners = new ArrayList<WFListener>(size);
        for (int i = 0; i < size; ++i) {
            executionListener = executionListeners.getJSONObject(i);
            listener = new WFListener();
            listener.setId(executionListener.getString(ID));
            listener.setEvent(executionListener.getString("event"));
            listener.setImplementation(executionListener.getString("implementation"));
            listener.setImplementationType(executionListener.getString("implementationtype"));
            listeners.add(listener);
        }
        return listeners;
    }

    private List<WFVariable> getVairables(JSONObject properties) {
        JSONObject variableGroup = properties.getJSONObject("variableGroup");
        if (variableGroup == null) {
            return new ArrayList<WFVariable>();
        }
        JSONArray vars = variableGroup.getJSONArray("variables");
        if (vars == null || vars.isEmpty()) {
            return new ArrayList<WFVariable>();
        }
        int size = vars.size();
        JSONObject var = null;
        WFVariable variable = null;
        ArrayList<WFVariable> variables = new ArrayList<WFVariable>(size);
        for (int i = 0; i < size; ++i) {
            var = vars.getJSONObject(i);
            variable = new WFVariable();
            variable.setId(var.getString(ID));
            variable.setName(var.getString("name"));
            variable.setType(var.getString("type"));
            Object value = var.get((Object)"defaultvalue");
            if (value instanceof Serializable) {
                variable.setDefaultValue((Serializable)value);
            }
            variable.setDescription(var.getString("description"));
            variables.add(variable);
        }
        return variables;
    }
}

