/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.api.model.NodeProperty;
import kd.bos.workflow.api.model.ProcessNode;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateGroupEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class GetProcessNodesCmd
implements Command<List<ProcessNode>> {
    private String procType;

    public GetProcessNodesCmd(String procType) {
        this.procType = procType;
    }

    @Override
    public List<ProcessNode> execute(CommandContext commandContext) {
        ArrayList<ProcessNode> nodes = null;
        NodeTemplateEntityManager nodeTplManager = commandContext.getNodeTemplateEntityManager();
        QFilter[] filters = new QFilter[]{new QFilter("processtype", "=", (Object)this.procType)};
        String fields = String.format("%s,%s,%s,%s,%s,%s", "name", "number", "stenciltype", "properties", "propsdefinition", "groupid");
        List entities = nodeTplManager.findByQueryFilters(filters, fields, "id asc");
        int size = entities.size();
        nodes = new ArrayList<ProcessNode>(size);
        HashSet<Long> groupIds = new HashSet<Long>(size);
        for (NodeTemplateEntity entity : entities) {
            groupIds.add(entity.getGroupId());
        }
        filters = new QFilter[]{new QFilter("id", "in", groupIds)};
        fields = String.format("%s,%s", "name", "number");
        List groups = commandContext.getNodeTemplateGroupEntityManager().findByQueryFilters(filters, fields, "id asc");
        HashMap<Long, NodeTemplateGroupEntity> groupMap = new HashMap<Long, NodeTemplateGroupEntity>(groups.size());
        for (NodeTemplateGroupEntity group : groups) {
            groupMap.put(group.getId(), group);
        }
        for (NodeTemplateEntity entity : entities) {
            ProcessNode node = this.getProcessNode(entity, groupMap);
            nodes.add(node);
        }
        return nodes;
    }

    private ProcessNode getProcessNode(NodeTemplateEntity entity, Map<Long, NodeTemplateGroupEntity> groupMap) {
        ProcessNode node = new ProcessNode();
        node.setName(entity.getName());
        node.setNumber(entity.getNumber());
        node.setStencilType(entity.getStencilType());
        node.setProperties(this.getNodeProperties(entity.getProperties(), entity.getPropsDefinition()));
        NodeTemplateGroupEntity group = groupMap.get(entity.getGroupId());
        if (group != null) {
            node.setGroupName(String.valueOf(group.getName()));
            node.setGroupNumber(group.getNumber());
        }
        return node;
    }

    private List<NodeProperty> getNodeProperties(String properties, String propsDefinition) {
        ArrayList<Object> nodeProperties = new ArrayList<NodeProperty>(16);
        if (WfUtils.isEmpty(propsDefinition)) {
            return nodeProperties;
        }
        JSONArray props = JSON.parseArray((String)propsDefinition);
        int size = props.size();
        nodeProperties = new ArrayList(size);
        HashMap<String, NodeProperty> propertyMap = new HashMap<String, NodeProperty>(size);
        for (int i = 0; i < size; ++i) {
            JSONObject prop = props.getJSONObject(i);
            NodeProperty nodeProperty = new NodeProperty();
            nodeProperty.setName(prop.getString("name"));
            String number = prop.getString("number");
            nodeProperty.setNumber(number);
            String groupName = prop.getString("groupName");
            if (WfUtils.isNotEmpty(groupName)) {
                nodeProperty.setGroupName(groupName);
            }
            String propPath = number;
            String groupNumber = prop.getString("groupNumber");
            if (WfUtils.isNotEmpty(groupNumber)) {
                propPath = String.format("%s.%s", groupNumber, number);
                nodeProperty.setGroupNumber(groupNumber);
            }
            nodeProperty.setConfig((Map)prop.getJSONObject("config"));
            nodeProperties.add(nodeProperty);
            propertyMap.put(propPath, nodeProperty);
        }
        if (WfUtils.isNotEmpty(properties)) {
            JSONObject defProps = JSON.parseObject((String)properties);
            for (Map.Entry entry : propertyMap.entrySet()) {
                NodeProperty nodeProperty = (NodeProperty)entry.getValue();
                Object defaultValue = BpmnModelUtil.getProperty((Map<String, Object>)defProps, (String)entry.getKey());
                if (defaultValue == null) continue;
                nodeProperty.setDefaultValue(defaultValue);
            }
        }
        return nodeProperties;
    }
}

