/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowElement;
import kd.bos.workflow.engine.impl.cmd.management.scheme.GetConfigSchemeBpmnJsonStringCmd;
import kd.bos.workflow.engine.impl.cmd.model.GetProcessElementsCmd;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntityManager;
import kd.bos.workflow.exception.WFException;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class GetSchemeProcessElementsCmd
extends GetProcessElementsCmd {
    private static final long serialVersionUID = 5476831838832566825L;
    private transient Log logger = LogFactory.getLog(this.getClass());
    public static final String PARAM_SCHEMEID = "schemeId";
    public static final String PARAM_SCHEMENUMBER = "schemeNumber";

    public GetSchemeProcessElementsCmd(Map<String, Object> params) {
        super(params);
    }

    @Override
    public List<WFFlowElement> execute(CommandContext commandContext) {
        if (this.params == null || this.params.isEmpty()) {
            throw new WFIllegalArgumentException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GetSchemeProcessElementsCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        Long schemeId = (Long)this.params.get(PARAM_SCHEMEID);
        String schemeNumber = (String)this.params.get(PARAM_SCHEMENUMBER);
        if (WfUtils.isEmpty(schemeId) && WfUtils.isEmpty(schemeNumber)) {
            throw new WFIllegalArgumentException(ResManager.loadKDString((String)"\u53c2\u6570\u201c\u65b9\u6848ID(schemeID)\u201d\u6216\u201c\u65b9\u6848\u7f16\u7801(schemeNumber)\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GetSchemeProcessElementsCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        DynamicConfigSchemeEntity dynamicConfigScheme = null;
        if (WfUtils.isNotEmpty(schemeId)) {
            dynamicConfigScheme = (DynamicConfigSchemeEntity)commandContext.getDynamicConfigSchemeEntityManager().findById(schemeId);
        } else {
            DynamicConfigSchemeEntityManager dynConfManager = commandContext.getDynamicConfigSchemeEntityManager();
            EntityQueryBuilder queryBuilder = dynConfManager.createQueryBuilder();
            queryBuilder.addFilter("number", schemeNumber);
            List dynConfs = dynConfManager.findByQueryBuilder(queryBuilder);
            if (dynConfs == null || dynConfs.isEmpty()) {
                this.logger.warn(String.format("Cann't found the DynamicConfigScheme! %s", schemeNumber));
                return null;
            }
            dynamicConfigScheme = (DynamicConfigSchemeEntity)dynConfs.get(0);
        }
        try {
            return this.getProcessElements(commandContext, dynamicConfigScheme);
        }
        catch (Exception e) {
            throw new WFException(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u8282\u70b9\u83b7\u53d6\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"GetProcessElementsCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private List<WFFlowElement> getProcessElements(CommandContext commandContext, DynamicConfigSchemeEntity dynamicConfigScheme) {
        if (dynamicConfigScheme == null) {
            return null;
        }
        ResourceEntity resource = (ResourceEntity)commandContext.getResourceEntityManager().findById(dynamicConfigScheme.getJsonResourceId());
        ResourceEntity resourceCopy = (ResourceEntity)commandContext.getResourceEntityManager().create();
        resourceCopy.setContent(resource.getContent());
        resourceCopy.setData(new GetConfigSchemeBpmnJsonStringCmd(dynamicConfigScheme.getId(), null).execute(commandContext));
        try {
            return this.getProcessElements(dynamicConfigScheme, resourceCopy);
        }
        catch (Exception e) {
            this.logger.error(WfUtils.getExceptionStacktrace(e));
            return null;
        }
    }
}

