/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.workflow.api.model.ProcessModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.nocode.NoCodeFlowUtil;

public class LoadProcessModelCmd
implements Command<ProcessModel> {
    private Long modelId;
    private Log log = LogFactory.getLog(this.getClass());

    public LoadProcessModelCmd(Long modelId) {
        this.modelId = modelId;
    }

    @Override
    public ProcessModel execute(CommandContext commandContext) {
        ProcessModel processModel = new ProcessModel();
        ModelEntity entity = (ModelEntity)commandContext.getModelEntityManager().findById(this.modelId);
        processModel.setId(entity.getId());
        processModel.setNumber(entity.getNumber());
        processModel.setBusinessId(entity.getBusinessId());
        processModel.setName(LocaleString.fromMap((Map)entity.getName()));
        processModel.setDescription(LocaleString.fromMap((Map)entity.getDescription()));
        processModel.setType(entity.getType());
        processModel.setEntityId(entity.getEntityId());
        processModel.setEntityNumber(entity.getEntityNumber());
        processModel.setOrgId(entity.getOrgId());
        processModel.setOperation(entity.getOperation());
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)entity.getCategory())};
        String fields = String.format("%s,%s,%s", "id", "parentid", "applicationid");
        List categories = commandContext.getProcessCategoryEntityManager().findByQueryFilters(filters, fields, null);
        if (!categories.isEmpty()) {
            Long rootCategoryId = 10000L;
            ProcessCategoryEntity category = (ProcessCategoryEntity)categories.get(0);
            String applicationId = category.getApplicationId();
            if (rootCategoryId.equals(category.getParentId())) {
                processModel.setCloudId(applicationId);
            } else {
                processModel.setAppId(applicationId);
                DynamicObject bizApp = null;
                try {
                    bizApp = BizAppServiceHelp.getBizAppByID((String)applicationId);
                }
                catch (Exception e) {
                    this.log.error(WfUtils.getExceptionStacktrace(e));
                }
                if (bizApp != null) {
                    DynamicObject bizCloud = (DynamicObject)bizApp.get("bizcloud");
                    processModel.setCloudId(bizCloud.getString("id"));
                }
            }
        }
        ResourceEntity resource = (ResourceEntity)commandContext.getResourceEntityManager().findById(entity.getBPMNXMLID());
        if (ModelType.NoCodeFlow.name().equals(entity.getType())) {
            JSONObject workflowJson = JSON.parseObject((String)resource.getData());
            JSONObject noCodeJson = NoCodeFlowUtil.convertWorkflowJsonToNoCodeJson(workflowJson);
            processModel.setData(noCodeJson.toJSONString());
        } else {
            processModel.setData(resource.getData());
        }
        return processModel;
    }
}

