/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.exception.KDException;
import kd.bos.workflow.bpmn.model.AutoCoordinate;
import kd.bos.workflow.bpmn.model.AutoCoordinateModel;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.BroadcastTask;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.Circulate;
import kd.bos.workflow.bpmn.model.CirculateModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.MessageSendModel;
import kd.bos.workflow.bpmn.model.NotifyTask;
import kd.bos.workflow.bpmn.model.ParticipantRangeSettingModel;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.WaitTask;
import kd.bos.workflow.bpmn.model.dynamicpartial.DynamicModelPartial;
import kd.bos.workflow.bpmn.model.dynamicpartial.IDynamicPartial;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.model.AbstractProcessor;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.context.ModelProcessorContext;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.exception.WFErrorCode;

public class ParticipantProcessor
extends AbstractProcessor {
    @Override
    public void process(ModelProcessorContext context, Long modelId, DynamicModelPartial partial) {
        try {
            this.saveParticipants(context, partial, modelId, null, null);
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.saveParticipantModelError(), new Object[]{e.getMessage()});
        }
    }

    @Override
    public void process(ModelProcessorContext context, DynamicModelPartial dynPartial, Long procDefId) {
        this.process(context, dynPartial, procDefId, null);
    }

    @Override
    public void process(ModelProcessorContext context, DynamicModelPartial partial, Long procDefId, Long schemeId) {
        try {
            this.saveParticipants(context, partial, null, procDefId, schemeId);
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.saveParticipantModelError(), new Object[]{e.getMessage()});
        }
    }

    private void deleteParticipant(ModelProcessorContext context, String activityId, Long modelId, Long schemeId) {
        List<Long> ids = context.getParticipantModelIdsByActId(modelId, schemeId, activityId);
        if (ids == null || ids.isEmpty() || context.isParticipantProcessed(activityId)) {
            this.logger.debug(String.format("%s no participantModels, modelId: %s, schemeId: %s", activityId, modelId, schemeId));
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(ids.size());
        for (Long id : ids) {
            params.add(new Object[]{id});
        }
        context.addSqlParams("DELETE FROM T_WF_PARTICIPANTMODEL WHERE FID = ? ", params);
        context.addSqlParams("DELETE FROM T_WF_PARTICIPANTMODEL_L WHERE FID = ? ", params);
        context.addProcessedParticipantActId(activityId);
    }

    private void saveParticipants(ModelProcessorContext context, DynamicModelPartial dynamicModelPartial, Long modelId, Long procDefId, Long schemeId) {
        BaseElement flowElement = dynamicModelPartial.getFlowElement();
        ArrayList<ParticipantModelEntityImpl> participants = new ArrayList();
        IDynamicPartial dynamicPartial = dynamicModelPartial.getPartial();
        if (dynamicPartial instanceof ParticipatantModel) {
            participants = ((ParticipatantModel)dynamicPartial).getParticipant();
            this.setPropertyName(dynamicModelPartial.getPartialPropertyName(), participants);
        } else if (dynamicPartial instanceof ParticipantRangeSettingModel) {
            List<ParticipantModelEntityImpl> participantBlackList;
            ParticipantRangeSettingModel participantRangeSettingModel = (ParticipantRangeSettingModel)dynamicPartial;
            List<ParticipantModelEntityImpl> participantAllow = participantRangeSettingModel.getParticipantAllow();
            if (participantAllow != null && !participantAllow.isEmpty()) {
                this.setPropertyName("allowlistor", participantAllow);
                participants.addAll(participantAllow);
            }
            if ((participantBlackList = participantRangeSettingModel.getParticipantBlackList()) != null && !participantBlackList.isEmpty()) {
                this.setPropertyName("blacklistor", participantBlackList);
                participants.addAll(participantBlackList);
            }
        } else if (dynamicPartial instanceof MessageSendModel) {
            participants = ((MessageSendModel)dynamicPartial).getReceiver();
            this.setMsgSendModelPropName(participants, dynamicPartial);
        } else if (dynamicPartial instanceof Circulate) {
            participants = ((Circulate)dynamicPartial).getParticipant();
            this.setPropertyName(dynamicModelPartial.getPartialPropertyName(), participants);
        } else if (dynamicPartial instanceof AutoCoordinate) {
            participants = ((AutoCoordinate)dynamicPartial).getParticipant();
            this.setPropertyName(dynamicModelPartial.getPartialPropertyName(), participants);
        }
        this.saveParticipant(context, flowElement, participants, modelId, procDefId, schemeId);
    }

    private void setMsgSendModelPropName(List<ParticipantModelEntityImpl> participants, IDynamicPartial dynamicPartial) {
        String sendEvt = ((MessageSendModel)dynamicPartial).getSendevt();
        if ("receiver".equalsIgnoreCase(dynamicPartial.getPartialType())) {
            if ("start".equals(sendEvt) || "reject".equals(sendEvt)) {
                this.setPropertyName("inMsg.receiver", participants);
            } else {
                this.setPropertyName("outMsg.receiver", participants);
            }
        }
    }

    private void setPropertyName(String propertyName, List<ParticipantModelEntityImpl> participants) {
        if (participants != null && !participants.isEmpty()) {
            for (ParticipantModelEntityImpl impl : participants) {
                impl.setProperty(propertyName);
            }
        }
    }

    private void saveParticipant(ModelProcessorContext context, BaseElement flowElement, List<ParticipantModelEntityImpl> participants, Long modelId, Long procDefId, Long schemeId) {
        this.deleteParticipant(context, flowElement.getId(), modelId, schemeId);
        this.insertParticipantModelEntity(flowElement, modelId, procDefId, schemeId, participants);
    }

    private List<Long> insertParticipantModelEntity(BaseElement flowElement, Long modelId, Long procDefId, Long schemeId, List<ParticipantModelEntityImpl> participantEntities) {
        if (participantEntities == null || participantEntities.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Long> participantIds = new ArrayList<Long>(participantEntities.size());
        CommandContext commandContext = Context.getCommandContext();
        ILocaleString activityName = this.getActivityName(flowElement, modelId, procDefId, schemeId);
        for (ParticipantModelEntityImpl participantEntity : participantEntities) {
            participantEntity.setModelId(modelId);
            participantEntity.setModelJsonPartId(participantEntity.getId());
            participantEntity.setProcdefId(procDefId);
            participantEntity.setTaskActivityId(flowElement.getId());
            participantEntity.setActivityName(activityName);
            participantEntity.setSchemeId(schemeId);
            participantEntity.setId(null);
            commandContext.getParticipantModelEntityManager().insert(participantEntity);
            participantIds.add(participantEntity.getId());
        }
        return participantIds;
    }

    private ILocaleString getActivityName(BaseElement flowElement, Long modelId, Long procDefId, Long schemeId) {
        DynamicConfigSchemeEntity scheme;
        ProcessDefinitionEntity procDef;
        CommandContext commandContext = Context.getCommandContext();
        Long resourceId = 0L;
        if (!WfUtils.isEmpty(modelId)) {
            ModelEntity model = (ModelEntity)commandContext.getModelEntityManager().findById(modelId, "bpmnxmlid");
            if (model != null) {
                resourceId = model.getBPMNXMLID();
            }
        } else if (!WfUtils.isEmpty(procDefId) && (procDef = (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(procDefId, "resourceid")) != null) {
            resourceId = procDef.getResourceId();
        }
        if (WfUtils.isEmpty(resourceId) && (scheme = (DynamicConfigSchemeEntity)commandContext.getDynamicConfigSchemeEntityManager().findById(schemeId, "jsonresourceid")) != null) {
            resourceId = scheme.getJsonResourceId();
        }
        if (!WfUtils.isEmpty(resourceId)) {
            ResourceEntity resource = (ResourceEntity)commandContext.getResourceEntityManager().findById(resourceId);
            String multiKey = BpmnModelUtil.getActivityNameMultiKey(flowElement.getId());
            return BpmnModelUtil.getMultiLangFieldValueFromResource(resource, multiKey, flowElement.getName());
        }
        return new LocaleString(flowElement.getName());
    }

    @Override
    public void updateBpmnModel(BpmnModel bpmnModel, List<AbstractEntity> entities) {
        Map<String, List<ParticipantModelEntityImpl>> participantMap = this.groupParticipantByProperty(entities);
        String[] procIdActIdProperty = null;
        for (Map.Entry<String, List<ParticipantModelEntityImpl>> entry : participantMap.entrySet()) {
            FlowElement flowElement;
            procIdActIdProperty = entry.getKey().split("-");
            List<ParticipantModelEntityImpl> participants = entry.getValue();
            String activityId = "";
            if (procIdActIdProperty.length >= 2) {
                activityId = procIdActIdProperty[1];
            }
            if (WfUtils.isEmpty(activityId)) {
                return;
            }
            String property = "";
            if (procIdActIdProperty.length >= 3) {
                property = procIdActIdProperty[2];
            }
            if ((flowElement = bpmnModel.getFlowElement(activityId)) instanceof UserTask) {
                UserTask userTask = (UserTask)flowElement;
                switch (property) {
                    case "participant": {
                        this.updateParticipantModel(userTask, participants, property);
                        break;
                    }
                    case "allowlistor": 
                    case "blacklistor": {
                        this.updateParticipantRangeSettingModel(userTask, participants, property);
                        break;
                    }
                    case "circulator": {
                        this.updateCirculateModel(userTask, participants);
                        break;
                    }
                    case "coordinator": {
                        this.updateAutoCoordinateModel(userTask, participants);
                        break;
                    }
                }
            }
            if (!"outMsg.receiver".equals(property) && !"inMsg.receiver".equals(property)) continue;
            this.updateMessageSendModel(flowElement, participants, property);
        }
    }

    private Map<String, List<ParticipantModelEntityImpl>> groupParticipantByProperty(List<AbstractEntity> entities) {
        ParticipantModelEntityImpl participant = null;
        HashMap<String, List<ParticipantModelEntityImpl>> participantMap = new HashMap<String, List<ParticipantModelEntityImpl>>();
        String key = null;
        ArrayList<ParticipantModelEntityImpl> participants = null;
        for (AbstractEntity entity : entities) {
            participant = (ParticipantModelEntityImpl)entity;
            Long processId = participant.getProcdefId();
            if (WfUtils.isEmpty(processId)) {
                processId = participant.getModelId();
            }
            if ((participants = (ArrayList<ParticipantModelEntityImpl>)participantMap.get(key = String.format("%s-%s-%s", processId, participant.getTaskActivityId(), participant.getProperty()))) == null) {
                participants = new ArrayList<ParticipantModelEntityImpl>();
                participantMap.put(key, participants);
            }
            participants.add(participant);
        }
        return participantMap;
    }

    private void updateParticipantModel(UserTask userTask, List<ParticipantModelEntityImpl> participants, String property) {
        ParticipatantModel participatantModel = userTask.getParticipant();
        if (participatantModel != null) {
            List<ParticipantModelEntityImpl> srcParticipants = participatantModel.getParticipant();
            this.updateParticipants(srcParticipants, participants);
            if (BpmnModelUtil.instanceofUserTaskOnly(userTask.getType())) {
                this.updateBpmnModelProperty(userTask, property, participatantModel);
            }
        }
    }

    private void updateParticipantRangeSettingModel(UserTask userTask, List<ParticipantModelEntityImpl> participants, String property) {
        ParticipantRangeSettingModel participantRangeSettingModel = userTask.getParticipantRangeSetting();
        if (participantRangeSettingModel != null) {
            if ("allowlistor".equals(property)) {
                List<ParticipantModelEntityImpl> srcParticipantAllow = participantRangeSettingModel.getParticipantAllow();
                this.updateParticipants(srcParticipantAllow, participants);
            } else if ("blacklistor".equals(property)) {
                List<ParticipantModelEntityImpl> srcParticipantBlackList = participantRangeSettingModel.getParticipantBlackList();
                this.updateParticipants(srcParticipantBlackList, participants);
            }
        }
    }

    private void updateCirculateModel(UserTask userTask, List<ParticipantModelEntityImpl> participants) {
        Circulate circulate;
        CirculateModel circulateModel = userTask.getCirculateModel();
        if (circulateModel != null && (circulate = circulateModel.getCirculate()) != null) {
            List<ParticipantModelEntityImpl> srcCirculators = circulate.getParticipant();
            this.updateParticipants(srcCirculators, participants);
        }
    }

    private void updateAutoCoordinateModel(UserTask userTask, List<ParticipantModelEntityImpl> participants) {
        AutoCoordinate autoCoordinate;
        AutoCoordinateModel autoCoordinateModel = userTask.getAutoCoordinateModel();
        if (autoCoordinateModel != null && (autoCoordinate = autoCoordinateModel.getAutoCoordinate()) != null) {
            List<ParticipantModelEntityImpl> srcCoordinator = autoCoordinate.getParticipant();
            this.updateParticipants(srcCoordinator, participants);
        }
    }

    private void updateMessageSendModel(FlowElement flowElement, List<ParticipantModelEntityImpl> receivers, String property) {
        List<Object> msgs = new ArrayList();
        if ("inMsg.receiver".equals(property)) {
            if (flowElement instanceof UserTask) {
                msgs = ((UserTask)flowElement).getInMsg();
            } else if (flowElement instanceof AutoTask) {
                msgs = ((AutoTask)flowElement).getInMsg();
            } else if (flowElement instanceof WaitTask) {
                msgs = ((WaitTask)flowElement).getInMsg();
            } else if (flowElement instanceof BroadcastTask) {
                msgs = ((BroadcastTask)flowElement).getInMsg();
            } else if (flowElement instanceof CallActivity) {
                msgs = ((CallActivity)flowElement).getInMsg();
            } else if (flowElement instanceof NotifyTask) {
                msgs = ((NotifyTask)flowElement).getInMsg();
            }
        } else if ("outMsg.receiver".equals(property)) {
            if (flowElement instanceof UserTask) {
                msgs = ((UserTask)flowElement).getOutMsg();
            } else if (flowElement instanceof AutoTask) {
                msgs = ((AutoTask)flowElement).getOutMsg();
            } else if (flowElement instanceof WaitTask) {
                msgs = ((WaitTask)flowElement).getOutMsg();
            } else if (flowElement instanceof BroadcastTask) {
                msgs = ((BroadcastTask)flowElement).getOutMsg();
            } else if (flowElement instanceof CallActivity) {
                msgs = ((CallActivity)flowElement).getOutMsg();
            }
        }
        if (msgs != null && !msgs.isEmpty()) {
            this.setMsgSendReceiver(receivers, msgs);
        }
    }

    private void setMsgSendReceiver(List<ParticipantModelEntityImpl> receivers, List<MessageSendModel> msgSendModels) {
        if (msgSendModels != null && !msgSendModels.isEmpty()) {
            for (MessageSendModel msgSendModel : msgSendModels) {
                List<ParticipantModelEntityImpl> scrReceivers = msgSendModel.getReceiver();
                this.updateParticipants(scrReceivers, receivers);
            }
        }
    }

    private void updateParticipants(List<ParticipantModelEntityImpl> srcParticipants, List<ParticipantModelEntityImpl> targetParticipants) {
        if (srcParticipants == null || srcParticipants.isEmpty()) {
            return;
        }
        for (ParticipantModelEntityImpl srcParticipant : srcParticipants) {
            if (!"person".equals(srcParticipant.getType())) continue;
            Long srcParticipantId = srcParticipant.getId();
            String srcValue = srcParticipant.getValue();
            for (ParticipantModelEntityImpl targetParticipant : targetParticipants) {
                Long targetPartId = targetParticipant.getModelJsonPartId();
                String targetValue = targetParticipant.getValue();
                if (srcParticipantId == null || !srcParticipantId.equals(targetPartId) || WfUtils.isEmpty(srcValue) || srcValue.equals(targetValue)) continue;
                srcParticipant.setValue(targetValue);
            }
        }
    }

    @Override
    public String getEntityNumber() {
        return "wf_participantmodel";
    }
}

