/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntity;
import org.apache.commons.lang.ArrayUtils;

public class ProcessCagetoryNameUpdateCmd
implements Command<Boolean> {
    private Log logger = LogFactory.getLog(ProcessCagetoryNameUpdateCmd.class);

    @Override
    public Boolean execute(CommandContext commandContext) {
        try {
            List<ProcessCategoryEntity> processCategoryEntitys = commandContext.getProcessCategoryEntityManager().getAllProcessCategoryEntity();
            this.logger.debug(String.format("ProcessCagetoryUpdate:processCategoryEntitys size:%s", processCategoryEntitys.size()));
            ArrayList<String> applicationIdList = new ArrayList<String>(processCategoryEntitys.size());
            HashMap<String, ProcessCategoryEntity> processCategoryEntityMap = new HashMap<String, ProcessCategoryEntity>(processCategoryEntitys.size());
            for (ProcessCategoryEntity processCategoryEntity : processCategoryEntitys) {
                String applicationId = processCategoryEntity.getApplicationId();
                applicationIdList.add(applicationId);
                processCategoryEntityMap.put(applicationId, processCategoryEntity);
            }
            this.logger.debug(String.format("applicationIdList is:%s", applicationIdList));
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", applicationIdList)};
            Object[] bizClouds = BusinessDataServiceHelper.load((String)"bos_devportal_bizcloud", (String)"id,name", (QFilter[])filters);
            Object[] bizApps = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"id,name", (QFilter[])filters);
            DynamicObject[] bizAll = (DynamicObject[])ArrayUtils.addAll((Object[])bizClouds, (Object[])bizApps);
            HashMap<String, ILocaleString> idNameMap = new HashMap<String, ILocaleString>(bizAll.length);
            for (DynamicObject bizCloud : bizAll) {
                idNameMap.put(bizCloud.getString("id"), bizCloud.getLocaleString("name"));
            }
            Set numberNameMapEntrySet = idNameMap.entrySet();
            for (Map.Entry entry : numberNameMapEntrySet) {
                String id = (String)entry.getKey();
                ILocaleString name = (ILocaleString)entry.getValue();
                ProcessCategoryEntity processCategoryEntity = (ProcessCategoryEntity)processCategoryEntityMap.get(id);
                processCategoryEntity.setILocaleStringName(name);
                commandContext.getProcessCategoryEntityManager().update(processCategoryEntity);
            }
        }
        catch (Exception e) {
            this.logger.debug(String.format("ProcessCagetoryUpdate:error:%s", WfUtils.getExceptionStacktrace(e)));
            return Boolean.FALSE;
        }
        return true;
    }
}

