/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import java.sql.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.workflow.domain.model.NodeLifecycleUtil;
import kd.bos.workflow.engine.WFLicenseUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.repository.DeploymentBuilderImpl;
import kd.bos.workflow.engine.repository.Deployment;
import kd.bos.workflow.engine.repository.DeploymentBuilder;

public class PublishModelCmd
implements Command<Long> {
    private Long[] modelIds;
    private String deployName;
    private Date activationDate;
    private Map<String, Map<String, Object>> deploymentProperties;

    public PublishModelCmd(Long[] modelIds, String deployName, Date activationDate) {
        this.modelIds = modelIds;
        this.deployName = deployName;
        this.activationDate = activationDate;
    }

    public PublishModelCmd(Long[] modelIds) {
        this.modelIds = modelIds;
    }

    public PublishModelCmd(Long[] modelIds, Map<String, Map<String, Object>> deploymentProperties) {
        this.modelIds = modelIds;
        this.deploymentProperties = deploymentProperties;
    }

    @Override
    public Long execute(CommandContext commandContext) {
        WFLicenseUtil.checkLicenseAllowCount(commandContext.getProcessDefinitionEntityManager().getEnableProcessCount());
        if (this.modelIds == null || this.modelIds.length == 0) {
            return null;
        }
        StringBuilder logInfo = new StringBuilder();
        Long logBizId = null;
        DeploymentBuilder deploymentBuilder = commandContext.getProcessEngineConfiguration().getRepositoryService().createDeployment();
        ModelEntity model = null;
        HashSet<String> workFlowTypes = new HashSet<String>(2);
        for (Long modelId : this.modelIds) {
            model = (ModelEntity)commandContext.getModelEntityManager().findById(modelId);
            if (model == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728ID\u4e3a\u201c%s\u201d\u7684\u6d41\u7a0b\u3002", (String)"PublishModelCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), modelId));
            }
            ResourceEntity resource = (ResourceEntity)commandContext.getResourceEntityManager().findById(model.getBPMNXMLID());
            deploymentBuilder.addString(model.getKey() + "." + "bpmn20.json", modelId, resource);
            logInfo.append(model.getKey()).append('/').append(model.getVersion()).append(' ');
            logBizId = model.getId();
            workFlowTypes.add(model.getType());
        }
        if (this.activationDate == null) {
            deploymentBuilder.activateProcessDefinitions();
        } else {
            deploymentBuilder.activateProcessDefinitionsOn(this.activationDate);
        }
        if (this.deployName == null) {
            this.deployName = "publish" + System.currentTimeMillis();
        }
        deploymentBuilder.name(this.deployName);
        if (deploymentBuilder instanceof DeploymentBuilderImpl && this.deploymentProperties != null) {
            ((DeploymentBuilderImpl)deploymentBuilder).getDeploymentProperties().putAll(this.deploymentProperties);
        }
        final Deployment deployment = deploymentBuilder.deploy();
        String appType = "wf";
        if (workFlowTypes.contains("BizFlow") && !workFlowTypes.contains("AuditFlow")) {
            appType = "bpm";
        }
        WfUtils.addOpLogByAppType(appType, "wf_model", "publishProcess", new MultiLangEnumBridge("\u53d1\u5e03\u6d41\u7a0b", "PublishModelCmd_2", "bos-wf-engine"), new MultiLangEnumBridge("\u6d41\u7a0bID\uff1a\u201c%1$s\u201d%2$s\u3002", "PublishModelCmd_3", "bos-wf-engine"), logBizId, logInfo.toString());
        if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
            ProcessDefinitionEntity entity;
            HashMap<String, Object> params = new HashMap<String, Object>(5);
            if (model != null) {
                params.put("modelId", model.getId());
                params.put("processNumber", model.getKey());
            }
            if (deployment != null && (entity = commandContext.getProcessDefinitionEntityManager().findLatestProcessDefinitionByDeploymentId(deployment.getId())) != null) {
                params.put("processDefinitionId", entity.getId());
                params.put("processVersion", entity.getVersion());
                if (commandContext.getAttribute("processDefinitionId") != null) {
                    commandContext.addAttribute("processDefinitionId", entity.getId());
                }
            }
            new EventTriggerCmd("wf.AfterPublishModelEvent", SerializationUtils.toJsonString(params)).execute(commandContext);
        }
        commandContext.addCloseListener(new DefaultCommandContextCloseListener("lifecycleListener"){

            @Override
            public void closed(CommandContext commandContext) {
                try {
                    NodeLifecycleUtil.executeLifecyclePublishListener(deployment.getId());
                }
                catch (Exception e) {
                    this.log.error(WfUtils.getExceptionStacktrace(e));
                }
            }
        });
        Long id = -1L;
        if (deployment != null) {
            id = deployment.getId();
        }
        return id;
    }
}

