/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.api.model.ProcPublishResult;
import kd.bos.workflow.api.model.ValidateResultItem;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.ValidateProcessByBpmnModelCmd;
import kd.bos.workflow.engine.impl.cmd.model.PublishModelCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.validation.ValidationError;

public class PublishProcessCmd
implements Command<ProcPublishResult> {
    private Long modelId;
    private Map<String, Object> deploymentProperty;
    private Log log = LogFactory.getLog(this.getClass());

    public PublishProcessCmd(Long modelId, Map<String, Object> deploymentProperty) {
        this.modelId = modelId;
        this.deploymentProperty = deploymentProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcPublishResult execute(CommandContext commandContext) {
        String versionDescription = null;
        boolean ignoreValidateInfo = false;
        if (this.deploymentProperty != null) {
            versionDescription = (String)this.deploymentProperty.get("versionDescription");
            ignoreValidateInfo = Boolean.TRUE.equals(this.deploymentProperty.get("ignoreValidateInfo"));
        }
        ProcPublishResult result = new ProcPublishResult();
        ModelEntity model = (ModelEntity)commandContext.getModelEntityManager().findById(this.modelId);
        Long resourceId = model.getBPMNXMLID();
        ResourceEntity resource = (ResourceEntity)commandContext.getResourceEntityManager().findById(resourceId);
        if (resource != null) {
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(resource.getData());
            Object errors = new ValidateProcessByBpmnModelCmd(bpmnModel, null).execute(commandContext);
            if (errors != null && !errors.isEmpty()) {
                ValidationError error;
                boolean hasErrorInfo = false;
                Iterator iterator = errors.iterator();
                while (iterator.hasNext()) {
                    error = (ValidationError)iterator.next();
                    if ("warning".equals(error.getInfoType())) continue;
                    hasErrorInfo = true;
                    break;
                }
                if (!ignoreValidateInfo || hasErrorInfo) {
                    result.setSuccess(false);
                    iterator = errors.iterator();
                    while (iterator.hasNext()) {
                        error = (ValidationError)iterator.next();
                        ValidateResultItem item = new ValidateResultItem();
                        item.setNodeId(error.getActivityId());
                        item.setProperty(error.getProperty());
                        item.setMessage(error.getInfo());
                        item.setNodeName(error.getObjName());
                        result.getValidateResult().add(item);
                    }
                    return result;
                }
            }
        } else {
            this.log.debug(String.format("resource is null. %s", this.modelId));
        }
        HashMap<String, Map<String, Object>> deploymentProperties = new HashMap<String, Map<String, Object>>();
        HashMap<String, Object> config = new HashMap<String, Object>();
        if (WfUtils.isNotEmpty(versionDescription)) {
            config.put("versionDescription", versionDescription);
        }
        config.put("disableOtherProcess", true);
        config.put("disablePrevious", true);
        deploymentProperties.put(String.valueOf(this.modelId), config);
        try {
            commandContext.addAttribute("processDefinitionId", 0L);
            Long deploymentId = new PublishModelCmd(new Long[]{this.modelId}, deploymentProperties).execute(commandContext);
            Long procDefId = (Long)commandContext.getAttribute("processDefinitionId");
            if (procDefId == null) {
                QFilter[] filters = new QFilter[]{new QFilter("deploymentid", "=", (Object)deploymentId)};
                List procDefEntities = commandContext.getProcessDefinitionEntityManager().findByQueryFilters(filters, "id", null);
                if (!procDefEntities.isEmpty()) {
                    ((ProcessDefinitionEntity)procDefEntities.get(0)).getId();
                }
            }
            result.setProcDefId(procDefId);
        }
        finally {
            commandContext.removeAttribute("processDefinitionId");
        }
        return result;
    }
}

