/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverter;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.domain.model.NodeLifecycleUtil;
import kd.bos.workflow.engine.WFEngineVersion;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.deployer.VersionUtils;
import kd.bos.workflow.engine.impl.cmd.entity.GetSingleEntityCmd;
import kd.bos.workflow.engine.impl.cmd.entity.NewEntityCmd;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ExtractMultiLanguageWordsUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class SaveModelCmd
implements Command<Map<String, Object>>,
Serializable {
    private static Log logger = LogFactory.getLog(SaveModelCmd.class);
    private static final long serialVersionUID = 1L;
    protected ModelEntity model;
    protected Map<String, Object> resources;

    public SaveModelCmd(ModelEntity model) {
        this.model = model;
    }

    public SaveModelCmd(ModelEntity model, Map<String, Object> resources) {
        this.model = model;
        this.resources = resources;
    }

    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        if (this.model == null) {
            throw new WFIllegalArgumentException("model is null");
        }
        if (WfUtils.isEmpty(this.model.getId()) && WfUtils.isNotEmpty(this.model.getKey()) && !commandContext.getProcessEngineConfiguration().getRepositoryService().validateUniqueModelByKey(this.model.getKey())) {
            throw new WFIllegalArgumentException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%s\u201d\u5df2\u5b58\u5728\u3002", (String)"SaveModelCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), this.model.getKey()));
        }
        return this.saveOrUpdateModel(commandContext);
    }

    private Map<String, Object> saveOrUpdateModel(CommandContext commandContext) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        try {
            boolean isAddNew = false;
            if (WfUtils.isEmpty(this.model.getId())) {
                this.model.setId(ORM.create().genLongId("wf_model"));
                isAddNew = true;
            }
            final String modelJson = this.saveResources(commandContext, this.model);
            this.saveOrUpdateBaseModel(commandContext, isAddNew);
            BpmnModelUtil.disposeDynamicPartial(modelJson, this.model.getId());
            if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
                HashMap<String, Object> params = new HashMap<String, Object>(5);
                params.put("modelId", this.model.getId());
                params.put("modelJson", modelJson);
                params.put("processNumber", this.model.getKey());
                new EventTriggerCmd("wf.AfterSaveOrUpdateModelEvent", SerializationUtils.toJsonString(params)).execute(commandContext);
            }
            commandContext.addCloseListener(new DefaultCommandContextCloseListener("lifecycleListener"){

                @Override
                public void closed(CommandContext commandContext) {
                    try {
                        NodeLifecycleUtil.executeLifecycleSaveListener(SaveModelCmd.this.model, modelJson);
                    }
                    catch (Exception e) {
                        this.log.error(WfUtils.getExceptionStacktrace(e));
                    }
                }
            });
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, WFErrorCode.modelSaveError(), new Object[]{e.getMessage()});
        }
        return retMap;
    }

    private void setOperation(String graph_json) {
        BpmnModel bpmnModel;
        Process process;
        JsonNode jsonNode = null;
        try {
            jsonNode = new ObjectMapper().readTree(graph_json);
        }
        catch (JsonProcessingException e) {
            logger.error(WfUtils.getExceptionStacktrace(e));
        }
        if (null != jsonNode && (process = (bpmnModel = new BpmnJsonConverter().convertToBpmnModel(jsonNode)).getMainProcess()) != null) {
            UserTask firstUser = BpmnModelUtil.getFirstUserTask(process);
            if (firstUser != null) {
                this.model.setOperation(firstUser.getOperationStr());
            } else if (WfUtils.isNotEmpty(process.getTriggerMode())) {
                this.model.setOperation(process.getTriggerMode());
            }
        }
    }

    private void saveOrUpdateBaseModel(CommandContext commandContext, boolean isAddNew) {
        String appType = "wf";
        if ("BizFlow".equals(this.model.getType())) {
            appType = "bpm";
        }
        if (isAddNew) {
            commandContext.getModelEntityManager().insert(this.model);
            WfUtils.addOpLogByAppType(appType, "wf_model", "baraddnew", new MultiLangEnumBridge("\u65b0\u589e\u4fdd\u5b58\u6d41\u7a0b", "SaveModelCmd_2", "bos-wf-engine"), new MultiLangEnumBridge("\u6d41\u7a0bID\uff1a%1$s\uff0c\u7f16\u7801\uff1a%2$s\u3002", "SaveModelCmd_3", "bos-wf-engine"), this.model.getId(), this.model.getKey());
        } else {
            commandContext.getModelEntityManager().updateModel(this.model);
            WfUtils.addOpLogByAppType(appType, "wf_model", "baredit", new MultiLangEnumBridge("\u4fee\u6539\u4fdd\u5b58\u6d41\u7a0b", "SaveModelCmd_4", "bos-wf-engine"), new MultiLangEnumBridge("\u6d41\u7a0bID\uff1a%1$s\uff0c\u7f16\u7801\uff1a%2$s\u3002", "SaveModelCmd_3", "bos-wf-engine"), this.model.getId(), this.model.getKey());
        }
    }

    private String saveResources(CommandContext commandContext, ModelEntity modelEntity) {
        String graph_json = null;
        if (this.isWizardSave()) {
            BpmnModel bpmnModel = GraphCodecUtils.getDefaultBpmnModel(GraphCodecUtils.getModelTypeByProcessType(modelEntity.getType()), (List)this.resources.get("featuresConfig"));
            graph_json = GraphCodecUtils.convertBpmnModelToJSON(bpmnModel);
        } else {
            graph_json = (String)this.resources.get("graph_json");
            try {
                this.setOperation(graph_json);
            }
            catch (Exception e) {
                logger.error("save failed!" + WfUtils.getExceptionStacktrace(e));
            }
        }
        JSONObject root = JSON.parseObject((String)graph_json);
        String bosVersion = (String)root.getJSONObject("properties").get((Object)"bosVersion");
        if (WFEngineVersion.isPreviousVersion(bosVersion, "1.1.631")) {
            graph_json = BpmnDiffUtil.fixArrayElementId(graph_json);
        }
        ResourceEntity bpmnResource = this.updateOrCreateResourceEntity(commandContext, modelEntity.getBPMNXMLID(), graph_json, modelEntity, "graph_json");
        modelEntity.setBPMNXMLID(bpmnResource.getId());
        String version = "";
        version = !modelEntity.isPublish() ? "0002" : VersionUtils.getNextVersion(modelEntity.getVersion());
        String name = modelEntity.getName().toString();
        ExtractMultiLanguageWordsUtil.extractWordsAndSaveOrUpdate(bpmnResource.getId(), name, modelEntity.getId(), version, modelEntity.getKey());
        return graph_json;
    }

    private ResourceEntity updateOrCreateResourceEntity(CommandContext commandContext, Long resourceId, String context, ModelEntity modelEntity, String type) {
        ResourceEntity entity = null;
        if (WfUtils.isNotEmpty(resourceId)) {
            entity = (ResourceEntity)new GetSingleEntityCmd(resourceId, "wf_resource").execute(commandContext);
        } else {
            entity = (ResourceEntity)new NewEntityCmd("wf_resource").execute(commandContext);
            commandContext.getResourceEntityManager().insert(entity);
            entity.setContent(this.getDefaultContent(modelEntity, entity));
        }
        entity.setData(context);
        entity.setName(String.format("%s.%s", this.model.getKey(), type));
        entity.setCurrentLanguage(RequestContext.get().getLang().toString());
        commandContext.getResourceEntityManager().update(entity);
        return entity;
    }

    private ILocaleString getDefaultContent(ModelEntity modelEntity, ResourceEntity resourceEntity) {
        Sets.SetView keys;
        LocaleString content = new LocaleString();
        Long resourceId = resourceEntity.getId();
        ILocaleString processName = modelEntity.getName();
        ILocaleString description = modelEntity.getDescription();
        if (processName == null && description == null) {
            return content;
        }
        if (processName == null) {
            processName = new LocaleString();
        }
        if (description == null) {
            description = new LocaleString();
        }
        if (!(keys = Sets.union((Set)processName.keySet(), (Set)description.keySet())).isEmpty()) {
            for (String key : keys) {
                String name = (String)processName.get((Object)key);
                String desc = (String)description.get((Object)key);
                Map<String, Object> template = ExtractMultiLanguageWordsUtil.getMultiLangResourceTemplate(resourceId, name != null ? name : "", modelEntity.getId(), modelEntity.getVersion(), key);
                Map data = (Map)template.get("data");
                if (WfUtils.isNotEmpty(name)) {
                    data.put(BpmnModelUtil.getProcessPropertyMultiKey("name"), name);
                }
                if (WfUtils.isNotEmpty(desc)) {
                    data.put(BpmnModelUtil.getProcessPropertyMultiKey("documentation"), desc);
                }
                content.put((Object)key, (Object)JSON.toJSONString(template));
            }
        }
        return content;
    }

    private boolean isWizardSave() {
        return this.resources != null && this.resources.get("featuresConfig") != null;
    }
}

