/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.workflow.api.model.ProcessModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityManager;
import kd.bos.workflow.nocode.NoCodeFlowUtil;

public class SaveProcessModelCmd
implements Command<Long> {
    private ProcessModel processModel;
    private Log logger = LogFactory.getLog(this.getClass());

    public SaveProcessModelCmd(ProcessModel processModel) {
        this.processModel = processModel;
    }

    @Override
    public Long execute(CommandContext commandContext) {
        ModelEntity entity = null;
        Long id = this.processModel.getId();
        ModelEntityManager modelManager = commandContext.getModelEntityManager();
        ResourceEntityManager resourceManager = commandContext.getResourceEntityManager();
        if (WfUtils.isEmpty(id)) {
            JSONObject data;
            JSONObject properties;
            Long orgUnitId;
            this.logger.debug(String.format("insert ProcessModel. %s", this.processModel.getNumber()));
            entity = (ModelEntity)commandContext.getModelEntityManager().create();
            entity.setKey(this.processModel.getNumber());
            Long modelId = ORM.create().genLongId("wf_model");
            entity.setId(modelId);
            ResourceEntity resource = (ResourceEntity)resourceManager.create();
            if (ModelType.NoCodeFlow.name().equals(this.processModel.getType())) {
                String data2 = this.processModel.getData().replaceAll("\"node_1\"", String.format("\"%s\"", modelId));
                resource.setData(this.getWorkflowJsonFromNoCodeJson(data2));
            } else {
                resource.setData(this.processModel.getData());
            }
            resource.setName(String.format("%s.%s", this.processModel.getNumber(), "graph_json"));
            resource.setCurrentLanguage(RequestContext.get().getLang().toString());
            Long orgId = RequestContext.get().getOrgId();
            String resourceData = resource.getData();
            if (WfUtils.isNotEmpty(resourceData) && WfUtils.isNotEmpty(orgUnitId = (properties = (data = JSON.parseObject((String)resourceData)).getJSONObject("properties")).getLong("orgUnitId"))) {
                orgId = orgUnitId;
            }
            if (WfUtils.isEmpty(orgId)) {
                orgId = OrgUnitServiceHelper.getRootOrgId();
            }
            entity.setOrgUnitId(orgId);
            resourceManager.insert(resource);
            Long resourceId = resource.getId();
            entity.setBPMNXMLID(resourceId);
            this.updateModelEntityFields(commandContext, entity);
            modelManager.insert(entity);
            id = entity.getId();
        } else {
            this.logger.debug(String.format("update ProcessModel. %s", id));
            entity = (ModelEntity)modelManager.findById(id);
            ResourceEntity resource = (ResourceEntity)resourceManager.findById(entity.getBPMNXMLID());
            String resourceData = resource.getData();
            if (WfUtils.isNotEmpty(this.processModel.getData())) {
                resourceData = ModelType.NoCodeFlow.name().equals(entity.getType()) ? this.getWorkflowJsonFromNoCodeJson(this.processModel.getData()) : this.processModel.getData();
            }
            JSONObject data = JSON.parseObject((String)resourceData);
            JSONObject properties = data.getJSONObject("properties");
            if (WfUtils.isNotEmpty((ILocaleString)this.processModel.getName())) {
                properties.put("name", (Object)this.processModel.getName().getLocaleValue());
            }
            if (WfUtils.isNotEmpty((ILocaleString)this.processModel.getDescription())) {
                properties.put("documentation", (Object)this.processModel.getDescription().getLocaleValue());
            } else {
                properties.put("documentation", null);
            }
            if (WfUtils.isNotEmpty(this.processModel.getBusinessId())) {
                properties.put("businessId", (Object)this.processModel.getBusinessId());
            }
            if (WfUtils.isNotEmpty(this.processModel.getOrgId())) {
                properties.put("orgUnitId", (Object)this.processModel.getOrgId());
            }
            resource.setData(data.toJSONString());
            resourceManager.update(resource);
            this.updateModelEntityFields(commandContext, entity);
            String entraBillId = properties.getString("entraBillId");
            String entraBill = properties.getString("entraBill");
            String triggerMode = properties.getString("triggerMode");
            if (WfUtils.isNotEmpty(entraBillId)) {
                entity.setEntraBillId(entraBillId);
            }
            if (WfUtils.isNotEmpty(entraBill)) {
                entity.setEntraBill(entraBill);
            }
            if (WfUtils.isNotEmpty(triggerMode)) {
                entity.setOperation(triggerMode);
            }
            modelManager.update(entity);
        }
        return id;
    }

    private String getWorkflowJsonFromNoCodeJson(String noCodeJsonString) {
        JSONObject noCodeJson = JSON.parseObject((String)noCodeJsonString);
        JSONObject workflowJson = NoCodeFlowUtil.convertNoCodeJsonToWorkflowJson(noCodeJson);
        return workflowJson.toJSONString();
    }

    private void updateModelEntityFields(CommandContext commandContext, ModelEntity entity) {
        String processType = this.processModel.getType();
        if (WfUtils.isEmpty(processType)) {
            processType = entity.getType();
        }
        if (WfUtils.isNotEmpty(this.processModel.getCloudId()) || WfUtils.isNotEmpty(this.processModel.getAppId())) {
            entity.setCategory(this.getOrCreateCategory(commandContext, this.processModel.getCloudId(), this.processModel.getAppId(), processType));
        }
        if (WfUtils.isNotEmpty(this.processModel.getEntityId())) {
            entity.setEntraBillId(this.processModel.getEntityId());
            String applicationId = WfUtils.getApplicationIdByBillId(this.processModel.getEntityId());
            entity.setApplicationId(applicationId);
        }
        if (WfUtils.isNotEmpty(this.processModel.getEntityNumber())) {
            entity.setEntraBill(this.processModel.getEntityNumber());
        }
        if (WfUtils.isNotEmpty(this.processModel.getOrgId())) {
            entity.setOrgUnitId(this.processModel.getOrgId());
        }
        if (WfUtils.isNotEmpty(this.processModel.getOperation())) {
            entity.setOperation(this.processModel.getOperation());
        }
        if (WfUtils.isNotEmpty(this.processModel.getType())) {
            entity.setType(this.processModel.getType());
        }
        if (WfUtils.isNotEmpty((ILocaleString)this.processModel.getName())) {
            entity.setName((ILocaleString)this.processModel.getName());
        }
        if (WfUtils.isNotEmpty((ILocaleString)this.processModel.getDescription())) {
            entity.setDescription((ILocaleString)this.processModel.getDescription());
        }
        if (WfUtils.isNotEmpty(this.processModel.getBusinessId())) {
            entity.setBusinessId(this.processModel.getBusinessId());
        }
    }

    private Long getOrCreateCategory(CommandContext commandContext, String cloudId, String appId, String processType) {
        return commandContext.getProcessCategoryEntityManager().getOrCreateCategory(cloudId, appId, processType);
    }
}

