/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cmd.model.AddNodeTemplateLogCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntityManager;

public class SwitchNodeTemplateEnableCmd
implements Command<String>,
Serializable {
    private transient Log log = LogFactory.getLog(this.getClass());
    private static final long serialVersionUID = -5626658584118219990L;
    private List<String> nodeTemplateNumbers = new ArrayList<String>();
    private Boolean isEnabled;

    public SwitchNodeTemplateEnableCmd(List<String> nodeTemplateNumbers, Boolean isEnabled) {
        this.nodeTemplateNumbers = nodeTemplateNumbers;
        this.isEnabled = isEnabled;
    }

    @Override
    public String execute(CommandContext commandContext) {
        String enableOrDisable = this.isEnabled != false ? ResManager.loadKDString((String)"\u542f\u7528", (String)"SwitchNodeTemplateEnableCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u7528", (String)"SwitchNodeTemplateEnableCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]);
        try {
            NodeTemplateEntityManager nodeTemplateEntityManager = commandContext.getNodeTemplateEntityManager();
            this.log.debug(String.format("nodeTemplate's numbers are %s", this.nodeTemplateNumbers));
            QFilter[] filters = new QFilter[]{new QFilter("number", "in", this.nodeTemplateNumbers)};
            List nodeTemplates = nodeTemplateEntityManager.findByQueryFilters(filters);
            for (NodeTemplateEntity nodeTemplate : nodeTemplates) {
                String enableValue = this.isEnabled != false ? "1" : "0";
                nodeTemplate.setEnable(enableValue);
                nodeTemplateEntityManager.update(nodeTemplate);
                String operationValue = this.isEnabled != false ? "abled" : "disabled";
                new AddNodeTemplateLogCmd(null, nodeTemplate, operationValue).execute(commandContext);
                WfCacheHelper.removeNodeTemplateExpendData(nodeTemplate.getStencilType());
            }
        }
        catch (Exception e) {
            this.log.warn(WfUtils.getExceptionStacktrace(e));
            return String.format(ResManager.loadKDString((String)"%1s\u5931\u8d25\uff0c\u539f\u56e0\uff1a%2s\u3002", (String)"SwitchNodeTemplateEnableCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]), enableOrDisable, e.getMessage());
        }
        return String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"SwitchNodeTemplateEnableCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]), enableOrDisable);
    }
}

