/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class SyncToModelCmd
implements Command<Boolean>,
Serializable {
    private static final long serialVersionUID = -8571813453633412452L;
    private Long schemeId;

    public SyncToModelCmd(Long schemeId) {
        this.schemeId = schemeId;
    }

    @Override
    public Boolean execute(CommandContext commandContext) {
        ModelEntityManager modelEntityManger;
        ModelEntity model;
        ProcessDefinitionEntity procDef;
        ResourceEntityManager resourceEntityManager;
        ResourceEntity resourceFrom;
        if (this.schemeId == null) {
            throw new WFIllegalArgumentException("schemeId is null");
        }
        String dataFrom = null;
        Long defId = null;
        Long jsonResourceId = null;
        Long modelId = null;
        Long bpmnXmlId = null;
        JSONObject properties = null;
        String documentation = null;
        String businessId = null;
        Long orgUnitId = null;
        String orgViewId = null;
        DynamicConfigSchemeEntity scheme = (DynamicConfigSchemeEntity)commandContext.getDynamicConfigSchemeEntityManager().findById(this.schemeId, "jsonresourceid,processdefinitionid");
        if (null != scheme) {
            defId = scheme.getProcDefId();
            jsonResourceId = scheme.getJsonResourceId();
        }
        if (null != (resourceFrom = (ResourceEntity)(resourceEntityManager = commandContext.getResourceEntityManager()).findById(jsonResourceId, "data"))) {
            dataFrom = resourceFrom.getData();
        }
        if (null != (procDef = (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(defId, "modelid"))) {
            modelId = procDef.getModelId();
        }
        if (null != (model = (ModelEntity)(modelEntityManger = commandContext.getModelEntityManager()).findById(modelId))) {
            bpmnXmlId = model.getBPMNXMLID();
        }
        ResourceEntity modelResource = (ResourceEntity)resourceEntityManager.findById(bpmnXmlId);
        if (null != model && null != modelResource && WfUtils.isNotEmpty(dataFrom)) {
            QFilter filter3;
            List mmodels;
            modelResource.setData(dataFrom);
            resourceEntityManager.update(modelResource);
            JSONObject data = JSON.parseObject((String)dataFrom);
            if (null != data) {
                properties = data.getJSONObject("properties");
            }
            if (null != properties) {
                documentation = properties.getString("documentation");
                businessId = properties.getString("businessId");
                orgUnitId = properties.getLong("orgUnitId");
                orgViewId = properties.getString("orgViewId");
            }
            model.setDescription(documentation);
            if (WfUtils.isNotEmpty(businessId)) {
                model.setBusinessId(businessId);
            }
            if (WfUtils.isNotEmpty(orgUnitId)) {
                model.setOrgUnitId(orgUnitId);
            }
            if (WfUtils.isNotEmpty(orgViewId)) {
                model.setOrgViewId(orgViewId);
            }
            modelEntityManger.update(model);
            QFilter filter1 = new QFilter("type", "=", (Object)"person");
            QFilter filter2 = new QFilter("procdefid", "=", (Object)procDef.getId());
            ParticipantModelEntityManager participantModelEntityManager = commandContext.getParticipantModelEntityManager();
            List pModels = participantModelEntityManager.findByQueryFilters(new QFilter[]{filter2, filter1});
            if (CollectionUtils.isNotEmpty(pModels) && CollectionUtils.isNotEmpty(mmodels = participantModelEntityManager.findByQueryFilters(new QFilter[]{filter3 = new QFilter("modelid", "=", (Object)modelId), filter1}))) {
                block0: for (ParticipantModelEntity mmodel : mmodels) {
                    for (ParticipantModelEntity pModel : pModels) {
                        if (pModel.getModelJsonPartId() == null || !pModel.getModelJsonPartId().equals(mmodel.getModelJsonPartId()) || pModel.getTaskActivityId() == null || !pModel.getTaskActivityId().equals(mmodel.getTaskActivityId()) || pModel.getProperty() == null || !pModel.getProperty().equals(mmodel.getProperty())) continue;
                        mmodel.setValue(pModel.getValue());
                        participantModelEntityManager.update(mmodel);
                        continue block0;
                    }
                }
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

