/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.cmd.management.scheme.UpdateDynamicConfigSchemeCmd;
import kd.bos.workflow.engine.impl.cmd.model.GetResourceByModelIdAndTypeCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.exception.WFException;

public class UpdateLatestProcessDefaultSchemeCmd
implements Command<Void> {
    private Long modelId;
    private Log log = LogFactory.getLog(this.getClass());

    public UpdateLatestProcessDefaultSchemeCmd(Long modelId) {
        this.modelId = modelId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        QFilter[] filters = new QFilter[]{new QFilter("modelid", "=", (Object)this.modelId)};
        List procDefs = commandContext.getProcessDefinitionEntityManager().findByQueryFilters(filters, "id", "id desc");
        if (procDefs.isEmpty()) {
            this.log.warn(String.format("ProcessDefinitionEntity is null. modelId: %s", this.modelId));
            return null;
        }
        ProcessDefinitionEntity procDef = (ProcessDefinitionEntity)procDefs.get(0);
        Long procDefId = procDef.getId();
        filters = new QFilter[]{new QFilter("processdefinitionid", "=", (Object)procDefId), new QFilter("isdefault", "=", (Object)true)};
        List schemes = commandContext.getDynamicConfigSchemeEntityManager().findByQueryFilters(filters);
        if (schemes.isEmpty()) {
            this.log.warn(String.format("DynamicConfigSchemeEntity is null. modelId: %s, procDefId: %s", this.modelId, procDefId));
            return null;
        }
        ResourceEntity resource = new GetResourceByModelIdAndTypeCmd(this.modelId, "graph_json").execute(commandContext);
        DynamicConfigSchemeEntity scheme = (DynamicConfigSchemeEntity)schemes.get(0);
        ResourceEntity schemeResource = (ResourceEntity)commandContext.getResourceEntityManager().findById(scheme.getResourceId());
        if (!this.verifyProcessStructure(resource.getData(), schemeResource.getData())) {
            throw new WFException(ResManager.loadKDString((String)"\u6d41\u7a0b\u6a21\u578b\u4e0e\u6d41\u7a0b\u65b9\u6848\u4e2d\u7684\u8282\u70b9\u6216\u7ebf\u6709\u5dee\u5f02\uff0c\u4e0d\u80fd\u66f4\u65b0\u3002", (String)"UpdateLatestProcessDefaultSchemeCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        new UpdateDynamicConfigSchemeCmd(scheme, resource.getData(), null).execute(commandContext);
        return null;
    }

    private boolean verifyProcessStructure(String modelData, String schemeData) {
        Set<String> modelElements = this.getProcessElementIds(modelData);
        Set<String> schemeElements = this.getProcessElementIds(schemeData);
        Sets.SetView difference = Sets.difference(modelElements, schemeElements);
        return difference.isEmpty();
    }

    private Set<String> getProcessElementIds(String data) {
        JSONObject json = JSON.parseObject((String)data);
        JSONArray childShapes = json.getJSONArray("childShapes");
        HashSet<String> ret = new HashSet<String>(childShapes.size());
        for (Object obj : childShapes) {
            JSONObject child = (JSONObject)obj;
            ret.add(child.getString("resourceId"));
        }
        return ret;
    }
}

