/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model.generate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.GenerateModelAutoKeyNumberCMD;
import kd.bos.workflow.engine.impl.cmd.model.SaveModelCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;

public class CreateEmptyModel
implements Command<Long> {
    protected Log logger = LogFactory.getLog(this.getClass());
    private final String entityNumber;

    public CreateEmptyModel(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    @Override
    public Long execute(CommandContext commandContext) {
        Long DEFAULTMODEL = 1716752139562276864L;
        ModelEntity src = (ModelEntity)commandContext.getModelEntityManager().findById(DEFAULTMODEL);
        if (src == null) {
            return null;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.entityNumber);
        MetadataReader reader = new MetadataReader();
        String entityId = reader.loadIdByNumber(this.entityNumber, MetaCategory.Entity);
        String processNumber = this.getAutoProcessNumber(commandContext, this.entityNumber, entityId);
        String businessId = String.format("%s%s", this.entityNumber, "gpt");
        String name = String.format(ResManager.loadKDString((String)"%s\u5ba1\u6279\u6d41\u7a0b", (String)"CreateEmptyModel_1", (String)"bos-wf-engine", (Object[])new Object[0]), entityType.getDisplayName().getLocaleValue());
        ModelEntityImpl model = new ModelEntityImpl();
        model.setId(ORM.create().genLongId("wf_model"));
        model.setCreatorId(RequestContext.get().getCurrUserId());
        model.setCreateDate(WfUtils.now());
        model.setBusinessId(businessId);
        model.setName(name);
        model.setKey(processNumber);
        model.setType(ModelType.AuditFlow.name());
        model.setOrgUnitId(RequestContext.get().getOrgId());
        model.setEntraBill(this.entityNumber);
        model.setEntraBillId(entityId);
        model.setApplicationId(WfUtils.getApplicationIdByBillId(model.getEntraBillId()));
        HashMap<String, Object> res = new HashMap<String, Object>();
        ResourceEntity resSrc = (ResourceEntity)commandContext.getResourceEntityManager().findById(src.getResourceId());
        String data = resSrc.getData();
        JSONObject root = JSON.parseObject((String)data);
        if (root != null) {
            JSONObject props = root.getJSONObject("properties");
            if (props == null) {
                props = new JSONObject();
            }
            props.put("name", (Object)name);
            props.put("businessId", (Object)businessId);
            props.put("entraBillName", (Object)entityType.getDisplayName().getLocaleValue());
            props.put("entraBill", (Object)this.entityNumber);
            props.put("entraBillId", (Object)entityId);
            props.put("orgUnitId", (Object)model.getOrgUnitId());
            props.put("process_id", (Object)model.getNumber());
            try {
                JSONArray arr = root.getJSONArray("childShapes");
                if (arr != null && arr.size() > 0) {
                    for (int i = 0; i < arr.size(); ++i) {
                        JSONObject target;
                        JSONObject out;
                        JSONArray outs;
                        JSONObject t = (JSONObject)arr.get(i);
                        JSONObject s = t.getJSONObject("stencil");
                        String type = (String)s.get((Object)"id");
                        if ("StartSignalEvent".equalsIgnoreCase(type)) {
                            props = (JSONObject)t.get((Object)"properties");
                            props.put("number", (Object)"StartSignalEvent1");
                            props.put("itemId", (Object)(processNumber + "_" + props.get((Object)"number")));
                            t.put("resourceId", props.get((Object)"itemId"));
                            outs = t.getJSONArray("outgoing");
                            if (outs == null || outs.size() <= 0) continue;
                            out = (JSONObject)outs.get(0);
                            out.put("resourceId", (Object)(processNumber + "_SequenceFlow2"));
                            continue;
                        }
                        if ("EndNoneEvent".equalsIgnoreCase(type)) {
                            props = (JSONObject)t.get((Object)"properties");
                            props.put("number", (Object)"EndNoneEvent2");
                            props.put("itemId", (Object)(processNumber + "_" + props.get((Object)"number")));
                            t.put("resourceId", props.get((Object)"itemId"));
                            continue;
                        }
                        if (!"SequenceFlow".equalsIgnoreCase(type)) continue;
                        props = (JSONObject)t.get((Object)"properties");
                        props.put("itemId", (Object)(processNumber + "_SequenceFlow2"));
                        t.put("resourceId", props.get((Object)"itemId"));
                        outs = t.getJSONArray("outgoing");
                        if (outs != null && outs.size() > 0) {
                            out = (JSONObject)outs.get(0);
                            out.put("resourceId", (Object)(processNumber + "_" + "EndNoneEvent" + 2));
                        }
                        if ((target = t.getJSONObject("target")) == null) continue;
                        target.put("resourceId", (Object)(processNumber + "_" + "EndNoneEvent" + 2));
                    }
                }
            }
            catch (Exception e) {
                this.logger.error(WfUtils.getExceptionStacktrace(e));
            }
            res.put("graph_json", root.toJSONString());
        }
        new SaveModelCmd(model, res).execute(commandContext);
        return model.getId();
    }

    private String getAutoProcessNumber(CommandContext commandContext, String entityNumber, String entityId) {
        HashMap<String, String> modelInfoMap = new HashMap<String, String>();
        modelInfoMap.put("billNumber", entityNumber);
        modelInfoMap.put("entraBillId", entityId);
        modelInfoMap.put("orgUnitId", String.valueOf(RequestContext.get().getOrgId()));
        int autoKeyNumber = new GenerateModelAutoKeyNumberCMD(modelInfoMap).execute(commandContext);
        String prefix = "Proc_" + entityNumber + "_audit_";
        String newNumber = prefix + autoKeyNumber;
        while (this.exists(newNumber)) {
            newNumber = prefix + ++autoKeyNumber;
        }
        return newNumber;
    }

    private boolean exists(String number) {
        QFilter[] filters = new QFilter[]{new QFilter("key", "=", (Object)number)};
        return QueryServiceHelper.exists((String)"wf_model", (QFilter[])filters);
    }
}

