/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model.generate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareTypeDto;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.EndEvent;
import kd.bos.workflow.bpmn.model.EventDefinition;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.GraphicInfo;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.SignalEventDefinition;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.comparetype.CompareTypesUtils;
import kd.bos.workflow.engine.dynprocess.freeflow.WFAuditTask;
import kd.bos.workflow.engine.dynprocess.freeflow.WFBillExceptionOp;
import kd.bos.workflow.engine.dynprocess.freeflow.WFConditionalRule;
import kd.bos.workflow.engine.dynprocess.freeflow.WFDecisionOption;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowElement;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowNode;
import kd.bos.workflow.engine.dynprocess.freeflow.WFJointAuditTask;
import kd.bos.workflow.engine.dynprocess.freeflow.WFListener;
import kd.bos.workflow.engine.dynprocess.freeflow.WFParticipantEntity;
import kd.bos.workflow.engine.dynprocess.freeflow.WFParticipantModel;
import kd.bos.workflow.engine.dynprocess.freeflow.WFProcess;
import kd.bos.workflow.engine.dynprocess.freeflow.WFRejectNodesModel;
import kd.bos.workflow.engine.dynprocess.freeflow.WFSequenceFlow;
import kd.bos.workflow.engine.dynprocess.freeflow.WFUserTask;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.cmd.model.SaveModelCmd;
import kd.bos.workflow.engine.impl.cmd.model.generate.CreateEmptyModel;
import kd.bos.workflow.engine.impl.cmd.model.generate.DiffElem;
import kd.bos.workflow.engine.impl.cmd.model.generate.ModelExtend;
import kd.bos.workflow.engine.impl.dynprocess.DynProcessProcessorUtil;
import kd.bos.workflow.engine.impl.dynprocess.FreeFlowProcessor;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.RoleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityImpl;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class GenerateAuditProcessByJSON
implements Command<ModelExtend> {
    private static final String ENTRYBILLNAME = "entraBillName";
    private static final String NODETYPE = "nodeType";
    protected static final String NODENAME = "nodeName";
    private static final String OUTGOINGS = "outgoings";
    private static final String TO = "to";
    private static final String NEXT = "_next_";
    private static final String CALCED = "calced";
    private static final String OTHERWISE = "otherwise";
    private static final String END = "end";
    public static final String CREATEDEFAULTROLE = "createDefaultRole";
    public static final String CREATEDEFAULTPERSON = "createDefaultPerson";
    protected Log logger = LogFactory.getLog(this.getClass());
    protected static final String NODES = "nodes";
    private String inputJson;
    private Long curModelId;
    private final Map<String, String> configs;
    private Map<String, IModelConverter> convertors = new HashMap<String, IModelConverter>();

    public GenerateAuditProcessByJSON(String inputJson, Long curModelId, Map<String, String> configs) {
        this.inputJson = inputJson;
        this.curModelId = curModelId;
        this.configs = configs;
        this.init();
    }

    private void init() {
        this.convertors.put("Process", new ProcessConvertor());
        this.convertors.put("UserTask", new UserTaskConvertor());
        this.convertors.put("AuditTask", new AuditTaskConvertor());
        this.convertors.put("YunzhijiaTask", new YunzhijiaTaskConvertor());
    }

    @Override
    public ModelExtend execute(CommandContext commandContext) {
        if (WfUtils.isEmpty(this.inputJson)) {
            this.logger.debug("empty original1.");
            return null;
        }
        JSONObject original = this.getRightJson();
        if (original == null) {
            this.logger.debug("empty original after parse.");
            return null;
        }
        try {
            this.fixOriginalJSON(original);
            IModelConverter converter = this.getConverter("Process");
            if (!converter.validate(original)) {
                return null;
            }
            String entityNumber = original.getString("entityNumber");
            ModelEntity model = this.getModelEntity(commandContext, entityNumber);
            converter.setModel(model);
            WFProcess wfProcess = (WFProcess)converter.convert(commandContext, null, (Map<String, Object>)original);
            ConverterContext context = new ConverterContext(wfProcess.getNumber(), wfProcess.getEntraBillId(), wfProcess.getEntraBill(), wfProcess.getEntraBillName().getLocaleValue(), 1);
            context.setConfigs(this.configs);
            WFProcess prevElem = wfProcess;
            context.addFlowElement((WFFlowElement)wfProcess);
            this.addNextOutgoings(context, (WFFlowElement)wfProcess);
            JSONArray arrs = original.getJSONArray(NODES);
            if (arrs != null && !arrs.isEmpty()) {
                int seq = 1;
                int size = this.calcAuditCount(arrs);
                for (Object arr : arrs) {
                    Map<String, Object> go;
                    JSONObject json = (JSONObject)arr;
                    String type = json.getString(NODETYPE);
                    converter = this.getConverter(type);
                    if (WfUtils.isEmpty(type) || converter == null) {
                        this.logger.debug("type[%s] is null or does not support by json generation.", (Object)type);
                        continue;
                    }
                    if (seq == size) {
                        context.setLastAudit(true);
                    } else {
                        context.setLastAudit(false);
                    }
                    WFFlowElement element = converter.convert(commandContext, context, (Map<String, Object>)json);
                    ArrayList<Map<String, Object>> goings = new ArrayList<Map>();
                    Object obj = json.get((Object)OUTGOINGS);
                    if (obj instanceof Map) {
                        goings.add((Map)obj);
                    } else if (obj instanceof List) {
                        goings = (List)json.get((Object)OUTGOINGS);
                    }
                    if (goings != null && !goings.isEmpty()) {
                        context.addNodeOutgoings(element.getId(), goings);
                    } else {
                        this.addNextOutgoings(context, element);
                    }
                    if (context.getOutgings(prevElem.getId()) != null && context.getOutgings(prevElem.getId()).size() == 1 && NEXT.equals((go = context.getOutgings(prevElem.getId()).get(0)).get(TO))) {
                        go.put(TO, element.getId());
                        go.put(CALCED, Boolean.TRUE);
                    }
                    prevElem = element;
                    context.addFlowElement(element);
                    if (!BpmnModelUtil.instanceofAuditTask(type)) continue;
                    ++seq;
                }
                this.buildSequencesFlows(context);
            }
            return this.saveToModel(commandContext, model, wfProcess);
        }
        catch (KDBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u6d41\u7a0b\u53d1\u751f\u9519\u8bef,\u53ef\u80fd\u4ea7\u751f\u7684\u6d41\u7a0b\u6a21\u578b\u6709\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5\u5904\u7406\uff0c\u5982\u679c\u8fd8\u6709\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"GenerateAuditProcessByJSON_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
    }

    private JSONObject getRightJson() {
        try {
            this.logger.debug(this.inputJson);
            return JSON.parseObject((String)this.inputJson);
        }
        catch (Exception e) {
            this.inputJson = this.inputJson.replaceAll("((?<=\\{)\\s*\\'|(?<=,)\\s*\\'|\\'\\s*(?=:)|(?<=:)\\s*\\'|\\'\\s*(?=,)|\\'\\s*(?=}))", "\"");
            try {
                this.logger.debug(String.format("\u5c06\u5355\u5f15\u53f7\u8f6c\u5316\u4e3a\u53cc\u5f15\u53f7[%s]", this.inputJson));
                return JSON.parseObject((String)this.inputJson);
            }
            catch (Exception e1) {
                this.inputJson = this.inputJson.replaceAll("(\\w+)\\s*:\\s*(\\w+)", "\"$1\":\"$2\"");
                try {
                    this.logger.debug(String.format("\u5c06\u4e0d\u5e26\u5355\u5f15\u53f7\u7684\u52a0\u4e0a\u53cc\u5f15\u53f7[%s]", this.inputJson));
                    return JSON.parseObject((String)this.inputJson);
                }
                catch (Exception e2) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u4e86\u975e\u6cd5\u7684JSON\u5b57\u7b26\u4e32\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"GenerateAuditProcessByJSON_2", (String)"bos-wf-engine", (Object[])new Object[0]));
                }
            }
        }
    }

    private void fixOriginalJSON(JSONObject original) {
        JSONArray arrs = original.getJSONArray(NODES);
        if (arrs != null && !arrs.isEmpty()) {
            Iterator iter = arrs.iterator();
            int i = 1;
            while (iter.hasNext()) {
                JSONObject json = (JSONObject)iter.next();
                if (json.isEmpty()) {
                    iter.remove();
                    continue;
                }
                String nodeName = json.getString(NODENAME);
                if (WfUtils.isEmpty(nodeName)) {
                    throw new KDBizException(new ErrorCode("illegalInputJson", ResManager.loadKDString((String)"\u751f\u6210\u7684json\u6709\u8bef\uff0c\u6682\u65f6\u4e0d\u652f\u6301\u6b64\u79cd\u573a\u666f\u3002", (String)"GenerateAuditProcessByJSON_3", (String)"bos-wf-engine", (Object[])new Object[0])), new Object[0]);
                }
                String type = json.getString(NODETYPE);
                if (this.isEndNode(nodeName, type)) {
                    iter.remove();
                } else {
                    String to;
                    Object obj = json.get((Object)OUTGOINGS);
                    if (obj == null || obj instanceof JSONObject && ((JSONObject)obj).isEmpty() || obj instanceof JSONArray && ((JSONArray)obj).isEmpty()) {
                        JSONObject end = new JSONObject();
                        end.put(TO, (Object)"End");
                        json.put(OUTGOINGS, (Object)end);
                    } else if (obj instanceof JSONObject && WfUtils.isEmpty(to = (String)((JSONObject)obj).get((Object)TO))) {
                        ((JSONObject)obj).put(TO, (Object)"End");
                    }
                    Object participantObject = json.get((Object)"participant");
                    if (participantObject instanceof JSONObject) {
                        JSONObject participantJSONObject = (JSONObject)participantObject;
                        String participantType = participantJSONObject.getString("type");
                        String participantTypeValue = "";
                        Set participantEntrySet = participantJSONObject.entrySet();
                        for (Map.Entry participant : participantEntrySet) {
                            if ("type".equals(participant.getKey())) continue;
                            participantTypeValue = (String)participant.getKey();
                        }
                        String participantValue = WfUtils.isNotEmpty(participantTypeValue) ? participantType + "(" + participantTypeValue + ")" : participantType;
                        json.put("participant", (Object)participantValue);
                    }
                }
                if (WfUtils.isEmpty(type)) {
                    if (i == 1) {
                        json.put(NODETYPE, (Object)"UserTask");
                    } else {
                        json.put(NODETYPE, (Object)"AuditTask");
                    }
                }
                ++i;
            }
        } else {
            throw new KDBizException(new ErrorCode("illegalInputJson", ResManager.loadKDString((String)"\u751f\u6210\u7684json\u6709\u8bef\uff0c\u6682\u65f6\u4e0d\u652f\u6301\u6b64\u79cd\u573a\u666f\u3002", (String)"GenerateAuditProcessByJSON_3", (String)"bos-wf-engine", (Object[])new Object[0])), new Object[0]);
        }
        this.logger.debug(String.format("after fix, json is %s", original.toJSONString()));
    }

    private void addNextOutgoings(ConverterContext context, WFFlowElement element) {
        HashMap<String, String> go = new HashMap<String, String>(1);
        go.put(TO, NEXT);
        ArrayList<Map<String, Object>> outs = new ArrayList<Map<String, Object>>();
        outs.add(go);
        context.addNodeOutgoings(element.getId(), outs);
    }

    private void buildSequencesFlows(ConverterContext context) {
        Set<Map.Entry<String, WFFlowElement>> elements = context.getFlowElementMap().entrySet();
        HashMap<String, NodeAssistInfo> nodeAssistInfoMap = new HashMap<String, NodeAssistInfo>();
        for (Map.Entry<String, WFFlowElement> entry : elements) {
            List<Map<String, Object>> outgoings;
            WFFlowElement elem = entry.getValue();
            NodeAssistInfo nodeAsst = (NodeAssistInfo)nodeAssistInfoMap.get(elem.getId());
            if (nodeAsst == null) {
                nodeAsst = new NodeAssistInfo(elem.getId(), null);
                if (elem instanceof WFFlowNode) {
                    nodeAsst.setName(((WFFlowNode)elem).getName().getLocaleValue());
                }
                nodeAssistInfoMap.put(elem.getId(), nodeAsst);
            }
            if ((outgoings = context.getOutgings(elem.getId())) == null || outgoings.isEmpty()) continue;
            boolean exclusive = false;
            for (Map<String, Object> go : outgoings) {
                List<TargetNodeInfo> nextNodes = this.getTargetNode(context, go);
                if (nextNodes == null || nextNodes.isEmpty()) continue;
                for (TargetNodeInfo nextNode : nextNodes) {
                    if (nextNode.getSequenceFlow() == null) {
                        if (nextNode.getTarget() == null) continue;
                        WFFlowNode nNode = nextNode.getTarget();
                        elem.addNextNode(nNode);
                        NodeAssistInfo nextNodeAssit = (NodeAssistInfo)nodeAssistInfoMap.get(nNode.getId());
                        if (nextNodeAssit == null) {
                            nextNodeAssit = new NodeAssistInfo(nNode.getId(), nNode.getName().getLocaleValue());
                            nodeAssistInfoMap.put(nNode.getId(), nextNodeAssit);
                        }
                        nextNodeAssit.incIncomings();
                        continue;
                    }
                    elem.addNextNode(nextNode.getTarget(), nextNode.getSequenceFlow());
                    if (exclusive) continue;
                    exclusive = true;
                }
            }
            if (exclusive || elem.getNextNodes() == null || elem.getNextNodes().size() <= 1 || !(elem instanceof WFFlowNode)) continue;
            ((WFFlowNode)elem).setFork(Boolean.valueOf(true));
            ((WFFlowNode)elem).setOutSet("leavewhenallmeet");
        }
        Set infos = nodeAssistInfoMap.entrySet();
        for (Map.Entry entry : infos) {
            String id;
            WFFlowElement target;
            if (((NodeAssistInfo)entry.getValue()).getIncomings() <= 1 || !((target = context.getFlowElementById(id = ((NodeAssistInfo)entry.getValue()).getNodeId())) instanceof WFFlowNode)) continue;
            ((WFFlowNode)target).setJoin(Boolean.valueOf(true));
            ((WFFlowNode)target).setInSet("enterwhenallarrive");
        }
    }

    private List<TargetNodeInfo> getTargetNode(ConverterContext context, Map<String, Object> go) {
        Boolean calced = (Boolean)go.get(CALCED);
        if (calced != null && calced.booleanValue()) {
            String targetId = (String)go.get(TO);
            if (WfUtils.isEmpty(targetId)) {
                return null;
            }
            WFFlowElement target = context.getFlowElementById(targetId);
            if (target instanceof WFFlowNode) {
                return Collections.singletonList(new TargetNodeInfo((WFFlowNode)target, null));
            }
        } else {
            String condition = (String)go.get("condition");
            if (WfUtils.isNotEmpty(condition)) {
                ArrayList<TargetNodeInfo> ret = new ArrayList<TargetNodeInfo>();
                String targetName = (String)go.get(TO);
                this.calcTargetsByName(context, targetName, ret, this.createSequenceFlow(context, condition));
                String otherwise = (String)go.get(OTHERWISE);
                if (WfUtils.isNotEmpty(otherwise)) {
                    this.calcTargetsByName(context, otherwise, ret, this.createOtherwiseSequenceFlow(context));
                }
                return ret;
            }
            String gotos = (String)go.get(TO);
            if (WfUtils.isNotEmpty(gotos)) {
                ArrayList<TargetNodeInfo> ret = new ArrayList<TargetNodeInfo>();
                this.calcTargetsByName(context, gotos, ret, null);
                return ret;
            }
        }
        return null;
    }

    private void calcTargetsByName(ConverterContext context, String gotos, List<TargetNodeInfo> ret, WFSequenceFlow sequenceFlow) {
        Arrays.stream(gotos.split(",")).forEach(node -> {
            WFFlowElement other = context.getFlowElementByName((String)node);
            if (other instanceof WFFlowNode) {
                ret.add(new TargetNodeInfo((WFFlowNode)other, sequenceFlow));
            } else if (this.isEndNode((String)node)) {
                WFFlowNode endNode = new WFFlowNode();
                endNode.setNumber(END);
                endNode.setType("EndNoneEvent");
                endNode.setName(new LocaleString("End"));
                endNode.setId(context.getProcessNumber() + "_" + "EndNoneEvent" + "2");
                ret.add(new TargetNodeInfo(endNode, sequenceFlow));
            }
        });
    }

    private boolean isEndNode(String node) {
        String s1 = ResManager.loadKDString((String)"\u7ed3\u675f", (String)"GenerateAuditProcessByJSON_4", (String)"bos-wf-engine", (Object[])new Object[0]);
        String s2 = ResManager.loadKDString((String)"\u7ed3\u675f\u8282\u70b9", (String)"GenerateAuditProcessByJSON_5", (String)"bos-wf-engine", (Object[])new Object[0]);
        return s1.equalsIgnoreCase(node) || s2.equalsIgnoreCase(node) || "End".equalsIgnoreCase(node);
    }

    private boolean isEndNode(String node, String type) {
        String s1 = ResManager.loadKDString((String)"\u7ed3\u675f", (String)"GenerateAuditProcessByJSON_4", (String)"bos-wf-engine", (Object[])new Object[0]);
        String s2 = ResManager.loadKDString((String)"\u7ed3\u675f\u8282\u70b9", (String)"GenerateAuditProcessByJSON_5", (String)"bos-wf-engine", (Object[])new Object[0]);
        return s1.equalsIgnoreCase(node) || s2.equalsIgnoreCase(node) || "End".equalsIgnoreCase(node) || "EndEvent".equalsIgnoreCase(type);
    }

    private WFSequenceFlow createOtherwiseSequenceFlow(ConverterContext context) {
        WFSequenceFlow wfSequenceFlow = new WFSequenceFlow();
        wfSequenceFlow.setDefaultflow(true);
        wfSequenceFlow.setName(ResManager.loadKDString((String)"\u5426\u5219", (String)"GenerateAuditProcessByJSON_6", (String)"bos-wf-engine", (Object[])new Object[0]));
        wfSequenceFlow.setType("SequenceFlow");
        return wfSequenceFlow;
    }

    private WFSequenceFlow createSequenceFlow(ConverterContext context, String condition) {
        WFSequenceFlow wfSequenceFlow = new WFSequenceFlow();
        wfSequenceFlow.setDefaultflow(false);
        wfSequenceFlow.setType("SequenceFlow");
        WFConditionalRule conditionalRule = this.getWfConditionalRule(context, condition);
        if (conditionalRule != null) {
            wfSequenceFlow.setName(conditionalRule.getShowtext() == null ? "" : conditionalRule.getShowtext().getLocaleValue());
            wfSequenceFlow.setConditionalRule(conditionalRule);
        }
        return wfSequenceFlow;
    }

    private WFConditionalRule getWfConditionalRule(ConverterContext context, String condition) {
        String regex = "([a-zA-Z]+.[a-zA-Z]+.[a-zA-Z]+)|([a-zA-Z]+.[a-zA-Z]+)|([a-zA-Z]+)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(condition);
        StringBuffer sb = new StringBuffer();
        String showtext = condition;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)context.getEntityNumber());
        while (matcher.find()) {
            String attribute = matcher.group(0);
            if (attribute.startsWith("model.")) continue;
            matcher.appendReplacement(sb, "model." + attribute);
            DynamicProperty dp = entityType.getProperty(attribute);
            if (dp == null || dp.getDisplayName() == null || !WfUtils.isNotEmpty(dp.getDisplayName().getLocaleValue())) continue;
            showtext = showtext.replaceAll(attribute, dp.getDisplayName().getLocaleValue());
        }
        matcher.appendTail(sb);
        showtext = this.replaceCompareInfo(showtext);
        String updatedExpression = sb.toString();
        if (WfUtils.isNotEmpty(updatedExpression)) {
            WFConditionalRule conditionalRule = new WFConditionalRule();
            conditionalRule.setProperty("conditionalRule");
            conditionalRule.setType("sequenceFlow");
            conditionalRule.setExpression(String.format("${%s}", updatedExpression));
            conditionalRule.setShowtext(new LocaleString(showtext));
            return conditionalRule;
        }
        return null;
    }

    private String replaceCompareInfo(String showtext) {
        if (WfUtils.isEmpty(showtext)) {
            return "";
        }
        HashMap<String, CompareTypeDto> compareTypes = CompareTypesUtils.get().getCompareTypeItemMap();
        Set<Map.Entry<String, CompareTypeDto>> compareTypesEntrySet = compareTypes.entrySet();
        for (Map.Entry<String, CompareTypeDto> compareType : compareTypesEntrySet) {
            CompareTypeDto dto;
            String key = compareType.getKey();
            if (!showtext.contains(key) || (dto = compareType.getValue()) == null) continue;
            showtext = showtext.replaceAll(key, dto.getName().getLocaleValue());
        }
        showtext = showtext.replaceAll(" ", "");
        return showtext.trim();
    }

    private int calcAuditCount(JSONArray arrs) {
        int count = 0;
        for (Object arr : arrs) {
            JSONObject json = (JSONObject)arr;
            String type = json.getString(NODETYPE);
            if (!BpmnModelUtil.instanceofAuditTask(type)) continue;
            ++count;
        }
        return count;
    }

    private ModelExtend saveToModel(CommandContext commandContext, ModelEntity model, WFProcess wfProcess) {
        try {
            ResourceEntity resource = (ResourceEntity)commandContext.getResourceEntityManager().findById(model.getBPMNXMLID());
            BpmnModel oldModel = ProcessDefinitionUtil.getBpmnModel(resource.getData());
            HashMap<String, Object> resources = new HashMap<String, Object>();
            BpmnModel last = this.getBpmnJson(commandContext, wfProcess);
            resources.put("graph_json", GraphCodecUtils.convertBpmnModelToJSON(last));
            new SaveModelCmd(model, resources).execute(commandContext);
            return new ModelExtend(model.getId(), this.calcDiffs(commandContext, oldModel, last));
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u6d41\u7a0b\u53d1\u751f\u8f6c\u6362\u9519\u8bef,\u53ef\u80fd\u751f\u6210\u7684\u6d41\u7a0b\u6a21\u578b\u6709\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5\u5904\u7406\uff0c\u5982\u679c\u8fd8\u6709\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"GenerateAuditProcessByJSON_7", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
    }

    private List<DiffElem> calcDiffs(CommandContext commandContext, BpmnModel oldModel, BpmnModel newModel) {
        ArrayList<DiffElem> ret = new ArrayList<DiffElem>();
        try {
            List<String> sources = this.getElementsKeys(oldModel.getMainProcess());
            List<String> dest = this.getElementsKeys(newModel.getMainProcess());
            this.logger.debug(String.format("Sources[%s],Dest[%s]", sources == null ? "null" : sources.toString(), WfUtils.listToString(dest, ",")));
            TreeSet first = Sets.newTreeSet((Iterable)Sets.newHashSet(sources));
            TreeSet second = Sets.newTreeSet((Iterable)Sets.newHashSet(dest));
            Sets.SetView diffs = null;
            diffs = "true".equals(WfConfigurationUtil.getConfigCenterVal("gpt.generate.symDiff")) ? Sets.symmetricDifference((Set)second, (Set)first) : Sets.difference((Set)second, (Set)first);
            this.logger.debug(String.format("Diffs[%s]", WfUtils.listToString(diffs, ",")));
            if (!diffs.isEmpty()) {
                HashMap<String, DiffElem> levels = new HashMap<String, DiffElem>();
                List<StartEvent> startEvts = newModel.getMainProcess().findFlowElementsOfType(StartEvent.class);
                if (startEvts == null || startEvts.isEmpty()) {
                    return ret;
                }
                this.calcLevel(levels, startEvts.get(0), 1);
                Set levelsEntrySet = levels.entrySet();
                for (Map.Entry level : levelsEntrySet) {
                    if (!diffs.contains(level.getKey())) continue;
                    ret.add((DiffElem)level.getValue());
                }
            }
        }
        catch (Exception e) {
            this.logger.error(WfUtils.getExceptionStacktrace(e));
        }
        this.logger.debug(WfUtils.listToString(ret, ","));
        return ret;
    }

    private void calcLevel(Map<String, DiffElem> levels, FlowNode element, int level) {
        if (levels.containsKey(element.getId())) {
            return;
        }
        if (this.isFirstNode(element)) {
            levels.put("UserTask", new DiffElem(element.getId(), element.getName(), level));
        } else {
            levels.put(element.getName(), new DiffElem(element.getId(), element.getName(), level));
        }
        if (element.getIncomingFlows() != null && !element.getIncomingFlows().isEmpty()) {
            for (SequenceFlow flow : element.getIncomingFlows()) {
                levels.put(this.getFlowKey(flow), new DiffElem(flow.getId(), this.getFlowKey(flow), level));
            }
        }
        List<SequenceFlow> outgoingFlows = element.getOutgoingFlows();
        for (SequenceFlow sequenceFlow : outgoingFlows) {
            if (sequenceFlow.getTargetFlowElement() == null) continue;
            FlowNode nextFlowNode = (FlowNode)sequenceFlow.getTargetFlowElement();
            this.calcLevel(levels, nextFlowNode, level + 1);
        }
    }

    private String getFlowKey(SequenceFlow seq) {
        String condition;
        String src;
        String string = seq.getSourceFlowElement() == null ? "" : (src = this.isFirstNode(seq.getSourceFlowElement()) ? "UserTask" : seq.getSourceFlowElement().getName());
        String dest = seq.getTargetFlowElement() == null ? "" : (this.isFirstNode(seq.getTargetFlowElement()) ? "UserTask" : seq.getTargetFlowElement().getName());
        String string2 = condition = WfUtils.isEmpty(seq.getName()) ? "" : "HASCON";
        if (WfUtils.isNotEmpty(condition)) {
            return src + "-" + dest + "-" + condition;
        }
        return src + "-" + dest;
    }

    private List<String> getElementsKeys(Process mainProcess) {
        return mainProcess.getFlowElementList().stream().filter(p -> !(p instanceof StartEvent) && !(p instanceof EndEvent)).map(p -> {
            if (this.isFirstNode((FlowElement)p)) {
                return "UserTask";
            }
            if (p instanceof FlowNode) {
                return p.getName();
            }
            if (p instanceof SequenceFlow) {
                return this.getFlowKey((SequenceFlow)p);
            }
            return "";
        }).collect(Collectors.toList());
    }

    private boolean isFirstNode(FlowElement p) {
        return p instanceof UserTask && BpmnModelUtil.isFirstNodeByModel((FlowNode)p);
    }

    private BpmnModel getBasicBpmnModel(WFProcess wfProcess) {
        BpmnModel aa = ProcessDefinitionUtil.getBpmnModel(Long.parseLong("886006942529487872"), null);
        BpmnModel bpmnModel = new BpmnModel();
        Process dynProcess = new Process();
        dynProcess.setId(wfProcess.getNumber());
        dynProcess.setNumber(wfProcess.getNumber());
        dynProcess.setEntraBillName(wfProcess.getEntraBillName().getLocaleValue());
        dynProcess.setEntraBill(wfProcess.getEntraBill());
        dynProcess.setEntraBillId(wfProcess.getEntraBillId());
        dynProcess.setProcessType(wfProcess.getProcessType());
        dynProcess.setAutoAuditWhenSamePerson(wfProcess.getAutoAuditWhenSamePerson());
        dynProcess.setName((ILocaleString)wfProcess.getName());
        dynProcess.setOrgUnitId(OrgUnitServiceHelper.getRootOrgId());
        String businessId = String.format("%s%s", wfProcess.getEntraBill(), "gpt");
        dynProcess.setBusinessId(businessId);
        bpmnModel.addProcess(dynProcess);
        StartEvent startEvent = new StartEvent();
        startEvent.setNumber("StartSignalEvent1");
        startEvent.setName(ResManager.loadKDString((String)"\u5f00\u59cb", (String)"GenerateAuditProcessByJSON_8", (String)"bos-wf-engine", (Object[])new Object[0]));
        startEvent.setId(wfProcess.getId() + "_" + startEvent.getNumber());
        startEvent.setType("StartSignalEvent");
        startEvent.setStyle(aa.getFlowElement("freeflowtpl_StartSignalEvent1").getStyle());
        dynProcess.setInitialFlowElement(startEvent);
        ArrayList<EventDefinition> eventDefinitions = new ArrayList<EventDefinition>();
        SignalEventDefinition evt = new SignalEventDefinition();
        evt.setSignalRef(wfProcess.getId());
        eventDefinitions.add(evt);
        startEvent.setEventDefinitions(eventDefinitions);
        dynProcess.addFlowElement(startEvent);
        EndEvent endEvent = new EndEvent();
        endEvent.setNumber("EndNoneEvent2");
        endEvent.setName(ResManager.loadKDString((String)"\u7ed3\u675f", (String)"GenerateAuditProcessByJSON_9", (String)"bos-wf-engine", (Object[])new Object[0]));
        endEvent.setId(wfProcess.getId() + "_" + endEvent.getNumber());
        endEvent.setType("EndNoneEvent");
        endEvent.setStyle(aa.getFlowElement("freeflowtpl_EndNoneEvent9").getStyle());
        dynProcess.addFlowElement(endEvent);
        bpmnModel.addGraphicInfo(startEvent.getId(), aa.getGraphicInfo("freeflowtpl_StartSignalEvent1"));
        bpmnModel.addGraphicInfo(endEvent.getId(), aa.getGraphicInfo("freeflowtpl_EndNoneEvent9"));
        GraphicInfo ap = aa.getLocation();
        ap.setRelative(false);
        bpmnModel.setLocation(ap);
        return bpmnModel;
    }

    private BpmnModel getBpmnJson(CommandContext commandContext, WFProcess wfProcess) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("freeflowmodelstr", SerializationUtils.toJsonString((Object)wfProcess));
        BpmnModel bpmnModel = this.getBasicBpmnModel(wfProcess);
        BpmnModel newBpmnModel = bpmnModel.clone();
        BpmnModel dynBpmnModel = new BpmnModel();
        Process dynProcess1 = new Process();
        dynBpmnModel.addProcess(dynProcess1);
        HashMap<String, BpmnModel> mulBpmnModel = new HashMap<String, BpmnModel>(WfMultiLangUtils.getSupportLangs().length);
        for (Lang lang : WfMultiLangUtils.getSupportLangs()) {
            mulBpmnModel.put(lang.name(), new BpmnModel());
        }
        FreeFlowProcessor dynProcessHandler = new FreeFlowProcessor();
        ExecutionEntityImpl execution = new ExecutionEntityImpl();
        execution.setEntityNumber(wfProcess.getEntraBill());
        dynProcessHandler.createDynProcess(execution, bpmnModel.getMainProcess().getInitialFlowElement().getId(), newBpmnModel, dynBpmnModel, dynProcess1, mulBpmnModel, params);
        DynProcessProcessorUtil.addFlowGraphicInfo(newBpmnModel, (BpmnModel)mulBpmnModel.get(Lang.zh_CN.name()), dynProcess1);
        BpmnModel last = bpmnModel.clone();
        dynProcessHandler.mergeDynBpmnModel(last, (BpmnModel)mulBpmnModel.get(Lang.zh_CN.name()));
        ProcessDefinitionUtil.removeBPMNModel(Long.parseLong("886006942529487872"));
        newBpmnModel = null;
        dynBpmnModel = null;
        mulBpmnModel.clear();
        return last;
    }

    private ModelEntity getModelEntity(CommandContext commandContext, String entityNum) {
        ModelEntity model = null;
        Long userIdL = RequestContext.get().getCurrUserId();
        if (WfUtils.isNotEmpty(this.curModelId) && (model = (ModelEntity)commandContext.getModelEntityManager().findById(this.curModelId)) != null && !model.getEntraBill().equalsIgnoreCase(entityNum)) {
            model = null;
        }
        String businessId = String.format("%s%s", entityNum, "gpt");
        if (model == null) {
            List models = commandContext.getModelEntityManager().findByQueryFilters(new QFilter[]{new QFilter("entrabill", "=", (Object)entityNum), new QFilter("businessid", "=", (Object)businessId)});
            if (models != null && !models.isEmpty()) {
                model = (ModelEntity)models.get(0);
            }
            if (model == null) {
                Long modelId = new CreateEmptyModel(entityNum).execute(commandContext);
                model = (ModelEntity)commandContext.getModelEntityManager().findById(modelId);
            }
        } else {
            model.setBusinessId(businessId);
        }
        model.setModifierId(userIdL);
        return model;
    }

    private IModelConverter getConverter(String type) {
        if (WfUtils.isEmpty(type)) {
            return new DefaultModelConverter();
        }
        return this.convertors.get(type);
    }

    private static class NodeAssistInfo {
        private String nodeId;
        private int depth = 1;
        private String lastForkId;
        private String name;
        private int incomings = 0;

        public NodeAssistInfo(String nodeId, String name) {
            this.nodeId = nodeId;
            this.name = name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getIncomings() {
            return this.incomings;
        }

        public void incIncomings() {
            ++this.incomings;
        }

        public String getName() {
            return this.name;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public int getDepth() {
            return this.depth;
        }

        public void setDepth(int depth) {
            this.depth = depth;
        }

        public String getLastForkId() {
            return this.lastForkId;
        }

        public void setLastForkId(String lastForkId) {
            this.lastForkId = lastForkId;
        }
    }

    private static class TargetNodeInfo {
        private WFFlowNode target = null;
        private WFSequenceFlow sequenceFlow;

        public TargetNodeInfo(WFFlowNode target, WFSequenceFlow sequenceFlow) {
            this.target = target;
            this.sequenceFlow = sequenceFlow;
        }

        public WFFlowNode getTarget() {
            return this.target;
        }

        public WFSequenceFlow getSequenceFlow() {
            return this.sequenceFlow;
        }
    }

    private static class YunzhijiaTaskConvertor
    extends AuditTaskConvertor {
        private YunzhijiaTaskConvertor() {
        }

        @Override
        protected String getType() {
            return "YunzhijiaTask";
        }

        @Override
        protected WFAuditTask getNodeElement() {
            return new WFJointAuditTask();
        }

        @Override
        public WFFlowElement convert(CommandContext commandContext, ConverterContext context, Map<String, Object> source) {
            WFFlowElement element = super.convert(commandContext, context, source);
            WFJointAuditTask jointAuditTask = (WFJointAuditTask)element;
            jointAuditTask.setBusinessModel("oneVoteVeto");
            return jointAuditTask;
        }
    }

    private static class AuditTaskConvertor
    extends DefaultModelConverter {
        private AuditTaskConvertor() {
        }

        @Override
        public boolean validate(JSONObject original) {
            return this.getType().equalsIgnoreCase((String)original.get((Object)"type"));
        }

        protected String getType() {
            return "AuditTask";
        }

        protected WFAuditTask getNodeElement() {
            return new WFAuditTask();
        }

        @Override
        public WFFlowElement convert(CommandContext commandContext, ConverterContext context, Map<String, Object> source) {
            WFAuditTask ret = this.getNodeElement();
            this.setCommonProp(context, source, (WFUserTask)ret, this.getType());
            ArrayList<WFDecisionOption> decisionOptions = new ArrayList<WFDecisionOption>();
            decisionOptions.add(this.packageDecisionOption("approve", context));
            decisionOptions.add(this.packageDecisionOption("reject", context));
            ret.setDecisionOptions(decisionOptions);
            if (context.isLastAudit() && this.existOperation(context.getEntityNumber(), "audit")) {
                ArrayList<WFListener> executionListeners = new ArrayList<WFListener>(2);
                executionListeners.add(this.packOperationWfListener("complete", "Consent", "audit", ResManager.loadKDString((String)"\u5ba1\u6838", (String)"WorkflowModelWizardPlugin_11", (String)"bos-wf-engine", (Object[])new Object[0]), "unaudit", ResManager.loadKDString((String)"\u53cd\u5ba1\u6838", (String)"WorkflowModelWizardPlugin_10", (String)"bos-wf-engine", (Object[])new Object[0])));
                ret.setTaskListeners(executionListeners);
            }
            ArrayList<Object> array = null;
            if (source.get("participant") instanceof JSONArray) {
                array = (ArrayList<Object>)source.get("participant");
            } else if (source.get("participant") instanceof String) {
                String participants = (String)source.get("participant");
                String[] participantArray = participants.split("\\),");
                ArrayList<String> arrayList = new ArrayList<String>(participantArray.length);
                for (int i = 0; i < participantArray.length; ++i) {
                    if (i == participantArray.length - 1) {
                        arrayList.add(participantArray[i].trim());
                        continue;
                    }
                    arrayList.add(participantArray[i].trim() + ")");
                }
                array = new ArrayList(arrayList.size());
                for (String participant : arrayList) {
                    this.extractCommasAddArray(participant, array);
                }
            } else {
                array = new ArrayList<Object>(1);
                array.add(source.get("participant"));
            }
            if (array != null && !array.isEmpty()) {
                WFParticipantModel participantModel = new WFParticipantModel();
                for (Object e : array) {
                    String param;
                    Set pSet;
                    List pList;
                    Map<String, String> fun;
                    String funType;
                    if (e == null || e instanceof String && WfUtils.isEmpty((String)e) || WfUtils.isEmpty(funType = (fun = this.parseKey(String.valueOf(e))).get("fun"))) continue;
                    WFParticipantEntity impl = null;
                    if ("self".equalsIgnoreCase(funType) || "superior".equalsIgnoreCase(funType) || "indirectSuperior".equalsIgnoreCase(funType)) {
                        impl = this.packageRelationParticipant(commandContext, context, funType, fun.get("param"));
                    } else if ("person".equalsIgnoreCase(funType)) {
                        impl = this.packagePersonParticipant(commandContext, context, funType, fun.get("param"), ret.getNumber());
                    } else if ("role".equalsIgnoreCase(funType) && !(pList = (pSet = Arrays.stream((param = fun.get("param") == null ? "" : fun.get("param")).split(",")).map(String::trim).collect(Collectors.toSet())).stream().map(p -> this.packageRoleParticipant(commandContext, context, funType, (String)p)).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
                        participantModel.getParticipant().addAll(pList);
                    }
                    if (impl == null) continue;
                    participantModel.getParticipant().add(impl);
                }
                ret.setParticipant(participantModel);
            }
            return ret;
        }

        private void extractCommasAddArray(String input, List<Object> array) {
            Pattern commaPattern;
            Matcher commaMatcher;
            Pattern prefixPattern = Pattern.compile("(\\w+)\\(");
            Matcher prefixMatcher = prefixPattern.matcher(input);
            String prefixValue = "";
            if (prefixMatcher.find()) {
                prefixValue = prefixMatcher.group(1);
            }
            if ((commaMatcher = (commaPattern = Pattern.compile("\\(([^()]+)\\)")).matcher(input)).find()) {
                String[] withinBracketGroupSons;
                String withinBracketGroup = commaMatcher.group(1);
                for (String withinBracketGroupSon : withinBracketGroupSons = withinBracketGroup.split(",")) {
                    array.add(prefixValue + "(" + withinBracketGroupSon + ")");
                }
            }
        }

        private WFParticipantEntity packageRelationParticipant(CommandContext commandContext, ConverterContext context, String funType, String param) {
            String creatorPropDesc;
            BillEntityType type = (BillEntityType)EntityMetadataCache.getDataEntityType((String)context.getEntityNumber());
            String orgProp = type.getMainOrgProperty() == null ? null : type.getMainOrgProperty().getName();
            String creatorProp = type.getCreatedByProperty() == null ? "creator" : type.getCreatedByProperty().getName();
            String string = creatorPropDesc = type.getCreatedByProperty() == null ? ResManager.loadKDString((String)"\u521b\u5efa\u4eba", (String)"WorkflowManageCenterPlugin_81", (String)"bos-wf-engine", (Object[])new Object[0]) : type.getCreatedByProperty().getDisplayName().getLocaleValue();
            if (orgProp != null) {
                WFParticipantEntity impl = new WFParticipantEntity();
                impl.setReferencePerson(String.format("ENTI_%s", creatorProp));
                impl.setType("relation");
                impl.setRelationType("person");
                impl.setPersonRelation(funType);
                impl.setReportType("admin_org");
                impl.setReferenceOrg(String.format("ENTI_%s", orgProp));
                String funDesc = null;
                if ("self".equalsIgnoreCase(funType)) {
                    funDesc = ResManager.loadKDString((String)"\u672c\u4eba", (String)"WfCustomReportRelationBaseInfoPlugin_1", (String)"bos-wf-engine", (Object[])new Object[0]);
                } else if ("superior".equalsIgnoreCase(funType)) {
                    funDesc = ResManager.loadKDString((String)"\u76f4\u63a5\u4e0a\u7ea7", (String)"WfCustomReportRelationBaseInfoPlugin_3", (String)"bos-wf-engine", (Object[])new Object[0]);
                } else if ("indirectSuperior".equalsIgnoreCase(funType)) {
                    funDesc = ResManager.loadKDString((String)"\u95f4\u63a5\u4e0a\u7ea7", (String)"WfCustomReportRelationBaseInfoPlugin_2", (String)"bos-wf-engine", (Object[])new Object[0]);
                }
                String name = String.format("%s-%s", creatorPropDesc, funDesc);
                impl.setValueshowtext(name);
                impl.setValue(name);
                impl.setId(BpmnDiffUtil.getListElementId("participant"));
                return impl;
            }
            return null;
        }

        private WFParticipantEntity packageRoleParticipant(CommandContext commandContext, ConverterContext context, String funType, String param) {
            String orgProp;
            BillEntityType type = (BillEntityType)EntityMetadataCache.getDataEntityType((String)context.getEntityNumber());
            String string = orgProp = type.getMainOrgProperty() == null ? null : type.getMainOrgProperty().getName();
            if (orgProp == null || param == null) {
                return null;
            }
            List<RoleEntity> roles = commandContext.getRoleEntityManager().findRoleByName(param.trim());
            RoleEntity role = null;
            if (roles == null || roles.isEmpty()) {
                if (context.getBooleanConfig(GenerateAuditProcessByJSON.CREATEDEFAULTROLE)) {
                    role = this.createDefaultRole(commandContext, param);
                }
            } else {
                role = roles.get(0);
            }
            if (role == null) {
                return null;
            }
            WFParticipantEntity impl = new WFParticipantEntity();
            impl.setId(BpmnDiffUtil.getListElementId("participant"));
            impl.setType("role");
            impl.setRoleId(String.valueOf(role.getId()));
            impl.setValue(param);
            HashMap<String, String> bo = new HashMap<String, String>(4);
            bo.put("entityNumber", "bos_org");
            bo.put("parseInfo", String.format("ENTI_%s", orgProp));
            bo.put("selectType", "2");
            bo.put("showName", type.getMainOrgProperty().getDisplayName().getLocaleValue());
            impl.setBusinessOrgField(SerializationUtils.toJsonString(bo));
            return impl;
        }

        private RoleEntity createDefaultRole(CommandContext commandContext, String param) {
            RoleEntity role = (RoleEntity)commandContext.getRoleEntityManager().create();
            role.setName(param);
            role.setOrgUnit(RequestContext.get().getOrgId());
            role.setNumber(String.format("Role-%s", String.valueOf(System.currentTimeMillis())));
            role.setManager(RequestContext.get().getCurrUserId());
            role.setId(ORM.create().genLongId("wf_role"));
            role.setRoleType("user");
            DynamicObjectCollection col = role.getRoleEntry();
            DynamicObject dyn = role.getRoleEntry().addNew();
            dyn.set("org", (Object)OrgUnitServiceHelper.getRootOrgId());
            dyn.set("functiontype", (Object)"01");
            dyn.set("user", (Object)RequestContext.get().getCurrUserId());
            role.setRoleEntry(col);
            commandContext.getRoleEntityManager().insert(role);
            return role;
        }

        private WFParticipantEntity packagePersonParticipant(CommandContext commandContext, ConverterContext context, String funType, String param, String number) {
            if (WfUtils.isNotEmpty(param)) {
                Set<Object> nodeUserIdSet;
                WFParticipantEntity impl = new WFParticipantEntity();
                impl.setType("person");
                String[] arrs = param.split(",");
                List m = Arrays.stream(arrs).map(String::trim).collect(Collectors.toList());
                DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("name", "in", m)});
                StringBuilder sb = new StringBuilder();
                Map<String, Set<String>> nodeUserIdMap = context.getNodeUserIds();
                Set<Object> set = nodeUserIdSet = nodeUserIdMap.get(number) == null ? new HashSet() : nodeUserIdMap.get(number);
                if (dyns != null && dyns.length > 0) {
                    int size = dyns.length;
                    int i = 0;
                    for (DynamicObject dyn : dyns) {
                        String userId = dyn.getString("id");
                        if (nodeUserIdSet.add(userId)) {
                            if (i == size - 1) {
                                sb.append(userId);
                            } else {
                                sb.append(userId).append(",");
                            }
                        }
                        ++i;
                    }
                } else {
                    String currUserId = String.valueOf(RequestContext.get().getCurrUserId());
                    if (nodeUserIdSet.add(currUserId) && context.getBooleanConfig(GenerateAuditProcessByJSON.CREATEDEFAULTPERSON)) {
                        sb.append(RequestContext.get().getCurrUserId());
                        param = RequestContext.get().getUserName();
                    } else {
                        return null;
                    }
                }
                if (WfUtils.isEmpty(sb.toString())) {
                    return null;
                }
                nodeUserIdMap.put(number, nodeUserIdSet);
                impl.setValue(sb.toString());
                impl.setValueshowtext(param);
                impl.setId(BpmnDiffUtil.getListElementId("participant"));
                return impl;
            }
            return null;
        }

        private Map<String, String> parseKey(String key) {
            Pattern pattern = Pattern.compile("(\\w+)(?:\\(([^\\)]+)\\)){1,10}");
            Matcher matcher = pattern.matcher(key);
            String type = null;
            String param = null;
            if (matcher.find()) {
                type = matcher.group(1);
                param = matcher.group(2);
            }
            final String finalType = type;
            final String finalParam = param;
            return new HashMap<String, String>(){
                {
                    this.put("fun", finalType);
                    this.put("param", finalParam);
                }
            };
        }

        private WFDecisionOption packageDecisionOption(String decisionType, ConverterContext context) {
            WFDecisionOption option = new WFDecisionOption();
            option.setAuditType(decisionType);
            if ("approve".equalsIgnoreCase(decisionType)) {
                option.setDefaultDecision(true);
                option.setName((LocaleString)WfUtils.getPromptWordLocaleString("\u540c\u610f", "FreeFlowPlugin_17", "bos-wf-unittest"));
                option.setNumber("Consent");
            } else {
                option.setName((LocaleString)WfUtils.getPromptWordLocaleString("\u9a73\u56de", "FreeFlowPlugin_18", "bos-wf-unittest"));
                option.setNumber("Reject");
                if (context.getFirstUserTask() != null) {
                    ArrayList<WFRejectNodesModel> rejectOptions = new ArrayList<WFRejectNodesModel>(1);
                    WFRejectNodesModel rejectNodesModel = new WFRejectNodesModel();
                    rejectNodesModel.setItemId(context.getFirstUserTask().getId());
                    rejectNodesModel.setName(context.getFirstUserTask().getName().getLocaleValue());
                    rejectOptions.add(rejectNodesModel);
                    option.setRejectOptions(rejectOptions);
                }
            }
            option.setId(BpmnDiffUtil.getListElementId("decisionOptions"));
            return option;
        }
    }

    public static class UserTaskConvertor
    extends DefaultModelConverter {
        @Override
        public boolean validate(JSONObject original) {
            return "UserTask".equalsIgnoreCase((String)original.get((Object)"type"));
        }

        @Override
        public WFFlowElement convert(CommandContext commandContext, ConverterContext context, Map<String, Object> source) {
            boolean firstUserTask;
            WFUserTask wfUserTask = new WFUserTask();
            this.setCommonProp(context, source, wfUserTask, "UserTask");
            if (context.getFirstUserTask() == null) {
                context.setFirstUserTask(wfUserTask);
            }
            boolean bl = firstUserTask = context.getFirstUserTask() != null && context.getFirstUserTask().getId().equalsIgnoreCase(wfUserTask.getId());
            if (!firstUserTask) {
                return wfUserTask;
            }
            if (this.existOperation(context.getEntityNumber(), "submit")) {
                ArrayList<WFDecisionOption> decisionOptions = new ArrayList<WFDecisionOption>();
                WFDecisionOption decisionOption = new WFDecisionOption();
                decisionOption.setAuditType("approve");
                decisionOption.setDefaultDecision(true);
                Map entityOperate = EntityMetadataCache.getDataEntityOperate((String)context.getEntityNumber(), (String)"submit");
                if (entityOperate != null) {
                    decisionOption.setNumber((String)entityOperate.get("key"));
                    Map nm = (Map)entityOperate.get("name");
                    decisionOption.setName(LocaleString.fromMap((Map)nm));
                }
                decisionOption.setId(BpmnDiffUtil.getListElementId("decisionOptions"));
                decisionOptions.add(decisionOption);
                wfUserTask.setDecisionOptions(decisionOptions);
            }
            if (this.existOperation(context.getEntityNumber(), "unsubmit")) {
                ArrayList<WFListener> executionListeners = new ArrayList<WFListener>(2);
                executionListeners.add(this.packOperationWfListener("start", "reject", "unsubmit", ResManager.loadKDString((String)"\u64a4\u9500", (String)"WorkflowModelWizardPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), "submit", ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"WorkflowModelWizardPlugin_35", (String)"bos-wf-formplugin", (Object[])new Object[0])));
                executionListeners.add(this.packOperationWfListener(GenerateAuditProcessByJSON.END, GenerateAuditProcessByJSON.END, "", "", "unsubmit", ResManager.loadKDString((String)"\u64a4\u9500", (String)"WorkflowModelWizardPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0])));
                wfUserTask.setExecutionListeners(executionListeners);
            }
            return wfUserTask;
        }
    }

    private static class DefaultModelConverter
    implements IModelConverter {
        protected static final String ENTITYID = "entityId";
        protected static final String OPERATION_SUBMIT = "submit";
        protected static final String OPERATION_AUDIT = "audit";
        protected static final String OPERATION_UNAUDIT = "unaudit";
        protected static final String OPERATION_UNSUBMIT = "unsubmit";

        private DefaultModelConverter() {
        }

        @Override
        public boolean validate(JSONObject original) {
            return false;
        }

        @Override
        public WFFlowElement convert(CommandContext commandContext, ConverterContext context, Map<String, Object> source) {
            return null;
        }

        protected WFListener packOperationWfListener(String event, String operation, String forwad, String forwadName, String withdraw, String withdrawName) {
            WFListener withdrawOp = new WFListener();
            withdrawOp.setEvent(event);
            if (WfUtils.isNotEmpty(operation)) {
                withdrawOp.setOperation(operation);
            }
            withdrawOp.setImplementationType("operation");
            String withdrawAuditedProcOp = ExternalInterfaceUtil.buildExtItfOperationValue(forwad, forwadName, withdraw, withdrawName);
            withdrawOp.setImplementation(withdrawAuditedProcOp);
            withdrawOp.setId(BpmnDiffUtil.getListElementId("executionListeners"));
            return withdrawOp;
        }

        protected boolean existOperation(String entityNumber, String operation) {
            Map entityOperate = EntityMetadataCache.getDataEntityOperate((String)entityNumber, (String)operation);
            return entityOperate != null;
        }

        protected String getNumber(ConverterContext context, String type) {
            return String.format("%s%s", type, context.incAndGetIndex());
        }

        protected String getId(ConverterContext context, String number) {
            return String.format("%s_%s", context.getProcessNumber(), number);
        }

        protected void setCommonProp(ConverterContext context, Map<String, Object> source, WFUserTask ret, String type) {
            String number = this.getNumber(context, type);
            ret.setNumber(number);
            String id = this.getId(context, number);
            ret.setId(id);
            ret.setType(type);
            ret.setName(new LocaleString((String)source.get(GenerateAuditProcessByJSON.NODENAME)));
            ret.setAllowTransfer(true);
        }
    }

    private static class ProcessConvertor
    extends DefaultModelConverter {
        private static final String OPERATION_UNSUBMIT = "unsubmit";
        private static final String OPERATION_DELETE = "delete";
        protected Log logger = LogFactory.getLog(this.getClass());
        private ModelEntity model;

        private ProcessConvertor() {
        }

        @Override
        public boolean validate(JSONObject original) {
            String entityNumber = original.getString("entityNumber");
            if (WfUtils.isEmpty(entityNumber)) {
                throw new KDBizException(new ErrorCode("illegalEntityNumber", ResManager.loadKDString((String)"\u751f\u6210\u7684JSON\u6709\u8bef\uff0c\u5bf9\u5e94\u7684\u5b9e\u4f53\u7f16\u7801\u4e3a\u7a7a\uff0c\u6682\u65f6\u4e0d\u652f\u6301\u6b64\u79cd\u573a\u666f\u3002", (String)"GenerateAuditProcessByJSON_10", (String)"bos-wf-engine", (Object[])new Object[0])), new Object[0]);
            }
            MainEntityType mainEntityType = null;
            try {
                mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            }
            catch (Exception e) {
                this.logger.info(WfUtils.getExceptionStacktrace(e));
            }
            if (mainEntityType == null) {
                this.logger.warn(String.format("entityNumber[%s] is not exist.", entityNumber));
                throw new KDBizException(new ErrorCode("illegalEntityNumber", ResManager.loadKDString((String)"\u751f\u6210\u7684JSON\u6709\u8bef\uff0c\u5bf9\u5e94\u7684\u5b9e\u4f53\u7f16\u7801\u4e3a\u7a7a\uff0c\u6682\u65f6\u4e0d\u652f\u6301\u6b64\u79cd\u573a\u666f\u3002", (String)"GenerateAuditProcessByJSON_10", (String)"bos-wf-engine", (Object[])new Object[0])), new Object[]{entityNumber});
            }
            return true;
        }

        @Override
        public WFFlowElement convert(CommandContext commandContext, ConverterContext context, Map<String, Object> original) {
            WFProcess wfProcess = new WFProcess();
            String entityNumber = (String)original.get("entityNumber");
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            wfProcess.setEntraBill(entityNumber);
            wfProcess.setEntraBillId(this.model.getEntraBillId());
            wfProcess.setEntraBillName(entityType.getDisplayName());
            wfProcess.setNumber(this.model.getKey());
            wfProcess.setId(this.model.getKey());
            wfProcess.setType("Process");
            wfProcess.setProcessType(ModelType.AuditFlow.name());
            wfProcess.setName(LocaleString.fromMap((Map)this.model.getName()));
            HashMap<String, String> extProps = new HashMap<String, String>();
            extProps.put("businessId", this.model.getBusinessId());
            extProps.put("process_id", wfProcess.getNumber());
            wfProcess.setExtProps(extProps);
            if (this.existOperation(entityNumber, OPERATION_UNSUBMIT)) {
                ArrayList<WFListener> executionListeners = new ArrayList<WFListener>(1);
                WFListener withdrawOp = this.packOperationWfListener("withdraw_audited_proc", "", OPERATION_UNSUBMIT, ResManager.loadKDString((String)"\u64a4\u9500", (String)"WorkflowModelWizardPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), "", "");
                executionListeners.add(withdrawOp);
                wfProcess.setExecutionListeners(executionListeners);
            }
            if (this.existOperation(entityNumber, OPERATION_DELETE)) {
                ArrayList<WFBillExceptionOp> billExceptionOps = new ArrayList<WFBillExceptionOp>();
                WFBillExceptionOp billExceptionOp = new WFBillExceptionOp();
                billExceptionOp.setOper(OPERATION_DELETE);
                billExceptionOp.setProcaction("terminate");
                billExceptionOp.setNumber(OPERATION_DELETE);
                Map entityOperate = EntityMetadataCache.getDataEntityOperate((String)entityNumber, (String)OPERATION_DELETE);
                if (entityOperate != null) {
                    Map nm = (Map)entityOperate.get("name");
                    billExceptionOp.setOpername((String)nm.get(RequestContext.get().getLang().name()));
                }
                billExceptionOps.add(billExceptionOp);
                wfProcess.setBillExceptionOp(billExceptionOps);
            }
            return wfProcess;
        }

        @Override
        public void setModel(ModelEntity model) {
            this.model = model;
        }
    }

    private static interface IModelConverter {
        public boolean validate(JSONObject var1);

        public WFFlowElement convert(CommandContext var1, ConverterContext var2, Map<String, Object> var3);

        default public void setModel(ModelEntity model) {
        }
    }

    private static class ConverterContext {
        private String processNumber;
        private String entityNumber;
        private String entityName;
        private int index;
        private Map<String, List<Map<String, Object>>> seqFlows = new HashMap<String, List<Map<String, Object>>>(4);
        private String entityId;
        private boolean lastAudit = false;
        private WFUserTask firstUserTask;
        private Map<String, WFFlowElement> flowElementMapByName = new HashMap<String, WFFlowElement>();
        private Map<String, WFFlowElement> flowElementMapById = new HashMap<String, WFFlowElement>();
        private Map<String, String> configs = new HashMap<String, String>();
        private Map<String, Set<String>> nodeUserIds = new HashMap<String, Set<String>>();

        public ConverterContext(String processNumber, String entityId, String entityNumber, String entityName, int index) {
            this.processNumber = processNumber;
            this.entityId = entityId;
            this.entityNumber = entityNumber;
            this.entityName = entityName;
            this.index = index;
        }

        public Map<String, Set<String>> getNodeUserIds() {
            return this.nodeUserIds;
        }

        public void setNodeUserIds(Map<String, Set<String>> nodeUserIds) {
            this.nodeUserIds = nodeUserIds;
        }

        public String getProcessNumber() {
            return this.processNumber;
        }

        public void setProcessNumber(String processNumber) {
            this.processNumber = processNumber;
        }

        public int incAndGetIndex() {
            ++this.index;
            return this.index;
        }

        public String getEntityNumber() {
            return this.entityNumber;
        }

        public void setEntityNumber(String entityNumber) {
            this.entityNumber = entityNumber;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        public void addNodeOutgoings(String nodeId, List<Map<String, Object>> goings) {
            this.seqFlows.put(nodeId, goings);
        }

        public List<Map<String, Object>> getOutgings(String nodeId) {
            return this.seqFlows.get(nodeId);
        }

        public String getEntityId() {
            return this.entityId;
        }

        public boolean isLastAudit() {
            return this.lastAudit;
        }

        public void setLastAudit(boolean lastAudit) {
            this.lastAudit = lastAudit;
        }

        public void addFlowElement(WFFlowElement flowElement) {
            this.flowElementMapById.put(flowElement.getId(), flowElement);
            if (flowElement instanceof WFFlowNode) {
                this.flowElementMapByName.put(((WFFlowNode)flowElement).getName().getLocaleValue(), flowElement);
            }
        }

        public WFFlowElement getFlowElementById(String nodeId) {
            return this.flowElementMapById.get(nodeId);
        }

        public WFFlowElement getFlowElementByName(String nodeName) {
            return this.flowElementMapByName.get(nodeName);
        }

        public Map<String, WFFlowElement> getFlowElementMap() {
            return this.flowElementMapById;
        }

        public Map<String, List<Map<String, Object>>> getSeqFlows() {
            return this.seqFlows;
        }

        public WFUserTask getFirstUserTask() {
            return this.firstUserTask;
        }

        public void setFirstUserTask(WFUserTask firstUserTask) {
            this.firstUserTask = firstUserTask;
        }

        public boolean getBooleanConfig(String param) {
            String obj = this.configs.get(param);
            return "true".equals(obj);
        }

        public void setConfigs(Map<String, String> configs) {
            this.configs = configs;
        }
    }
}

