/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.monitor;

import java.io.Serializable;
import kd.bos.context.RequestContext;
import kd.bos.workflow.api.SuspendInfo;
import kd.bos.workflow.engine.WfSuspendUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExtItfCallerType;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class RecoverProcessInstanceCmd
implements Command<String>,
Serializable {
    private static final long serialVersionUID = -8205191735752830825L;
    private Long deadLetterJobId;
    private Long processInstanceId;

    public RecoverProcessInstanceCmd(Long deadLetterJobId, Long processInstanceId) {
        this.deadLetterJobId = deadLetterJobId;
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String execute(CommandContext commandContext) {
        if (this.deadLetterJobId == null && this.processInstanceId == null) {
            throw new WFIllegalArgumentException("deadLetterJobId And processInstanceId is null");
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        if (WfUtils.isNotEmpty(this.processInstanceId)) {
            processEngineConfiguration.getManagementService().activateProcessInstanceByProcessInstanceId(this.processInstanceId);
        } else if (WfUtils.isNotEmpty(this.deadLetterJobId)) {
            processEngineConfiguration.getManagementService().activateProcessInstanceByDeadLetterJob(this.deadLetterJobId);
        }
        this.afterActiveProcess(commandContext);
        return null;
    }

    private void afterActiveProcess(CommandContext commandContext) {
        String className = WfSuspendUtil.getSuspendConfigInfo(ExtItfCallerType.AFTERACTIVEPROCESS);
        if (WfUtils.isNotEmpty(className)) {
            SuspendInfo suspendInfo = this.bulidSuspendInfo(commandContext);
            WfSuspendUtil.invokeExtItfMethod(suspendInfo, ExtItfCallerType.AFTERACTIVEPROCESS, className);
        }
    }

    private SuspendInfo bulidSuspendInfo(CommandContext commandContext) {
        SuspendInfo suspendInfo = new SuspendInfo();
        if (WfUtils.isNotEmpty(this.processInstanceId)) {
            HistoricProcessInstanceEntity hiEntity = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(this.processInstanceId);
            suspendInfo.setProcessInstanceId(this.processInstanceId);
            suspendInfo.setProcessDefinitionId(hiEntity.getProcessDefinitionId());
            suspendInfo.setBusinessKey(hiEntity.getBusinessKey());
            suspendInfo.setEntityNumber(hiEntity.getEntitynumber());
        } else if (WfUtils.isNotEmpty(this.deadLetterJobId)) {
            DeadLetterJobEntity deadLetterJob = (DeadLetterJobEntity)commandContext.getDeadLetterJobEntityManager().findById(this.deadLetterJobId);
            suspendInfo.setProcessInstanceId(deadLetterJob.getProcessInstanceId());
            suspendInfo.setProcessDefinitionId(deadLetterJob.getProcessDefinitionId());
            suspendInfo.setBusinessKey(deadLetterJob.getBusinessKey());
            suspendInfo.setEntityNumber(deadLetterJob.getEntityNumber());
            suspendInfo.setElementId(deadLetterJob.getElementId());
            suspendInfo.setErrMsg(deadLetterJob.getExceptionMessage());
        }
        suspendInfo.setUserId(Long.valueOf(RequestContext.get().getCurrUserId()));
        return suspendInfo;
    }
}

