/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.monitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.dynprocess.AddSignInfo;
import kd.bos.workflow.engine.history.HistoricProcessInstance;
import kd.bos.workflow.engine.impl.cmd.GetBpmnModelCmd;
import kd.bos.workflow.engine.impl.cmd.management.GetJumpNodesCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CoordinateRecordUtil;
import kd.bos.workflow.engine.impl.util.RuntimeUtil;
import kd.bos.workflow.engine.task.TaskDelegateUtil;
import kd.bos.workflow.exception.EngineAPIExceptionEnum;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class ValidateApiCmd
implements Command<String>,
Serializable {
    private static final long serialVersionUID = -6869674312929218681L;
    private Long id;
    private String type;
    private String srcId;
    private String destId;
    private AddSignInfo addSignInfo;

    public ValidateApiCmd(Long id, String type) {
        this.id = id;
        this.type = type;
    }

    public ValidateApiCmd(Long id, String type, String srcId, String destId) {
        this.id = id;
        this.type = type;
        this.srcId = srcId;
        this.destId = destId;
    }

    public ValidateApiCmd(Long id, String type, AddSignInfo addSignInfo) {
        this.id = id;
        this.type = type;
        this.addSignInfo = addSignInfo;
    }

    @Override
    public String execute(CommandContext commandContext) {
        if (this.id == null || this.type == null) {
            return EngineAPIExceptionEnum.CHECKERRORCODE.getCode();
        }
        switch (this.type) {
            case "suspend": {
                return this.checkSuspended(commandContext);
            }
            case "revoke": {
                return this.checkRevokeSuspended(commandContext);
            }
            case "abort": {
                return this.checkAbort(commandContext);
            }
            case "jump": {
                return this.checkJump(commandContext);
            }
            case "preComputor": {
                return this.checkPreComputor(commandContext);
            }
            case "addsign": {
                return this.checkAddsign(commandContext);
            }
            case "addsignView": {
                return this.checkAddsignView(commandContext);
            }
            case "jumpView": {
                return this.checkJumpView(commandContext);
            }
        }
        return EngineAPIExceptionEnum.CHECKERRORCODE.getCode();
    }

    private int checkEndOrRun(CommandContext commandContext, Long processInstanceId) {
        HistoricProcessInstance hp = (HistoricProcessInstance)commandContext.getHistoricProcessInstanceEntityManager().findById(processInstanceId);
        List<ExecutionEntity> executionList = commandContext.getExecutionEntityManager().findChildExecutionsByProcessInstanceId(processInstanceId);
        if (hp == null || executionList == null) {
            return 1;
        }
        for (ExecutionEntity executionEntity : executionList) {
            if (!executionEntity.getId().equals(executionEntity.getProcessInstanceId()) || !ModelType.BizFlow.name().equalsIgnoreCase(executionEntity.getProcessType())) continue;
            return 2;
        }
        if (hp.getEndTime() != null) {
            return 3;
        }
        if (RuntimeUtil.isRunning(commandContext, processInstanceId) || RuntimeUtil.isRetring(commandContext, processInstanceId)) {
            return 4;
        }
        return 0;
    }

    private String checkSuspended(CommandContext commandContext) {
        Long processInstanceId = this.id;
        int check = this.checkEndOrRun(commandContext, processInstanceId);
        switch (check) {
            case 1: {
                return EngineAPIExceptionEnum.NOTEXIETRRORCODE.getCode();
            }
            case 2: {
                return EngineAPIExceptionEnum.BUSINESSERRORCODE.getCode();
            }
            case 3: {
                return EngineAPIExceptionEnum.FINISHERRORCODE.getCode();
            }
            case 4: {
                return EngineAPIExceptionEnum.RUNERRORCODE.getCode();
            }
        }
        if (ManagementConstants.SUSPENDED.getStateCode().equals(((ExecutionEntity)commandContext.getExecutionEntityManager().findById(processInstanceId)).getSuspensionState())) {
            return EngineAPIExceptionEnum.ALREADYERRORCODE.getCode();
        }
        return null;
    }

    private String checkRevokeSuspended(CommandContext commandContext) {
        Long processInstanceId = this.id;
        int check = this.checkEndOrRun(commandContext, processInstanceId);
        switch (check) {
            case 1: {
                return EngineAPIExceptionEnum.NOTEXIETRRORCODE.getCode();
            }
            case 2: {
                return EngineAPIExceptionEnum.REVOKEBUSINESSERRORCODE.getCode();
            }
            case 3: {
                return EngineAPIExceptionEnum.REVOKEFINISHERRORCODE.getCode();
            }
            case 4: {
                return EngineAPIExceptionEnum.REVOKERUNERRORCODE.getCode();
            }
        }
        if (!ManagementConstants.SUSPENDED.getStateCode().equals(((ExecutionEntity)commandContext.getExecutionEntityManager().findById(processInstanceId)).getSuspensionState())) {
            return EngineAPIExceptionEnum.REVOKEALREADYERRORCODE.getCode();
        }
        return null;
    }

    private String checkAbort(CommandContext commandContext) {
        Long processInstanceId = this.id;
        int check = this.checkEndOrRun(commandContext, processInstanceId);
        switch (check) {
            case 1: {
                return EngineAPIExceptionEnum.NOTEXIETRRORCODE.getCode();
            }
            case 2: {
                return EngineAPIExceptionEnum.ABORTEBUSINESSERRORCODE.getCode();
            }
            case 3: {
                return EngineAPIExceptionEnum.ABORTFINISHERRORCODE.getCode();
            }
            case 4: {
                return EngineAPIExceptionEnum.ABORTRUNERRORCODE.getCode();
            }
        }
        return null;
    }

    private String checkJumpView(CommandContext commandContext) {
        Long processInstanceId = this.id;
        int check = this.checkEndOrRun(commandContext, processInstanceId);
        switch (check) {
            case 1: {
                return EngineAPIExceptionEnum.NOTEXIETRRORCODE.getCode();
            }
            case 2: {
                return EngineAPIExceptionEnum.SKIPBUSINESSERRORCODE.getCode();
            }
            case 3: {
                return EngineAPIExceptionEnum.SKIPFINISHERRORCODE.getCode();
            }
            case 4: {
                return EngineAPIExceptionEnum.SKIPRUNERRORCODE.getCode();
            }
        }
        return null;
    }

    private String checkJump(CommandContext commandContext) {
        Long processInstanceId = this.id;
        if (this.destId == null || this.srcId == null) {
            return EngineAPIExceptionEnum.CHECKERRORCODE.getCode();
        }
        int check = this.checkEndOrRun(commandContext, processInstanceId);
        switch (check) {
            case 1: {
                return EngineAPIExceptionEnum.NOTEXIETRRORCODE.getCode();
            }
            case 2: {
                return EngineAPIExceptionEnum.SKIPBUSINESSERRORCODE.getCode();
            }
            case 3: {
                return EngineAPIExceptionEnum.SKIPFINISHERRORCODE.getCode();
            }
            case 4: {
                return EngineAPIExceptionEnum.SKIPRUNERRORCODE.getCode();
            }
        }
        Object jumpNodes = new GetJumpNodesCmd(processInstanceId).execute(commandContext);
        if (jumpNodes == null || jumpNodes.isEmpty() || !this.srcId.equalsIgnoreCase((String)((Map)jumpNodes.get(0)).get("value"))) {
            return EngineAPIExceptionEnum.SRCNODEERRORCODE.getCode();
        }
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        ExecutionEntity execution = (ExecutionEntity)service.getRepositoryService().findEntityById(processInstanceId, "wf_execution");
        if (execution == null) {
            return EngineAPIExceptionEnum.DESTNODEERRORCODE.getCode();
        }
        BpmnModel bpmnModel = service.getRepositoryService().getBpmnModel(execution.getProcessDefinitionId(), execution.getSchemeId(), processInstanceId);
        if (bpmnModel == null) {
            return EngineAPIExceptionEnum.DESTNODEERRORCODE.getCode();
        }
        List<FlowElement> destJumpNodes = this.filterOptionalNodes(BpmnModelUtil.getJumpNodes(bpmnModel, this.srcId));
        if (destJumpNodes.isEmpty()) {
            return EngineAPIExceptionEnum.DESTNODEERRORCODE.getCode();
        }
        boolean isNotDestId = true;
        for (FlowElement flowElement : destJumpNodes) {
            if (!this.destId.equalsIgnoreCase(flowElement.getId())) continue;
            isNotDestId = false;
            break;
        }
        if (isNotDestId) {
            return EngineAPIExceptionEnum.DESTNODEERRORCODE.getCode();
        }
        if (ManagementConstants.SUSPENDED.getStateCode().equals(((ExecutionEntity)commandContext.getExecutionEntityManager().findById(processInstanceId)).getSuspensionState())) {
            return "suspended";
        }
        return null;
    }

    private List<FlowElement> filterOptionalNodes(List<FlowElement> nodesWithoutFilter) {
        ArrayList<FlowElement> filterNodes = new ArrayList<FlowElement>(nodesWithoutFilter.size());
        for (FlowElement node : nodesWithoutFilter) {
            if (node instanceof StartEvent) continue;
            filterNodes.add(node);
        }
        return filterNodes;
    }

    private String checkPreComputor(CommandContext commandContext) {
        Long processInstanceId = this.id;
        int check = this.checkEndOrRun(commandContext, processInstanceId);
        switch (check) {
            case 1: {
                return EngineAPIExceptionEnum.NOTEXIETRRORCODE.getCode();
            }
            case 2: {
                return EngineAPIExceptionEnum.PREBUSINESSERRORCODE.getCode();
            }
            case 3: {
                return EngineAPIExceptionEnum.PREFINISHERRORCODE.getCode();
            }
        }
        if (ManagementConstants.SUSPENDED.getStateCode().equals(((ExecutionEntity)commandContext.getExecutionEntityManager().findById(processInstanceId)).getSuspensionState())) {
            return EngineAPIExceptionEnum.PRESUSPANDERRORCODE.getCode();
        }
        return null;
    }

    private String checkAddsign(CommandContext commandContext) {
        FlowElement element;
        Long taskId = this.id;
        if (this.checkAddsignMsg()) {
            return EngineAPIExceptionEnum.CHECKERRORCODE.getCode();
        }
        if (this.checkAddsignUser()) {
            return EngineAPIExceptionEnum.ADDSIGNUSERERRORCODE.getCode();
        }
        if (this.checkAddsignMsgCombine()) {
            return EngineAPIExceptionEnum.ADDSIGNCOMERRORCODE.getCode();
        }
        if (!QueryServiceHelper.exists((String)"wf_hitaskinst", (Object)taskId)) {
            return EngineAPIExceptionEnum.ADDSIGNNOIDERRORCODE.getCode();
        }
        ArrayList<Long> idList = new ArrayList<Long>();
        idList.add(taskId);
        boolean coordinateRecored = CoordinateRecordUtil.getIsContainCoordinateRecored(idList);
        if (coordinateRecored) {
            return EngineAPIExceptionEnum.ADDSIGNCOORDINATEERRORCODE.getCode();
        }
        TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
        if (task == null || "2".equals(task.getSuspensionState())) {
            return EngineAPIExceptionEnum.ADDSIGNSUSPENDERRORCODE.getCode();
        }
        if (task.getProcessType() == null || ModelType.BizFlow.name().equalsIgnoreCase(task.getProcessType())) {
            return EngineAPIExceptionEnum.ADDSIGNBUSINESSERRORCODE.getCode();
        }
        if (TaskDelegateUtil.isDelegateTask(taskId, RequestContext.get().getCurrUserId())) {
            return EngineAPIExceptionEnum.ADDSIGNTOERRORCODE.getCode();
        }
        BpmnModel bpmnModel = new GetBpmnModelCmd(task.getProcessDefinitionId(), task.getProcessInstanceId()).execute(commandContext);
        FlowElement flowElement = element = bpmnModel == null ? null : bpmnModel.getFlowElement(task.getTaskDefinitionKey());
        if (!(element instanceof AuditTask)) {
            return EngineAPIExceptionEnum.ADDSIGNAUDITERRORCODE.getCode();
        }
        AuditTask auditTask = (AuditTask)element;
        if (!auditTask.isCountersigned()) {
            return EngineAPIExceptionEnum.ADDSIGNALLOWERRORCODE.getCode();
        }
        if ("addsignafter".equals(this.addSignInfo.getAddSignType())) {
            return this.checkAfter(element);
        }
        if ("addsignbefore".equals(this.addSignInfo.getAddSignType())) {
            return this.checkBefore(element, task);
        }
        return null;
    }

    private String checkAfter(FlowElement element) {
        if (element instanceof YunzhijiaTask) {
            return EngineAPIExceptionEnum.ADDSIGNALLERRORCODE.getCode();
        }
        return null;
    }

    private String checkBefore(FlowElement element, TaskEntity task) {
        FlowNode flowNode = (FlowNode)element;
        if (flowNode != null && flowNode.getJoin() != null && flowNode.getJoin().booleanValue() && "enterwhenallarrive".equals(flowNode.getInSet())) {
            return EngineAPIExceptionEnum.ADDSIGNCOMBINEERRORCODE.getCode();
        }
        return null;
    }

    private boolean checkAddsignMsg() {
        if (this.addSignInfo == null || this.addSignInfo.getAllowAddSign() == null || this.addSignInfo.getUserIds() == null) {
            return true;
        }
        String addSignType = this.addSignInfo.getAddSignType();
        return !"addsignbefore".equals(addSignType) && !"addsignafter".equals(addSignType);
    }

    private boolean checkAddsignUser() {
        List userIds = this.addSignInfo.getUserIds();
        for (Long userId : userIds) {
            if (!WfUtils.isEmpty(userId) && !userId.equals(RequestContext.get().getCurrUserId()) && QueryServiceHelper.exists((String)"bos_user", (Object)userId)) continue;
            return true;
        }
        return false;
    }

    private boolean checkAddsignMsgCombine() {
        String yzjType = this.addSignInfo.getYzjType();
        String addSignDealType = this.addSignInfo.getAddSignDealType();
        boolean one = "one".equals(addSignDealType) && this.addSignInfo.getUserIds().size() == 1 && WfUtils.isEmpty(yzjType);
        boolean anyoneOrseq = ("anyone".equals(addSignDealType) || "seq".equals(addSignDealType)) && this.addSignInfo.getUserIds().size() > 1 && WfUtils.isEmpty(yzjType);
        boolean yzj = "yzj".equals(addSignDealType) && this.addSignInfo.getUserIds().size() > 1 && ("passByOne".equals(yzjType) || "oneVoteVeto".equals(yzjType));
        return !one && !anyoneOrseq && !yzj;
    }

    private String checkAddsignView(CommandContext commandContext) {
        FlowElement element;
        Long taskId = this.id;
        if (!QueryServiceHelper.exists((String)"wf_hitaskinst", (Object)taskId)) {
            return EngineAPIExceptionEnum.ADDSIGNNOIDERRORCODE.getCode();
        }
        ArrayList<Long> idList = new ArrayList<Long>();
        idList.add(taskId);
        boolean coordinateRecored = CoordinateRecordUtil.getIsContainCoordinateRecored(idList);
        if (coordinateRecored) {
            return EngineAPIExceptionEnum.ADDSIGNCOORDINATEERRORCODE.getCode();
        }
        TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
        if (task == null || "2".equals(task.getSuspensionState())) {
            return EngineAPIExceptionEnum.ADDSIGNSUSPENDERRORCODE.getCode();
        }
        if (task.getProcessType() == null || ModelType.BizFlow.name().equalsIgnoreCase(task.getProcessType())) {
            return EngineAPIExceptionEnum.ADDSIGNBUSINESSERRORCODE.getCode();
        }
        if (TaskDelegateUtil.isDelegateTask(taskId, RequestContext.get().getCurrUserId())) {
            return EngineAPIExceptionEnum.ADDSIGNTOERRORCODE.getCode();
        }
        BpmnModel bpmnModel = new GetBpmnModelCmd(task.getProcessDefinitionId(), task.getProcessInstanceId()).execute(commandContext);
        FlowElement flowElement = element = bpmnModel == null ? null : bpmnModel.getFlowElement(task.getTaskDefinitionKey());
        if (!(element instanceof AuditTask)) {
            return EngineAPIExceptionEnum.ADDSIGNAUDITERRORCODE.getCode();
        }
        AuditTask auditTask = (AuditTask)element;
        if (!auditTask.isCountersigned()) {
            return EngineAPIExceptionEnum.ADDSIGNALLOWERRORCODE.getCode();
        }
        return null;
    }
}

