/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.monitor.worktransfer;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.Row;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.execution.AbstractBatchQueryCmd;

public class GetModelIdsByProcDefIdsCmd
extends AbstractBatchQueryCmd<Set<Long>> {
    private Set<Long> procDefIds;

    public GetModelIdsByProcDefIdsCmd(Set<Long> procDefIds) {
        this.procDefIds = procDefIds;
    }

    @Override
    protected void handleResult(Set<Long> ret, Row row) {
        Long modelId = row.getLong("fmodelid");
        if (!WfUtils.isEmpty(modelId)) {
            ret.add(modelId);
        }
    }

    @Override
    protected Object[] createParameter(List<String> subList) {
        Object[] params = new Object[subList.size()];
        int i = 0;
        for (String t : subList) {
            params[i] = Long.valueOf(t);
            ++i;
        }
        return params;
    }

    @Override
    protected String createSQL(List<String> subList) {
        StringBuilder sql = new StringBuilder();
        sql.append("select fmodelid from t_wf_procdef ");
        sql.append(" where fid in (");
        int length = subList.size();
        for (int i = 0; i < length; ++i) {
            sql.append(" ?");
            if (i == length - 1) continue;
            sql.append(',');
        }
        sql.append(')');
        return sql.toString();
    }

    @Override
    protected Collection<String> getTotal() {
        HashSet<String> defIds = new HashSet<String>();
        if (this.procDefIds != null && !this.procDefIds.isEmpty()) {
            for (Long procDefId : this.procDefIds) {
                defIds.add(String.valueOf(procDefId));
            }
        }
        return defIds;
    }

    @Override
    protected Set<Long> createRet() {
        return new HashSet<Long>();
    }
}

