/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.monitor.worktransfer;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.Row;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.execution.AbstractBatchQueryCmd;
import kd.bos.workflow.engine.impl.cmd.monitor.worktransfer.GetInProcessProcDefIdsCmd;
import kd.bos.workflow.engine.impl.context.Context;

public class GetParticipantModelIdsByUserIdCmd
extends AbstractBatchQueryCmd<StringBuilder> {
    private Long userId;

    public GetParticipantModelIdsByUserIdCmd(Long userId) {
        this.userId = userId;
    }

    @Override
    protected void handleResult(StringBuilder ret, Row row) {
        Long participantModelId = row.getLong("participantmodelid");
        if (!WfUtils.isEmpty(participantModelId)) {
            ret.append(participantModelId).append(",");
        }
    }

    @Override
    protected Object[] createParameter(List<String> subList) {
        Object[] params = new Object[subList.size()];
        int i = 0;
        for (String t : subList) {
            params[i] = Long.parseLong(t);
            ++i;
        }
        return params;
    }

    @Override
    protected String createSQL(List<String> subList) {
        StringBuilder sql = new StringBuilder();
        sql.append("select b.fid participantmodelid from t_wf_procdef a ");
        sql.append("left join t_wf_participantmodel b on a.fid = b.fprocdefid ");
        sql.append("where b.ftype='person' and b.fvalue like '%").append(this.userId).append("%'");
        sql.append("and a.fid in (");
        int length = subList.size();
        for (int i = 0; i < length; ++i) {
            sql.append(" ?");
            if (i == length - 1) continue;
            sql.append(',');
        }
        sql.append(')');
        return sql.toString();
    }

    @Override
    protected Collection<String> getTotal() {
        HashSet<String> procDefIds = new HashSet<String>();
        Set inProcessProcDefIds = (Set)new GetInProcessProcDefIdsCmd().execute(Context.getCommandContext());
        if (inProcessProcDefIds != null && !inProcessProcDefIds.isEmpty()) {
            for (Long inProcessProcDefId : inProcessProcDefIds) {
                procDefIds.add(String.valueOf(inProcessProcDefId));
            }
        }
        return procDefIds;
    }

    @Override
    protected StringBuilder createRet() {
        return new StringBuilder();
    }
}

