/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.monitor.worktransfer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.Row;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.execution.AbstractBatchQueryCmd;

public class GetParticipantModelParamsListForModelCmd
extends AbstractBatchQueryCmd<List<Object[]>> {
    private List<Object[]> procDefIdActIdProps;
    private String transferId;
    private String receiverIds;

    public GetParticipantModelParamsListForModelCmd(List<Object[]> procDefIdActIdProps, String transferId, String receiverIds) {
        this.procDefIdActIdProps = procDefIdActIdProps;
        this.transferId = transferId;
        this.receiverIds = receiverIds;
    }

    @Override
    protected void handleResult(List<Object[]> ret, Row row) {
        Long procDefId = row.getLong("procdefid");
        String taskActivityId = row.getString("ftaskactivityid");
        String property = row.getString("fproperty");
        for (Object[] procDefIdActIdProp : this.procDefIdActIdProps) {
            if (!this.isProcDefIdEquals(procDefId, procDefIdActIdProp) || !this.isActivityIdEquals(taskActivityId, procDefIdActIdProp) || !this.isPropertyEquals(property, procDefIdActIdProp)) continue;
            Long participantModelId = row.getLong("fid");
            String value = row.getString("fvalue");
            if (WfUtils.isEmpty(value) || !Arrays.asList(value.split(",")).contains(this.transferId)) continue;
            value = value.replace(this.transferId, this.receiverIds);
            ret.add(new Object[]{value, participantModelId});
        }
    }

    private boolean isProcDefIdEquals(Long procDefId, Object[] procDefIdActIdProp) {
        return !WfUtils.isEmpty(procDefId) && procDefId.equals(WfUtils.getLongValueFromObj(procDefIdActIdProp[0]));
    }

    private boolean isActivityIdEquals(String taskActivityId, Object[] procDefIdActIdProp) {
        return !WfUtils.isEmpty(taskActivityId) && taskActivityId.equals(procDefIdActIdProp[1]);
    }

    private boolean isPropertyEquals(String property, Object[] procDefIdActIdProp) {
        return !WfUtils.isEmpty(property) && property.equals(procDefIdActIdProp[2]);
    }

    @Override
    protected Object[] createParameter(List<String> subList) {
        Object[] params = new Object[subList.size()];
        int i = 0;
        for (String t : subList) {
            params[i] = Long.parseLong(t);
            ++i;
        }
        return params;
    }

    @Override
    protected String createSQL(List<String> subList) {
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fid,a.fvalue,b.fid procdefid,a.ftaskactivityid,a.fproperty from t_wf_participantmodel a ");
        sql.append("inner join t_wf_procdef b on a.fmodelid = b.fmodelid ");
        sql.append("where a.ftype = 'person' and b.fid in (");
        int length = subList.size();
        for (int i = 0; i < length; ++i) {
            sql.append(" ?");
            if (i == length - 1) continue;
            sql.append(',');
        }
        sql.append(')');
        return sql.toString();
    }

    @Override
    protected Collection<String> getTotal() {
        if (this.procDefIdActIdProps == null || this.procDefIdActIdProps.isEmpty()) {
            return new HashSet<String>();
        }
        HashSet<String> procDefIds = new HashSet<String>(this.procDefIdActIdProps.size());
        for (Object[] procDefIdActIdProp : this.procDefIdActIdProps) {
            Long procDefId = WfUtils.getLongValueFromObj(procDefIdActIdProp[0]);
            if (WfUtils.isEmpty(procDefId)) continue;
            procDefIds.add(String.valueOf(procDefId));
        }
        return procDefIds;
    }

    @Override
    protected List<Object[]> createRet() {
        return new ArrayList<Object[]>();
    }
}

