/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.monitor.worktransfer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.algo.Row;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.execution.AbstractBatchQueryCmd;

public class GetTaskIdsByParticipantIdCmd
extends AbstractBatchQueryCmd<StringBuilder> {
    private Long participantId;

    public GetTaskIdsByParticipantIdCmd(Long participantId) {
        this.participantId = participantId;
    }

    @Override
    protected void handleResult(StringBuilder ret, Row row) {
        Long taskId = row.getLong("fid");
        if (!WfUtils.isEmpty(taskId)) {
            ret.append(taskId).append(',');
        }
    }

    @Override
    protected Object[] createParameter(List<String> subList) {
        return new Object[]{this.participantId};
    }

    @Override
    protected String createSQL(List<String> subList) {
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fid from t_wf_task a ");
        sql.append("left join t_wf_participant b on a.fid = b.ftaskid ");
        sql.append(" where b.fuserid = ? ");
        return sql.toString();
    }

    @Override
    protected Collection<String> getTotal() {
        ArrayList<String> participantIds = new ArrayList<String>(1);
        if (!WfUtils.isEmpty(this.participantId)) {
            participantIds.add(String.valueOf(this.participantId));
        }
        return participantIds;
    }

    @Override
    protected StringBuilder createRet() {
        return new StringBuilder();
    }
}

