/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.monitor.worktransfer;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.management.scheme.GetConfigSchemeBpmnJsonStringCmd;
import kd.bos.workflow.engine.impl.cmd.monitor.worktransfer.GetInProcessProcDefIdsCmd;
import kd.bos.workflow.engine.impl.cmd.monitor.worktransfer.GetModelIdsByProcDefIdsCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class RenovateWorkTransferRelatedDataCmd
implements Command<String>,
Serializable {
    private static final long serialVersionUID = -4479864053067018320L;
    private static Log logger = LogFactory.getLog(RenovateWorkTransferRelatedDataCmd.class);
    private static final String VALUE = "value";

    @Override
    public String execute(CommandContext commandContext) {
        StringBuilder resultInfos = new StringBuilder();
        Set inProcessProcDefIds = (Set)new GetInProcessProcDefIdsCmd().execute(commandContext);
        if (inProcessProcDefIds == null || inProcessProcDefIds.isEmpty()) {
            return null;
        }
        this.disposeSchemeDynamicPartial(commandContext, inProcessProcDefIds, resultInfos);
        this.disposeModelDynamicPartial(commandContext, inProcessProcDefIds, resultInfos);
        RenovateWorkTransferRelatedDataCmd.saveWfConfCenter("true");
        return resultInfos.toString();
    }

    private void disposeSchemeDynamicPartial(CommandContext commandContext, Set<Long> inProcessProcDefIds, StringBuilder resultInfos) {
        QFilter[] qFilters = new QFilter[]{new QFilter("processDefinitionId", "in", inProcessProcDefIds)};
        List schemes = commandContext.getDynamicConfigSchemeEntityManager().findByQueryFilters(qFilters);
        for (DynamicConfigSchemeEntity scheme : schemes) {
            try {
                String modelJson = new GetConfigSchemeBpmnJsonStringCmd(scheme.getId(), scheme.getState()).execute(commandContext);
                BpmnModelUtil.disposeDynamicPartial(modelJson, scheme);
            }
            catch (Exception e) {
                resultInfos.append(String.format(ResManager.loadKDString((String)"schemeID\u4e3a\u201c%1$s\u201d\u7684\u52a8\u6001\u914d\u7f6e\u65b9\u6848\u4fee\u590d\u5931\u8d25\uff0c\u539f\u56e0\uff1a%2$s\u3002", (String)"RenovateWorkTransferRelatedDataCmd_0", (String)"bos-wf-engine", (Object[])new Object[0]), scheme.getId(), e.getMessage()));
                logger.info("\u4fee\u590d\u914d\u7f6e\u65b9\u6848\u51fa\u9519\uff0c\u539f\u56e0\uff1a" + WfUtils.getExceptionStacktrace(e));
            }
        }
    }

    private void disposeModelDynamicPartial(CommandContext commandContext, Set<Long> inProcessProcDefIds, StringBuilder resultInfos) {
        Set modelIds = (Set)new GetModelIdsByProcDefIdsCmd(inProcessProcDefIds).execute(commandContext);
        if (modelIds == null || modelIds.isEmpty()) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)modelIds)};
        List models = commandContext.getModelEntityManager().findByQueryFilters(filters);
        for (ModelEntity model : models) {
            try {
                ResourceEntity resource;
                Long modelId = model.getId();
                Long resourceId = model.getBPMNXMLID();
                if (WfUtils.isEmpty(modelId) || WfUtils.isEmpty(resourceId) || (resource = (ResourceEntity)commandContext.getResourceEntityManager().findById(resourceId)) == null) continue;
                String modelJson = resource.getData();
                BpmnModelUtil.disposeDynamicPartial(modelJson, modelId);
            }
            catch (Exception e) {
                resultInfos.append(String.format(ResManager.loadKDString((String)"modelID\u4e3a\u201c%1$s\u201d\u7684\u6d41\u7a0b\u6a21\u578b\u4fee\u590d\u5931\u8d25\uff0c\u539f\u56e0\uff1a%2$s\u3002", (String)"RenovateWorkTransferRelatedDataCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), model.getId(), e.getMessage()));
                logger.info("\u4fee\u590d\u6d41\u7a0b\u6a21\u578b\u51fa\u9519\uff0c\u539f\u56e0\uff1a" + WfUtils.getExceptionStacktrace(e));
            }
        }
    }

    public static void saveWfConfCenter(String value) {
        QFilter[] qFilters = new QFilter[]{new QFilter("key", "=", (Object)"renovateWorkTransferRelatedData")};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"wf_confcenter", (String)"type,key,value,description", (QFilter[])qFilters);
        if (dynamicObject == null) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"wf_confcenter");
            dynamicObject = new DynamicObject((DynamicObjectType)dataEntityType);
            dynamicObject.set("type", (Object)"global");
            dynamicObject.set("key", (Object)"renovateWorkTransferRelatedData");
            dynamicObject.set(VALUE, (Object)value);
            dynamicObject.set("description", (Object)ResManager.loadKDString((String)"\u4fee\u590d\u5de5\u4f5c\u79fb\u4ea4\u76f8\u5173\u6570\u636e", (String)"RenovateWorkTransferRelatedDataCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        } else if (!value.equals(dynamicObject.getString(VALUE))) {
            dynamicObject.set(VALUE, (Object)value);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }
}

