/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.monitor.worktransfer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cmd.execution.AbstractBatchQueryCmd;
import kd.bos.workflow.engine.impl.cmd.monitor.worktransfer.GetParticipantModelParamsListForModelCmd;
import kd.bos.workflow.engine.impl.db.BatchSQLInfo;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.deploy.DeploymentCache;
import kd.bos.workflow.engine.impl.persistence.deploy.ProcessDefinitionCacheEntry;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;

public class TransferProcessModelAndDefinitionCmd
extends AbstractBatchQueryCmd<Map<String, String>> {
    private String participantModelIds;
    private String transferId;
    private String receiverIds;
    private List<Object[]> paramsList;
    private List<Object[]> procDefIdActIdProps;

    public TransferProcessModelAndDefinitionCmd(String participantModelIds, String transferId, String receiverIds) {
        this.participantModelIds = participantModelIds;
        this.transferId = transferId;
        this.receiverIds = receiverIds;
    }

    @Override
    public Map<String, String> execute(CommandContext commandContext) {
        HashMap<String, String> results = new HashMap<String, String>();
        if (WfUtils.isEmpty(this.participantModelIds)) {
            return results;
        }
        super.execute(commandContext);
        StringBuilder resultsb = new StringBuilder();
        int updateCount = this.participantModelIds.split(",").length;
        String title = "";
        try {
            this.batchUpdateParticipantModel(commandContext, this.paramsList, 5000);
            this.transferProcessModel(commandContext);
            this.insertWorksTransferLog(commandContext);
            title = String.format(ResManager.loadKDString((String)"\u79fb\u4ea4%1$s\u6761\u6d89\u53ca\u7684\u6d41\u7a0b\u573a\u666f\uff0c\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"TransferProcessDefinitionCmd_0", (String)"bos-wf-engine", (Object[])new Object[0]), updateCount, updateCount, 0);
            this.disposeSchemeCache(commandContext);
        }
        catch (Exception e) {
            title = String.format(ResManager.loadKDString((String)"\u79fb\u4ea4%1$s\u6761\u6d89\u53ca\u7684\u6d41\u7a0b\u573a\u666f\uff0c\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"TransferProcessDefinitionCmd_0", (String)"bos-wf-engine", (Object[])new Object[0]), updateCount, 0, updateCount);
            resultsb.append(e.getMessage()).append("\r\n");
            this.logger.info("\u79fb\u4ea4\u6d89\u53ca\u7684\u6d41\u7a0b\u573a\u666f\u65f6\uff0c\u5176\u4e2d\u6d41\u7a0b\u5b9a\u4e49\u7684\u79fb\u4ea4\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + WfUtils.getExceptionStacktrace(e));
        }
        StringBuilder details = new StringBuilder();
        if (resultsb.length() > 0) {
            details.append(ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0:\r\n", (String)"TransferProcessDefinitionCmd_1", (String)"bos-wf-engine", (Object[])new Object[0])).append((CharSequence)resultsb);
        }
        results.put("title", title);
        results.put("details", details.toString());
        return results;
    }

    private void transferProcessModel(CommandContext commandContext) {
        List modelParamsList = (List)new GetParticipantModelParamsListForModelCmd(this.procDefIdActIdProps, this.transferId, this.receiverIds).execute(commandContext);
        this.batchUpdateParticipantModel(commandContext, modelParamsList, 5000);
    }

    private void batchUpdateParticipantModel(CommandContext commandContext, List<Object[]> paramsList, Integer batchCount) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        String batchSql = "update t_wf_participantmodel set fvalue = ? where fid = ? ";
        BatchSQLInfo batchSQLInfo = new BatchSQLInfo(batchSql, paramsList, batchCount);
        commandContext.getParticipantModelEntityManager().addBatchSQLInfo(batchSQLInfo);
    }

    private void insertWorksTransferLog(CommandContext commandContext) {
        if (this.procDefIdActIdProps == null || this.procDefIdActIdProps.isEmpty()) {
            return;
        }
        for (Object[] procDefIdActIdProp : this.procDefIdActIdProps) {
            String activityId = "";
            if (procDefIdActIdProp.length >= 1 && !WfUtils.isEmptyString(procDefIdActIdProp[1])) {
                activityId = procDefIdActIdProp[1].toString();
            }
            commandContext.getWorksTransferLogEntityManager().insertWorksTransferLog(Long.valueOf(this.transferId), this.receiverIds, 0L, WfUtils.getLongValueFromObj(procDefIdActIdProp[0]), 0L, activityId, "process");
        }
    }

    private void disposeSchemeCache(CommandContext commandContext) {
        if (this.procDefIdActIdProps == null || this.procDefIdActIdProps.isEmpty()) {
            return;
        }
        HashSet<Long> procDefIds = new HashSet<Long>(this.procDefIdActIdProps.size());
        for (Object[] procDefIdActIdProp : this.procDefIdActIdProps) {
            procDefIds.add(WfUtils.getLongValueFromObj(procDefIdActIdProp[0]));
        }
        QFilter[] procdefFilters = new QFilter[]{new QFilter("processdefinitionid", "in", procDefIds)};
        List schemes = commandContext.getDynamicConfigSchemeEntityManager().findByQueryFilters(procdefFilters);
        if (schemes != null && !schemes.isEmpty()) {
            DeploymentCache<ProcessDefinitionCacheEntry> processDefinitionCache = commandContext.getProcessEngineConfiguration().getDeploymentManager().getProcessDefinitionCache();
            Date now = WfUtils.now();
            StringBuilder schemeIdStrs = new StringBuilder();
            schemeIdStrs.append('(');
            ArrayList<Object[]> schemeList = new ArrayList<Object[]>(schemes.size());
            ArrayList<Object[]> procdefList = new ArrayList<Object[]>(schemes.size());
            for (DynamicConfigSchemeEntity scheme : schemes) {
                Long schemeId = scheme.getId();
                Long procDefId = scheme.getProcDefId();
                schemeIdStrs.append(schemeId).append(',');
                schemeList.add(new Object[]{now, schemeId});
                procdefList.add(new Object[]{now, procDefId});
                processDefinitionCache.remove(schemeId);
                processDefinitionCache.remove(procDefId);
                WfCacheHelper.removeSchemeMultiLangDatas(schemeId);
            }
            String schemeBatchSql = "update t_wf_dynconfscheme set fmodifydate = ? where fid = ? ";
            BatchSQLInfo schemeBatchSQLInfo = new BatchSQLInfo(schemeBatchSql, schemeList, 5000);
            commandContext.getDynamicConfigSchemeEntityManager().addBatchSQLInfo(schemeBatchSQLInfo);
            String procdefBatchSql = "update t_wf_procdef set fmodifydate = ? where fid = ? ";
            BatchSQLInfo procdefBatchSQLInfo = new BatchSQLInfo(procdefBatchSql, procdefList, 5000);
            commandContext.getDynamicConfigSchemeEntityManager().addBatchSQLInfo(procdefBatchSQLInfo);
            String schemeIdsString = schemeIdStrs.substring(0, schemeIdStrs.length() - 1) + ')';
            String sql = String.format("SELECT E.FID FROM T_WF_DYNRESOURCE D INNER JOIN T_WF_EXECUTION E ON E.FID = D.FPROCINSTID WHERE E.FSCHEMEID in %s", schemeIdsString);
            HashSet<Long> ids = new HashSet<Long>();
            try (DataSet ds = DB.queryDataSet((String)"wf.engine.queryDynamicProcessBySchemeId", (DBRoute)DBRoute.workflow, (String)sql, null);){
                for (Object row : ds) {
                    ids.add(row.getLong("FID"));
                }
            }
            if (!ids.isEmpty()) {
                QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
                List executions = commandContext.getExecutionEntityManager().findByQueryFilters(filters, true);
                if (executions != null && !executions.isEmpty()) {
                    ArrayList<Object[]> execList = new ArrayList<Object[]>(executions.size());
                    for (ExecutionEntity execution : executions) {
                        Long processInstanceId = execution.getProcessInstanceId();
                        execList.add(new Object[]{now, processInstanceId});
                        processDefinitionCache.remove(processInstanceId);
                    }
                    String execBatchSql = "update T_WF_EXECUTION set fmodifydate = ? where fid = ? ";
                    BatchSQLInfo execBatchSQLInfo = new BatchSQLInfo(execBatchSql, execList, 5000);
                    commandContext.getDynamicConfigSchemeEntityManager().addBatchSQLInfo(execBatchSQLInfo);
                }
            }
        }
    }

    @Override
    protected void handleResult(Map<String, String> ret, Row row) {
        Long participantModelId = row.getLong("fid");
        String value = row.getString("fvalue");
        if (!WfUtils.isEmpty(value) && Arrays.asList(value.split(",")).contains(this.transferId)) {
            value = value.replace(this.transferId, this.receiverIds);
            if (this.paramsList == null) {
                this.paramsList = new ArrayList<Object[]>();
            }
            this.paramsList.add(new Object[]{value, participantModelId});
        }
        if (this.procDefIdActIdProps == null) {
            this.procDefIdActIdProps = new ArrayList<Object[]>();
        }
        Long procDefId = row.getLong("fprocdefid");
        String activityId = row.getString("ftaskactivityid");
        String property = row.getString("fproperty");
        if (!WfUtils.isEmpty(procDefId)) {
            this.procDefIdActIdProps.add(new Object[]{procDefId, activityId, property});
        }
    }

    @Override
    protected Object[] createParameter(List<String> subList) {
        Object[] params = new Object[subList.size()];
        int i = 0;
        for (String t : subList) {
            params[i] = Long.parseLong(t);
            ++i;
        }
        return params;
    }

    @Override
    protected String createSQL(List<String> subList) {
        StringBuilder sql = new StringBuilder();
        sql.append("select fid,fvalue,fprocdefid,ftaskactivityid,fproperty from t_wf_participantmodel ");
        sql.append(" where fid in (");
        int length = subList.size();
        for (int i = 0; i < length; ++i) {
            sql.append(" ?");
            if (i == length - 1) continue;
            sql.append(',');
        }
        sql.append(')');
        return sql.toString();
    }

    @Override
    protected Collection<String> getTotal() {
        return Arrays.asList(this.participantModelIds.split(","));
    }

    @Override
    protected Map<String, String> createRet() {
        return new HashMap<String, String>();
    }
}

