/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.monitor.worktransfer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class TransferWorkflowExecutionsCmd
implements Command<Map<String, String>>,
Serializable {
    private String executionIds;
    private String transferId;
    private String receiverIds;

    public TransferWorkflowExecutionsCmd(String executionIds, String transferId, String receiverIds) {
        this.executionIds = executionIds;
        this.transferId = transferId;
        this.receiverIds = receiverIds;
    }

    @Override
    public Map<String, String> execute(CommandContext commandContext) {
        String[] split;
        HashMap<String, String> results = new HashMap<String, String>();
        StringBuilder resultSb = new StringBuilder();
        int success = 0;
        int fail = 0;
        for (String executionId : split = this.executionIds.split(",")) {
            String result = "";
            try {
                ExecutionEntityManager manager = commandContext.getExecutionEntityManager();
                ExecutionEntity execution = manager.findProcessInstanceById(Long.parseLong(executionId));
                String userActivityId = this.queryFirstUserTaskInfo(execution);
                commandContext.getWorksTransferLogEntityManager().insertWorksTransferLog(Long.valueOf(this.transferId), this.receiverIds, Long.parseLong(executionId), execution.getProcessDefinitionId(), 0L, userActivityId, "execution");
                execution.setCreatorId(Long.parseLong(this.receiverIds));
                execution.setPriorityShow("transfer");
                manager.update(execution);
                HistoricProcessInstanceEntityManager historicProcessInstanceEntityManager = commandContext.getHistoricProcessInstanceEntityManager();
                HistoricProcessInstanceEntity hisProcInstEntity = (HistoricProcessInstanceEntity)historicProcessInstanceEntityManager.findById(execution.getId());
                if (hisProcInstEntity != null) {
                    hisProcInstEntity.setCreatorId(Long.parseLong(this.receiverIds));
                    hisProcInstEntity.setPriorityShow("transfer");
                    historicProcessInstanceEntityManager.update(hisProcInstEntity);
                }
                result = "OK";
            }
            catch (Exception e) {
                result = e.getMessage();
            }
            if ("OK".equalsIgnoreCase(result)) {
                ++success;
                continue;
            }
            ++fail;
            resultSb.append(result).append("\r\n");
        }
        String title = String.format(ResManager.loadKDString((String)"\u79fb\u4ea4%1$s\u6761\u6d89\u53ca\u7684\u5728\u529e\u7533\u8bf7\uff0c\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"TransferWorkflowExecutionsCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), split.length, success, fail);
        StringBuilder details = new StringBuilder();
        if (resultSb.length() > 0) {
            details.append(ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0:", (String)"TransferWorkflowExecutionsCmd_2", (String)"bos-wf-engine", (Object[])new Object[0])).append((CharSequence)resultSb);
        }
        results.put("title", title);
        results.put("details", details.toString());
        return results;
    }

    private String queryFirstUserTaskInfo(ExecutionEntity entity) {
        Long processInstanceId = entity.getProcessInstanceId();
        Long processDefinitionId = entity.getProcessDefinitionId();
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionId, processInstanceId);
        Process process = bpmnModel.getMainProcess();
        UserTask userTask = BpmnModelUtil.getFirstUserTask(process);
        return userTask.getId();
    }
}

