/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.monitor.worktransfer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.execution.AbstractBatchQueryCmd;
import kd.bos.workflow.engine.impl.db.BatchSQLInfo;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.RoleEntity;

public class TransferWorkflowRolesCmd
extends AbstractBatchQueryCmd<Map<String, String>> {
    private String roleIds;
    private String roleEntryIds;
    private String transferId;
    private String receiverIds;
    private List<Object[]> updateParamsList;
    private List<Object[]> insertParamsList;
    private Set<String> roleIdsSet;
    private Map<Long, List<Map<String, Long>>> roleUserOrgs = new HashMap<Long, List<Map<String, Long>>>();
    private static final String USERID = "userId";
    private static final String ORGID = "orgId";
    private Long hasUpdateUserId = 0L;

    public TransferWorkflowRolesCmd(String roleIds, String transferId, String receiverIds) {
        this.roleIds = roleIds;
        this.transferId = transferId;
        this.receiverIds = receiverIds;
    }

    public TransferWorkflowRolesCmd(String roleIds, String roleEntryIds, String transferId, String receiverIds) {
        this.roleIds = roleIds;
        this.roleEntryIds = roleEntryIds;
        this.transferId = transferId;
        this.receiverIds = receiverIds;
    }

    @Override
    public Map<String, String> execute(CommandContext commandContext) {
        HashMap<String, String> results = new HashMap<String, String>();
        if (WfUtils.isEmpty(this.roleIds)) {
            return results;
        }
        int updateCount = 0;
        Collection<String> totalCollection = this.getTotal();
        if (totalCollection != null && !totalCollection.isEmpty()) {
            updateCount = totalCollection.size();
        }
        this.initRoleUserOrgs(commandContext);
        super.execute(commandContext);
        StringBuilder resultsb = new StringBuilder();
        String title = "";
        try {
            this.batchUpdateRole(commandContext, this.updateParamsList, 5000);
            this.batchInsertRoles(commandContext, this.insertParamsList, 5000);
            this.insertWorksTransferLog(commandContext);
            title = String.format(ResManager.loadKDString((String)"\u79fb\u4ea4%1$s\u6761\u6d89\u53ca\u7684\u5de5\u4f5c\u6d41\u89d2\u8272\uff0c\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"TransferWorkflowRolesCmd_0", (String)"bos-wf-engine", (Object[])new Object[0]), updateCount, updateCount, 0);
        }
        catch (Exception e) {
            title = String.format(ResManager.loadKDString((String)"\u79fb\u4ea4%1$s\u6761\u6d89\u53ca\u7684\u5de5\u4f5c\u6d41\u89d2\u8272\uff0c\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"TransferWorkflowRolesCmd_0", (String)"bos-wf-engine", (Object[])new Object[0]), updateCount, 0, updateCount);
            resultsb.append(e.getMessage()).append("\r\n");
            this.logger.info("\u79fb\u4ea4\u6d89\u53ca\u7684\u5de5\u4f5c\u6d41\u89d2\u8272\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + WfUtils.getExceptionStacktrace(e));
        }
        StringBuilder details = new StringBuilder();
        if (resultsb.length() > 0) {
            details.append(ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0:\r\n", (String)"TransferWorkflowRolesCmd_1", (String)"bos-wf-engine", (Object[])new Object[0])).append((CharSequence)resultsb);
        }
        results.put("title", title);
        results.put("details", details.toString());
        return results;
    }

    private void initRoleUserOrgs(CommandContext commandContext) {
        HashSet<Long> roleIdz = new HashSet<Long>(this.roleIdsSet.size());
        for (String roleId : this.roleIdsSet) {
            roleIdz.add(Long.parseLong(roleId));
        }
        List roleEntities = commandContext.getRoleEntityManager().findByQueryFilters(new QFilter[]{new QFilter("id", "in", roleIdz)});
        for (RoleEntity roleEntity : roleEntities) {
            Long roleId = roleEntity.getId();
            DynamicObjectCollection users = roleEntity.getRoleEntry();
            if (users == null || users.isEmpty()) continue;
            ArrayList userInfos = new ArrayList();
            for (DynamicObject user : users) {
                HashMap<String, Long> userInfo = new HashMap<String, Long>();
                userInfo.put(USERID, user.getLong("user_id"));
                userInfo.put(ORGID, user.getLong("org_id"));
                userInfos.add(userInfo);
            }
            this.roleUserOrgs.put(roleId, userInfos);
        }
    }

    private void batchUpdateRole(CommandContext commandContext, List<Object[]> paramsList, Integer batchCount) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        String batchSql = "update t_wf_roleentry set fuser = ? , fuserposition = 0 where fentryid = ?";
        BatchSQLInfo batchSQLInfo = new BatchSQLInfo(batchSql, paramsList, batchCount);
        commandContext.getRoleEntityManager().addBatchSQLInfo(batchSQLInfo);
    }

    private void batchInsertRoles(CommandContext commandContext, List<Object[]> insertParamsList, int batchCount) {
        if (insertParamsList == null || insertParamsList.isEmpty()) {
            return;
        }
        if (!WfUtils.isEmpty(this.receiverIds) && this.receiverIds.split(",").length > 1) {
            StringBuilder batchSql = new StringBuilder();
            batchSql.append("insert into t_wf_roleentry(fid,fentryid,fseq,forg,fuser,falternatetype,falternateuser) values (?,?,?,?,?,?,?)");
            BatchSQLInfo batchSQLInfo = new BatchSQLInfo(batchSql.toString(), insertParamsList, batchCount);
            commandContext.getRoleEntityManager().addBatchSQLInfo(batchSQLInfo);
        }
    }

    private void insertWorksTransferLog(CommandContext commandContext) {
        for (String roleId : this.roleIdsSet) {
            commandContext.getWorksTransferLogEntityManager().insertWorksTransferLog(Long.valueOf(this.transferId), this.receiverIds, 0L, 0L, Long.valueOf(roleId), "", "role");
        }
    }

    @Override
    protected void handleResult(Map<String, String> ret, Row row) {
        this.createUpdateParamsList(row);
        this.createInsertParamsList(row);
    }

    private void createUpdateParamsList(Row row) {
        Long updateUserId = 0L;
        if (!WfUtils.isEmpty(this.receiverIds)) {
            updateUserId = Long.valueOf(this.receiverIds.split(",")[0]);
        }
        Long entryId = row.getLong("fentryid");
        if (WfUtils.isNotEmpty(this.roleEntryIds) && !this.roleEntryIds.contains(String.valueOf(entryId))) {
            return;
        }
        if (this.updateParamsList == null) {
            this.updateParamsList = new ArrayList<Object[]>();
        }
        if (!(WfUtils.isEmpty(updateUserId) || WfUtils.isEmpty(entryId) || this.receiverIds.contains(this.transferId))) {
            this.hasUpdateUserId = updateUserId;
            this.updateParamsList.add(new Object[]{updateUserId, entryId});
        }
    }

    private void createInsertParamsList(Row row) {
        if (WfUtils.isEmpty(this.receiverIds)) {
            return;
        }
        String[] receiverIdsArray = this.receiverIds.split(",");
        int length = receiverIdsArray.length;
        if (length > 1) {
            if (this.insertParamsList == null) {
                this.insertParamsList = new ArrayList<Object[]>(length);
            }
            Long roleId = row.getLong("fid");
            long[] entryIds = ORM.create().genLongIds("wf_role", length);
            int seq = 0;
            if (row.getInteger("fseq") != null) {
                seq = row.getInteger("fseq");
            }
            Long orgId = 0L;
            if (!WfUtils.isEmpty(row.getLong("forg"))) {
                orgId = row.getLong("forg");
            }
            String alternateType = row.getString("falternatetype");
            Long alternateUserId = 0L;
            if (!WfUtils.isEmpty(row.getLong("falternateuser"))) {
                alternateUserId = row.getLong("falternateuser");
            }
            for (int i = 0; i < length; ++i) {
                Long insertUserId = Long.valueOf(receiverIdsArray[i]);
                boolean exist = false;
                List<Map<String, Long>> list = this.roleUserOrgs.get(roleId);
                if (list != null && !list.isEmpty()) {
                    for (Map<String, Long> map : list) {
                        if (insertUserId == null || !insertUserId.equals(map.get(USERID)) || orgId == null || !map.get(ORGID).equals(orgId)) continue;
                        exist = true;
                        break;
                    }
                }
                if (exist || this.hasUpdateUserId.equals(insertUserId)) continue;
                Object[] param = new Object[]{roleId, entryIds[i], seq, orgId, insertUserId, alternateType, alternateUserId};
                this.insertParamsList.add(param);
            }
        }
    }

    @Override
    protected Object[] createParameter(List<String> subList) {
        Object[] params = new Object[subList.size()];
        int i = 0;
        for (String t : subList) {
            params[i] = Long.parseLong(t);
            ++i;
        }
        return params;
    }

    @Override
    protected String createSQL(List<String> subList) {
        StringBuilder sql = new StringBuilder();
        sql.append("select fid,fentryid,fseq,forg,fuser,falternatetype,falternateuser from t_wf_roleentry ");
        sql.append("where fuser = ").append(this.transferId).append(" and fid in (");
        int length = subList.size();
        for (int i = 0; i < length; ++i) {
            sql.append(" ?");
            if (i == length - 1) continue;
            sql.append(',');
        }
        sql.append(')');
        return sql.toString();
    }

    @Override
    protected Collection<String> getTotal() {
        if (this.roleIdsSet == null) {
            this.roleIdsSet = new HashSet<String>(this.roleIds.split(",").length);
            this.roleIdsSet.addAll(Arrays.asList(this.roleIds.split(",")));
        }
        return this.roleIdsSet;
    }

    @Override
    protected Map<String, String> createRet() {
        return new HashMap<String, String>();
    }
}

