/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.monitor.worktransfer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.monitor.worktransfer.GetParticipantModelIdsByUserIdCmd;
import kd.bos.workflow.engine.impl.cmd.monitor.worktransfer.GetTaskIdsByParticipantIdCmd;
import kd.bos.workflow.engine.impl.cmd.monitor.worktransfer.GetWorkflowRoleIdsByAuditorIdCmd;
import kd.bos.workflow.engine.impl.cmd.monitor.worktransfer.TransferProcessModelAndDefinitionCmd;
import kd.bos.workflow.engine.impl.cmd.monitor.worktransfer.TransferWorkflowRolesCmd;
import kd.bos.workflow.engine.impl.cmd.task.AdminTransferTaskCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class WorksBatchTransferCmd
implements Command<Map<String, String>>,
Serializable {
    private static final long serialVersionUID = 2217277808324888024L;
    private Long transferId;
    private String receiverIds;
    private static final String TITLE = "title";
    private static final String DETAILS = "details";

    public WorksBatchTransferCmd(Long transferId, String receiverIds) {
        this.transferId = transferId;
        this.receiverIds = receiverIds;
    }

    @Override
    public Map<String, String> execute(CommandContext commandContext) {
        StringBuilder roleIds;
        StringBuilder participantModelIds;
        HashMap<String, String> results = new HashMap<String, String>();
        StringBuilder title = new StringBuilder();
        StringBuilder details = new StringBuilder();
        StringBuilder taskIds = (StringBuilder)new GetTaskIdsByParticipantIdCmd(this.transferId).execute(commandContext);
        if (taskIds != null && !WfUtils.isEmpty(taskIds.toString())) {
            Object taskTransferRes = new AdminTransferTaskCmd(taskIds.toString(), String.valueOf(this.transferId), this.receiverIds, null, Boolean.FALSE, Boolean.TRUE).execute(commandContext);
            title.append((String)taskTransferRes.get(TITLE)).append(";");
            details.append((String)taskTransferRes.get(DETAILS));
        }
        if ((participantModelIds = (StringBuilder)new GetParticipantModelIdsByUserIdCmd(this.transferId).execute(commandContext)) != null && !WfUtils.isEmpty(participantModelIds.toString())) {
            Object procDefTransferRes = new TransferProcessModelAndDefinitionCmd(participantModelIds.toString(), String.valueOf(this.transferId), this.receiverIds).execute(commandContext);
            title.append((String)procDefTransferRes.get(TITLE)).append(";");
            details.append((String)procDefTransferRes.get(DETAILS));
        }
        if ((roleIds = (StringBuilder)new GetWorkflowRoleIdsByAuditorIdCmd(this.transferId).execute(commandContext)) != null && !WfUtils.isEmpty(roleIds.toString())) {
            Object roleTransferRes = new TransferWorkflowRolesCmd(roleIds.toString(), String.valueOf(this.transferId), this.receiverIds).execute(commandContext);
            title.append((String)roleTransferRes.get(TITLE)).append(";");
            details.append((String)roleTransferRes.get(DETAILS));
        }
        results.put(TITLE, title.toString());
        results.put(DETAILS, details.toString());
        return results;
    }
}

