/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.precomputation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.GetProcInstIdByBusinessKeyCMD;
import kd.bos.workflow.engine.impl.cmd.history.GetHistoricActivityInstanceCmd;
import kd.bos.workflow.engine.impl.cmd.precomputation.impl.DefaultPrecomputatorCmd;
import kd.bos.workflow.engine.impl.cmd.startup.AddressProcessCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.precomputor.IPreComputorRecord;
import kd.bos.workflow.engine.precomputor.IPreComputorRecordItem;

public class GetPrecomputatorWithHistoryCmd
implements Command<List<Map<String, Object>>> {
    protected static final Log logger = LogFactory.getLog(GetPrecomputatorWithHistoryCmd.class);
    protected String businessKey;
    protected Long procDefId;
    protected DynamicObject billObj;
    protected String entityNumber;
    protected String opKey;
    private static final String NODEID = "nodeId";
    private static final String NODENAME = "nodeName";
    private static final String ASSIGNEE = "assignee";
    private static final String ASSIGNEENAME = "assigneeName";
    private static final String NODETYPE = "nodeType";
    private static final String STATUS = "status";
    private static final String EXECUTED = "executed";
    private static final String NEXTNODE = "nextNode";
    private static final String NEXTNODENAME = "nextNodeName";
    private static final String ADDRESSSCENSE = "ADDRESSSCENSE";

    public GetPrecomputatorWithHistoryCmd(String businessKey) {
        this.businessKey = businessKey;
    }

    public GetPrecomputatorWithHistoryCmd(Long procDefId, DynamicObject billObj) {
        this.procDefId = procDefId;
        this.billObj = billObj;
    }

    public GetPrecomputatorWithHistoryCmd(String opKey, String entityNumber, String businessKey) {
        this.opKey = opKey;
        this.entityNumber = entityNumber;
        this.businessKey = businessKey;
    }

    @Override
    public List<Map<String, Object>> execute(CommandContext commandContext) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (WfUtils.isNotEmpty(this.procDefId) && this.billObj != null) {
            Process process = ProcessDefinitionUtil.getProcessByProcDefId(this.procDefId);
            IPreComputorRecord preResult = new DefaultPrecomputatorCmd(this.procDefId, this.billObj).execute(commandContext);
            result.addAll(this.getPreRecord(process, preResult));
        } else if (WfUtils.isNotEmpty(this.businessKey)) {
            Long procDefId;
            DynamicObject dynamicObject;
            Long procInstId;
            if (WfUtils.isEmpty(this.opKey) && WfUtils.isEmpty(this.entityNumber) && WfUtils.isNotEmpty(procInstId = new GetProcInstIdByBusinessKeyCMD(this.businessKey).execute(commandContext))) {
                Process process = ProcessDefinitionUtil.getProcessByProcInstId(procInstId);
                IPreComputorRecord preResult = new DefaultPrecomputatorCmd(procInstId).execute(commandContext);
                result.addAll(this.getHisRecord(procInstId, process, commandContext));
                result.addAll(this.getPreRecord(process, preResult));
            }
            if (WfUtils.isNotEmpty(this.opKey) && WfUtils.isNotEmpty(this.entityNumber) && (dynamicObject = WfUtils.findBusinessObject(this.businessKey, this.entityNumber)) != null && (procDefId = this.getProcDefIdByAddress(commandContext, this.opKey, dynamicObject)) != null && procDefId != 0L) {
                Process process = ProcessDefinitionUtil.getProcessByProcDefId(procDefId);
                IPreComputorRecord preResult = new DefaultPrecomputatorCmd(procDefId, dynamicObject).execute(commandContext);
                result.addAll(this.getPreRecord(process, preResult));
            }
        }
        return result;
    }

    private List<Map<String, Object>> getHisRecord(Long procInstId, Process process, CommandContext commandContext) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Object entities = new GetHistoricActivityInstanceCmd(procInstId).execute(commandContext);
        HashMap<Long, Long> idTaskMap = new HashMap<Long, Long>(entities.size());
        HashMap<Long, Map<String, List<Long>>> taskResultMap = new HashMap<Long, Map<String, List<Long>>>();
        HashMap targetSourceMap = new HashMap(entities.size());
        Iterator iterator = entities.iterator();
        while (iterator.hasNext()) {
            Long sTaskId;
            Map sResultItem;
            Long sid;
            HistoricActivityInstanceEntity entity = (HistoricActivityInstanceEntity)iterator.next();
            Long id = entity.getId();
            Long taskId = entity.getTaskId();
            if (WfUtils.isNotEmpty(taskId)) {
                Long parentTaskId = entity.getParentTaskId();
                if (WfUtils.isNotEmpty(parentTaskId)) {
                    taskId = parentTaskId;
                }
            } else {
                taskId = id;
            }
            idTaskMap.put(id, taskId);
            targetSourceMap.put(id, idTaskMap.get(entity.getSourceElementId()));
            String activityType = entity.getActivityType();
            if ("SequenceFlow".equals(activityType)) continue;
            if (entity.getEndTime() != null) {
                Map<String, List<Long>> resultItem = new HashMap();
                List<Long> assignee = new ArrayList();
                if (taskResultMap.containsKey(taskId)) {
                    resultItem = (Map)taskResultMap.get(taskId);
                    assignee = (List)resultItem.get(ASSIGNEE);
                } else {
                    String actId = entity.getActivityId();
                    String nodeName = process.getFlowElement(actId).getName();
                    String status = entity.getExecutionType();
                    resultItem.put(NODEID, (List<Long>)((Object)actId));
                    resultItem.put(NODENAME, (List<Long>)((Object)nodeName));
                    resultItem.put(NODETYPE, (List<Long>)((Object)"node"));
                    resultItem.put(STATUS, (List<Long>)((Object)status));
                    resultItem.put(EXECUTED, (List<Long>)((Object)Boolean.TRUE));
                    result.add(resultItem);
                }
                assignee.add(entity.getAssigneeId());
                resultItem.put(ASSIGNEE, assignee);
                resultItem.put(ASSIGNEENAME, (List<Long>)((Object)WfUtils.getUsersName(assignee)));
                taskResultMap.put(taskId, resultItem);
            }
            if (!WfUtils.isNotEmpty(sid = entity.getSourceElementId()) || (sResultItem = (Map)taskResultMap.get(sTaskId = (Long)targetSourceMap.get(sid))) == null) continue;
            ArrayList<String> targetEdges = (ArrayList<String>)sResultItem.get(NEXTNODE);
            if (targetEdges == null) {
                targetEdges = new ArrayList<String>();
            }
            if (targetEdges.contains(entity.getActivityId())) continue;
            targetEdges.add(entity.getActivityId());
            sResultItem.put(NEXTNODE, targetEdges);
            sResultItem.put(NEXTNODENAME, this.getNodeName(process, targetEdges));
        }
        return result;
    }

    private List<Map<String, Object>> getPreRecord(Process process, IPreComputorRecord record) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List data = record.getPcrData();
        for (IPreComputorRecordItem pre : data) {
            Boolean isnormal = pre.getIsNormal();
            String nodeId = pre.getNodeId();
            String nodeType = pre.getNodeType();
            String status = pre.getStatus();
            if (!isnormal.booleanValue() || "SequenceFlow".equals(nodeType)) continue;
            HashMap<String, Object> resultItem = new HashMap<String, Object>();
            resultItem.put(NODEID, nodeId);
            FlowElement flowNode = process.getFlowElement(nodeId);
            resultItem.put(NODENAME, flowNode.getName());
            List assignee = pre.getAssignee();
            resultItem.put(ASSIGNEE, assignee);
            String assigneeName = WfUtils.getUsersName(assignee);
            if (WfUtils.isEmpty(assigneeName)) {
                resultItem.put(ASSIGNEENAME, ResManager.loadKDString((String)"\u672a\u8ba1\u7b97\u5230\u9884\u4f30\u7684\u53c2\u4e0e\u4eba\u3002", (String)"GetPrecomputatorWithHistoryCmd_0", (String)"bos-wf-engine", (Object[])new Object[0]));
            } else {
                resultItem.put(ASSIGNEENAME, String.format(ResManager.loadKDString((String)"\u9884\u4f30\u7684\u53c2\u4e0e\u4eba:%s", (String)"GetPrecomputatorWithHistoryCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), assigneeName));
            }
            List targetList = pre.getNextNodeId();
            resultItem.put(NEXTNODE, targetList);
            resultItem.put(NEXTNODENAME, this.getNodeName(process, targetList));
            resultItem.put(NODETYPE, "node");
            resultItem.put(STATUS, status);
            resultItem.put(EXECUTED, Boolean.FALSE);
            if (flowNode instanceof UserTask) {
                resultItem.put("extAttrGroup", BpmnModelUtil.extendAttributeGroupConverterToWF(flowNode));
            }
            result.add(resultItem);
        }
        return result;
    }

    private String getNodeName(Process process, List<String> nodeIds) {
        StringBuilder builder = new StringBuilder();
        if (nodeIds != null) {
            for (String id : nodeIds) {
                FlowElement flowNode = process.getFlowElement(id);
                builder.append(",").append(flowNode.getName());
            }
            if (builder.length() > 0) {
                return builder.substring(1);
            }
        }
        return ResManager.loadKDString((String)"\u672a\u8ba1\u7b97\u5230\u4e0b\u4e00\u8282\u70b9", (String)"GetPrecomputatorWithHistoryCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getProcDefIdByAddress(CommandContext commandContext, String opKey, DynamicObject billObj) {
        Long procDefId = 0L;
        logger.debug("GetPrecomputatorWithHistoryCmd.getProcDefIdByAddress opKey is " + opKey);
        String businessKey = null;
        try {
            if (null != billObj && billObj.getPkValue() != null) {
                businessKey = String.valueOf(billObj.getPkValue());
                logger.debug(String.format("GetPrecomputatorWithHistoryCmd.getProcDefIdByAddress businessKey is [%s],entityNumber is [%s]", businessKey, billObj.getDataEntityType().getName()));
            }
            commandContext.addAttribute(ADDRESSSCENSE, String.valueOf(Boolean.TRUE).toUpperCase());
            AddressProcessCmd addressProcessCmd = new AddressProcessCmd(opKey, billObj);
            procDefId = addressProcessCmd.execute(commandContext);
        }
        finally {
            commandContext.removeAttribute(ADDRESSSCENSE);
        }
        return procDefId;
    }
}

