/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.precomputation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.domain.model.NodeForkJoinModel;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.agenda.ForkJoinUtils;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.WarpGatewayActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.YunzhijiaNotifyActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.YunzhijiaParallelMultiInstanceBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.YunzhijiaSequentialMultiInstanceBehavior;
import kd.bos.workflow.engine.impl.cmd.precomputation.NodeTempVariable;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PreComputatorExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.engine.task.TaskUtils;

public class PercomputatorUtils {
    private static final Log logger = LogFactory.getLog(PercomputatorUtils.class);

    public static TaskEntity getNodeTask(FlowNode flowNode, ExecutionEntity execution) {
        Object behavior = flowNode.getBehavior();
        if (behavior instanceof WarpGatewayActivityBehavior) {
            behavior = ((WarpGatewayActivityBehavior)flowNode.getBehavior()).getActivityBehavior();
        }
        if (behavior instanceof YunzhijiaNotifyActivityBehavior) {
            return null;
        }
        if (behavior instanceof UserTaskActivityBehavior) {
            return TaskBehaviorUtil.buildTaskEntityForNextNode(execution, (UserTask)flowNode);
        }
        if (behavior instanceof YunzhijiaParallelMultiInstanceBehavior || behavior instanceof YunzhijiaSequentialMultiInstanceBehavior) {
            return TaskBehaviorUtil.buildTaskEntityForNextNode(execution, (UserTask)flowNode);
        }
        return null;
    }

    public static List<SequenceFlow> getNodeOutgoingSequences(FlowNode flowNode, VariableScope variableScope, Process process) {
        String firstApproveOptNum = BpmnModelUtil.getFirstApproveOptNum(flowNode);
        logger.debug(String.format("\u83b7\u53d6%s\u7684\u7b2c\u4e00\u4e2a\u7edf\u4e00\u51b3\u7b56\u9879%s", flowNode.getId(), firstApproveOptNum));
        if (variableScope != null && WfUtils.isNotEmpty(firstApproveOptNum)) {
            variableScope.setTransientVariableLocal("auditNumber", firstApproveOptNum);
            variableScope.setTransientVariableLocal("auditType", "approve");
            logger.debug("\u8bbe\u7f6e\u5230Scope\u4e2d\u5e76\u4f7f\u7528");
        }
        ArrayList<SequenceFlow> sequenceFlows = new ArrayList<SequenceFlow>();
        String defaultSequenceFlowId = flowNode.getDefaultFlow();
        SequenceFlow defaultSequenceFlow = null;
        try {
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                if (sequenceFlow.isDynamic()) {
                    logger.debug(String.format("\u7ebf%s\u4e3a\u52a8\u6001\uff0c\u8df3\u8fc7", sequenceFlow.getId()));
                    continue;
                }
                String expression = "";
                if (sequenceFlow.getConditionalRule() != null) {
                    expression = sequenceFlow.getConditionalRule().getExpression();
                }
                if (WfUtils.isNotEmpty(expression) && ConditionUtil.hasTrueCondition(expression, variableScope, null) && (defaultSequenceFlowId == null || !defaultSequenceFlowId.equals(sequenceFlow.getId()))) {
                    sequenceFlows.add(sequenceFlow);
                    logger.debug(String.format("\u7ebf%s\u4e3a\u6ee1\u8db3\u6761\u4ef6", sequenceFlow.getId()));
                    continue;
                }
                if (defaultSequenceFlowId != null && sequenceFlow.getId().equals(defaultSequenceFlowId)) {
                    defaultSequenceFlow = sequenceFlow;
                    logger.debug(String.format("\u7ebf%s\u4e3a\u9ed8\u8ba4\u7ebf", sequenceFlow.getId()));
                    continue;
                }
                if (!WfUtils.isEmpty(expression)) continue;
                if (sequenceFlow.getConditionalRule() != null && WfUtils.isNotEmpty(sequenceFlow.getConditionalRule().getPlugin())) {
                    if (!ConditionUtil.hasTrueCondition(sequenceFlow.getConditionalRule(), variableScope, "percomputator-getOutgoingFlows")) continue;
                    sequenceFlows.add(sequenceFlow);
                    logger.debug(String.format("\u7ebf%s\u4e3a\u6ee1\u8db3\u6761\u4ef6\u63d2\u4ef6", sequenceFlow.getId()));
                    continue;
                }
                sequenceFlows.add(sequenceFlow);
                logger.debug(String.format("\u7ebf%s\u6ca1\u6709\u6761\u4ef6", sequenceFlow.getId()));
            }
        }
        catch (Exception e) {
            logger.debug("\u9884\u8ba1\u7b97\u8fd0\u7b97\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + WfUtils.getExceptionStacktrace(e));
            return Collections.emptyList();
        }
        if (sequenceFlows.isEmpty() && defaultSequenceFlow != null) {
            sequenceFlows.add(defaultSequenceFlow);
        }
        ExecutionEntity proinst = null;
        if (variableScope instanceof TaskEntity) {
            proinst = ((TaskEntity)variableScope).getProcessInstance();
        } else if (variableScope instanceof ExecutionEntity) {
            proinst = ((ExecutionEntity)variableScope).getProcessInstance();
        }
        if (ForkJoinUtils.isForkNode(flowNode) && "reject".equals(flowNode.getPassTypeAfterInnerReject()) && proinst != null) {
            String forkNodeId = flowNode.getId();
            int cycle = ForkJoinUtils.getEnterForkCycle(forkNodeId, proinst);
            String joinRejectKey = ForkJoinUtils.getJoinNodeRejectKey(flowNode.getId(), cycle, proinst);
            if (cycle > 0 && WfUtils.isNotEmpty(joinRejectKey)) {
                ArrayList<SequenceFlow> outgoingSequenceFlowsClone = new ArrayList<SequenceFlow>();
                Iterator iter = sequenceFlows.iterator();
                Map<String, NodeForkJoinModel> models = process.getForkJoinModels();
                FlowNode rejectNode = (FlowNode)process.getFlowElement(joinRejectKey);
                if (joinRejectKey.startsWith("JOIN_") || rejectNode == null) {
                    while (iter.hasNext()) {
                        SequenceFlow s = (SequenceFlow)iter.next();
                        outgoingSequenceFlowsClone.add(s);
                        String val = ForkJoinUtils.getItemForkResult(forkNodeId, s.getTargetFlowElement().getId(), cycle, proinst);
                        if ("reject".equals(val)) continue;
                        iter.remove();
                        logger.debug(String.format("\u591a\u5206\u652f\u9a73\u56de\uff0c\u79fb\u9664%s", s.getId()));
                    }
                } else {
                    NodeForkJoinModel rejectNodeModel = models.get(joinRejectKey);
                    String targetStructure = rejectNodeModel.getForkStructure();
                    while (iter.hasNext()) {
                        SequenceFlow s = (SequenceFlow)iter.next();
                        outgoingSequenceFlowsClone.add(s);
                        String tmpId = s.getTargetFlowElement().getId();
                        if (models.get(tmpId) != null && targetStructure.equals(models.get(tmpId).getForkStructure())) continue;
                        iter.remove();
                        logger.debug(String.format("\u591a\u5206\u652f\u9a73\u56de\uff0c\u79fb\u9664%s", s.getId()));
                    }
                }
                if (sequenceFlows.isEmpty() && !outgoingSequenceFlowsClone.isEmpty()) {
                    sequenceFlows = outgoingSequenceFlowsClone;
                }
            }
        }
        return sequenceFlows;
    }

    public static List<Map<String, String>> getRepeaterInfo(AuditTask auditTask, TaskEntity task, List<Long> userIds, ExecutionEntity execution) {
        Long procinstId = execution.getProcessInstanceId();
        boolean adjacentnodeonly = auditTask.isAdjacentnodeonly();
        List<Object> repeaterApprovalInfo = new ArrayList(0);
        repeaterApprovalInfo = adjacentnodeonly ? TaskUtils.getRepeaterAdjacentNodes(userIds, procinstId, auditTask.getId()) : TaskUtils.getRepeaterApprovalAuditNumber(userIds, procinstId, null, execution);
        if (!adjacentnodeonly && WfUtils.isNotEmpty(execution.getProcessInstanceId())) {
            HashSet<String> repeaterInfoKeys = new HashSet<String>(32);
            for (Map map : repeaterApprovalInfo) {
                repeaterInfoKeys.add(String.format("%s-%s", map.get("assigneeId"), map.get("resultNumber")));
            }
            List<FlowElement> preNodes = BpmnModelUtil.getPreviousNodes(ProcessDefinitionUtil.getBpmnModel(execution.getProcessDefinitionId(), procinstId), auditTask.getId());
            List<ExecutionEntity> list = Context.getCommandContext().getExecutionEntityManager().findActiveExecutionsByProcessInstanceId(procinstId);
            HashMap<String, ExecutionEntity> esMap = new HashMap<String, ExecutionEntity>(16);
            for (ExecutionEntity e : list) {
                if (e.isScope() || e.getActivityId().endsWith(auditTask.getId())) continue;
                esMap.put(e.getActivityId(), e);
            }
            for (FlowElement node : preNodes) {
                if (!esMap.containsKey(node.getId())) continue;
                List<Map<String, String>> tmVal = TaskUtils.getRepeaterApprovalAuditNumber(userIds, procinstId, null, (ExecutionEntity)esMap.get(node.getId()));
                for (Map<String, String> t : tmVal) {
                    String key = String.format("%s-%s", t.get("assigneeId"), t.get("resultNumber"));
                    if (!repeaterInfoKeys.add(key)) continue;
                    repeaterApprovalInfo.add(t);
                }
            }
        }
        if (repeaterApprovalInfo.isEmpty()) {
            String currentNodeId = auditTask.getId();
            Map<String, NodeTempVariable> tempVariableMap = ((PreComputatorExecutionEntityImpl)execution).getTempVariableMap();
            NodeTempVariable nodeTempVariable = tempVariableMap.get(currentNodeId);
            String currentActivityId = execution.getProcessInstance().getActivityId();
            if (CollectionUtil.isNotEmpty(userIds)) {
                for (Long userId : userIds) {
                    LinkedList<NodeTempVariable> queue = new LinkedList<NodeTempVariable>();
                    queue.add(nodeTempVariable);
                    PercomputatorUtils.getTransitionRepeaterInfo(adjacentnodeonly, userId, repeaterApprovalInfo, tempVariableMap, currentActivityId, queue);
                }
            }
            return repeaterApprovalInfo;
        }
        return repeaterApprovalInfo;
    }

    private static void getTransitionRepeaterInfo(boolean adjacentnodeonly, Long userId, List<Map<String, String>> repeaterApprovalInfo, Map<String, NodeTempVariable> tempVariableMap, String currentActivityId, LinkedList<NodeTempVariable> queue) {
        int count = 0;
        HashSet<String> calculatedNodes = new HashSet<String>();
        HashSet<String> adjancentNodeSet = new HashSet<String>();
        while (!queue.isEmpty() && count < 50) {
            Boolean judgeAssigneeIsReject;
            ++count;
            NodeTempVariable nodeVariable = queue.pop();
            calculatedNodes.add(nodeVariable.getNodeId());
            if (nodeVariable == null) continue;
            List<Long> assigneeIds = nodeVariable.getAssigneeId();
            boolean allowRepeaters = WfConfigurationUtil.getRepeaterApprovalConfig(assigneeIds);
            if (CollectionUtil.isNotEmpty(assigneeIds) && allowRepeaters && assigneeIds.contains(userId) && !(judgeAssigneeIsReject = PercomputatorUtils.judgeAssigneeIsReject(nodeVariable, userId, currentActivityId)).booleanValue()) {
                HashMap<String, String> tmp = new HashMap<String, String>();
                tmp.put("nodeId", nodeVariable.getNodeId());
                tmp.put("resultNumber", nodeVariable.getAuditNumber());
                tmp.put("assigneeId", String.valueOf(userId));
                if (!adjacentnodeonly || "byHand".equals(nodeVariable.getExecutionType())) {
                    repeaterApprovalInfo.add(tmp);
                    if (count != 1) {
                        adjancentNodeSet.add(nodeVariable.getNodeId());
                    }
                }
            }
            if (adjacentnodeonly && adjancentNodeSet.contains(nodeVariable.getNodeId())) continue;
            Set<String> preNodeIds = nodeVariable.getPreNodeIds();
            for (String i : preNodeIds) {
                NodeTempVariable preNodeVariable = tempVariableMap.get(i);
                if (preNodeVariable == null || calculatedNodes.contains(preNodeVariable.getNodeId())) continue;
                if (!adjacentnodeonly) {
                    queue.addLast(preNodeVariable);
                    continue;
                }
                String executionType = preNodeVariable.getExecutionType();
                if ("byAuto".equals(executionType)) {
                    if (preNodeVariable.getAssigneeId().isEmpty()) {
                        queue.addLast(preNodeVariable);
                        continue;
                    }
                    if (!preNodeVariable.getAssigneeId().contains(userId)) continue;
                    HashMap<String, String> tmp = new HashMap<String, String>();
                    tmp.put("nodeId", preNodeVariable.getNodeId());
                    tmp.put("resultNumber", preNodeVariable.getAuditNumber());
                    tmp.put("assigneeId", String.valueOf(userId));
                    repeaterApprovalInfo.add(tmp);
                    continue;
                }
                if ("skip".equals(executionType)) {
                    queue.addLast(preNodeVariable);
                    continue;
                }
                Boolean judgeAssigneeIsReject2 = PercomputatorUtils.judgeAssigneeIsReject(nodeVariable, userId, currentActivityId);
                if (judgeAssigneeIsReject2.booleanValue() || !"byHand".equals(preNodeVariable.getExecutionType()) || !preNodeVariable.getAssigneeId().contains(userId)) continue;
                HashMap<String, String> tmp = new HashMap<String, String>();
                tmp.put("nodeId", preNodeVariable.getNodeId());
                tmp.put("resultNumber", preNodeVariable.getAuditNumber());
                tmp.put("assigneeId", String.valueOf(userId));
                repeaterApprovalInfo.add(tmp);
            }
        }
    }

    private static Boolean judgeAssigneeIsReject(NodeTempVariable nodeVariable, Long userId, String currentActivityId) {
        FlowElement currentFlowElement = nodeVariable.getCurrentFlowElement();
        if (currentFlowElement instanceof YunzhijiaTask && nodeVariable.getNodeId().equals(currentActivityId)) {
            Long processInstanceId = nodeVariable.getCurrentTask().getProcessInstanceId();
            CommentEntityManager commentEntityManager = Context.getProcessEngineConfiguration().getCommentEntityManager();
            List<CommentEntity> comments = commentEntityManager.findCommentsByProcessInstanceIdAndActivityId(processInstanceId, nodeVariable.getNodeId());
            if (CollectionUtil.isEmpty(comments)) {
                return Boolean.FALSE;
            }
            for (CommentEntity comment : comments) {
                String decisionType = comment.getDecisionType();
                Long assigneeId = comment.getUserId();
                if (!"reject".equals(decisionType) || !userId.equals(assigneeId)) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public static Object getNodeAssignee(String nodeId, ExecutionEntity execution) {
        if (!(execution instanceof PreComputatorExecutionEntityImpl)) {
            return null;
        }
        Map<String, NodeTempVariable> tempVariableMap = ((PreComputatorExecutionEntityImpl)execution).getTempVariableMap();
        NodeTempVariable var = tempVariableMap.get(nodeId);
        if (var != null) {
            return WfUtils.listToString(var.getAssigneeId(), ",");
        }
        return null;
    }

    public static Object getExecutionType(String nodeId, ExecutionEntity execution) {
        if (!(execution instanceof PreComputatorExecutionEntityImpl)) {
            return null;
        }
        Map<String, NodeTempVariable> tempVariableMap = ((PreComputatorExecutionEntityImpl)execution).getTempVariableMap();
        NodeTempVariable var = tempVariableMap.get(nodeId);
        if (var != null) {
            return var.getExecutionType();
        }
        return null;
    }

    public static String getLastAssignee(String nodeId, ExecutionEntity execution) {
        if (!(execution instanceof PreComputatorExecutionEntityImpl)) {
            return null;
        }
        Map<String, NodeTempVariable> tempVariableMap = ((PreComputatorExecutionEntityImpl)execution).getTempVariableMap();
        NodeTempVariable var = tempVariableMap.get(nodeId);
        if (var == null || var.getPreNodeIds().isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String pid : var.getPreNodeIds()) {
            List<Long> userIds = tempVariableMap.get(pid).getAssigneeId();
            sb.append(",").append(WfUtils.listToString(userIds, ","));
        }
        if (sb.length() > 1) {
            return sb.substring(1);
        }
        return "";
    }

    public static Object getNodeAuditNumber(String nodeId, ExecutionEntity execution) {
        if (!(execution instanceof PreComputatorExecutionEntityImpl)) {
            return null;
        }
        Map<String, NodeTempVariable> tempVariableMap = ((PreComputatorExecutionEntityImpl)execution).getTempVariableMap();
        NodeTempVariable var = tempVariableMap.get(nodeId);
        if (var == null) {
            return null;
        }
        return var.getAuditNumber();
    }

    public Object getCurrentparticipant(ExecutionEntity execution) {
        if (!(execution instanceof PreComputatorExecutionEntityImpl)) {
            return null;
        }
        String nodeId = (String)execution.getTransientVariable("percomputation_currentnode");
        Map<String, NodeTempVariable> tempVariableMap = ((PreComputatorExecutionEntityImpl)execution).getTempVariableMap();
        NodeTempVariable var = tempVariableMap.get(nodeId);
        return WfUtils.listToString(var.getAssigneeId(), ",");
    }

    public static void addNodeDesc(String nodeId, String auditNumber, String auditType, List<Long> assigneeId, String executionType, PreComputatorExecutionEntityImpl execution) {
        Map<String, NodeTempVariable> tempVariableMap = execution.getTempVariableMap();
        NodeTempVariable var = tempVariableMap.containsKey(nodeId) ? tempVariableMap.get(nodeId) : new NodeTempVariable();
        var.setNodeId(nodeId);
        var.setAssigneeId(assigneeId);
        var.setAuditNumber(auditNumber);
        var.setAuditType(auditType);
        var.setExecutionType(executionType);
        tempVariableMap.put(nodeId, var);
        logger.info(String.format("\u589e\u52a0%s\u8fc7\u7a0b\u7ed3\u679c\u4fe1\u606fassigneeId=%s,auditNumber=%s,auditType=%s,executionType=%s", nodeId, assigneeId, auditNumber, auditType, executionType));
    }
}

