/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.precomputation;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.precomputation.PreComputorRecord;
import kd.bos.workflow.engine.impl.cmd.precomputation.PreComputorRecordItem;
import kd.bos.workflow.engine.impl.cmd.precomputation.impl.DefaultPrecomputatorCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PreComputorInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PreComputorInstanceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PreComputorInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.precomputor.IPreComputorRecord;
import kd.bos.workflow.engine.precomputor.IPreComputorRecordItem;

public final class PreComputorHelper {
    protected static Log logger = LogFactory.getLog((String)PreComputorHelper.class.getName());
    public static final String STRATEGY_THROUGH = "through";
    public static final String STRATEGY_VIEWFLOWCHAR = "viewflowchar";
    public static final String STRATEGY_AFTERAUDIT = "afteraudit";
    private static final String MODIFYTIME = "modifytime";

    public static IPreComputorRecord getPreComputorRecordByImmediateCalc(Long procInstId) {
        return new DefaultPrecomputatorCmd(procInstId).execute(Context.getCommandContext());
    }

    public static IPreComputorRecord getPreComputorRecord(Long procInstId) {
        CommandContext commandContext = Context.getCommandContext();
        QFilter procinstFilter = new QFilter("processinstanceid", "=", (Object)procInstId);
        QFilter validityFilter = new QFilter("validity", "=", (Object)Boolean.TRUE);
        QFilter[] qFilter = new QFilter[]{procinstFilter, validityFilter};
        List dym = commandContext.getPreComputorEntityManager().findByQueryFilters(qFilter);
        if (dym == null || dym != null && dym.isEmpty()) {
            return PreComputorHelper.doPreComputor(procInstId);
        }
        return PreComputorHelper.entity2Record((PreComputorInstanceEntity)dym.get(0));
    }

    public static IPreComputorRecord doPreComputor(Long procInstId) {
        return PreComputorHelper.doPreComputor(procInstId, STRATEGY_THROUGH);
    }

    public static IPreComputorRecord doPreComputor(Long procInstId, String strategy) {
        return PreComputorHelper.doPreComputor(procInstId, strategy, null, null);
    }

    private static IPreComputorRecord doPreComputor(Long procInstId, String strategy, UserTask userTask, TaskEntity task) {
        CommandContext commandContext = Context.getCommandContext();
        PreComputorHelper.invalidInstanceByProcinstId(procInstId);
        IPreComputorRecord pcRecord = new DefaultPrecomputatorCmd(procInstId).execute(commandContext);
        PreComputorInstanceEntityManager manager = commandContext.getPreComputorEntityManager();
        pcRecord.setStrategy(strategy);
        pcRecord.setValidity(Boolean.TRUE);
        pcRecord.setVersion(manager.getMaxVersion(procInstId));
        return PreComputorHelper.insertRecord(procInstId, pcRecord, userTask, task);
    }

    public static IPreComputorRecord doAfterAuditPreComputor(Long procInstId) {
        CommandContext commandContext = Context.getCommandContext();
        return new DefaultPrecomputatorCmd(procInstId, STRATEGY_AFTERAUDIT).execute(commandContext);
    }

    public static IPreComputorRecordItem getNextAfterAuditNode(IPreComputorRecord record, String currentNodeId, Long participant) {
        List data = record.getPcrData();
        ArrayList<String> currentNodeIds = new ArrayList<String>();
        currentNodeIds.add(currentNodeId);
        for (IPreComputorRecordItem node : data) {
            String nodeId = node.getNodeId();
            Boolean normal = node.getIsNormal();
            if (!normal.booleanValue() || !currentNodeIds.contains(nodeId)) continue;
            List assigneeList = node.getAssignee();
            String status = node.getStatus();
            String nodeType = node.getNodeType();
            if ("AuditTask".equals(nodeType) && "byHand".equals(status) && assigneeList.size() == 1 && assigneeList.contains(participant) && !currentNodeId.equals(nodeId)) {
                return node;
            }
            List nextNodeId = node.getNextNodeId();
            currentNodeIds.addAll(nextNodeId);
        }
        return null;
    }

    public static IPreComputorRecord getPreComputorRecordFromApprovalPageForAfterAudit(Long procInstId, DecisionOption option, AuditTask auditTask, TaskEntity task) {
        IPreComputorRecord pcRecord;
        CommandContext commandContext = Context.getCommandContext();
        String activityId = auditTask.getId();
        QFilter procinstFilter = new QFilter("processinstanceid", "=", (Object)procInstId);
        QFilter validityFilter = new QFilter("validity", "=", (Object)Boolean.TRUE);
        QFilter activityIdFilter = new QFilter("activityid", "=", (Object)activityId);
        QFilter auditFilter = new QFilter("entryauditnumber", "=", (Object)option.getNumber());
        QFilter[] qFilter = new QFilter[]{procinstFilter, validityFilter, activityIdFilter, auditFilter};
        List dym = commandContext.getPreComputorEntityManager().findByQueryFilters(qFilter);
        if (dym.isEmpty()) {
            pcRecord = new DefaultPrecomputatorCmd(procInstId, STRATEGY_AFTERAUDIT, option).execute(commandContext);
            pcRecord.setEntryAuditNumber(option.getNumber());
            String opKey = BpmnModelUtil.getDecisionNameMultiKey(activityId, option.getId());
            ILocaleString optionName = BpmnModelUtil.getMultiLangFieldValue(procInstId, opKey, option.getName());
            pcRecord.setEntryAuditName(optionName);
            PreComputorInstanceEntityManager manager = commandContext.getPreComputorEntityManager();
            int maxVersion = manager.getMaxVersion(procInstId);
            pcRecord.setStrategy(STRATEGY_AFTERAUDIT);
            pcRecord.setValidity(Boolean.TRUE);
            pcRecord.setVersion(maxVersion);
            pcRecord.setEntryNodeId(activityId);
            String nodeKey = BpmnModelUtil.getActivityNameMultiKey(activityId);
            ILocaleString nodeName = BpmnModelUtil.getMultiLangFieldValue(procInstId, nodeKey, auditTask.getName());
            pcRecord.setEntryNodeName(nodeName);
            pcRecord.setEntryTaskId(task.getId());
        } else {
            pcRecord = PreComputorHelper.entity2Record((PreComputorInstanceEntity)dym.get(0));
        }
        return pcRecord;
    }

    public static IPreComputorRecord updateAfterAuditRecord(IPreComputorRecord record) {
        List data = record.getPcrData();
        for (IPreComputorRecordItem node : data) {
            IPreComputorRecordItem item;
            String nodeId = node.getNodeId();
            Boolean normal = node.getIsNormal();
            if (!normal.booleanValue()) continue;
            List assigneeList = node.getAssignee();
            String status = node.getStatus();
            String nodeType = node.getNodeType();
            if (!"AuditTask".equals(nodeType) || !"byHand".equals(status) || assigneeList.size() != 1 || (item = PreComputorHelper.getNextAfterAuditNode(record, nodeId, (Long)assigneeList.get(0))) == null) continue;
            node.setStatus("skip");
        }
        return record;
    }

    public static List<IPreComputorRecordItem> getNextNodeForAfterAudit(IPreComputorRecord record, String currentNodeId) {
        ArrayList<IPreComputorRecordItem> result = new ArrayList<IPreComputorRecordItem>(0);
        List data = record.getPcrData();
        ArrayList<String> currentNodeIds = new ArrayList<String>();
        currentNodeIds.add(currentNodeId);
        for (IPreComputorRecordItem node : data) {
            String nodeId = node.getNodeId();
            Boolean normal = node.getIsNormal();
            if (!normal.booleanValue() || !currentNodeIds.contains(nodeId)) continue;
            String nodeType = node.getNodeType();
            if ("EndNoneEvent".equals(nodeType)) {
                result.add(node);
                continue;
            }
            String status = node.getStatus();
            if ("byHand".equals(status) && !currentNodeId.equals(nodeId)) {
                result.add(node);
                continue;
            }
            List nextNodeId = node.getNextNodeId();
            currentNodeIds.addAll(nextNodeId);
        }
        return result;
    }

    private static IPreComputorRecord insertRecord(Long procInstId, IPreComputorRecord pcRecord, UserTask userTask, TaskEntity task) {
        if (userTask != null) {
            pcRecord.setEntryNodeId(userTask.getId());
            String nodeKey = BpmnModelUtil.getActivityNameMultiKey(userTask.getId());
            ILocaleString nodeName = BpmnModelUtil.getMultiLangFieldValue(procInstId, nodeKey, userTask.getName());
            pcRecord.setEntryNodeName(nodeName);
            DecisionOption defaultDecision = BpmnModelUtil.getDefaultOption(userTask);
            if (defaultDecision != null) {
                pcRecord.setEntryAuditNumber(defaultDecision.getNumber());
                String opKey = BpmnModelUtil.getDecisionNameMultiKey(userTask.getId(), defaultDecision.getId());
                ILocaleString optionName = BpmnModelUtil.getMultiLangFieldValue(procInstId, opKey, defaultDecision.getName());
                pcRecord.setEntryAuditName(optionName);
            }
        }
        if (task != null) {
            pcRecord.setEntryTaskId(task.getId());
        }
        return pcRecord;
    }

    public static void invalidInstanceByProcinstId(Long procinstId) {
        PreComputorInstanceEntityManager manager = Context.getCommandContext().getPreComputorEntityManager();
        manager.invalidInstanceByProcInstId(procinstId);
    }

    public static boolean existValidInstanceByProcInstId(Long procInstId) {
        PreComputorInstanceEntityManager manager = Context.getCommandContext().getPreComputorEntityManager();
        return manager.existValidInstanceByProcInstId(procInstId);
    }

    public static void deleteInstanceByProcInstId(Long procinstId) {
        PreComputorInstanceEntityManager manager = Context.getCommandContext().getPreComputorEntityManager();
        manager.deleteInstanceByProcInstId(procinstId);
    }

    public static void doPreComputorFromAuditTaskForAfterAudit(Long procInstId, String strategy, AuditTask auditTask, TaskEntity task) {
        CommandContext commandContext = Context.getCommandContext();
        if (!WfConfigurationUtil.enableAfterAuditPreComputorStorage()) {
            return;
        }
        if (auditTask == null) {
            return;
        }
        try {
            ArrayList<IPreComputorRecord> recordList = new ArrayList<IPreComputorRecord>(0);
            List<DecisionOption> dos = auditTask.getDecisionOptions();
            for (DecisionOption option : dos) {
                if (!"approve".equals(option.getAuditType())) continue;
                IPreComputorRecord pcRecord = new DefaultPrecomputatorCmd(procInstId, STRATEGY_AFTERAUDIT, option).execute(commandContext);
                pcRecord.setEntryAuditNumber(option.getNumber());
                String opKey = BpmnModelUtil.getDecisionNameMultiKey(auditTask.getId(), option.getId());
                ILocaleString optionName = BpmnModelUtil.getMultiLangFieldValue(procInstId, opKey, option.getName());
                pcRecord.setEntryAuditName(optionName);
                recordList.add(pcRecord);
            }
            if (!recordList.isEmpty()) {
                PreComputorHelper.invalidInstanceByProcinstId(procInstId);
                PreComputorInstanceEntityManager manager = commandContext.getPreComputorEntityManager();
                int maxVersion = manager.getMaxVersion(procInstId);
                for (IPreComputorRecord pcRecord : recordList) {
                    pcRecord.setStrategy(strategy);
                    pcRecord.setValidity(Boolean.TRUE);
                    pcRecord.setVersion(maxVersion);
                    pcRecord.setEntryNodeId(auditTask.getId());
                    String nodeKey = BpmnModelUtil.getActivityNameMultiKey(auditTask.getId());
                    ILocaleString nodeName = BpmnModelUtil.getMultiLangFieldValue(procInstId, nodeKey, auditTask.getName());
                    pcRecord.setEntryNodeName(nodeName);
                    pcRecord.setEntryTaskId(task.getId());
                }
            } else {
                PreComputorHelper.doPreComputor(procInstId, strategy, auditTask, task);
            }
        }
        catch (Exception e) {
            logger.info(String.format("error occur when precompute on node[%s],msg is [%s]", auditTask.getId(), WfUtils.getExceptionStacktrace(e)));
        }
    }

    public static void doPreComputorFromActivityBehavior(Long procInstId, String strategy, UserTask userTask, TaskEntity task) {
        CommandContext commandContext = Context.getCommandContext();
        if (!WfConfigurationUtil.enablePreComputorStorage()) {
            return;
        }
        if (userTask == null) {
            return;
        }
        try {
            if (PreComputorHelper.existValidInstanceByProcInstId(procInstId) && !"UserTask".equals(userTask.getType())) {
                Date schemeDate;
                Date billdate;
                QFilter procinstFilter = new QFilter("processinstanceid", "=", (Object)procInstId);
                QFilter validityFilter = new QFilter("validity", "=", (Object)Boolean.TRUE);
                QFilter[] qFilter = new QFilter[]{procinstFilter, validityFilter};
                List dym = commandContext.getPreComputorEntityManager().findByQueryFilters(qFilter, "schemeid,modifydate", null);
                PreComputorInstanceEntity entity = (PreComputorInstanceEntity)dym.get(0);
                Date entityDate = entity.getModifyDate();
                if (entityDate == null) {
                    return;
                }
                if (MetadataServiceHelper.getDataEntityType((String)task.getEntityNumber()).findProperty(MODIFYTIME) != null && (billdate = BusinessDataServiceHelper.loadSingle((Object)task.getBusinessKey(), (String)task.getEntityNumber(), (String)MODIFYTIME).getDate(MODIFYTIME)) != null && entityDate.before(billdate)) {
                    PreComputorHelper.doPreComputor(procInstId, strategy, userTask, task);
                    return;
                }
                List<DynamicResourceEntity> drEntity = commandContext.getDynamicResourceEntityManager().findByProcessInstanceId(procInstId);
                for (DynamicResourceEntity e : drEntity) {
                    if (e.getModifyDate() == null || !entityDate.before(e.getModifyDate())) continue;
                    PreComputorHelper.doPreComputor(procInstId, strategy, userTask, task);
                    return;
                }
                Long schemeid = entity.getSchemeId();
                DynamicConfigSchemeEntity dcsentity = (DynamicConfigSchemeEntity)commandContext.getDynamicConfigSchemeEntityManager().findById(schemeid, "modifyDate");
                if (dcsentity != null && (schemeDate = dcsentity.getModifyDate()) != null && entityDate.before(schemeDate)) {
                    PreComputorHelper.doPreComputor(procInstId, strategy, userTask, task);
                }
            } else {
                PreComputorHelper.doPreComputor(procInstId, strategy, userTask, task);
            }
        }
        catch (Exception e) {
            logger.info(String.format("error occur when precompute on node[%s],msg is [%s]", userTask.getId(), WfUtils.getExceptionStacktrace(e)));
        }
    }

    public static IPreComputorRecord getPreComputorRecordForFlowchar(Long procInstId) {
        CommandContext commandContext = Context.getCommandContext();
        QFilter procinstFilter = new QFilter("processinstanceid", "=", (Object)procInstId);
        QFilter validityFilter = new QFilter("validity", "=", (Object)Boolean.TRUE);
        QFilter[] qFilter = new QFilter[]{procinstFilter, validityFilter};
        List dym = commandContext.getPreComputorEntityManager().findByQueryFilters(qFilter);
        if (dym.isEmpty()) {
            return PreComputorHelper.doPreComputor(procInstId, STRATEGY_VIEWFLOWCHAR);
        }
        PreComputorInstanceEntity entity = (PreComputorInstanceEntity)dym.get(0);
        Date entityDate = entity.getModifyDate();
        List<DynamicResourceEntity> drEntity = commandContext.getDynamicResourceEntityManager().findByProcessInstanceId(procInstId);
        for (DynamicResourceEntity e : drEntity) {
            if (!entityDate.before(e.getModifyDate())) continue;
            return PreComputorHelper.doPreComputor(procInstId, STRATEGY_VIEWFLOWCHAR);
        }
        Long schemeid = entity.getSchemeId();
        String[] dcsentity = (String[])commandContext.getDynamicConfigSchemeEntityManager().findById(schemeid, "modifyDate");
        Date schemeDate = dcsentity.getModifyDate();
        if (entityDate.before(schemeDate)) {
            return PreComputorHelper.doPreComputor(procInstId, STRATEGY_VIEWFLOWCHAR);
        }
        IPreComputorRecord pcRecord = PreComputorHelper.entity2Record((PreComputorInstanceEntity)dym.get(0));
        List execution = commandContext.getExecutionEntityManager().findByQueryFilters(new QFilter[]{new QFilter("processInstanceId", "=", (Object)procInstId), new QFilter("scope", "=", (Object)Boolean.TRUE)});
        String activityId = ((ExecutionEntity)execution.get(0)).getActivityId();
        String[] activityIds = activityId.split(",");
        HashSet<String> actIdSet = new HashSet<String>(activityIds.length);
        for (String actId : activityIds) {
            actIdSet.add(actId);
        }
        List items = pcRecord.getPcrData();
        ArrayList<IPreComputorRecordItem> returnItem = new ArrayList<IPreComputorRecordItem>();
        int sequenceNum = 0;
        for (int i = 0; i < items.size(); ++i) {
            IPreComputorRecordItem item = (IPreComputorRecordItem)items.get(i);
            if (item.getIsNormal().booleanValue()) {
                if (item.getNodeType().contains("SequenceFlow")) {
                    returnItem.add(item);
                    ++sequenceNum;
                    continue;
                }
                if (actIdSet.contains(item.getNodeId())) {
                    returnItem.add(item);
                    actIdSet.addAll(item.getNextNodeId());
                    continue;
                }
                if (item.getNextNodeId() == null) continue;
                i += item.getNextNodeId().size();
                continue;
            }
            returnItem.add(item);
        }
        if (returnItem.isEmpty() || actIdSet.size() + sequenceNum > returnItem.size()) {
            return PreComputorHelper.doPreComputor(procInstId, STRATEGY_VIEWFLOWCHAR);
        }
        pcRecord.setPcrData(returnItem);
        return pcRecord;
    }

    public static IPreComputorRecord entity2Record(PreComputorInstanceEntity entity) {
        PreComputorRecord record = new PreComputorRecord();
        record.setProcessInstanceId(entity.getProcessInstanceId());
        record.setProcessDefinitionId(entity.getProcessDefinitionId());
        record.setSchemeId(entity.getSchemeId());
        record.setStrategy(entity.getStrategy());
        record.setValidity(entity.getValidity());
        record.setVersion(entity.getVersion());
        record.setBusinessKey(entity.getBusinessKey());
        record.setBillNo(entity.getBillNo());
        record.setActivityId(entity.getActivityId());
        record.setActivityName(entity.getActivityName());
        record.setEntryNodeId(entity.getEntryNodeId());
        record.setEntryNodeName(entity.getEntryNodeName());
        record.setEntryAuditNumber(entity.getEntryAuditNumber());
        record.setEntryAuditName(entity.getEntryAuditName());
        record.setEntryTaskId(entity.getEntryTaskId());
        record.setExecutionId(entity.getExecutionId());
        record.setCreateDate(entity.getCreateDate());
        record.setModifyDate(entity.getModifyDate());
        record.setPcrData(PreComputorHelper.entity2Items(entity));
        return record;
    }

    public static List<IPreComputorRecordItem> entity2Items(PreComputorInstanceEntity entity) {
        ArrayList<IPreComputorRecordItem> pcrData = new ArrayList<IPreComputorRecordItem>();
        DynamicObjectCollection collection = entity.getPreComputorResult();
        for (DynamicObject iter : collection) {
            PreComputorRecordItem item = new PreComputorRecordItem();
            item.setIsNormal(iter.getBoolean("isnormal"));
            item.setNodeId(iter.getString("nodeid"));
            item.setNodeName(iter.getLocaleString("nodename"));
            String assigneeStr = iter.getString("assignee");
            ArrayList<Long> assignee = new ArrayList<Long>();
            if (WfUtils.isNotEmpty(assigneeStr)) {
                for (String ass : assigneeStr.split(",")) {
                    assignee.add(Long.parseLong(ass));
                }
            }
            item.setAssignee(assignee);
            item.setAssigneeName(iter.getLocaleString("assigneename"));
            item.setNodeType(iter.getString("nodetype"));
            item.setStatus(iter.getString("status"));
            item.setAuditNumber(iter.getString("auditnumber"));
            item.setBizIdentifyKey(iter.getString("bizidentifykey"));
            ArrayList<String> nextNodeId = new ArrayList<String>();
            String nextNodeStr = iter.getString("nextnodeid");
            if (WfUtils.isNotEmpty(nextNodeStr)) {
                for (String nextNode : nextNodeStr.split(",")) {
                    nextNodeId.add(nextNode);
                }
            }
            item.setNextNodeId(nextNodeId);
            item.setErrType(iter.getString("errtype"));
            item.setErrMsg(iter.getLocaleString("errmsg"));
            item.setExceptionMsg(iter.getString("exceptionmsg"));
            pcrData.add(item);
        }
        return pcrData;
    }

    public static PreComputorInstanceEntity record2Entity(IPreComputorRecord record) {
        PreComputorInstanceEntityImpl entity = new PreComputorInstanceEntityImpl();
        entity.setProcessInstanceId(record.getProcessInstanceId());
        entity.setSchemeId(record.getSchemeId());
        entity.setProcessDefinitionId(record.getProcessDefinitionId());
        entity.setStrategy(record.getStrategy());
        entity.setValidity(record.getValidity());
        entity.setVersion(record.getVersion());
        entity.setBusinessKey(record.getBusinessKey());
        entity.setBillNo(record.getBillNo());
        entity.setActivityId(record.getActivityId());
        entity.setActivityName(record.getActivityName());
        entity.setEntryNodeId(record.getEntryNodeId());
        entity.setEntryNodeName(record.getEntryNodeName());
        entity.setEntryAuditNumber(record.getEntryAuditNumber());
        entity.setEntryAuditName(record.getEntryAuditName());
        entity.setEntryTaskId(record.getEntryTaskId());
        entity.setExecutionId(record.getExecutionId());
        entity.setCreateDate(record.getCreateDate());
        entity.setModifyDate(record.getModifyDate());
        DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"wf_precomputorinstance");
        Object object = newDynamicObject.get("precomputorresult");
        DynamicObjectCollection collection = (DynamicObjectCollection)object;
        DynamicObjectType type = collection.getDynamicObjectType();
        List data = record.getPcrData();
        for (IPreComputorRecordItem item : data) {
            DynamicObject instance = (DynamicObject)type.createInstance();
            instance.set("isnormal", (Object)item.getIsNormal());
            instance.set("nodeid", (Object)item.getNodeId());
            instance.set("nodename", (Object)item.getNodeName());
            List assignee = item.getAssignee();
            StringBuilder assigneeStr = new StringBuilder();
            for (Long ass : assignee) {
                if (!WfUtils.isNotEmpty(ass)) continue;
                assigneeStr.append(",").append(ass.toString());
            }
            instance.set("assignee", (Object)(WfUtils.isEmpty(assigneeStr.toString()) ? "" : WfUtils.subStringForMax(assigneeStr.substring(1), 1980)));
            instance.set("assigneename", (Object)item.getAssigneeName());
            instance.set("nodetype", (Object)item.getNodeType());
            instance.set("status", (Object)item.getStatus());
            instance.set("auditnumber", (Object)item.getAuditNumber());
            instance.set("bizidentifykey", (Object)item.getBizIdentifyKey());
            List nextNodeId = item.getNextNodeId();
            StringBuilder nextNodeStr = new StringBuilder();
            for (String nextNode : nextNodeId) {
                nextNodeStr.append(",").append(nextNode);
            }
            instance.set("nextnodeid", (Object)(WfUtils.isEmpty(nextNodeStr.toString()) ? "" : nextNodeStr.substring(1)));
            instance.set("errtype", (Object)item.getErrType());
            instance.set("errmsg", (Object)item.getErrMsg());
            instance.set("exceptionmsg", (Object)WfUtils.subStringForMax(item.getExceptionMsg(), 2000));
            instance.set("exceptionmsg_tag", (Object)item.getExceptionMsg());
            collection.add((Object)instance);
        }
        entity.setPreComputorResult(collection);
        return entity;
    }

    public static IPreComputorRecord getPreComputorRecord(Long procInstId, Long procdefId, DynamicObject dynamicObject, CommandContext commandContext, String precomputatorMode) {
        DefaultPrecomputatorCmd cmd = new DefaultPrecomputatorCmd(procdefId, procInstId, dynamicObject, precomputatorMode);
        IPreComputorRecord preComputorRecord = cmd.execute(commandContext);
        return preComputorRecord;
    }

    public static Map<String, Object> getNextPreComputorRecordItem(Long procInstId, Long procdefId, DynamicObject dynamicObject, CommandContext commandContext, String currentNodeId) {
        List pcrData;
        HashMap<String, Object> nextPreComputorMap = new HashMap<String, Object>();
        ArrayList<IPreComputorRecordItem> nextPreComputorRecordItem = new ArrayList<IPreComputorRecordItem>();
        IPreComputorRecord preComputorRecord = PreComputorHelper.getPreComputorRecord(procInstId, procdefId, dynamicObject, commandContext, "stopWhenFirstApprove");
        Long schemeId = preComputorRecord.getSchemeId();
        nextPreComputorMap.put("schemeid", schemeId);
        if (null != preComputorRecord && (pcrData = preComputorRecord.getPcrData()) != null && pcrData.size() > 0) {
            ArrayList<String> currentNodeIds = new ArrayList<String>();
            currentNodeIds.add(currentNodeId);
            for (IPreComputorRecordItem item : pcrData) {
                String preNodeId = item.getNodeId();
                String preNodeType = item.getNodeType();
                String preStatus = item.getStatus();
                if (null != currentNodeIds && currentNodeIds.contains(preNodeId)) {
                    if (!"byHand".equals(preStatus)) {
                        if ("CallActivity".equals(preNodeType) || "EndNoneEvent".equals(preNodeType)) {
                            return null;
                        }
                        currentNodeIds.addAll(item.getNextNodeId());
                        if (null != currentNodeIds && 0 != currentNodeIds.size()) continue;
                        nextPreComputorRecordItem = new ArrayList();
                        break;
                    }
                    if (preNodeId == null || preNodeType == null || !"byHand".equals(preStatus)) continue;
                    nextPreComputorRecordItem.add(item);
                    continue;
                }
                if (preNodeType == null || !"byHand".equals(preStatus)) continue;
                nextPreComputorRecordItem.add(item);
            }
        }
        nextPreComputorMap.put("afternodes", nextPreComputorRecordItem);
        return nextPreComputorMap;
    }

    public static Map<String, Object> getAfterPreComputorRecordItem(Long procInstId, Long procdefId, DynamicObject dynamicObject, CommandContext commandContext, String currentNodeId, DecisionOption decisionOption) {
        HashMap<String, Object> afterPreComputorMap = new HashMap<String, Object>();
        DefaultPrecomputatorCmd cmd = null;
        cmd = null == decisionOption ? new DefaultPrecomputatorCmd(procdefId, procInstId, dynamicObject, "default") : new DefaultPrecomputatorCmd(procInstId, "default", decisionOption);
        IPreComputorRecord preComputorRecord = cmd.execute(commandContext);
        Long schemeId = preComputorRecord.getSchemeId();
        afterPreComputorMap.put("schemeid", schemeId);
        ArrayList<IPreComputorRecordItem> afterNodeList = new ArrayList<IPreComputorRecordItem>();
        if (null != preComputorRecord) {
            ArrayList afterNodeIds = new ArrayList();
            List pcrData = preComputorRecord.getPcrData();
            if (pcrData == null || pcrData.size() == 0) {
                return afterPreComputorMap;
            }
            for (IPreComputorRecordItem iPreComputorRecordItem : pcrData) {
                String nodeId = iPreComputorRecordItem.getNodeId();
                if (!StringUtils.isNotBlank((CharSequence)nodeId)) continue;
                List nextNodeList = iPreComputorRecordItem.getNextNodeId();
                if (currentNodeId.equals(nodeId)) {
                    afterNodeIds.addAll(nextNodeList);
                }
                if (!afterNodeIds.contains(nodeId)) continue;
                String recordItemStatus = iPreComputorRecordItem.getStatus();
                if ("byAuto".equals(recordItemStatus) || "byHand".equals(recordItemStatus)) {
                    List nextNodeIds = iPreComputorRecordItem.getNextNodeId();
                    afterNodeIds.addAll(nextNodeIds);
                    if (afterNodeList.contains(iPreComputorRecordItem) || !"byHand".equals(recordItemStatus)) continue;
                    afterNodeList.add(iPreComputorRecordItem);
                    continue;
                }
                afterNodeIds.addAll(iPreComputorRecordItem.getNextNodeId());
            }
        }
        afterPreComputorMap.put("afternodes", afterNodeList);
        return afterPreComputorMap;
    }

    public static Map<String, Object> getAfterPreComputorRecordItem(Long procInstId, Long procdefId, DynamicObject dynamicObject, CommandContext commandContext, String currentNodeId) {
        return PreComputorHelper.getAfterPreComputorRecordItem(procInstId, procdefId, dynamicObject, commandContext, currentNodeId, null);
    }
}

