/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.precomputation.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfAfterAuditUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.calculator.LastAssigneeMacroParserImpl;
import kd.bos.workflow.engine.impl.cmd.precomputation.PercomputatorUtils;
import kd.bos.workflow.engine.impl.cmd.precomputation.impl.UserTaskPercomputator;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;

public class AuditTaskPercomputator
extends UserTaskPercomputator {
    private static final String RESULTNUMBER = "resultNumber";

    public AuditTaskPercomputator(Long procinstId) {
        super(procinstId);
    }

    @Override
    public void doApprove(UserTask userTask, TaskEntity task, ExecutionEntity execution, List<Long> participants, DecisionOption approveDecision) {
        AuditTask auditTask = (AuditTask)userTask;
        DecisionOption adapterDecision = approveDecision;
        boolean isRepeater = false;
        String executionType = "byHand";
        ArrayList<Long> assigneeIds = new ArrayList<Long>();
        boolean rejectBackNotSkip = DynamicFlowUtil.rejectBackNotSkip(execution, userTask.getId());
        if (!rejectBackNotSkip) {
            if (Boolean.TRUE.equals(this.process.getAutoAuditWhenSamePerson()) && participants != null && WfUtils.isNotEmpty(task.getStarterId()) && participants.contains(task.getStarterId())) {
                DecisionOption defaultOption = WfUtils.getDefaultDecision(auditTask);
                if ("approve".equals(defaultOption.getAuditType())) {
                    executionType = "byAuto";
                    adapterDecision = defaultOption;
                    assigneeIds.add(task.getStarterId());
                    logger.debug(String.format("\u8282\u70b9%s\u7b26\u5408\u4e1a\u52a1\u63d0\u5355\u4eba\u76f8\u540c\u81ea\u52a8\u5ba1\u6279\uff0c\u5904\u7406\u4eba%s\uff0c\u51b3\u7b56\u9879%s\uff0c\u6267\u884c\u7c7b\u578b%s", auditTask.getId(), task.getStarterId(), adapterDecision.getNumber(), executionType));
                }
            } else if (this.isAutoAuditTask(auditTask, task, execution)) {
                String autoDecision = auditTask.getAutoAudit().getAutoDecisionWhenMatch();
                for (DecisionOption option : auditTask.getDecisionOptions()) {
                    if (!autoDecision.equals(option.getNumber()) || !"approve".equals(option.getAuditType())) continue;
                    Boolean isAutoAuditor = auditTask.getAutoAudit().getParticipantAsAutoAuditor();
                    if (isAutoAuditor != null && isAutoAuditor.booleanValue()) {
                        assigneeIds = participants == null ? new ArrayList<Long>() : participants;
                    }
                    executionType = "byAuto";
                    adapterDecision = WfUtils.getDecisionOption(auditTask, autoDecision);
                    logger.debug(String.format("\u8282\u70b9%s\u7b26\u5408\u4e1a\u52a1\u63d0\u5355\u4eba\u76f8\u540c\u81ea\u52a8\u5ba1\u6279\uff0c\u5904\u7406\u4eba%s\uff0c\u51b3\u7b56\u9879%s\uff0c\u6267\u884c\u7c7b\u578b%s", auditTask.getId(), "[]", adapterDecision.getNumber(), executionType));
                    break;
                }
            } else {
                isRepeater = this.isRepeater(auditTask, task, participants, execution, approveDecision);
                assigneeIds.addAll(participants);
            }
        }
        if (!isRepeater) {
            this.setApprovalResult(auditTask, participants, assigneeIds, adapterDecision, executionType, execution);
            if (!"byAuto".equals(executionType)) {
                this.stopCalculator(auditTask);
            }
        }
    }

    boolean isRepeater(AuditTask auditTask, TaskEntity task, List<Long> participants, ExecutionEntity execution, DecisionOption approveDecision) {
        boolean isRepeater = false;
        boolean allowRepeaters = WfConfigurationUtil.getRepeaterApprovalConfig(participants);
        Boolean canDoAfterAudit = WfAfterAuditUtil.canDoAfterAudit(new HashSet<Long>(participants), this.process);
        if ("afteraudit".equals(this.model) && canDoAfterAudit.booleanValue()) {
            return isRepeater;
        }
        if (allowRepeaters && auditTask.isRepeaterbtn() && CollectionUtil.isNotEmpty(participants)) {
            boolean isRepeaterAndApproval;
            List<Map<String, String>> repeaterInfos = PercomputatorUtils.getRepeaterInfo(auditTask, task, participants, execution);
            boolean bl = isRepeaterAndApproval = !repeaterInfos.isEmpty();
            if (isRepeaterAndApproval) {
                if ("skip".equals(auditTask.getRepeaterModel())) {
                    String nodeId;
                    logger.debug(String.format("\u8282\u70b9%s\u7b26\u5408\u91cd\u590d\u5ba1\u6279\u4eba\u8df3\u8fc7\uff01", auditTask.getId()));
                    isRepeater = CollectionUtil.isNotEmpty(repeaterInfos) && repeaterInfos.size() == 1 ? (nodeId = repeaterInfos.get(0).get("nodeId")) == null || !nodeId.contains("UserTask") : true;
                    this.setSkipResult(auditTask, participants, execution);
                } else if ("auto".equals(auditTask.getRepeaterModel())) {
                    Map map;
                    HashSet<String> approvalNumbers = new HashSet<String>();
                    List<DecisionOption> options = auditTask.getDecisionOptions();
                    String auditNumber = null;
                    HashMap<String, DecisionOption> optionMap = new HashMap<String, DecisionOption>();
                    for (DecisionOption decisionOption : options) {
                        if (!"approve".equals(decisionOption.getAuditType())) continue;
                        auditNumber = decisionOption.getNumber();
                        approvalNumbers.add(auditNumber);
                        optionMap.put(auditNumber, decisionOption);
                    }
                    Iterator<Object> iterator = repeaterInfos.iterator();
                    while (iterator.hasNext() && !(isRepeater = approvalNumbers.contains(auditNumber = (String)(map = (Map)iterator.next()).get(RESULTNUMBER)) && WfUtils.isNotEmpty(auditNumber))) {
                    }
                    if (isRepeater) {
                        for (Map map2 : repeaterInfos) {
                            String assigneeId = (String)map2.get("assigneeId");
                            ArrayList<Long> assigneeIdList = new ArrayList<Long>(1);
                            assigneeIdList.add(Long.valueOf(assigneeId));
                            logger.debug(String.format("\u8282\u70b9%s\u7b26\u5408\u91cd\u590d\u5ba1\u6279\u4eba\u81ea\u52a8\u5ba1\u6279\uff0c\u5904\u7406\u4eba%s\uff0c\u51b3\u7b56\u9879%s\uff01", auditTask.getId(), assigneeId, auditNumber));
                            this.setApprovalResult(auditTask, participants, assigneeIdList, (DecisionOption)optionMap.get(auditNumber), "byAuto", execution);
                        }
                    }
                }
            }
            if (isRepeater) {
                return isRepeater;
            }
            String lastAssignee = PercomputatorUtils.getLastAssignee(auditTask.getId(), execution);
            if (WfUtils.isEmpty(lastAssignee)) {
                lastAssignee = (String)new LastAssigneeMacroParserImpl("lastAssignee").parseMacro(execution);
            }
            if (lastAssignee.equals(String.valueOf(participants.get(0)))) {
                if ("skip".equals(this.process.getProcessMode())) {
                    isRepeater = true;
                    this.setSkipResult(auditTask, participants, execution);
                } else if ("auto".equals(this.process.getProcessMode())) {
                    this.setApprovalResult(auditTask, participants, participants, approveDecision, "byAuto", execution);
                }
            }
        }
        return isRepeater;
    }

    protected boolean isAutoAuditTask(AuditTask auditTask, TaskEntity task, ExecutionEntity execution) {
        boolean autoAudit = false;
        if (task == null || auditTask.getAutoAudit() == null) {
            return autoAudit;
        }
        ConditionalRuleEntityImpl rule = auditTask.getAutoAudit().getAutoAuditCondition();
        if (auditTask.getAutoAudit().isAutoAuditWhenMatch() && WfUtils.isNotEmpty(auditTask.getAutoAudit().getAutoDecisionWhenMatch()) && rule != null) {
            String expression = rule.getExpression();
            if ("afteraudit".equals(this.model) && WfUtils.isNotEmpty(expression)) {
                for (String autoExpression : this.afterAuditNodeSet) {
                    if (!expression.contains(autoExpression)) continue;
                    this.stopContinue();
                    ILocaleString lString = WfUtils.getPromptWordLocaleString(String.format("\u8282\u70b9\u201c%1$s(%2$s)\u201d\u81ea\u52a8\u5ba1\u6279\u6761\u4ef6\u5e94\u7528\u4e86\u540e\u5ba1\u8282\u70b9\u7684\u6d41\u7a0b\u5c5e\u6027\uff1a\u201c%3$s\u201d\u3002", auditTask.getName(), auditTask.getNumber(), autoExpression), "AuditTaskPercomputator_1", "bos-wf-engine");
                    this.addErrNodeResult(auditTask, "afteraudit", lString, "");
                    logger.debug(lString.getLocaleValue());
                    break;
                }
            }
            if (WfUtils.isNotEmpty(rule.getExpression()) && ConditionUtil.hasTrueCondition(rule.getExpression(), (VariableScope)task, null)) {
                return true;
            }
            if (WfUtils.isEmpty(expression) && WfUtils.isNotEmpty(rule.getPlugin()) && ConditionUtil.hasTrueCondition(rule, (VariableScope)execution, "percomputator-isAutoAuditTask")) {
                return true;
            }
        }
        return autoAudit;
    }

    @Override
    protected DecisionOption getApproveDecision(UserTask userTask) {
        List<DecisionOption> options = userTask.getDecisionOptions();
        DecisionOption approveDecision = null;
        for (DecisionOption d : options) {
            if (!"approve".equals(d.getAuditType())) continue;
            if (approveDecision == null) {
                approveDecision = d;
            }
            if (!d.isDefaultDecision()) continue;
            return d;
        }
        return approveDecision;
    }
}

