/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.precomputation.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.converter.util.ModelConfigUtil;
import kd.bos.workflow.bpmn.model.AfterAuditModel;
import kd.bos.workflow.bpmn.model.AllowNextPersonSetting;
import kd.bos.workflow.bpmn.model.AllowNextPersonSettingModel;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.InclusiveGateway;
import kd.bos.workflow.bpmn.model.JudgeTask;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.domain.model.NodeForkJoinModel;
import kd.bos.workflow.engine.WfAfterAuditUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.agenda.ForkJoinUtils;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.cmd.precomputation.IPercomputator;
import kd.bos.workflow.engine.impl.cmd.precomputation.NodeTempVariable;
import kd.bos.workflow.engine.impl.cmd.precomputation.PercomputatorUtils;
import kd.bos.workflow.engine.impl.cmd.precomputation.PreComputorRecord;
import kd.bos.workflow.engine.impl.cmd.precomputation.PreComputorRecordItem;
import kd.bos.workflow.engine.impl.cmd.precomputation.impl.AuditTaskPercomputator;
import kd.bos.workflow.engine.impl.cmd.precomputation.impl.UserTaskPercomputator;
import kd.bos.workflow.engine.impl.cmd.precomputation.impl.YzjTaskPercomputator;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PreComputatorExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.ProcessInstanceHelper;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.engine.precomputor.IPreComputorRecord;
import kd.bos.workflow.engine.precomputor.IPreComputorRecordItem;

public class DefaultPrecomputatorCmd
implements Command<IPreComputorRecord>,
IPercomputator {
    protected static final Log logger = LogFactory.getLog(DefaultPrecomputatorCmd.class);
    protected Long procInstId;
    protected Long procDefId;
    protected Long schemeId;
    protected DynamicObject billDym;
    protected String model;
    public static final String MODEL_DEFAULT = "default";
    public static final String MODEL_STOPWHENFIRSTAPPROVE = "stopWhenFirstApprove";
    public static final String MODEL_AFTERAUDIT = "afteraudit";
    protected Process process;
    protected CommandContext commandContext;
    protected LinkedList<ContinueOperation> agenda = new LinkedList();
    protected Map<String, DefaultPrecomputatorCmd> percomputators = new HashMap<String, DefaultPrecomputatorCmd>();
    protected Map<String, Integer> flownodeIndexMap = new HashMap<String, Integer>();
    protected Set<String> joinNodeIds = new HashSet<String>();
    protected Map<String, Integer> nodeCounterTimeMap = new HashMap<String, Integer>();
    protected Set<String> prepareNode = new HashSet<String>();
    protected List<TaskEntity> currentRealTasks = new ArrayList<TaskEntity>();
    protected PreComputorRecord pcRecord = new PreComputorRecord();
    public static final String NODETYPE_NODE = "node";
    public static final String NODETYPE_EDGE = "edge";
    public static final String STATUS_CURRENT = "current";
    public static final String STATUS_THROUGH = "through";
    public static final String STATUS_SKIP = "skip";
    public static final String STATUS_AUTONODE = "autonode";
    protected List<IPreComputorRecordItem> result = new ArrayList<IPreComputorRecordItem>();
    protected boolean canLeave = true;
    protected Set<Long> keyAuditorSet = new HashSet<Long>();
    protected Set<String> afterAuditNodeSet = new HashSet<String>();
    protected Map<String, Object> entryNodeMsg = new HashMap<String, Object>();
    protected JSONObject resourceMultiLangData = null;
    public static final String OPERATION_TYPE_THROUGH = "through";
    public static final String OPERATION_TYPE_LEAVE = "leave";
    protected Map<String, FlowNode> stopKey = new HashMap<String, FlowNode>();

    public DefaultPrecomputatorCmd(Long procinstId) {
        this.procInstId = procinstId;
        this.model = MODEL_DEFAULT;
    }

    public DefaultPrecomputatorCmd(Long procinstId, String model) {
        this.procInstId = procinstId;
        this.model = model;
    }

    public DefaultPrecomputatorCmd(Long procdefId, DynamicObject dym) {
        this.procDefId = procdefId;
        this.billDym = dym;
        this.model = MODEL_DEFAULT;
    }

    public DefaultPrecomputatorCmd(Long procDefId, Long schemeId, DynamicObject dym) {
        this.procDefId = procDefId;
        this.schemeId = schemeId;
        this.billDym = dym;
    }

    public DefaultPrecomputatorCmd(Long procdefId, DynamicObject dym, String model) {
        this.procDefId = procdefId;
        this.billDym = dym;
        this.model = model;
    }

    public DefaultPrecomputatorCmd(Long procdefId, Long procinstId, DynamicObject dym, String model) {
        this.procInstId = procinstId;
        this.procDefId = procdefId;
        this.billDym = dym;
        this.model = model;
    }

    public DefaultPrecomputatorCmd(Long procinstId, String model, DecisionOption decisonOption) {
        this.procInstId = procinstId;
        this.model = model;
        this.entryNodeMsg.put("decisionOption", decisonOption);
    }

    protected void stopContinue() {
        this.canLeave = false;
    }

    @Override
    public Boolean isCanLeave() {
        return this.canLeave;
    }

    protected void initPercomputatorProps(DefaultPrecomputatorCmd defaultPrecomputatorCmd) {
        this.agenda = defaultPrecomputatorCmd.agenda;
        this.commandContext = defaultPrecomputatorCmd.commandContext;
        this.percomputators = defaultPrecomputatorCmd.percomputators;
        this.process = defaultPrecomputatorCmd.process;
        this.procInstId = defaultPrecomputatorCmd.procInstId;
        this.result = defaultPrecomputatorCmd.result;
        this.flownodeIndexMap = defaultPrecomputatorCmd.flownodeIndexMap;
        this.joinNodeIds = defaultPrecomputatorCmd.joinNodeIds;
        this.nodeCounterTimeMap = defaultPrecomputatorCmd.nodeCounterTimeMap;
        this.stopKey = defaultPrecomputatorCmd.stopKey;
        this.model = defaultPrecomputatorCmd.model;
        this.prepareNode = defaultPrecomputatorCmd.prepareNode;
        this.pcRecord = defaultPrecomputatorCmd.pcRecord;
        this.keyAuditorSet = defaultPrecomputatorCmd.keyAuditorSet;
        this.afterAuditNodeSet = defaultPrecomputatorCmd.afterAuditNodeSet;
        this.entryNodeMsg = defaultPrecomputatorCmd.entryNodeMsg;
        this.canLeave = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPreComputorRecord execute(CommandContext commandContext) {
        block24: {
            ILocaleString lString;
            logger.debug(String.format("\u5f00\u59cb\u6d41\u7a0b\u9884\u6d4bprocInstid=%s,procdefId=%s,\u5355\u636e%s", this.procInstId, this.procDefId, this.billDym == null ? "kong" : this.billDym.getPkValue()));
            this.commandContext = commandContext;
            try {
                if (this.billDym != null) {
                    commandContext.setParsedBusinessObject(this.billDym);
                }
                if (WfUtils.isNotEmpty(this.procInstId)) {
                    this.initByProcInst();
                } else if (WfUtils.isNotEmpty(this.procDefId) && this.billDym != null) {
                    this.initByProcDef();
                } else {
                    ILocaleString lString2 = WfUtils.getPromptWordLocaleString("\u6d41\u7a0b\u6570\u636e\u5f02\u5e38\uff0c\u9700\u63d0\u4f9b\u6d41\u7a0b\u5b9e\u4f8bID\u6216\u6d41\u7a0b\u5b9a\u4e49ID\u3001\u5355\u636e\u6570\u636e\u3002", "DefaultPrecomputatorCmd_0", "bos-wf-engine");
                    this.addErrNodeResult(null, "data", lString2, "");
                    logger.warn("\u6570\u636e\u5f02\u5e38\uff0c\u9700\u63d0\u4f9b\u6d41\u7a0b\u5b9e\u4f8bid\u6216\u6d41\u7a0b\u5b9a\u4e49id+\u5355\u636e\u6570\u636e\u3002");
                }
            }
            catch (Exception e) {
                lString = WfUtils.getPromptWordLocaleString("\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", "DefaultPrecomputatorCmd_1", "bos-wf-engine");
                this.addErrNodeResult(null, "initialize", lString, e.getMessage());
                logger.warn("\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + WfUtils.getExceptionStacktrace(e));
            }
            try {
                if (MODEL_AFTERAUDIT.equals(this.model)) {
                    AfterAuditModel afterAuditModel = this.process.getAfterAudit();
                    if (afterAuditModel == null || !afterAuditModel.getAfterAuditbtn().booleanValue()) {
                        this.model = MODEL_DEFAULT;
                    } else if ("auditor".equals(afterAuditModel.getPersonRange())) {
                        List<Long> keyAuditor = afterAuditModel.getKeyAuditor();
                        if (keyAuditor == null || keyAuditor.isEmpty() || WfAfterAuditUtil.getPersonByKeyAuditor(keyAuditor).isEmpty()) {
                            this.model = MODEL_DEFAULT;
                        } else {
                            this.keyAuditorSet = WfAfterAuditUtil.getPersonByKeyAuditor(afterAuditModel.getKeyAuditor());
                        }
                    } else {
                        this.keyAuditorSet.add(0L);
                    }
                }
                this.startPrecomputation(commandContext);
                if (this.currentRealTasks.isEmpty()) break block24;
            }
            catch (Exception e) {
                try {
                    lString = WfUtils.getPromptWordLocaleString("\u9884\u8ba1\u7b97\u8fd0\u7b97\u5f02\u5e38\u3002", "DefaultPrecomputatorCmd_2", "bos-wf-engine");
                    this.addErrNodeResult(null, "computor", lString, e.getMessage());
                    logger.warn("\u9884\u8ba1\u7b97\u8fd0\u7b97\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + WfUtils.getExceptionStacktrace(e));
                    if (this.currentRealTasks.isEmpty()) break block24;
                }
                catch (Throwable throwable) {
                    if (!this.currentRealTasks.isEmpty()) {
                        for (TaskEntity task : this.currentRealTasks) {
                            task.setExecution(null);
                        }
                    }
                    throw throwable;
                }
                for (TaskEntity task : this.currentRealTasks) {
                    task.setExecution(null);
                }
            }
            for (TaskEntity task : this.currentRealTasks) {
                task.setExecution(null);
            }
        }
        if (!MODEL_STOPWHENFIRSTAPPROVE.equals(this.model)) {
            for (Map.Entry<String, Integer> entry : this.flownodeIndexMap.entrySet()) {
                if (entry.getValue() <= 0) continue;
                String nodeId = entry.getKey();
                FlowNode flowNode = (FlowNode)this.process.getFlowElementMap().get(nodeId);
                ILocaleString lString = this.formatTips(flowNode, WfUtils.getPromptWordLocaleString("\u672a\u80fd\u8ba1\u7b97\u5230\u6240\u6709\u5165\u53e3\u7ebf\u3002", "DefaultPrecomputatorCmd_4", "bos-wf-engine"));
                this.addErrNodeResult(flowNode, "missinedge", lString, "");
                if (flowNode == null) continue;
                logger.info("\u6c47\u805a\u8282\u70b9" + flowNode.getName() + "(" + flowNode.getNumber() + ")\u672a\u80fd\u8ba1\u7b97\u5230\u6240\u6709\u5165\u53e3\u7ebf\u3002");
            }
        }
        this.pcRecord.setPcrData(this.result);
        return this.pcRecord;
    }

    private void initByProcDef() {
        BpmnModel bpmnModel;
        BusinessModelVariableScope variableScope = new BusinessModelVariableScope(this.billDym);
        if (this.schemeId == null) {
            this.schemeId = BpmnModelUtil.filterSchemeByProcdefId(this.commandContext, this.procDefId, variableScope);
        }
        this.process = (bpmnModel = ProcessDefinitionUtil.getBpmnModelBySchemeId(this.schemeId)) != null ? bpmnModel.getMainProcess() : ProcessDefinitionUtil.getProcessByProcDefId(this.procDefId);
        DynamicObject dym = this.billDym;
        PreComputatorExecutionEntityImpl preExecution = new PreComputatorExecutionEntityImpl();
        preExecution.setProcessInstanceId(this.procInstId);
        preExecution.setParentId(this.procInstId);
        preExecution.setSchemeId(this.schemeId);
        preExecution.setProcessDefinitionId(this.procDefId);
        preExecution.setSuperExecutionId(0L);
        preExecution.setRootProcessInstanceId(this.procInstId);
        String activityId = this.process.getInitialFlowElement().getId();
        preExecution.setActivityId(activityId);
        String key = BpmnModelUtil.getActivityNameMultiKey(activityId);
        ILocaleString nodeName = BpmnModelUtil.getMultiLangFieldValue(this.procInstId, key, this.process.getInitialFlowElement().getName());
        preExecution.setActivityName(nodeName);
        preExecution.setActive(Boolean.TRUE);
        preExecution.setBillExecution(Boolean.FALSE);
        preExecution.setScope(Boolean.FALSE);
        preExecution.setEventScope(Boolean.FALSE);
        preExecution.setMultiInstanceRoot(Boolean.FALSE);
        preExecution.setSuspensionState("1");
        preExecution.setCreateDate(WfUtils.now());
        preExecution.setCreatorId(Long.valueOf(RequestContext.get().getUserId()));
        preExecution.setStartUserId(Long.valueOf(RequestContext.get().getUserId()));
        preExecution.setCountEnabled(Boolean.FALSE);
        preExecution.setEventSubscriptionCount(0);
        preExecution.setTaskCount(0);
        preExecution.setJobCount(0);
        preExecution.setTimerJobCount(0);
        preExecution.setSuspendedJobCount(0);
        preExecution.setDeadLetterJobCount(0);
        preExecution.setVariableCount(0);
        preExecution.setIdentityLinkCount(0);
        DynamicObjectType type = dym.getDynamicObjectType();
        String entityNumber = "";
        if (type != null) {
            entityNumber = dym.getDynamicObjectType().getName();
        }
        preExecution.setEntityNumber(entityNumber);
        preExecution.setTransientBill(dym);
        if (dym.getPkValue() != null) {
            preExecution.setBusinessKey(dym.getPkValue().toString());
        }
        preExecution.setMainOrgId(0L);
        preExecution.setTestingPlanId(0L);
        preExecution.setBillNo(TaskBehaviorUtil.getTaskBillNo(entityNumber, dym));
        FlowNode flowNode = (FlowNode)this.process.getFlowElement(activityId);
        preExecution.setTransientVariable("percomputation_ctx", preExecution.getTempVariableMap());
        preExecution.setVariable("isPreComputator", true);
        ContinueOperation throughOperation = new ContinueOperation(flowNode, preExecution, "through");
        if (!this.isContainsAgenda(throughOperation)) {
            this.agenda.add(throughOperation);
        }
        ProcessInstanceHelper processInstanceHelper = this.commandContext.getProcessEngineConfiguration().getProcessInstanceHelper();
        preExecution.setVariablesLocal(processInstanceHelper.processVariables(this.process.getVariables(), preExecution));
        preExecution.setProcessInstance(preExecution);
        this.setExecutionRuntimeAttribute(preExecution);
    }

    private void initByProcInst() {
        this.process = ProcessDefinitionUtil.getProcessByProcInstId(this.procInstId);
        List<ExecutionEntity> tmpExes = this.commandContext.getExecutionEntityManager().findChildExecutionsByProcessInstanceId(this.procInstId);
        List cancelActInsts = this.commandContext.getHistoricActivityInstanceEntityManager().findByQueryFilters(new QFilter[]{new QFilter("processInstanceId", "=", (Object)this.procInstId).and("executionType", "=", (Object)"cancel")}, "executionid,activitytype", null);
        HashSet<Long> cancelExe = new HashSet<Long>(16);
        if (cancelActInsts != null) {
            for (HistoricActivityInstanceEntity i : cancelActInsts) {
                ExecutionEntity e;
                cancelExe.add(i.getExecutionId());
                if (!"YunzhijiaTask".equals(i.getActivityType()) || (e = (ExecutionEntity)this.commandContext.getExecutionEntityManager().findById(i.getExecutionId())) == null) continue;
                cancelExe.add(e.getParentId());
            }
        }
        Map<String, NodeForkJoinModel> models = this.process.getForkJoinModels();
        HashMap<String, NodeTempVariable> tempVariableMap = new HashMap<String, NodeTempVariable>();
        ExecutionEntity procinst = null;
        for (int i = 0; i < tmpExes.size(); ++i) {
            String actId;
            FlowNode flowNode;
            ExecutionEntity e = tmpExes.get(i);
            if (WfUtils.isNotEmpty(e.getId()) && e.getId().equals(e.getProcessInstanceId())) {
                this.setExecutionRuntimeAttribute(e);
            }
            if (e.isScope() || cancelExe.contains(e.getId()) || (flowNode = (FlowNode)this.process.getFlowElement(actId = e.getActivityId())) == null || flowNode instanceof BoundaryEvent || flowNode instanceof AutoTask || flowNode instanceof InclusiveGateway || !e.isActive() && !(flowNode instanceof YunzhijiaTask) && flowNode instanceof AuditTask || !this.prepareNode.add(actId)) continue;
            if (e.getCurrentTask() != null) {
                this.currentRealTasks.add(e.getCurrentTask());
            }
            NodeForkJoinModel fjModel = models.get(actId);
            PreComputatorExecutionEntityImpl preExecution = new PreComputatorExecutionEntityImpl((ExecutionEntityImpl)e);
            preExecution.setVariable("auditNumber", "Consent");
            if (fjModel != null) {
                String latestForkNodeId = fjModel.getLatestForkNode();
                if (WfUtils.isNotEmpty(latestForkNodeId)) {
                    this.flownodeIndexMap.put(fjModel.getLatestJoinNode(), this.getNoOfShouldSurvive(fjModel.getLatestJoinNode(), (FlowNode)this.process.getFlowElement(latestForkNodeId), preExecution, actId));
                    this.joinNodeIds.add(fjModel.getLatestJoinNode());
                }
                if (fjModel.isForkNode()) {
                    this.flownodeIndexMap.putIfAbsent(fjModel.getPairJoinNodeId(), this.getNoOfShouldSurvive(fjModel.getPairJoinNodeId(), (FlowNode)this.process.getFlowElement(actId), preExecution, actId));
                    this.joinNodeIds.add(fjModel.getPairJoinNodeId());
                }
                if (fjModel.isJoinNode() && (WfUtils.isEmpty(e.getCurrentTaskId()) || e.getCurrentTask() == null)) {
                    this.flownodeIndexMap.putIfAbsent(actId, this.getNoOfShouldSurvive(actId, (FlowNode)this.process.getFlowElement(fjModel.getPairForkNodeId()), preExecution, actId));
                    this.joinNodeIds.add(actId);
                    continue;
                }
            }
            preExecution.setTransientBill(this.billDym);
            preExecution.setTempVariableMap(tempVariableMap);
            preExecution.setTransientVariable("percomputation_ctx", preExecution.getTempVariableMap());
            if (procinst == null) {
                procinst = preExecution.getProcessInstance();
            } else {
                preExecution.setProcessInstance(procinst);
            }
            preExecution.setVariables(e.getVariables());
            preExecution.setVariable("isPreComputator", true);
            ContinueOperation throughOperation = new ContinueOperation(flowNode, preExecution, "through");
            if (this.isContainsAgenda(throughOperation)) continue;
            this.agenda.add(throughOperation);
        }
    }

    private Integer getNoOfShouldSurvive(String joinNodeId, FlowNode forkNode, ExecutionEntity execution, String currActid) {
        String forkNodeId = forkNode.getId();
        ExecutionEntity procinst = (ExecutionEntity)this.commandContext.getExecutionEntityManager().findById(execution.getProcessInstanceId());
        int cycle = ForkJoinUtils.getEnterForkCycle(forkNodeId, procinst);
        String joinFlag = forkNodeId + "$" + cycle + "$" + joinNodeId;
        Integer noOfShouldSurvive = (Integer)ForkJoinUtils.getNoOfShouldSurvive(joinFlag, procinst);
        Object noOfArrived = null;
        if (!forkNode.getId().equals(currActid) || "reject".equals(forkNode.getPassTypeAfterInnerReject())) {
            noOfArrived = ForkJoinUtils.getNoOfArrived(joinFlag, procinst);
        }
        Integer outGoSize = forkNode.getOutgoingFlows().size();
        for (SequenceFlow sequenceFlow : forkNode.getOutgoingFlows()) {
            Integer n;
            Integer n2;
            if (sequenceFlow.isDynamic()) {
                n2 = outGoSize;
                n = outGoSize = Integer.valueOf(outGoSize - 1);
            }
            if (!currActid.equals(forkNodeId) || ConditionUtil.hasTrueCondition(sequenceFlow, execution)) continue;
            n2 = outGoSize;
            n = outGoSize = Integer.valueOf(outGoSize - 1);
        }
        if ("leavewhenfristone".equals(forkNode.getOutSet())) {
            outGoSize = 1;
        }
        if (noOfShouldSurvive == null || outGoSize < noOfShouldSurvive) {
            noOfShouldSurvive = outGoSize;
        }
        if (noOfArrived != null) {
            Integer tmp = noOfShouldSurvive - (Integer)noOfArrived;
            noOfShouldSurvive = tmp == 0 ? noOfShouldSurvive : tmp;
        }
        return noOfShouldSurvive;
    }

    private void setExecutionRuntimeAttribute(ExecutionEntity e) {
        this.pcRecord.setProcessInstanceId(e.getProcessInstanceId());
        this.pcRecord.setProcessDefinitionId(e.getProcessDefinitionId());
        this.pcRecord.setSchemeId(e.getSchemeId());
        this.pcRecord.setBusinessKey(e.getBusinessKey());
        this.pcRecord.setBillNo(e.getBillNo());
        this.pcRecord.setExecutionId(e.getProcessInstanceId());
        this.pcRecord.setActivityId(e.getActivityId());
        this.pcRecord.setActivityName(e.getActivityName());
    }

    public void startPrecomputation(CommandContext commandContext) {
        while (!this.agenda.isEmpty()) {
            ContinueOperation operation = this.agenda.poll();
            FlowNode flowNode = operation.flowNode;
            logger.debug(String.format("\u5f00\u59cb\u6267\u884c\u8282\u70b9%s\u7684%s\u7c7b\u578b\u7684\u6d41\u8f6c!", flowNode.getId(), operation.type));
            if (ForkJoinUtils.isJoinNode(flowNode) && this.flownodeIndexMap.containsKey(flowNode.getId()) && 0 < this.flownodeIndexMap.get(flowNode.getId())) {
                logger.debug("\u4e0d\u7b26\u5408\u6c47\u805a\u8282\u70b9\u6761\u4ef6\uff0c\u629b\u5f03\uff01");
                continue;
            }
            DefaultPrecomputatorCmd computator = this.getPercomputator(flowNode);
            if (OPERATION_TYPE_LEAVE.equals(operation.type)) {
                computator.leave(commandContext, operation.execution, flowNode);
                continue;
            }
            int time = this.getNodeCalcuTimes(flowNode);
            if (time > 5) {
                ILocaleString lString = this.formatTips(flowNode, WfUtils.getPromptWordLocaleString("\u5b58\u5728\u5faa\u73af\u6267\u884c\uff0c\u8ba1\u7b97\u7ed3\u675f\uff0c\u8be5\u60c5\u51b5\u4e0d\u5f71\u54cd\u6d41\u7a0b\u5ba1\u6279\u3002", "DefaultPrecomputatorCmd_6", "bos-wf-engine"));
                this.addErrNodeResultForLoop(flowNode, "tip", lString, "");
                this.stopContinue();
                logger.warn("\u8282\u70b9" + flowNode.getName() + "(" + flowNode.getNumber() + ")\u91cd\u590d\u591a\u6b21\u8ba1\u7b97\uff0c\u9884\u6d4b\u5904\u4e8e\u5faa\u73af\u4e2d\uff0c\u8ba1\u7b97\u7ed3\u675f\u3002");
                continue;
            }
            computator.through(commandContext, operation.execution, flowNode);
            if (!this.isContinueCalculator(flowNode, computator)) continue;
            this.planLeaveOperation(operation.execution, flowNode);
        }
    }

    private int getNodeCalcuTimes(FlowNode flowNode) {
        String nodeId = flowNode.getId();
        int time = 1;
        if (this.nodeCounterTimeMap.containsKey(nodeId)) {
            time = this.nodeCounterTimeMap.get(nodeId) + 1;
        }
        this.nodeCounterTimeMap.put(nodeId, time);
        return time;
    }

    public void stopCalculator(FlowNode flowNode) {
        if (MODEL_STOPWHENFIRSTAPPROVE.equals(this.model) && !this.prepareNode.contains(flowNode.getId())) {
            this.stopKey.put(flowNode.getId(), flowNode);
        }
    }

    public boolean isContinueCalculator(FlowNode flowNode, IPercomputator computator) {
        return computator.isCanLeave() != false && this.stopKey.remove(flowNode.getId()) == null;
    }

    public void planThroughOperation(ExecutionEntity execution, FlowNode flowNode) {
        execution.setCurrentFlowElement(flowNode);
        ContinueOperation throughOperation = new ContinueOperation(flowNode, execution, "through");
        if (ForkJoinUtils.isJoinNode(flowNode) && this.process.getForkJoinModels().get(flowNode.getId()).isJoinNode()) {
            String joinNodeId = flowNode.getId();
            if (this.flownodeIndexMap.containsKey(joinNodeId)) {
                int index = this.flownodeIndexMap.get(joinNodeId);
                if (index == 1) {
                    if (this.isContainsAgenda(throughOperation)) {
                        logger.warn(String.format("\u6c47\u805a\u8282\u70b9%s\u5df2\u7ecf\u88ab\u653e\u5165\u6392\u671f\uff0c\u8fd9\u4e2a\u662f\u6709\u95ee\u9898\u7684\uff01", joinNodeId));
                    } else {
                        this.agenda.add(throughOperation);
                    }
                    this.flownodeIndexMap.remove(joinNodeId);
                } else {
                    this.flownodeIndexMap.put(joinNodeId, --index);
                }
            } else {
                ILocaleString lString = this.formatTips(flowNode, WfUtils.getPromptWordLocaleString("\u672a\u8ba1\u7b97\u5230\u5165\u53e3\u7ebf\uff0c\u8ba1\u7b97\u7ed3\u679c\u52a0\u5165\u8be5\u6c47\u805a\u8282\u70b9\u3002", "DefaultPrecomputatorCmd_7", "bos-wf-engine"));
                this.addErrNodeResult(flowNode, "tip", lString, "");
                logger.warn("\u6c47\u805a\u8282\u70b9" + flowNode.getName() + "(" + flowNode.getNumber() + ")\u672a\u8ba1\u7b97\u5165\u53e3\u7ebf\uff0c\u8ba1\u7b97\u52a0\u5165\u8be5\u6c47\u805a\u8282\u70b9\u3002");
            }
        } else if (!this.isContainsAgenda(throughOperation)) {
            this.agenda.add(throughOperation);
        }
    }

    public void planLeaveOperation(ExecutionEntity execution, FlowNode flowNode) {
        ContinueOperation leaveOperation = new ContinueOperation(flowNode, execution, OPERATION_TYPE_LEAVE);
        if (!this.isContainsAgenda(leaveOperation)) {
            this.agenda.addFirst(leaveOperation);
        }
    }

    public boolean isContainsAgenda(ContinueOperation continueOperation) {
        Boolean flag = Boolean.FALSE;
        for (int i = 0; i < this.agenda.size(); ++i) {
            ContinueOperation operation = this.agenda.get(i);
            if (!operation.flowNode.equals(continueOperation.flowNode) || !operation.type.equals(continueOperation.type)) continue;
            flag = Boolean.TRUE;
            break;
        }
        return flag;
    }

    @Override
    public void through(CommandContext commandContext, ExecutionEntity execution, FlowNode flowNode) {
        String stencilType;
        switch (stencilType = flowNode.getType()) {
            case "CallActivity": {
                if (!this.prepareNode.contains(flowNode.getId()) && ConditionUtil.isConditionAvailable(((CallActivity)flowNode).getSkipCondition()) && ConditionUtil.hasTrueCondition(((CallActivity)flowNode).getSkipCondition(), (VariableScope)execution, "percomputator-isSkipCallActivity")) {
                    this.setSkipResult(flowNode, Collections.emptyList(), execution);
                    break;
                }
                if (DynamicFlowUtil.skipRejectInnerAfterNode(execution, flowNode, false)) {
                    this.setSkipResult(flowNode, Collections.emptyList(), execution);
                    break;
                }
                PercomputatorUtils.addNodeDesc(flowNode.getId(), null, null, Collections.emptyList(), "byAuto", (PreComputatorExecutionEntityImpl)execution);
                this.addNodeResult(flowNode, Collections.emptyList(), "", STATUS_AUTONODE);
                break;
            }
            case "EndNoneEvent": {
                this.addNodeResult(flowNode, Collections.emptyList(), "", STATUS_AUTONODE);
                this.stopContinue();
                break;
            }
            case "StartSignalEvent": 
            case "WaitTask": 
            case "BroadcastTask": 
            case "AutoTask": 
            case "RPATask": 
            case "AutoMicroServiceTask": 
            case "JudgeTask": 
            case "NotifyTask": 
            case "InclusiveGateway": {
                PercomputatorUtils.addNodeDesc(flowNode.getId(), null, null, Collections.emptyList(), "byAuto", (PreComputatorExecutionEntityImpl)execution);
                this.addNodeResult(flowNode, Collections.emptyList(), "", STATUS_AUTONODE);
                break;
            }
            default: {
                if (this.isExtendedStencilType(stencilType)) {
                    PercomputatorUtils.addNodeDesc(flowNode.getId(), null, null, Collections.emptyList(), "byAuto", (PreComputatorExecutionEntityImpl)execution);
                    this.addNodeResult(flowNode, Collections.emptyList(), "", STATUS_AUTONODE);
                    break;
                }
                this.addNodeResult(flowNode, Collections.emptyList(), "", "through");
                this.stopContinue();
            }
        }
    }

    private boolean isExtendedStencilType(String stencilType) {
        try {
            Set<String> extendedTypes = ModelConfigUtil.getAllExtendedStencilTypes();
            return extendedTypes.contains(stencilType);
        }
        catch (Exception e) {
            logger.error(WfUtils.getExceptionStacktrace(e));
            return false;
        }
    }

    @Override
    public void leave(CommandContext commandContext, ExecutionEntity execution, FlowNode flowNode) {
        List<FlowNode> nextNodes = this.getNextNodes(commandContext, execution, flowNode);
        ArrayList<String> nextNodeId = new ArrayList<String>(nextNodes.size());
        String preNodeId = flowNode.getId();
        int i = 1;
        String varKey = String.format("%s_%s", flowNode.getId(), "rejectToForkInnerAndSkip");
        String rejectInnerInfo = (String)execution.getProcessInstance().getVariable(varKey);
        String stopSkipNode = "";
        if (WfUtils.isNotEmpty(rejectInnerInfo)) {
            String[] nodes = rejectInnerInfo.split("\\-");
            stopSkipNode = nodes[1];
        }
        this.mergeAssignParticipantToDynamicParticipant(execution, flowNode);
        for (FlowNode nextNode : nextNodes) {
            Map<String, NodeTempVariable> tempVariableMap;
            if (WfUtils.isNotEmpty(stopSkipNode)) {
                if (stopSkipNode.equals(nextNode.getId())) {
                    execution.getProcessInstance().removeVariable(varKey);
                } else {
                    String newVarKey = String.format("%s_%s", nextNode.getId(), "rejectToForkInnerAndSkip");
                    execution.getProcessInstance().setVariable(newVarKey, rejectInnerInfo);
                }
            }
            NodeTempVariable var = (tempVariableMap = ((PreComputatorExecutionEntityImpl)execution).getTempVariableMap()).containsKey(nextNode.getId()) ? tempVariableMap.get(nextNode.getId()) : new NodeTempVariable();
            var.addPreNodeId(nextNode.getId(), preNodeId);
            tempVariableMap.put(nextNode.getId(), var);
            nextNodeId.add(nextNode.getId());
            if (i > 1) {
                logger.debug("\u591a\u51fa\u53e3\u7ebf\uff0c\u8d1f\u8d23execution");
                PreComputatorExecutionEntityImpl exe = new PreComputatorExecutionEntityImpl((PreComputatorExecutionEntityImpl)execution);
                exe.setParent(execution);
                this.planThroughOperation(exe, nextNode);
            } else {
                this.planThroughOperation(execution, nextNode);
            }
            ++i;
        }
        logger.debug(String.format("\u83b7\u53d6\u5230%s\u7684\u540e\u7eed\u8282\u70b9%s\uff0c\u5e76\u653e\u5165\u6392\u671f", preNodeId, WfUtils.listToString(nextNodeId, ",")));
        this.result.get(this.result.size() - nextNodes.size() - 1).setNextNodeId(nextNodeId);
    }

    private void mergeAssignParticipantToDynamicParticipant(ExecutionEntity execution, FlowNode flowNode) {
        if (flowNode instanceof UserTask) {
            TaskEntity taskEntity;
            List taskParticipantList;
            String customNextParitcipant;
            List instanceParticipantList;
            LinkedHashMap instanceParticipantMap = new LinkedHashMap();
            String executionVariable = (String)execution.getVariable("dynParticipant");
            if (WfUtils.isNotEmpty(executionVariable) && (instanceParticipantList = SerializationUtils.fromJsonStringToList((String)executionVariable, Map.class)) != null) {
                for (Object instanceParticipant : instanceParticipantList) {
                    instanceParticipantMap.put((String)instanceParticipant.get("nodeId"), instanceParticipant.get("userIds"));
                }
            }
            if ((customNextParitcipant = DynamicFlowUtil.getCustomNextNodeParticipant(execution)) != null && (taskParticipantList = SerializationUtils.fromJsonStringToList((String)customNextParitcipant, Map.class)) != null) {
                for (Map taskParticipant : taskParticipantList) {
                    instanceParticipantMap.put((String)taskParticipant.get("nodeId"), taskParticipant.get("userIds"));
                }
            }
            String assignParticipant = null;
            Boolean currentTaskExist = Boolean.FALSE;
            if (execution.getCurrentTask() != null && (taskEntity = execution.getCurrentTask()) != null) {
                assignParticipant = (String)taskEntity.getVariableLocal(flowNode.getId().toLowerCase() + "assignparticipant");
                currentTaskExist = Boolean.TRUE;
            }
            if (assignParticipant == null) {
                assignParticipant = (String)execution.getVariable(flowNode.getId().toLowerCase() + "assignparticipant");
            }
            if (assignParticipant != null) {
                AllowNextPersonSetting allowNextPersonSetting;
                Map nodeAssignParticipant = (Map)SerializationUtils.fromJsonString(assignParticipant, Map.class);
                if (nodeAssignParticipant != null && nodeAssignParticipant.get(flowNode.getId()) != null) {
                    Map assignNodeInfo = (Map)nodeAssignParticipant.get(flowNode.getId());
                    for (Map.Entry assignParticipantEntry : assignNodeInfo.entrySet()) {
                        StringBuilder userIdBuilder = new StringBuilder();
                        List participantUserIds = (List)assignParticipantEntry.getValue();
                        for (String participantUserId : participantUserIds) {
                            userIdBuilder.append(participantUserId);
                            userIdBuilder.append(',');
                        }
                        if (userIdBuilder.length() > 0) {
                            userIdBuilder.deleteCharAt(userIdBuilder.length() - 1);
                        }
                        instanceParticipantMap.put((String)assignParticipantEntry.getKey(), userIdBuilder);
                    }
                }
                AllowNextPersonSettingModel allowNextPersonSettingModel = ((UserTask)flowNode).getAllowNextPersonSettingModel();
                Boolean isInsidetaskAgain = Boolean.FALSE;
                if (allowNextPersonSettingModel != null && (allowNextPersonSetting = allowNextPersonSettingModel.getAllowNextPersonSetting()) != null && allowNextPersonSettingModel.isAllowNextPersonWhenMatch()) {
                    isInsidetaskAgain = allowNextPersonSettingModel.getAllowNextPersonSetting().getReAssignPerson();
                }
                if ((isInsidetaskAgain == null || !isInsidetaskAgain.booleanValue()) && nodeAssignParticipant != null && nodeAssignParticipant.containsKey(flowNode.getId())) {
                    execution.getProcessInstance().removeVariableLocalIgnoreCase(flowNode.getId().toLowerCase() + "assignparticipant");
                } else if (isInsidetaskAgain != null && isInsidetaskAgain.booleanValue() && currentTaskExist.booleanValue()) {
                    execution.getProcessInstance().setVariable(flowNode.getId().toLowerCase() + "assignparticipant", SerializationUtils.toJsonString((Object)nodeAssignParticipant));
                }
            }
            if (instanceParticipantMap.size() > 0) {
                ArrayList instanceVariable = new ArrayList(instanceParticipantMap.size());
                for (Map.Entry instanceParticipant : instanceParticipantMap.entrySet()) {
                    LinkedHashMap<String, Object> instanceParticipantTemp = new LinkedHashMap<String, Object>();
                    instanceParticipantTemp.put("nodeId", instanceParticipant.getKey());
                    instanceParticipantTemp.put("userIds", instanceParticipant.getValue());
                    instanceVariable.add(instanceParticipantTemp);
                }
                execution.setVariable("dynParticipant", SerializationUtils.toJsonString(instanceVariable));
            }
        }
    }

    public void setSkipResult(FlowElement flowNode, List<Long> participants, ExecutionEntity execution) {
        PercomputatorUtils.addNodeDesc(flowNode.getId(), null, null, Collections.emptyList(), STATUS_SKIP, (PreComputatorExecutionEntityImpl)execution);
        this.addNodeResult(flowNode, participants, "", STATUS_SKIP);
    }

    public List<FlowNode> getNextNodes(CommandContext commandContext, ExecutionEntity execution, FlowNode flowNode) {
        boolean isExclusion;
        String joinId;
        String forkNode;
        FlowNode firstNextNode;
        VariableScope variableScope = execution.getCurrentTask() == null ? execution : execution.getCurrentTask();
        logger.debug(String.format("\u8ba1\u7b97\u51fa\u53e3\u7ebfScope%s", variableScope));
        List<SequenceFlow> outgoingSequenceFlows = PercomputatorUtils.getNodeOutgoingSequences(flowNode, variableScope, this.process);
        ArrayList<FlowNode> nextNodes = new ArrayList<FlowNode>(outgoingSequenceFlows.size());
        String preNodeId = flowNode.getId();
        int size = outgoingSequenceFlows.size();
        if (size <= 0) {
            ILocaleString lString = this.formatTips(flowNode, WfUtils.getPromptWordLocaleString("\u672a\u8ba1\u7b97\u5230\u51fa\u53e3\u7ebf\u3002", "DefaultPrecomputatorCmd_8", "bos-wf-engine"));
            this.addErrNodeResult(flowNode, "noneoutedge", lString, "");
            logger.debug(lString == null ? "" : lString.getLocaleValue());
            return nextNodes;
        }
        if (!(size <= 1 || "leavewhenfristone".equals(flowNode.getOutSet()) || ForkJoinUtils.isForkNode(flowNode) && !"leavewhenonlyone".equals(flowNode.getOutSet()))) {
            ILocaleString lString = this.formatTips(flowNode, WfUtils.getPromptWordLocaleString("\u8ba1\u7b97\u5230\u591a\u6761\u51fa\u53e3\u7ebf\u3002", "DefaultPrecomputatorCmd_9", "bos-wf-engine"));
            this.addErrNodeResult(flowNode, "multioutedge", lString, "");
            logger.debug(lString == null ? "" : lString.getLocaleValue());
            return nextNodes;
        }
        logger.debug(String.format("%s\u7684\u51fa\u53e3\u7ebf\u6570\u76ee%s", preNodeId, size));
        Map<String, NodeForkJoinModel> models = this.process.getForkJoinModels();
        if (ForkJoinUtils.isForkNode(flowNode) && models.get(preNodeId).isForkNode()) {
            String joinNodeId = models.get(preNodeId).getPairJoinNodeId();
            if ("reject".equals(flowNode.getPassTypeAfterInnerReject()) && this.flownodeIndexMap.containsKey(joinNodeId) && size == 1) {
                logger.debug("\u9a73\u56de\u91cd\u8d70\u4e0d\u91cd\u65b0\u8bbe\u7f6e\u6c47\u805a\u6807\u5fd7");
            } else {
                this.flownodeIndexMap.put(joinNodeId, size);
                this.joinNodeIds.add(joinNodeId);
            }
            logger.debug(String.format("\u8282\u70b9%s\u6c47\u805a\u5165\u53e3\u6570\u76ee%s", joinNodeId, this.flownodeIndexMap.get(joinNodeId)));
        }
        if (ForkJoinUtils.isJoinNode(firstNextNode = (FlowNode)outgoingSequenceFlows.get(0).getTargetFlowElement()) && !this.joinNodeIds.contains(firstNextNode.getId()) && WfUtils.isNotEmpty(forkNode = models.get(joinId = firstNextNode.getId()).getPairForkNodeId())) {
            ExecutionEntity procinst = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(execution.getProcessInstanceId());
            int cycle = ForkJoinUtils.getEnterForkCycle(forkNode, procinst);
            String joinFlag = forkNode + "$" + cycle + "$" + joinId;
            Integer noOfShouldSurvive = (Integer)ForkJoinUtils.getNoOfShouldSurvive(joinFlag, procinst);
            Integer noOfArrived = (Integer)ForkJoinUtils.getNoOfArrived(joinFlag, procinst);
            if (noOfShouldSurvive == null) {
                noOfShouldSurvive = firstNextNode.getIncomingFlows().size();
            }
            if (noOfArrived != null) {
                noOfShouldSurvive = noOfShouldSurvive - noOfArrived;
            }
            if (noOfShouldSurvive > 0) {
                this.flownodeIndexMap.put(joinId, noOfShouldSurvive);
                this.joinNodeIds.add(joinId);
            } else {
                logger.warn(String.format("\u8ba1\u7b97\u62c6\u5206\u6c47\u805a\u51fa\u9519\uff1a%s\uff0c %s", joinFlag, noOfArrived));
            }
        }
        if (isExclusion = "leavewhenfristone".equals(flowNode.getOutSet())) {
            outgoingSequenceFlows = BpmnModelUtil.sortOutgoingFlowsByJudgeTaskSeq(outgoingSequenceFlows);
        }
        int matchedIdx = 0;
        for (SequenceFlow f : outgoingSequenceFlows) {
            FlowElement target = f.getTargetFlowElement();
            if (target instanceof JudgeTask) {
                JudgeTask judgeTask = (JudgeTask)target;
                if (!judgeTask.hasTrueCondition(execution)) continue;
                ++matchedIdx;
            } else {
                ++matchedIdx;
            }
            if (MODEL_AFTERAUDIT.equals(this.model)) {
                String expression = "";
                if (f.getConditionalRule() != null) {
                    expression = f.getConditionalRule().getExpression();
                }
                if (WfUtils.isNotEmpty(expression)) {
                    for (String lineExpression : this.afterAuditNodeSet) {
                        if (!expression.contains(lineExpression)) continue;
                        this.stopContinue();
                        ILocaleString lString = WfUtils.getPromptWordLocaleString(String.format("\u51fa\u53e3\u7ebf\uff1a%1$s(%2$s)\u7ebf\u4e0a\u6761\u4ef6\u5e94\u7528\u4e86\u540e\u5ba1\u8282\u70b9\u7684\u6d41\u7a0b\u5c5e\u6027\uff1a\u201c%3$s\u201d\u3002", f.getName(), f.getNumber(), lineExpression), "DefaultPrecomputatorCmd_10", "bos-wf-engine");
                        this.addErrNodeResult(flowNode, MODEL_AFTERAUDIT, lString, "");
                        logger.debug(lString.getLocaleValue());
                        return Collections.emptyList();
                    }
                }
            }
            nextNodes.add((FlowNode)f.getTargetFlowElement());
            logger.debug(String.format("\u5f97\u5230\u76ee\u6807\u8282\u70b9%s", f.getTargetFlowElement().getId()));
            this.addNodeResult(f, Collections.emptyList(), "", "through");
            if (!isExclusion || matchedIdx <= 0) continue;
            break;
        }
        return nextNodes;
    }

    public DefaultPrecomputatorCmd getPercomputator(FlowNode node) {
        String stencilType = node.getType();
        DefaultPrecomputatorCmd percomputator = this.percomputators.get(stencilType);
        if (percomputator == null) {
            switch (stencilType) {
                case "UserTask": {
                    percomputator = new UserTaskPercomputator(this.procInstId);
                    break;
                }
                case "AuditTask": {
                    percomputator = new AuditTaskPercomputator(this.procInstId);
                    break;
                }
                case "YunzhijiaTask": {
                    percomputator = new YzjTaskPercomputator(this.procInstId);
                    break;
                }
                default: {
                    return this;
                }
            }
            this.percomputators.put(stencilType, percomputator);
        }
        percomputator.initPercomputatorProps(this);
        return percomputator;
    }

    public void addNodeResult(FlowElement node, List<Long> assignee, String auditConsent, String status) {
        PreComputorRecordItem item = new PreComputorRecordItem();
        item.setIsNormal(Boolean.TRUE);
        item.setNodeId(node.getId());
        item.setNodeName(this.getNodeName(node));
        item.setAssignee(assignee);
        item.setAssigneeName(WfUtils.getILocaleUsersName(assignee));
        item.setAuditNumber(auditConsent);
        item.setNodeType(node.getType());
        item.setStatus(status);
        item.setBizIdentifyKey(node.getBizIdentifyKey());
        item.setNextNodeId(Collections.emptyList());
        if (node instanceof UserTask) {
            item.setExtAttrGroup(BpmnModelUtil.extendAttributeGroupConverterToWF(node));
        }
        logger.debug(String.format("\u6dfb\u52a0\u7ed3\u679c\u4fe1\u606f%s", ((Object)item).toString()));
        this.result.add(item);
    }

    public void addErrNodeResult(FlowElement node, String type, ILocaleString msg, String exceptionMsg) {
        PreComputorRecordItem item = new PreComputorRecordItem();
        item.setIsNormal(Boolean.FALSE);
        if (node != null) {
            item.setNodeId(node.getId());
            item.setNodeName(this.getNodeName(node));
        }
        item.setErrType(type);
        item.setErrMsg(msg);
        item.setExceptionMsg(exceptionMsg);
        item.setAssignee(Collections.emptyList());
        item.setNextNodeId(Collections.emptyList());
        logger.debug(String.format("\u6dfb\u52a0\u7ed3\u679c\u4fe1\u606f%s", ((Object)item).toString()));
        this.result.add(item);
    }

    private void addErrNodeResultForLoop(FlowElement node, String type, ILocaleString msg, String exceptionMsg) {
        PreComputorRecordItem item = new PreComputorRecordItem();
        item.setIsNormal(Boolean.FALSE);
        if (node != null) {
            item.setNodeId(node.getId());
            item.setNodeName(this.getNodeName(node));
        }
        item.setErrType(type);
        item.setErrMsg(msg);
        item.setExceptionMsg(exceptionMsg);
        item.setAssignee(Collections.emptyList());
        item.setNextNodeId(Collections.emptyList());
        item.setLevel(1);
        logger.debug(String.format("\u6dfb\u52a0\u7ed3\u679c\u4fe1\u606f%s", ((Object)item).toString()));
        this.result.add(item);
    }

    private ILocaleString getNodeName(FlowElement node) {
        if (this.resourceMultiLangData == null) {
            this.resourceMultiLangData = this.getResourceMultiLangData();
        }
        if (this.resourceMultiLangData != null) {
            return BpmnModelUtil.getMultiLangFieldValue(this.resourceMultiLangData, BpmnModelUtil.getActivityNameMultiKey(node.getId()), node.getName());
        }
        return WfUtils.getMultiLangValue(node.getName());
    }

    private JSONObject getResourceMultiLangData() {
        if (WfUtils.isNotEmpty(this.procInstId)) {
            return BpmnModelUtil.getMultiLangDatas(this.procInstId);
        }
        if (WfUtils.isNotEmpty(this.procDefId)) {
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.commandContext.getProcessDefinitionEntityManager().findById(this.procDefId, "resourceid");
            ResourceEntity resource = (ResourceEntity)this.commandContext.getResourceEntityManager().findById(processDefinition.getResourceId());
            return BpmnModelUtil.getMultiLangDatasFromResource(resource);
        }
        return null;
    }

    private ILocaleString formatTips(FlowNode flowNode, ILocaleString info) {
        if (flowNode != null && WfUtils.isNotEmpty(flowNode.getId())) {
            String key = BpmnModelUtil.getActivityNameMultiKey(flowNode.getId());
            ILocaleString tip = BpmnModelUtil.getMultiLangFieldValue(this.procInstId, key, flowNode.getName());
            String nodeNumber = flowNode.getNumber();
            for (Lang lang : WfUtils.getSupportLangs()) {
                String langKey = lang.toString();
                tip.setItem(langKey, (Object)String.format("%s[%s]%s", tip.get((Object)langKey), nodeNumber, info.get((Object)langKey)));
            }
            return tip;
        }
        return null;
    }

    static class ContinueOperation {
        protected FlowNode flowNode;
        protected ExecutionEntity execution;
        protected String type;

        public ContinueOperation(FlowNode flowNode, ExecutionEntity execution, String type) {
            this.flowNode = flowNode;
            this.execution = execution;
            this.type = type;
        }
    }
}

